/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import java.io.InputStream;
import java.util.Arrays;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.filehandlers.art.BloodArtEntry;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Render.ModelHandle.VoxelInfo;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class Tile {
    public static int kSurfNone = 0;
    public static int kSurfStone = 1;
    public static int kSurfMetal = 2;
    public static int kSurfWood = 3;
    public static int kSurfFlesh = 4;
    public static int kSurfWater = 5;
    public static int kSurfDirt = 6;
    public static int kSurfClay = 7;
    public static int kSurfSnow = 8;
    public static int kSurfIce = 9;
    public static int kSurfLeaves = 10;
    public static int kSurfCloth = 11;
    public static int kSurfPlant = 12;
    public static int kSurfGoo = 13;
    public static int kSurfLava = 14;
    public static int kSurfMax = 15;
    public static int[] surfSfxLand = new int[]{-1, 600, 601, 602, 603, 604, 605, 605, 605, 600, 605, 605, 605, 604, 603};
    public static int[][] surfSfxMove = new int[][]{{-1, -1}, {802, 803}, {804, 805}, {806, 807}, {808, 809}, {810, 811}, {812, 813}, {814, 815}, {816, 817}, {818, 819}, {820, 821}, {822, 823}, {824, 825}, {826, 827}, {828, 829}};
    public static short[] gVoxelData = new short[Globals.kMaxTiles];
    public static byte[] shadeTable = new byte[Globals.kMaxTiles];

    public static void tileInit() {
        Tile.voxelsInit("VOXEL.DAT");
        Tile.shadeInit("SHADE.DAT");
    }

    public static void voxelsInit(String name) {
        Arrays.fill(gVoxelData, (short)-1);
        Entry entry = Main.game.getCache().getEntry(name, true);
        if (entry.exists()) {
            try (InputStream is = entry.getInputStream();){
                int i = 0;
                while ((long)i < entry.getSize() / 2L) {
                    Tile.gVoxelData[i] = StreamUtils.readShort(is);
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void tileLoadVoxel(int nTile) {
        if (Main.engine.getTile(nTile) instanceof BloodArtEntry) {
            Entry buffer;
            BloodArtEntry pic = (BloodArtEntry)Main.engine.getTile(nTile);
            if (pic.getView() != BloodArtEntry.ViewType.kSpriteViewVoxel && pic.getView() != BloodArtEntry.ViewType.kSpriteViewSpinVoxel) {
                return;
            }
            short nVoxel = gVoxelData[nTile];
            if (Main.game.currentDef.mdInfo.getVoxelInfo(nTile) == null && nVoxel >= 0 && nVoxel < 512 && (buffer = Main.game.getCache().getEntry(nVoxel, "KVX")).exists()) {
                try {
                    VoxelData vox = new VoxelData(buffer);
                    for (int i = 0; i < vox.zpiv.length; ++i) {
                        int n = i;
                        vox.zpiv[n] = vox.zpiv[n] + (pic.getOffsetY() << 8) / (1 << i);
                    }
                    Main.game.currentDef.mdInfo.addVoxelInfo(new VoxelInfo(vox), nTile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void shadeInit(String name) {
        Entry entry = Main.game.getCache().getEntry(name, true);
        if (!entry.exists()) {
            return;
        }
        byte[] data = entry.getBytes();
        System.arraycopy(data, 0, shadeTable, 0, Math.min(data.length, shadeTable.length));
    }
}

