/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.AIUNICULT;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.AI.DudeExtra;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Gib;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SECTORFX;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.BUSY;
import ru.m210projects.Blood.Types.BUSYPROC;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.MapInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Point;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class Trigger {
    public static final int kMaxBusyArray = 128;
    public static final int kRemoteDelay = 18;
    public static final int kProxDelay = 30;
    public static final int kBusyOk = 0;
    public static final int kBusyRestore = 1;
    public static final int kBusyReverse = 2;
    public static final int kBusyComplete = 3;
    private static final Vector3 wallVel = new Vector3(100.0f, 100.0f, 250.0f);
    public static int gBusyCount = 0;
    public static BUSY[] gBusy = new BUSY[128];
    public static Vector2[] kwall = new Vector2[Engine.MAXWALLS];
    public static int[] secFloorZ = new int[Engine.MAXSECTORS];
    public static int[] secCeilZ = new int[Engine.MAXSECTORS];
    public static int[] secPath = new int[Engine.MAXSECTORS];
    public static int getHighestZ;
    public static int getRangepzTop;
    public static int getRangepzBot;
    public static BUSYPROC[] gBusyProc;

    public static boolean valueIsBetween(int val, int min, int max) {
        return val > min && val < max;
    }

    public static int Lin2Sin(int nBusy, int opt) {
        switch (opt) {
            case 0: {
                return 32768 - (Trig.Cos(nBusy * 1024 / 65536) >> 15);
            }
            case 2: {
                return 65536 - (Trig.Cos(nBusy * 512 / 65536) >> 14);
            }
            case 3: {
                return Trig.Sin(nBusy * 512 / 65536) >> 14;
            }
        }
        return nBusy;
    }

    public static int gdxTypeSetSpriteState(int nSprite, XSPRITE pXSprite, int state) {
        if ((pXSprite.getBusy() & 0xFFFF) == 0 && pXSprite.getState() == state) {
            return state ^ pXSprite.getState();
        }
        pXSprite.setBusy(state << 16);
        pXSprite.setState((short)state);
        EVENT.checkEventList(nSprite, 3);
        if ((Main.boardService.getSprite(nSprite).getHitag() & 0x10) != 0 && Main.boardService.getSprite(nSprite).getZvel() >= 200 && Main.boardService.getSprite(nSprite).getZvel() < 256) {
            pXSprite.setRespawnPending(3);
            EVENT.evPostCallback(nSprite, 3, Integer.toUnsignedLong(Globals.pGameInfo.nMonsterRespawnTime), 9);
            return 1;
        }
        if (state != pXSprite.getRestState() && pXSprite.getWaitTime() > 0) {
            EVENT.evPost(nSprite, 3, Integer.toUnsignedLong(pXSprite.getWaitTime() * 120) / 10L, pXSprite.getRestState() != 0 ? 1 : 0);
        }
        if (pXSprite.getTxID() != 0 && (pXSprite.isTriggerOn() && pXSprite.getState() == 1 || pXSprite.isTriggerOff() && pXSprite.getState() == 0)) {
            switch (pXSprite.getCommand()) {
                case 5: 
                case 53: {
                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                    break;
                }
                case 7: {
                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                    break;
                }
                default: {
                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                }
            }
        }
        return 1;
    }

    public static int SetSpriteState(int nSprite, XSPRITE pXSprite, int state) {
        if ((pXSprite.getBusy() & 0xFFFF) == 0 && pXSprite.getState() == state) {
            return state ^ pXSprite.getState();
        }
        pXSprite.setBusy(state << 16);
        pXSprite.setState((short)state);
        EVENT.checkEventList(nSprite, 3);
        if ((Main.boardService.getSprite(nSprite).getHitag() & 0x10) != 0 && Main.boardService.getSprite(nSprite).getZvel() >= 200 && Main.boardService.getSprite(nSprite).getZvel() < 256) {
            pXSprite.setRespawnPending(3);
            EVENT.evPostCallback(nSprite, 3, Integer.toUnsignedLong(Globals.pGameInfo.nMonsterRespawnTime), 9);
            return 1;
        }
        if (state != pXSprite.getRestState() && pXSprite.getWaitTime() > 0) {
            EVENT.evPost(nSprite, 3, Integer.toUnsignedLong(pXSprite.getWaitTime() * 120) / 10L, pXSprite.getRestState() != 0 ? 1 : 0);
        }
        if (pXSprite.getTxID() != 0) {
            if (pXSprite.getCommand() == 5) {
                return 1;
            }
            if (pXSprite.isTriggerOn() && pXSprite.getState() == 1) {
                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
            }
            if (pXSprite.isTriggerOff() && pXSprite.getState() == 0) {
                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
            }
        }
        return 1;
    }

    public static int SetWallState(int nWall, XWALL pXWall, int state) {
        if ((pXWall.busy & 0xFFFF) == 0 && pXWall.state == state) {
            return state ^ pXWall.state;
        }
        pXWall.busy = state << 16;
        pXWall.state = (short)state;
        EVENT.checkEventList(nWall, 0);
        if (state != pXWall.restState && pXWall.waitTime > 0) {
            EVENT.evPost(nWall, 0, Integer.toUnsignedLong(pXWall.waitTime * 120) / 10L, pXWall.restState != 0 ? 1 : 0);
        }
        if (pXWall.txID != 0) {
            if (pXWall.command == 5) {
                return 1;
            }
            if (pXWall.triggerOn && pXWall.state == 1) {
                EVENT.evSend(nWall, 0, pXWall.txID, pXWall.command);
            }
            if (pXWall.triggerOff && pXWall.state == 0) {
                EVENT.evSend(nWall, 0, pXWall.txID, pXWall.command);
            }
        }
        return 1;
    }

    public static void SetSectorState(int nSector, XSECTOR pXSector, int state) {
        if ((pXSector.busy & 0xFFFF) == 0 && pXSector.state == state) {
            return;
        }
        pXSector.busy = state << 16;
        pXSector.state = (short)state;
        EVENT.checkEventList(nSector, 6);
        if (state == 1) {
            if (pXSector.command != 5 && pXSector.triggerOn && pXSector.txID != 0) {
                EVENT.evSend(nSector, 6, pXSector.txID, pXSector.command);
            }
            if (pXSector.stopFlag[1]) {
                pXSector.stopFlag[1] = false;
                pXSector.stopFlag[0] = false;
                return;
            }
            if (pXSector.waitFlag[1]) {
                EVENT.evPost(nSector, 6, Integer.toUnsignedLong(pXSector.waitTime[1] * 120) / 10L, 0);
            }
            return;
        }
        if (pXSector.command != 5 && pXSector.triggerOff && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, pXSector.command);
        }
        if (pXSector.stopFlag[0]) {
            pXSector.stopFlag[1] = false;
            pXSector.stopFlag[0] = false;
            return;
        }
        if (pXSector.waitFlag[0]) {
            EVENT.evPost(nSector, 6, Integer.toUnsignedLong(pXSector.waitTime[0] * 120) / 10L, 1);
        }
    }

    public static void AddBusy(int nIndex, int busyProc, int nDelta) {
        int i;
        if (nDelta == 0) {
            throw new AssertException("nDelta != 0");
        }
        for (i = 0; i < gBusyCount && (nIndex != Trigger.gBusy[i].nIndex || busyProc != Trigger.gBusy[i].busyProc); ++i) {
        }
        if (i == gBusyCount) {
            if (gBusyCount == 128) {
                return;
            }
            Trigger.gBusy[i].nIndex = nIndex;
            Trigger.gBusy[i].busyProc = busyProc;
            Trigger.gBusy[i].nBusy = nDelta > 0 ? 0 : 65536;
            ++gBusyCount;
        }
        Trigger.gBusy[i].nDelta = nDelta;
    }

    public static void ReverseBusy(int nIndex, int busyProc) {
        for (int i = 0; i < gBusyCount; ++i) {
            if (nIndex != Trigger.gBusy[i].nIndex || busyProc != Trigger.gBusy[i].busyProc) continue;
            Trigger.gBusy[i].nDelta = -Trigger.gBusy[i].nDelta;
            return;
        }
    }

    public static int GetSourceBusy(int event) {
        switch (EVENT.getType(event)) {
            case 6: {
                short nXIndex = Main.boardService.getSector(EVENT.getIndex(event)).getExtra();
                if (nXIndex <= 0 || nXIndex >= 512) {
                    throw new AssertException("nXIndex > 0 && nXIndex < kMaxXSectors");
                }
                return DB.xsector[nXIndex].busy;
            }
            case 0: {
                short nXIndex = Main.boardService.getWall(EVENT.getIndex(event)).getExtra();
                if (nXIndex <= 0 || nXIndex >= 512) {
                    throw new AssertException("nXIndex > 0 && nXIndex < kMaxXWalls");
                }
                return DB.xwall[nXIndex].busy;
            }
            case 3: {
                short nXIndex = Main.boardService.getSprite(EVENT.getIndex(event)).getExtra();
                return Main.boardService.getXSprite(nXIndex).getBusy();
            }
        }
        return 0;
    }

    public static void OperateSprite(int nSprite, XSPRITE pXSprite, int evCommand) {
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        switch (evCommand) {
            case 6: {
                pXSprite.setLocked(1);
                if (pSprite.getLotag() == 39) {
                    Trigger.stopWindOnSectors(pXSprite);
                }
                return;
            }
            case 7: {
                pXSprite.setLocked(0);
                return;
            }
            case 8: {
                pXSprite.setLocked(pXSprite.getLocked() ^ 1);
                if (pSprite.getLotag() == 39 && pXSprite.getLocked() == 1) {
                    Trigger.stopWindOnSectors(pXSprite);
                }
                return;
            }
        }
        if (pSprite.getStatnum() == 6 && Actor.IsDudeSprite(pSprite)) {
            switch (evCommand) {
                case 0: {
                    Trigger.SetSpriteState(nSprite, pXSprite, 0);
                    break;
                }
                case 1: 
                case 30: 
                case 33: {
                    if (pXSprite.getState() == 0) {
                        Trigger.SetSpriteState(nSprite, pXSprite, 1);
                    }
                    Ai.aiActivateDude(pSprite, pXSprite);
                    break;
                }
                case 35: {
                    if (pXSprite.getState() != 0) break;
                    Trigger.SetSpriteState(nSprite, pXSprite, 1);
                    Ai.aiActivateDude(pSprite, pXSprite);
                }
            }
            return;
        }
        block10 : switch (pSprite.getLotag()) {
            case 25: {
                int maxRetries;
                int tx = 0;
                if (pXSprite.getData1() > 0 && pXSprite.getData2() <= 0 && pXSprite.getData3() <= 0 && pXSprite.getData4() > 0) {
                    if (pXSprite.getData1() > pXSprite.getData4()) {
                        short tmp = pXSprite.getData1();
                        pXSprite.setData1((short)pXSprite.getData4());
                        pXSprite.setData4(tmp);
                    }
                    int total = pXSprite.getData4() - pXSprite.getData1();
                    while (maxRetries > 0 && (tx = Globals.pGameInfo.nGameType != 0 || Mmulti.numplayers > 1 ? Gameutils.Random(total) + pXSprite.getData1() : (int)((double)total * Math.random()) + pXSprite.getData1()) == pXSprite.getTxID()) {
                        --maxRetries;
                    }
                } else {
                    for (maxRetries = 10; maxRetries > 0 && ((tx = Actor.GetRandDataVal(null, pSprite)) <= 0 || tx == pXSprite.getTxID()); --maxRetries) {
                    }
                }
                pXSprite.setTxID((short)tx);
                Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1);
                break;
            }
            case 26: {
                boolean range = false;
                int cnt = 3;
                int tx = 0;
                if (pXSprite.getData1() > 0 && pXSprite.getData2() <= 0 && pXSprite.getData3() <= 0 && pXSprite.getData4() > 0) {
                    if (pXSprite.getData1() > pXSprite.getData4()) {
                        short tmp = pXSprite.getData1();
                        pXSprite.setData1((short)pXSprite.getData4());
                        pXSprite.setData4(tmp);
                    }
                    if (pSprite.getHitag() == 1) {
                        for (int i = pXSprite.getData1(); i <= pXSprite.getData4(); ++i) {
                            EVENT.evSend(nSprite, 3, i, pXSprite.getCommand());
                        }
                        pXSprite.setDropMsg(0);
                        return;
                    }
                    if (pXSprite.getDropMsg() < pXSprite.getData1()) {
                        pXSprite.setDropMsg(pXSprite.getData1());
                    } else if (pXSprite.getDropMsg() > pXSprite.getData4()) {
                        pXSprite.setDropMsg((short)pXSprite.getData4());
                    }
                    range = true;
                } else {
                    if (pSprite.getHitag() == 1) {
                        for (int i = 0; i < 4; ++i) {
                            tx = Actor.GetDataVal(pSprite, i);
                            if (tx <= 0) continue;
                            EVENT.evSend(nSprite, 3, tx, pXSprite.getCommand());
                        }
                        pXSprite.setDropMsg(0);
                        return;
                    }
                    if (pXSprite.getDropMsg() > 3) {
                        pXSprite.setDropMsg(0);
                    } else if (pXSprite.getDropMsg() < 0) {
                        pXSprite.setDropMsg(3);
                    }
                }
                block47 : switch (evCommand) {
                    case 0: {
                        if (!range) {
                            while (cnt-- >= 0) {
                                pXSprite.setDropMsg(pXSprite.getDropMsg() - 1);
                                if (pXSprite.getDropMsg() < 0) {
                                    pXSprite.setDropMsg(3);
                                }
                                if ((tx = Actor.GetDataVal(pSprite, pXSprite.getDropMsg())) < 0) {
                                    throw new AssertException(" -- Current data index is negative");
                                }
                                if (tx <= 0) continue;
                                break block47;
                            }
                            break;
                        }
                        pXSprite.setDropMsg(pXSprite.getDropMsg() - 1);
                        if (pXSprite.getDropMsg() < pXSprite.getData1()) {
                            pXSprite.setDropMsg((short)pXSprite.getData4());
                        }
                        tx = pXSprite.getDropMsg();
                        break;
                    }
                    default: {
                        if (!range) {
                            while (cnt-- >= 0) {
                                if (pXSprite.getDropMsg() > 3) {
                                    pXSprite.setDropMsg(0);
                                }
                                if ((tx = Actor.GetDataVal(pSprite, pXSprite.getDropMsg())) < 0) {
                                    throw new AssertException(" ++ Current data index is negative");
                                }
                                pXSprite.setDropMsg(pXSprite.getDropMsg() + 1);
                                if (tx <= 0) continue;
                                break block47;
                            }
                            break;
                        }
                        tx = pXSprite.getDropMsg();
                        if (pXSprite.getDropMsg() >= pXSprite.getData4()) {
                            pXSprite.setDropMsg(pXSprite.getData1());
                            break;
                        }
                        pXSprite.setDropMsg(pXSprite.getDropMsg() + 1);
                    }
                }
                pXSprite.setTxID((short)tx);
                Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1);
                break;
            }
            case 24: {
                if (Globals.pGameInfo.nMonsterSettings == 0 || Actor.actSpawnCustomDude(pSprite, -1) == null) break;
                ++LEVELS.totalKills;
                break;
            }
            case 18: {
                if (Globals.pGameInfo.nMonsterSettings == 0 || pXSprite.getData1() < 200 || pXSprite.getData1() >= 256) break;
                Sprite pSpawn = null;
                if (!DemoUtils.IsOriginalDemo()) {
                    pSpawn = Actor.spawnRandomDude(pSprite);
                    if (pSpawn == null) {
                        pSpawn = Actor.actSpawnDude(pSprite, pXSprite.getData1(), -1);
                    }
                } else {
                    pSpawn = Actor.actSpawnDude(pSprite, pXSprite.getData1(), -1);
                }
                if (pSpawn == null) break;
                ++LEVELS.totalKills;
                switch (pSpawn.getLotag()) {
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 252: 
                    case 253: {
                        XSPRITE pXSpawn = Main.boardService.getXSprite(pSpawn.getExtra());
                        pXSpawn.setHealth(DudeInfo.dudeInfo[pXSprite.getData1() - 200].startHealth << 4);
                        pXSpawn.setBurnTime(10);
                        pXSpawn.setTarget(-1);
                        Ai.aiActivateDude((BloodSprite)pSpawn, pXSpawn);
                    }
                }
                break;
            }
            case 19: {
                if (Globals.pGameInfo.nGameType >= 2) break;
                pXSprite.setTriggered(true);
                pXSprite.setTriggerOn(false);
                Trigger.SetSpriteState(nSprite, pXSprite, 1);
                short i = Mmulti.connecthead;
                while (i >= 0) {
                    int dx = pSprite.getX() - Globals.gPlayer[i].pSprite.getX() >> 4;
                    int dy = pSprite.getY() - Globals.gPlayer[i].pSprite.getY() >> 4;
                    int dz = pSprite.getZ() - Globals.gPlayer[i].pSprite.getZ() >> 8;
                    Globals.gPlayer[i].quakeTime = (pXSprite.getData1() << 16) / (262144 + dx * dx + dy * dy + dz * dz);
                    i = Mmulti.connectpoint2[i];
                }
                break;
            }
            case 8: {
                if (pXSprite.getTxID() <= 0) {
                    if (Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1) != 1) break;
                    Trigger.useTeleportTarget(pXSprite, null);
                    break;
                }
                Trigger.gdxTypeSetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1);
                break;
            }
            case 36: {
                if (pXSprite.getTxID() <= 0) {
                    if (Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1) != 1) break;
                    Trigger.useSpriteDamager(pXSprite, null);
                    break;
                }
                Trigger.gdxTypeSetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1);
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 35: {
                Trigger.gdxTypeSetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1);
                break;
            }
            case 20: {
                switch (evCommand) {
                    case 0: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 0) != 1) break block10;
                        SOUND.sfxStart3DSound(pSprite, pXSprite.getData2(), 0, 0);
                        break;
                    }
                    case 1: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 1) != 1) break block10;
                        SOUND.sfxStart3DSound(pSprite, pXSprite.getData1(), 0, 0);
                        break;
                    }
                    default: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1) != 1) break block10;
                        if (pXSprite.getState() == 0) {
                            SOUND.sfxStart3DSound(pSprite, pXSprite.getData2(), 0, 0);
                            break;
                        }
                        SOUND.sfxStart3DSound(pSprite, pXSprite.getData1(), 0, 0);
                        break;
                    }
                }
                break;
            }
            case 21: {
                switch (evCommand) {
                    case 0: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 0) != 1) break block10;
                        SOUND.sfxStart3DSound(pSprite, pXSprite.getData2(), 0, 0);
                        break;
                    }
                    case 1: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 1) != 1) break block10;
                        SOUND.sfxStart3DSound(pSprite, pXSprite.getData1(), 0, 0);
                        break;
                    }
                    default: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.getRestState() ^ 1) != 1) break block10;
                        if (pXSprite.getState() == 0) {
                            SOUND.sfxStart3DSound(pSprite, pXSprite.getData2(), 0, 0);
                            break;
                        }
                        SOUND.sfxStart3DSound(pSprite, pXSprite.getData1(), 0, 0);
                        break;
                    }
                }
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                if (pXSprite.getCommand() != 5 || pXSprite.getTxID() == 0) break;
                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 5);
                break;
            }
            case 15: {
                switch (evCommand) {
                    case 0: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        break;
                    }
                    case 5: {
                        if (pXSprite.getTxID() == 0) break block10;
                        EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 5);
                        break;
                    }
                    default: {
                        Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1);
                        break;
                    }
                }
                break;
            }
            case 22: {
                if (evCommand == 0) {
                    pXSprite.setData1(pXSprite.getData1() - 1);
                    if (pXSprite.getData1() < 0) {
                        pXSprite.setData1(pXSprite.getData1() + pXSprite.getData3());
                    }
                } else {
                    pXSprite.setData1(pXSprite.getData1() + 1);
                    if (pXSprite.getData1() >= pXSprite.getData3()) {
                        pXSprite.setData1(pXSprite.getData1() - pXSprite.getData3());
                    }
                }
                if (pXSprite.getCommand() == 5 && pXSprite.getTxID() != 0) {
                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 5);
                }
                SOUND.sfxStart3DSound(pSprite, pXSprite.getData4(), -1, 0);
                if (pXSprite.getData1() == pXSprite.getData2()) {
                    Trigger.SetSpriteState(nSprite, pXSprite, 1);
                    break;
                }
                Trigger.SetSpriteState(nSprite, pXSprite, 0);
                break;
            }
            case 23: {
                switch (evCommand) {
                    case 0: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break block10;
                    }
                    case 1: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        SeqHandling.seqSpawn(VERSION.getSeq(2), 3, pSprite.getExtra(), null);
                        break block10;
                    }
                }
                Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1);
                if (pXSprite.getState() == 0) break;
                SeqHandling.seqSpawn(VERSION.getSeq(2), 3, pSprite.getExtra(), null);
                break;
            }
            case 402: {
                if (Main.boardService.getSprite(nSprite).getStatnum() == 8) break;
                if (evCommand == 1) {
                    SOUND.sfxStart3DSound(pSprite, 454, 0, 0);
                    EVENT.evPost(nSprite, 3, Integer.toUnsignedLong(18), 0);
                    break;
                }
                Actor.actExplodeSprite((short)nSprite);
                break;
            }
            case 405: 
            case 408: {
                if (Trigger.SetSpriteState(nSprite, pXSprite, 0) == 0) {
                    return;
                }
                Actor.actPostSprite(nSprite, 1024);
                break;
            }
            case 400: {
                if ((pSprite.getHitag() & 0x10) != 0) break;
                Actor.actExplodeSprite(nSprite);
                break;
            }
            case 418: 
            case 419: 
            case 420: {
                Actor.actExplodeSprite(nSprite);
                break;
            }
            case 401: 
            case 433: {
                if (Main.boardService.getSprite(nSprite).getStatnum() == 8) break;
                switch (evCommand) {
                    case 1: {
                        SOUND.sfxStart3DSound(pSprite, 451, 0, 0);
                        pXSprite.setProximity(true);
                        break;
                    }
                    case 35: {
                        if (pXSprite.getState() != 0) break;
                        SOUND.sfxStart3DSound(pSprite, 452, 0, 0);
                        EVENT.evPost(nSprite, 3, Integer.toUnsignedLong(30), 0);
                        pXSprite.setState(1);
                        break;
                    }
                    default: {
                        Actor.actExplodeSprite(nSprite);
                        break;
                    }
                }
                break;
            }
            case 413: {
                if (pXSprite.getHealth() <= 0) break;
                if (evCommand == 1) {
                    if (Trigger.SetSpriteState(nSprite, pXSprite, 1) == 0) break;
                    SeqHandling.seqSpawn(VERSION.getSeq(3), 3, pSprite.getExtra(), SeqHandling.callbacks[2]);
                    if (pXSprite.getData1() <= 0) break;
                    pXSprite.setData2(pXSprite.getData1());
                    break;
                }
                if (evCommand != 0 || Trigger.SetSpriteState(nSprite, pXSprite, 0) == 0) break;
                SeqHandling.seqSpawn(VERSION.getSeq(5), 3, pSprite.getExtra(), null);
                break;
            }
            case 452: {
                if (evCommand == 1) {
                    if (Trigger.SetSpriteState(nSprite, pXSprite, 1) == 0) break;
                    SeqHandling.seqSpawn(VERSION.getSeq(3), 3, pSprite.getExtra(), null);
                    SOUND.sfxStart3DSound(pSprite, 441, 0, 0);
                    break;
                }
                if (evCommand != 0 || Trigger.SetSpriteState(nSprite, pXSprite, 0) == 0) break;
                SeqHandling.seqSpawn(VERSION.getSeq(5), 3, pSprite.getExtra(), null);
                SOUND.sfxKill3DSound(pSprite, -1, -1);
                break;
            }
            case 414: {
                if (Trigger.SetSpriteState(nSprite, pXSprite, 1) == 0) break;
                pSprite.setHitag(pSprite.getHitag() | 7);
                break;
            }
            case 416: 
            case 417: 
            case 425: 
            case 426: 
            case 427: {
                switch (evCommand) {
                    case 0: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 0) != 1) break block10;
                        Actor.actGibObject(pSprite, pXSprite);
                        break;
                    }
                    case 1: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, 1) != 1) break block10;
                        Actor.actGibObject(pSprite, pXSprite);
                        break;
                    }
                    default: {
                        if (Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1) != 1) break block10;
                        Actor.actGibObject(pSprite, pXSprite);
                        break;
                    }
                }
                break;
            }
            case 456: {
                switch (evCommand) {
                    case 0: {
                        pXSprite.setState(0);
                        pSprite.setCstat(pSprite.getCstat() | 0x8000);
                        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFFFE);
                        break;
                    }
                    case 1: {
                        pXSprite.setState(1);
                        pSprite.setCstat(pSprite.getCstat() & 0xFFFF7FFF);
                        pSprite.setCstat(pSprite.getCstat() | 1);
                        break;
                    }
                    case 3: {
                        pXSprite.setState(pXSprite.getState() ^ 1);
                        pSprite.setCstat(pSprite.getCstat() ^ 0x8000);
                        pSprite.setCstat(pSprite.getCstat() ^ 1);
                    }
                }
                break;
            }
            case 459: {
                if (evCommand != 1) {
                    pSprite.setCstat(pSprite.getCstat() & 0xFFFF7FFF);
                    Actor.actExplodeSprite(pSprite.getXvel());
                    return;
                }
                Trigger.SetSpriteState(nSprite, pXSprite, 1);
                break;
            }
            case 431: {
                Weapon.LeechOperate(pSprite, pXSprite, evCommand);
                break;
            }
            case 435: {
                AIUNICULT.dudeLeechOperate(pSprite, pXSprite, evCommand);
                break;
            }
            case 27: 
            case 38: {
                switch (evCommand) {
                    case 0: {
                        if (pXSprite.getState() != 1) break block10;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.getState() == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        if (pXSprite.getTxID() <= 0) {
                            if (pSprite.getLotag() == 27) {
                                Trigger.useSeqSpawnerGen(pXSprite, 3, pSprite.getXvel());
                            } else {
                                Trigger.useEffectGen(pXSprite, pSprite);
                            }
                        } else {
                            switch (pXSprite.getCommand()) {
                                case 5: {
                                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                    break;
                                }
                                case 7: {
                                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                    break;
                                }
                                default: {
                                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                                }
                            }
                        }
                        if (pXSprite.getBusyTime() <= 0) break block10;
                        EVENT.evPost(nSprite, 3, Integer.toUnsignedLong((pXSprite.getBusyTime() + Gameutils.BiRandom(pXSprite.getData1())) * 120) / 10L, 21);
                        break;
                    }
                    default: {
                        if (pXSprite.getState() == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                        break;
                    }
                }
                break;
            }
            case 39: {
                switch (evCommand) {
                    case 0: {
                        Trigger.stopWindOnSectors(pXSprite);
                        if (pXSprite.getState() != 1) break block10;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.getState() == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        if (pXSprite.getTxID() <= 0) {
                            Trigger.useSectorWindGen(pXSprite, Main.boardService.getSector(pSprite.getSectnum()));
                        } else {
                            switch (pXSprite.getCommand()) {
                                case 5: {
                                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                    break;
                                }
                                case 7: {
                                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                    break;
                                }
                                default: {
                                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                    EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                                }
                            }
                        }
                        if (pXSprite.getBusyTime() <= 0) break block10;
                        EVENT.evPost(nSprite, 3, Integer.toUnsignedLong(pXSprite.getBusyTime()), 21);
                        break;
                    }
                    default: {
                        if (pXSprite.getState() == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                        break;
                    }
                }
                break;
            }
            case 33: {
                boolean activated = false;
                if (pXSprite.getDropMsg() == 3 && 3 != pXSprite.getData4()) {
                    Trigger.activateDudes(pXSprite.getTxID());
                    activated = true;
                }
                switch (evCommand) {
                    case 0: {
                        if (pXSprite.getData4() == 3 && !activated) {
                            Trigger.activateDudes(pXSprite.getTxID());
                        }
                        if (pXSprite.getState() != 1) break;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.getState() == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        if (pXSprite.getTxID() <= 0 || !Trigger.getDudesForTargetChg(pXSprite)) {
                            EVENT.evPost(nSprite, 3, 0L, 0);
                            break;
                        }
                        switch (pXSprite.getCommand()) {
                            case 5: {
                                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                break;
                            }
                            case 7: {
                                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                break;
                            }
                            default: {
                                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                            }
                        }
                        if (pXSprite.getBusyTime() <= 0) break;
                        EVENT.evPost(nSprite, 3, Integer.toUnsignedLong(pXSprite.getBusyTime()), 21);
                        break;
                    }
                    default: {
                        if (pXSprite.getState() == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                    }
                }
                pXSprite.setDropMsg((short)pXSprite.getData4());
                break;
            }
            case 37: {
                switch (evCommand) {
                    case 0: {
                        if (pXSprite.getState() != 1) break block10;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.getState() == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        if (pXSprite.getTxID() <= 0 || pSprite.getHitag() == 0 && Trigger.goalValueIsReached(pXSprite)) {
                            EVENT.evPost(nSprite, 3, 0L, 0);
                            break;
                        }
                        if (pXSprite.getTxID() <= 0 || pXSprite.getData1() <= 0 || pXSprite.getData1() > 4) break block10;
                        switch (pXSprite.getCommand()) {
                            case 5: {
                                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                break;
                            }
                            case 7: {
                                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                break;
                            }
                            default: {
                                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), 53);
                                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                            }
                        }
                        if (pXSprite.getBusyTime() <= 0) break block10;
                        EVENT.evPost(nSprite, 3, Integer.toUnsignedLong(pXSprite.getBusyTime()), 21);
                        break;
                    }
                    default: {
                        if (pXSprite.getState() == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                        break;
                    }
                }
                break;
            }
            case 704: {
                if (DemoUtils.IsOriginalDemo()) break;
                switch (evCommand) {
                    case 0: {
                        if (pXSprite.getState() != 1) break block10;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.getState() == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        Trigger.ActivateGenerator(nSprite);
                        if (pXSprite.getTxID() != 0) {
                            EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                        }
                        if (pXSprite.getBusyTime() <= 0) break block10;
                        EVENT.evPost(nSprite, 3, Integer.toUnsignedLong(pXSprite.getBusyTime() * 120) / 10L, 21);
                        break;
                    }
                    default: {
                        if (pXSprite.getState() == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                        break;
                    }
                }
                break;
            }
            case 40: 
            case 80: {
                if (DemoUtils.IsOriginalDemo()) break;
                switch (evCommand) {
                    case 0: {
                        if (pXSprite.getState() != 1) break block10;
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 1: {
                        EVENT.checkEventList(nSprite, 3);
                        if (pXSprite.getState() == 0) {
                            Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        }
                    }
                    case 21: {
                        Trigger.ActivateGenerator(nSprite);
                        if (pXSprite.getBusyTime() <= 0) break block10;
                        EVENT.evPost(nSprite, 3, Integer.toUnsignedLong(pXSprite.getBusyTime() * 120) / 10L, 21);
                        break;
                    }
                    default: {
                        if (pXSprite.getState() == 0) {
                            EVENT.evPost(nSprite, 3, 0L, 1);
                            break;
                        }
                        EVENT.evPost(nSprite, 3, 0L, 0);
                        break;
                    }
                }
                break;
            }
            case 700: 
            case 701: 
            case 702: 
            case 703: 
            case 705: 
            case 706: 
            case 707: 
            case 708: {
                switch (evCommand) {
                    case 0: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break;
                    }
                    case 21: {
                        if (pSprite.getLotag() != 700) {
                            Trigger.ActivateGenerator(nSprite);
                        }
                        if (pXSprite.getTxID() != 0) {
                            EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
                        }
                        if (pXSprite.getBusyTime() <= 0) break block10;
                        EVENT.evPost(nSprite, 3, Integer.toUnsignedLong((pXSprite.getBusyTime() + Gameutils.BiRandom(pXSprite.getData1())) * 120) / 10L, 21);
                        break;
                    }
                    default: {
                        if (pXSprite.getState() != 0) break block10;
                        Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        EVENT.evPost(nSprite, 3, 0L, 21);
                        break;
                    }
                }
                break;
            }
            case 711: {
                if (Globals.pGameInfo.nGameType == 0) {
                    if (Globals.gMe == null || Globals.gMe.pXsprite == null || Globals.gMe.pXsprite.getHealth() == 0) {
                        return;
                    }
                    Globals.gMe.stayTime = 0;
                }
                SOUND.sndStartSample(pXSprite.getData1(), -1, 1, false);
                break;
            }
            default: {
                switch (evCommand) {
                    case 0: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 0);
                        break block10;
                    }
                    case 1: {
                        Trigger.SetSpriteState(nSprite, pXSprite, 1);
                        break block10;
                    }
                }
                Trigger.SetSpriteState(nSprite, pXSprite, pXSprite.getState() ^ 1);
            }
        }
    }

    public static void OperateWall(int nWall, XWALL pXWall, int evCommand) {
        Wall pWall = Main.boardService.getWall(nWall);
        switch (evCommand) {
            case 6: {
                pXWall.locked = 1;
                return;
            }
            case 7: {
                pXWall.locked = 0;
                return;
            }
            case 8: {
                pXWall.locked ^= 1;
                return;
            }
        }
        if (pWall.getLotag() == 511) {
            int action = 0;
            switch (evCommand) {
                case 0: {
                    action = Trigger.SetWallState(nWall, pXWall, 0);
                    break;
                }
                case 1: 
                case 51: {
                    action = Trigger.SetWallState(nWall, pXWall, 1);
                    break;
                }
                default: {
                    action = Trigger.SetWallState(nWall, pXWall, pXWall.state ^ 1);
                }
            }
            if (action != 0) {
                int spartType;
                Wall nextWall = null;
                if (pWall.getNextwall() >= 0) {
                    nextWall = Main.boardService.getWall(pWall.getNextwall());
                }
                if (pXWall.state != 0) {
                    pWall.setCstat(pWall.getCstat() & 0xFFFFFFBE);
                    if (nextWall != null) {
                        nextWall.setCstat(nextWall.getCstat() & 0xFFFFFFBE);
                        pWall.setCstat(pWall.getCstat() & 0xFFFFFFEF);
                        nextWall.setCstat(nextWall.getCstat() & 0xFFFFFFEF);
                    }
                } else {
                    pWall.setCstat(pWall.getCstat() | 1);
                    if (pXWall.triggerVector) {
                        pWall.setCstat(pWall.getCstat() | 0x40);
                    }
                    if (nextWall != null) {
                        nextWall.setCstat(nextWall.getCstat() & 0xFFFFFFFE);
                        if (pXWall.triggerVector) {
                            nextWall.setCstat(nextWall.getCstat() | 0x40);
                        }
                        pWall.setCstat(pWall.getCstat() | 0x10);
                        nextWall.setCstat(nextWall.getCstat() | 0x10);
                    }
                }
                if (pXWall.state != 0 && (spartType = Gameutils.ClipRange(pXWall.data, 0, 31)) > 0) {
                    Gib.walGenerateGib(nWall, spartType, wallVel);
                }
            }
        } else {
            switch (evCommand) {
                case 0: {
                    Trigger.SetWallState(nWall, pXWall, 0);
                    break;
                }
                case 1: {
                    Trigger.SetWallState(nWall, pXWall, 1);
                    break;
                }
                default: {
                    Trigger.SetWallState(nWall, pXWall, pXWall.state ^ 1);
                }
            }
        }
    }

    public static void sfxSectorBusy(int nSector, int nBusy) {
        for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
            BloodSprite pSprite = (BloodSprite)node.get();
            if (pSprite.getStatnum() != 0 || pSprite.getLotag() != 709) continue;
            XSPRITE pXSprite = pSprite.getXSprite();
            if (pXSprite != null) {
                if (nBusy != 0) {
                    if (pXSprite.getData3() == 0) continue;
                    SOUND.sfxStart3DSound(pSprite, pXSprite.getData3(), 0, 0);
                    continue;
                }
                if (pXSprite.getData1() == 0) continue;
                SOUND.sfxStart3DSound(pSprite, pXSprite.getData1(), 0, 0);
                continue;
            }
            Console.out.println("Warning: Sector " + nSector + " has wrong SFX generator", OsdColor.RED);
        }
    }

    public static void sfxSectorBusy(int nSector, int soundId, int flags) {
        for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
            Sprite pSprite = node.get();
            if (pSprite.getStatnum() != 0 || pSprite.getLotag() != 709) continue;
            SOUND.sfxStart3DSound(pSprite, soundId, 0, flags);
        }
    }

    public static void sfxSectorStop(int nSector, int nBusy) {
        for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
            Sprite pSprite = node.get();
            if (pSprite.getStatnum() != 0 || pSprite.getLotag() != 709) continue;
            XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
            if (pXSprite != null) {
                if (nBusy != 0) {
                    if (pXSprite.getData2() == 0) continue;
                    SOUND.sfxStart3DSound(pSprite, pXSprite.getData2(), 0, 0);
                    continue;
                }
                if (pXSprite.getData4() == 0) continue;
                SOUND.sfxStart3DSound(pSprite, pXSprite.getData4(), 0, 0);
                continue;
            }
            Console.out.println("Warning: Sector " + nSector + " has wrong SFX generator", OsdColor.RED);
        }
    }

    public static void TranslateSector(int nSector, int i0, int i1, int cx, int cy, int x0, int y0, int a0, int x1, int y1, int a1, boolean fAllWalls) {
        int y;
        int x;
        int i;
        XSECTOR pXSector = DB.xsector[Main.boardService.getSector(nSector).getExtra()];
        int vX = x1 - x0;
        int vY = y1 - y0;
        int vA = a1 - a0;
        int Xi0 = x0 + Pragmas.mulscale(i0, vX, 16);
        int Xi1 = x0 + Pragmas.mulscale(i1, vX, 16);
        int dX = Xi1 - Xi0;
        int Yi0 = y0 + Pragmas.mulscale(i0, vY, 16);
        int Yi1 = y0 + Pragmas.mulscale(i1, vY, 16);
        int dY = Yi1 - Yi0;
        int Ai0 = a0 + Pragmas.mulscale(i0, vA, 16);
        int Ai1 = a0 + Pragmas.mulscale(i1, vA, 16);
        int dA = Ai1 - Ai0;
        short nWall = Main.boardService.getSector(nSector).getWallptr();
        if (fAllWalls) {
            for (i = 0; i < Main.boardService.getSector(nSector).getWallnum(); ++i) {
                x = (int)Trigger.kwall[nWall].x;
                y = (int)Trigger.kwall[nWall].y;
                if (Ai1 != 0) {
                    Point out = Gameutils.RotatePoint(x, y, Ai1, cx, cy);
                    x = out.getX();
                    y = out.getY();
                }
                Main.engine.dragpoint(nWall, x + Xi1 - cx, y + Yi1 - cy);
                nWall = (short)(nWall + 1);
            }
        } else {
            for (i = 0; i < Main.boardService.getSector(nSector).getWallnum(); ++i) {
                Point out;
                short nWall2 = Main.boardService.getWall(nWall).getPoint2();
                x = (int)Trigger.kwall[nWall].x;
                y = (int)Trigger.kwall[nWall].y;
                if ((Main.boardService.getWall(nWall).getCstat() & 0x4000) != 0) {
                    if (Ai1 != 0) {
                        out = Gameutils.RotatePoint(x, y, Ai1, cx, cy);
                        x = out.getX();
                        y = out.getY();
                    }
                    Main.engine.dragpoint(nWall, x + Xi1 - cx, y + Yi1 - cy);
                    if ((Main.boardService.getWall(nWall2).getCstat() & 0xC000) == 0) {
                        x = (int)Trigger.kwall[nWall2].x;
                        y = (int)Trigger.kwall[nWall2].y;
                        if (Ai1 != 0) {
                            out = Gameutils.RotatePoint(x, y, Ai1, cx, cy);
                            x = out.getX();
                            y = out.getY();
                        }
                        Main.engine.dragpoint(nWall2, x + Xi1 - cx, y + Yi1 - cy);
                    }
                } else if ((Main.boardService.getWall(nWall).getCstat() & 0x8000) != 0) {
                    if (Ai1 != 0) {
                        out = Gameutils.RotatePoint(x, y, -Ai1, cx, cy);
                        x = out.getX();
                        y = out.getY();
                    }
                    Main.engine.dragpoint(nWall, x - (Xi1 - cx), y - (Yi1 - cy));
                    if ((Main.boardService.getWall(nWall2).getCstat() & 0xC000) == 0) {
                        x = (int)Trigger.kwall[nWall2].x;
                        y = (int)Trigger.kwall[nWall2].y;
                        if (Ai1 != 0) {
                            out = Gameutils.RotatePoint(x, y, -Ai1, cx, cy);
                            x = out.getX();
                            y = out.getY();
                        }
                        Main.engine.dragpoint(nWall2, x - (Xi1 - cx), y - (Yi1 - cy));
                    }
                }
                nWall = (short)(nWall + 1);
            }
        }
        for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
            int nSprite = node.getIndex();
            BloodSprite pSprite = (BloodSprite)node.get();
            if (!(pSprite.getStatnum() != 10 && pSprite.getStatnum() != 16 || !DemoUtils.IsOriginalDemo() && pSprite.getHitag() == 1)) continue;
            x = (int)pSprite.getKSprite().x;
            y = (int)pSprite.getKSprite().y;
            if ((Main.boardService.getSprite(nSprite).getCstat() & 0x2000) != 0) {
                if (Ai1 != 0) {
                    Point out = Gameutils.RotatePoint(x, y, Ai1, cx, cy);
                    x = out.getX();
                    y = out.getY();
                }
                View.viewBackupSpriteLoc(nSprite, pSprite);
                pSprite.setAng((short)(pSprite.getAng() + dA & 0x7FF));
                if (Gameutils.IsPlayerSprite(pSprite)) {
                    PLAYER pPlayer = Globals.gPlayer[pSprite.getLotag() - 231];
                    pPlayer.ang = ru.m210projects.Build.Gameutils.BClampAngle(pPlayer.ang + (float)dA);
                }
                pSprite.setX(x + Xi1 - cx);
                pSprite.setY(y + Yi1 - cy);
                continue;
            }
            if ((Main.boardService.getSprite(nSprite).getCstat() & 0x4000) != 0) {
                if (Ai1 != 0) {
                    Point out = Gameutils.RotatePoint(x, y, -Ai1, cx, cy);
                    x = out.getX();
                    y = out.getY();
                }
                View.viewBackupSpriteLoc(nSprite, pSprite);
                pSprite.setAng((short)(pSprite.getAng() - dA & 0x7FF));
                if (Gameutils.IsPlayerSprite(pSprite)) {
                    PLAYER pPlayer = Globals.gPlayer[pSprite.getLotag() - 231];
                    pPlayer.ang = ru.m210projects.Build.Gameutils.BClampAngle(pPlayer.ang + (float)dA);
                }
                pSprite.setX(x - (Xi1 - cx));
                pSprite.setY(y - (Yi1 - cy));
                continue;
            }
            if (!pXSector.Drag) continue;
            Gameutils.GetSpriteExtents(pSprite);
            int z = Main.engine.getflorzofslope((short)nSector, pSprite.getX(), pSprite.getY());
            if ((pSprite.getCstat() & 0x30) != 0 || Gameutils.extents_zBot < z) continue;
            if (dA != 0) {
                Point out = Gameutils.RotatePoint(pSprite.getX(), pSprite.getY(), dA, Xi0, Yi0);
                pSprite.setX(out.getX());
                pSprite.setY(out.getY());
            }
            View.viewBackupSpriteLoc(nSprite, pSprite);
            pSprite.setAng((short)(pSprite.getAng() + dA & 0x7FF));
            if (Gameutils.IsPlayerSprite(pSprite)) {
                PLAYER pPlayer = Globals.gPlayer[pSprite.getLotag() - 231];
                pPlayer.ang = ru.m210projects.Build.Gameutils.BClampAngle(pPlayer.ang + (float)dA);
            }
            pSprite.setX(pSprite.getX() + dX);
            pSprite.setY(pSprite.getY() + dY);
        }
    }

    public static void zMotion(int nSector, XSECTOR pXSector, int busy, int opt) {
        int ceilZRange;
        Sector pSector = Main.boardService.getSector(nSector);
        View.viewBackupSectorLoc(nSector, pSector);
        int floorZRange = pXSector.onFloorZ - pXSector.offFloorZ;
        if (floorZRange != 0) {
            int oldFloorZ = pSector.getFloorz();
            pSector.setFloorz(Pragmas.mulscale(floorZRange, Trigger.Lin2Sin(busy, opt), 16) + pXSector.offFloorZ);
            Trigger.secFloorZ[nSector] = pSector.getFloorz();
            int n = nSector;
            Actor.floorVel[n] = Actor.floorVel[n] + ((long)(pSector.getFloorz() - oldFloorZ) << 8);
            for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
                int nSprite = node.getIndex();
                Sprite pSprite = node.get();
                if (DemoUtils.IsOriginalDemo() && (pSprite.getStatnum() == 10 || pSprite.getStatnum() == 16)) continue;
                Gameutils.GetSpriteExtents(pSprite);
                if ((pSprite.getCstat() & 0x2000) != 0) {
                    View.viewBackupSpriteLoc(nSprite, pSprite);
                    pSprite.setZ(pSprite.getZ() + (pSector.getFloorz() - oldFloorZ));
                    continue;
                }
                if ((pSprite.getHitag() & 2) != 0) {
                    pSprite.setHitag(pSprite.getHitag() | 4);
                    continue;
                }
                if (oldFloorZ > Gameutils.extents_zBot || (pSprite.getCstat() & 0x30) != 0) continue;
                View.viewBackupSpriteLoc(nSprite, pSprite);
                pSprite.setZ(pSprite.getZ() + (pSector.getFloorz() - oldFloorZ));
            }
        }
        if ((ceilZRange = pXSector.onCeilZ - pXSector.offCeilZ) != 0) {
            int oldCeilZ = pSector.getCeilingz();
            pSector.setCeilingz(Pragmas.mulscale(ceilZRange, Trigger.Lin2Sin(busy, opt), 16) + pXSector.offCeilZ);
            Trigger.secCeilZ[nSector] = pSector.getCeilingz();
            int n = nSector;
            Actor.ceilingVel[n] = Actor.ceilingVel[n] + ((long)(pSector.getCeilingz() - oldCeilZ) << 8);
            for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
                int nSprite = node.getIndex();
                Sprite pSprite = node.get();
                if (DemoUtils.IsOriginalDemo() && (pSprite.getStatnum() == 10 || pSprite.getStatnum() == 16)) continue;
                Gameutils.GetSpriteExtents(pSprite);
                if ((pSprite.getCstat() & 0x4000) == 0) continue;
                View.viewBackupSpriteLoc(nSprite, pSprite);
                pSprite.setZ(pSprite.getZ() + (pSector.getCeilingz() - oldCeilZ));
            }
        }
    }

    public static int GetHighestSprite(int nSector, int nStatus) {
        getHighestZ = Main.boardService.getSector(nSector).getFloorz();
        int retSprite = -1;
        for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
            int nSprite = node.getIndex();
            Sprite pSprite = node.get();
            if (pSprite.getStatnum() != nStatus && nStatus != 1024) continue;
            Gameutils.GetSpriteExtents(pSprite);
            if (pSprite.getZ() - Gameutils.extents_zTop >= getHighestZ) continue;
            getHighestZ = pSprite.getZ() - Gameutils.extents_zTop;
            retSprite = nSprite;
        }
        return retSprite;
    }

    public static int GetSpriteRange(int nSector) {
        if (nSector < 0 || nSector >= Main.boardService.getSectorCount()) {
            throw new AssertException("nSector >= 0 && nSector < boardService.getSectorCount()");
        }
        int retSprite = -1;
        int ceilingz = Main.boardService.getSector(nSector).getCeilingz();
        for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
            int nSprite = node.getIndex();
            Sprite pSprite = node.get();
            if (pSprite.getStatnum() != 4 && pSprite.getStatnum() != 6) continue;
            Gameutils.GetSpriteExtents(pSprite);
            if (ceilingz <= Gameutils.extents_zTop) continue;
            ceilingz = Gameutils.extents_zTop;
            getRangepzTop = Gameutils.extents_zTop;
            getRangepzBot = Gameutils.extents_zBot;
            retSprite = nSprite;
        }
        return retSprite;
    }

    public static int VCrushBusy(int nSector, int nBusy) {
        System.out.println("crush");
        return 0;
    }

    public static int VSpriteBusy(int nSector, int nBusy) {
        int ceilZRange;
        if (nSector < 0 || nSector >= Main.boardService.getSectorCount()) {
            throw new AssertException("nSector >= 0 && nSector < boardService.getSectorCount()");
        }
        Sector pSector = Main.boardService.getSector(nSector);
        short nXSector = pSector.getExtra();
        if (nXSector <= 0 || nXSector >= 512) {
            throw new AssertException("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        int opt = Trigger.getWave(pXSector, nBusy);
        int floorZRange = pXSector.onFloorZ - pXSector.offFloorZ;
        if (floorZRange != 0) {
            for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
                int nSprite = node.getIndex();
                BloodSprite pSprite = (BloodSprite)node.get();
                if ((pSprite.getCstat() & 0x2000) == 0) continue;
                View.viewBackupSpriteLoc(nSprite, pSprite);
                pSprite.setZ((int)(pSprite.getKSprite().z + (float)Pragmas.mulscale(floorZRange, Trigger.Lin2Sin(nBusy, opt), 16)));
            }
        }
        if ((ceilZRange = pXSector.onCeilZ - pXSector.offCeilZ) != 0) {
            for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
                int nSprite = node.getIndex();
                BloodSprite pSprite = (BloodSprite)node.get();
                if ((pSprite.getCstat() & 0x4000) == 0) continue;
                View.viewBackupSpriteLoc(nSprite, pSprite);
                pSprite.setZ((int)(pSprite.getKSprite().z + (float)Pragmas.mulscale(ceilZRange, Trigger.Lin2Sin(nBusy, opt), 16)));
            }
        }
        pXSector.busy = nBusy;
        if (pXSector.command == 5 && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, 5);
        }
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            Trigger.sfxSectorStop(nSector, nBusy >> 16);
            return 3;
        }
        return 0;
    }

    public static int VDoorBusy(int nSector, int nBusy) {
        if (nSector < 0 || nSector >= Main.boardService.getSectorCount()) {
            throw new AssertException("nSector >= 0 && nSector < boardService.getSectorCount()");
        }
        Sector pSector = Main.boardService.getSector(nSector);
        short nXSector = pSector.getExtra();
        if (nXSector <= 0 || nXSector >= 512) {
            throw new AssertException("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        int nDelta = pXSector.state != 0 ? 65536 / Gameutils.ClipLow(pXSector.busyTime[1] * 120 / 10, 1) : -65536 / Gameutils.ClipLow(pXSector.busyTime[0] * 120 / 10, 1);
        int nSprite = Trigger.GetSpriteRange(nSector);
        if (nSprite >= 0) {
            BloodSprite pSprite = Main.boardService.getSprite(nSprite);
            XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
            if (pXSprite == null) {
                throw new AssertException("pXSprite != null");
            }
            if (nBusy < pXSector.busy) {
                if (pXSector.offCeilZ > pXSector.onCeilZ || pXSector.offFloorZ < pXSector.onFloorZ) {
                    if (pXSector.interruptable) {
                        if (pXSector.Crush) {
                            if (pXSprite.getHealth() == 0) {
                                return 2;
                            }
                            Actor.actDamageSprite(nSprite, pSprite, 0, pXSector.data != 0 ? pXSector.data << 4 : 8000);
                        }
                        nBusy = Gameutils.ClipRange(nBusy + Globals.kFrameTicks * (nDelta / 2), 0, 65536);
                    } else if (pXSector.Crush && pXSprite.getHealth() > 0) {
                        Actor.actDamageSprite(nSprite, pSprite, 0, pXSector.data != 0 ? pXSector.data << 4 : 8000);
                        nBusy = Gameutils.ClipRange(nBusy + Globals.kFrameTicks * (nDelta / 2), 0, 65536);
                    }
                }
            } else if (nBusy > pXSector.busy && (pXSector.onCeilZ > pXSector.offCeilZ || pXSector.onFloorZ < pXSector.offFloorZ)) {
                if (pXSector.interruptable) {
                    if (pXSector.Crush) {
                        if (pXSprite.getHealth() == 0) {
                            return 2;
                        }
                        Actor.actDamageSprite(nSprite, pSprite, 0, pXSector.data != 0 ? pXSector.data << 4 : 8000);
                    }
                    nBusy = Gameutils.ClipRange(nBusy - Globals.kFrameTicks * (nDelta / 2), 0, 65536);
                } else if (pXSector.Crush && pXSprite.getHealth() > 0) {
                    Actor.actDamageSprite(nSprite, pSprite, 0, pXSector.data != 0 ? pXSector.data << 4 : 8000);
                    nBusy = Gameutils.ClipRange(nBusy - Globals.kFrameTicks * (nDelta / 2), 0, 65536);
                }
            }
        }
        Trigger.zMotion(nSector, pXSector, nBusy, Trigger.getWave(pXSector, nBusy));
        pXSector.busy = nBusy;
        if (pXSector.command == 5 && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, 5);
        }
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            Trigger.sfxSectorStop(nSector, nBusy >> 16);
            return 3;
        }
        return 0;
    }

    public static int HDoorBusy(int nSector, int nBusy) {
        if (nSector < 0 || nSector >= Main.boardService.getSectorCount()) {
            throw new AssertException("nSector >= 0 && nSector < boardService.getSectorCount()");
        }
        Sector pSector = Main.boardService.getSector(nSector);
        short nXSector = pSector.getExtra();
        if (nXSector <= 0 || nXSector >= 512) {
            throw new AssertException("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        int opt = Trigger.getWave(pXSector, nBusy);
        BloodSprite pMark0 = Main.boardService.getSprite(pXSector.marker0);
        BloodSprite pMark1 = Main.boardService.getSprite(pXSector.marker1);
        Trigger.TranslateSector(nSector, Trigger.Lin2Sin(pXSector.busy, opt), Trigger.Lin2Sin(nBusy, opt), pMark0.getX(), pMark0.getY(), pMark0.getX(), pMark0.getY(), pMark0.getAng(), pMark1.getX(), pMark1.getY(), pMark1.getAng(), pSector.getLotag() == 616);
        Trigger.zMotion(nSector, pXSector, nBusy, opt);
        pXSector.busy = nBusy;
        if (pXSector.command == 5 && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, 5);
        }
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            Trigger.sfxSectorStop(nSector, nBusy >> 16);
            return 3;
        }
        return 0;
    }

    public static int RDoorBusy(int nSector, int nBusy) {
        if (nSector < 0 || nSector >= Main.boardService.getSectorCount()) {
            throw new AssertException("nSector >= 0 && nSector < boardService.getSectorCount()");
        }
        Sector pSector = Main.boardService.getSector(nSector);
        short nXSector = pSector.getExtra();
        if (nXSector <= 0 || nXSector >= 512) {
            throw new AssertException("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        int opt = Trigger.getWave(pXSector, nBusy);
        BloodSprite pMark = Main.boardService.getSprite(pXSector.marker0);
        Trigger.TranslateSector(nSector, Trigger.Lin2Sin(pXSector.busy, opt), Trigger.Lin2Sin(nBusy, opt), pMark.getX(), pMark.getY(), pMark.getX(), pMark.getY(), 0, pMark.getX(), pMark.getY(), pMark.getAng(), pSector.getLotag() == 617);
        Trigger.zMotion(nSector, pXSector, nBusy, opt);
        pXSector.busy = nBusy;
        if (pXSector.command == 5 && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, 5);
        }
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            Trigger.sfxSectorStop(nSector, nBusy >> 16);
            return 3;
        }
        return 0;
    }

    public static int SRDoorBusy(int nSector, int nBusy) {
        int data;
        int a1;
        int a0;
        if (nSector < 0 || nSector >= Main.boardService.getSectorCount()) {
            throw new AssertException("nSector >= 0 && nSector < boardService.getSectorCount()");
        }
        Sector pSector = Main.boardService.getSector(nSector);
        short nXSector = pSector.getExtra();
        if (nXSector <= 0 || nXSector >= 512) {
            throw new AssertException("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        BloodSprite pMark = Main.boardService.getSprite(pXSector.marker0);
        int opt = Trigger.getWave(pXSector, nBusy);
        if (pXSector.busy >= nBusy) {
            a0 = pXSector.data - pMark.getAng();
            a1 = pXSector.data;
            data = pXSector.data - pMark.getAng();
        } else {
            a0 = pXSector.data;
            a1 = pXSector.data + pMark.getAng();
            data = pXSector.data + pMark.getAng();
        }
        Trigger.TranslateSector(nSector, Trigger.Lin2Sin(pXSector.busy, opt), Trigger.Lin2Sin(nBusy, opt), pMark.getX(), pMark.getY(), pMark.getX(), pMark.getY(), a0, pMark.getX(), pMark.getY(), a1, true);
        pXSector.busy = nBusy;
        if (pXSector.command == 5 && pXSector.txID != 0) {
            EVENT.evSend(nSector, 6, pXSector.txID, 5);
        }
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            pXSector.data = data;
            Trigger.sfxSectorStop(nSector, nBusy >> 16);
            return 3;
        }
        return 0;
    }

    public static int PathSectorBusy(int nSector, int nBusy) {
        if (nSector < 0 || nSector >= Main.boardService.getSectorCount()) {
            throw new AssertException("nSector >= 0 && nSector < boardService.getSectorCount()");
        }
        Sector pSector = Main.boardService.getSector(nSector);
        short nXSector = pSector.getExtra();
        if (nXSector <= 0 || nXSector >= 512) {
            throw new AssertException("nXSector > 0 && nXSector < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[nXSector];
        BloodSprite pMarker0 = Main.boardService.getSprite(pXSector.marker0);
        XSPRITE pXMarker0 = Main.boardService.getXSprite(pMarker0.getExtra());
        BloodSprite pMarker1 = Main.boardService.getSprite(pXSector.marker1);
        XSPRITE pXMarker1 = Main.boardService.getXSprite(pMarker1.getExtra());
        BloodSprite pPivot = Main.boardService.getSprite(secPath[nSector]);
        Trigger.TranslateSector(nSector, Trigger.Lin2Sin(pXSector.busy, pXMarker0.getWave()), Trigger.Lin2Sin(nBusy, pXMarker0.getWave()), pPivot.getX(), pPivot.getY(), pMarker0.getX(), pMarker0.getY(), pMarker0.getAng(), pMarker1.getX(), pMarker1.getY(), pMarker1.getAng(), true);
        Trigger.zMotion(nSector, pXSector, nBusy, pXMarker0.getWave());
        pXSector.busy = nBusy;
        if ((nBusy & 0xFFFF) == 0) {
            EVENT.evPost(nSector, 6, Integer.toUnsignedLong(pXMarker1.getWaitTime() * 120) / 10L, 1);
            pXSector.busy = 0;
            pXSector.state = 0;
            if (pXMarker0.getData4() != 0) {
                Trigger.sfxSectorBusy(nSector, pXMarker0.getData4(), pXSector.busy);
            }
            pXSector.marker0 = pXSector.marker1;
            pXSector.data = pXMarker1.getData1();
            return 3;
        }
        return 0;
    }

    public static void OperateDoor(int nSector, XSECTOR pXSector, int evCommand, int busyProc) {
        switch (evCommand) {
            case 0: {
                if (pXSector.busy == 0) break;
                int nDelta = -65536 / Gameutils.ClipLow(pXSector.busyTime[0] * 120 / 10, 1);
                Trigger.AddBusy(nSector, busyProc, nDelta);
                Trigger.sfxSectorBusy(nSector, 1);
                break;
            }
            case 1: {
                if (pXSector.busy == 65536) break;
                int nDelta = 65536 / Gameutils.ClipLow(pXSector.busyTime[1] * 120 / 10, 1);
                Trigger.AddBusy(nSector, busyProc, nDelta);
                Trigger.sfxSectorBusy(nSector, 0);
                break;
            }
            default: {
                if ((pXSector.busy & 0xFFFF) != 0) {
                    if (!pXSector.interruptable) break;
                    Trigger.ReverseBusy(nSector, busyProc);
                    pXSector.state = (short)(pXSector.state == 0 ? 1 : 0);
                    break;
                }
                int nDelta = pXSector.state == 0 ? 65536 / Gameutils.ClipLow(pXSector.busyTime[1] * 120 / 10, 1) : -65536 / Gameutils.ClipLow(pXSector.busyTime[0] * 120 / 10, 1);
                Trigger.AddBusy(nSector, busyProc, nDelta);
                Trigger.sfxSectorBusy(nSector, pXSector.state);
            }
        }
    }

    public static boolean TeleportDudes(int sectnum) {
        for (ListNode<Sprite> node = Main.boardService.getSectNode(sectnum); node != null; node = node.getNext()) {
            if (node.get().getStatnum() != 6) continue;
            return true;
        }
        return false;
    }

    public static void TeleportDamage(int nSource, int nSector) {
        for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
            BloodSprite pSprite = (BloodSprite)node.get();
            if (pSprite.getStatnum() == 6) {
                Actor.actDamageSprite(nSource, pSprite, 3, 4000);
                continue;
            }
            if (pSprite.getStatnum() != 4) continue;
            Actor.actDamageSprite(nSource, pSprite, 3, 8000);
        }
    }

    public static void OperateTeleport(int nSector, XSECTOR pXSector) {
        if (nSector >= Main.boardService.getSectorCount()) {
            throw new AssertException("nSector < boardService.getSectorCount() " + nSector + " < " + Main.boardService.getSectorCount());
        }
        int nDest = pXSector.marker0;
        if (!Main.boardService.isValidSprite(nDest)) {
            throw new AssertException("isValidSprite(nDest)");
        }
        BloodSprite pDest = Main.boardService.getSprite(nDest);
        if (pDest.getStatnum() != 10) {
            throw new AssertException("pDest.statnum != kStatMarker");
        }
        if (pDest.getLotag() != 8) {
            throw new AssertException("pDest.type != kMarkerWarpDest");
        }
        if (!Main.boardService.isValidSector(pDest.getSectnum())) {
            throw new AssertException("boardService.isValidSector(pDest.getSectnum())");
        }
        for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
            int i = node.getIndex();
            BloodSprite pSprite = (BloodSprite)node.get();
            if (pSprite.getStatnum() != 6) continue;
            PLAYER pPlayer = null;
            if (Gameutils.IsPlayerSprite(pSprite)) {
                pPlayer = Globals.gPlayer[pSprite.getLotag() - 231];
            }
            if (pPlayer == null && Trigger.TeleportDudes(pDest.getSectnum())) continue;
            Trigger.TeleportDamage(pXSector.data, pDest.getSectnum());
            pSprite.setX(pDest.getX());
            pSprite.setY(pDest.getY());
            pSprite.setZ(pSprite.getZ() + (Main.boardService.getSector(pDest.getSectnum()).getFloorz() - Main.boardService.getSector(nSector).getFloorz()));
            pSprite.setAng(pDest.getAng());
            Main.engine.changespritesect((short)i, pDest.getSectnum());
            SOUND.sfxStart3DSound(pDest, 201, -1, 0);
            pSprite.setVelocity(0L, 0L, 0L);
            View.viewBackupSpriteLoc(i, pSprite);
            if (pPlayer == null) continue;
            View.viewUpdatePlayerLoc(pPlayer);
            Globals.gPlayer[pPlayer.nPlayer].viewOffdZ = 0;
            Globals.gPlayer[pPlayer.nPlayer].weapOffdZ = 0;
            Globals.gPlayer[pPlayer.nPlayer].ang = pSprite.getAng();
        }
    }

    public static void OperatePath(int nSector, XSECTOR pXSector, int evCommand) {
        if (nSector >= Main.boardService.getSectorCount()) {
            throw new AssertException("nSector < boardService.getSectorCount()");
        }
        if (pXSector.marker0 == -1) {
            return;
        }
        BloodSprite pMarker = Main.boardService.getSprite(pXSector.marker0);
        XSPRITE pXMarker = Main.boardService.getXSprite(pMarker.getExtra());
        int nMarker2 = -1;
        for (ListNode<Sprite> node = Main.boardService.getStatNode(16); node != null; node = node.getNext()) {
            Sprite pMarker2 = node.get();
            if (pMarker2.getLotag() != 15 || Main.boardService.getXSprite(pMarker2.getExtra()).getData1() != pXMarker.getData2()) continue;
            nMarker2 = node.getIndex();
            break;
        }
        if (nMarker2 == -1) {
            System.err.println("Unable to find path marker with id " + pXMarker.getData2());
            return;
        }
        if (!DemoUtils.IsOriginalDemo() && pXMarker.getState() != 1) {
            Trigger.trTriggerSprite(pMarker.getXvel(), pXMarker, 1);
        }
        pXSector.marker1 = nMarker2;
        pXSector.onFloorZ = Main.boardService.getSprite(nMarker2).getZ();
        pXSector.offFloorZ = pMarker.getZ();
        if (evCommand == 1) {
            pXSector.busy = 0;
            pXSector.state = 0;
            int nDelta = 65536 / Gameutils.ClipLow(pXMarker.getBusyTime() * 120 / 10, 1);
            Trigger.AddBusy(nSector, 7, nDelta);
            if (pXMarker.getData3() != 0) {
                Trigger.sfxSectorBusy(nSector, pXMarker.getData3(), 0);
            }
        }
    }

    public static void OperateSector(int nSector, XSECTOR pXSector, int evCommand) {
        Sector pSector = Main.boardService.getSector(nSector);
        block0 : switch (evCommand) {
            case 6: {
                pXSector.locked = 1;
                break;
            }
            case 7: {
                pXSector.locked = 0;
                if (DemoUtils.IsOriginalDemo() || pSector.getLotag() != 619) break;
                pXSector.state = 0;
                EVENT.evPostCallback(nSector, 6, 0L, 12);
                break;
            }
            case 8: {
                pXSector.locked ^= 1;
                if (DemoUtils.IsOriginalDemo() || pSector.getLotag() != 619 || pXSector.locked == 1) break;
                pXSector.state = 0;
                EVENT.evPostCallback(nSector, 6, 0L, 12);
                break;
            }
            case 9: {
                pXSector.stopFlag[0] = true;
                break;
            }
            case 10: {
                pXSector.stopFlag[1] = true;
                break;
            }
            case 11: {
                pXSector.stopFlag[0] = true;
                pXSector.stopFlag[1] = true;
                break;
            }
            default: {
                switch (pSector.getLotag()) {
                    case 602: {
                        Trigger.OperateDoor(nSector, pXSector, evCommand, 1);
                        break block0;
                    }
                    case 600: {
                        Trigger.OperateDoor(nSector, pXSector, evCommand, 2);
                        break block0;
                    }
                    case 614: 
                    case 616: {
                        Trigger.OperateDoor(nSector, pXSector, evCommand, 3);
                        break block0;
                    }
                    case 615: 
                    case 617: {
                        Trigger.OperateDoor(nSector, pXSector, evCommand, 4);
                        break block0;
                    }
                    case 613: {
                        int nDelta;
                        if (evCommand == 1) {
                            pXSector.busy = 0;
                            pXSector.state = 0;
                            nDelta = 65536 / Gameutils.ClipLow(pXSector.busyTime[1] * 120 / 10, 1);
                            Trigger.AddBusy(nSector, 5, nDelta);
                            Trigger.sfxSectorBusy(nSector, 0);
                        }
                        if (evCommand != 0) break block0;
                        pXSector.busy = 65536;
                        pXSector.state = 1;
                        nDelta = -65536 / Gameutils.ClipLow(pXSector.busyTime[0] * 120 / 10, 1);
                        Trigger.AddBusy(nSector, 5, nDelta);
                        Trigger.sfxSectorBusy(nSector, 0);
                        break block0;
                    }
                    case 604: {
                        Trigger.OperateTeleport(nSector, pXSector);
                        break block0;
                    }
                    case 612: {
                        Trigger.OperatePath(nSector, pXSector, evCommand);
                        break block0;
                    }
                    default: {
                        if (pXSector.busyTime[0] != 0 || pXSector.busyTime[1] != 0) {
                            Trigger.OperateDoor(nSector, pXSector, evCommand, 6);
                            break block0;
                        }
                        if (evCommand == 0) {
                            Trigger.SetSectorState(nSector, pXSector, 0);
                            break block0;
                        }
                        if (evCommand == 1) {
                            Trigger.SetSectorState(nSector, pXSector, 1);
                            break block0;
                        }
                        Trigger.SetSectorState(nSector, pXSector, pXSector.state ^ 1);
                    }
                }
            }
        }
    }

    public static void PathSectorInit(int nSector, XSECTOR pXSector) {
        if (nSector < 0 || nSector >= Main.boardService.getSectorCount()) {
            throw new AssertException("nSector >= 0 && nSector < boardService.getSectorCount()");
        }
        int nMarker2 = -1;
        for (ListNode<Sprite> node = Main.boardService.getStatNode(16); node != null; node = node.getNext()) {
            Sprite pSprite = node.get();
            if (pSprite.getLotag() != 15 || Main.boardService.getXSprite(pSprite.getExtra()).getData1() != pXSector.data) continue;
            nMarker2 = node.getIndex();
            break;
        }
        pXSector.marker0 = nMarker2;
        Trigger.secPath[nSector] = nMarker2;
        if (pXSector.state != 0) {
            EVENT.evPost(nSector, 6, 0L, 1);
        }
    }

    public static void LinkSector(int nSector, XSECTOR pXSector, int event) {
        Sector pSector = Main.boardService.getSector(nSector);
        int nBusy = Trigger.GetSourceBusy(event);
        switch (pSector.getLotag()) {
            case 602: {
                Trigger.VSpriteBusy(nSector, nBusy);
                break;
            }
            case 600: {
                Trigger.VDoorBusy(nSector, nBusy);
                break;
            }
            case 614: 
            case 616: {
                Trigger.HDoorBusy(nSector, nBusy);
                break;
            }
            case 615: 
            case 617: {
                Trigger.RDoorBusy(nSector, nBusy);
                break;
            }
            case 619: {
                if (!DemoUtils.IsOriginalDemo()) {
                    short nXIndex = Main.boardService.getSector(EVENT.getIndex(event)).getExtra();
                    if (nXIndex <= 0 || nXIndex >= 512) {
                        throw new AssertException("nXIndex > 0 && nXIndex < kMaxXSectors");
                    }
                    pXSector.waitTime[1] = DB.xsector[nXIndex].waitTime[1];
                    pXSector.data = DB.xsector[nXIndex].data;
                    break;
                }
            }
            default: {
                pXSector.busy = nBusy;
                if ((nBusy & 0xFFFF) != 0) break;
                Trigger.SetSectorState(nSector, pXSector, nBusy >> 16);
            }
        }
    }

    public static void LinkSprite(int nSprite, XSPRITE pXSprite, int event) {
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        int nBusy = Trigger.GetSourceBusy(event);
        switch (pSprite.getLotag()) {
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                BloodSprite pSprite2;
                XSPRITE pXSprite2;
                if (EVENT.getType(event) != 3 || (pXSprite2 = Main.boardService.getXSprite((pSprite2 = Main.boardService.getSprite(EVENT.getIndex(event))).getExtra())) == null) break;
                block5 : switch (pSprite.getLotag()) {
                    case 6: 
                    case 10: 
                    case 12: 
                    case 14: {
                        switch (pSprite2.getLotag()) {
                            case 6: 
                            case 10: 
                            case 12: 
                            case 14: {
                                break block5;
                            }
                        }
                        return;
                    }
                    case 7: 
                    case 9: 
                    case 11: 
                    case 13: {
                        switch (pSprite2.getLotag()) {
                            case 7: 
                            case 9: 
                            case 11: 
                            case 13: {
                                break block5;
                            }
                        }
                        return;
                    }
                }
                if (pXSprite.getData2() < 5 && pXSprite2.getData2() < 5) {
                    short tmp2 = pXSprite2.getData2();
                    pXSprite2.setData2(pXSprite.getData2());
                    pXSprite.setData2(tmp2);
                }
                short tmp3 = pSprite2.getLotag();
                pSprite2.setLotag(pSprite.getLotag());
                pSprite.setLotag(tmp3);
                Sector pSector = Main.boardService.getSector(pSprite.getSectnum());
                Sector pSector2 = Main.boardService.getSector(pSprite2.getSectnum());
                XSECTOR pXSector = null;
                XSECTOR pXSector2 = null;
                if (pSector.getExtra() > 0) {
                    pXSector = DB.xsector[pSector.getExtra()];
                }
                if (pSector2.getExtra() > 0) {
                    pXSector2 = DB.xsector[pSector2.getExtra()];
                }
                if (pXSector != null && pXSector2 != null) {
                    boolean tmp6 = pXSector.Underwater;
                    pXSector.Underwater = pXSector2.Underwater;
                    pXSector2.Underwater = tmp6;
                }
                if (pXSprite2.getData3() == 1) {
                    short tmp4 = pSector.getFloorpicnum();
                    pSector.setFloorpicnum(pSector2.getFloorpicnum());
                    pSector2.setFloorpicnum(tmp4);
                }
                if (pXSprite2.getData4() != 1) break;
                short tmp5 = pSector.getCeilingpicnum();
                pSector.setCeilingpicnum(pSector2.getCeilingpicnum());
                pSector2.setCeilingpicnum(tmp5);
                break;
            }
            case 15: {
                if (EVENT.getType(event) != 3) break;
                XSPRITE pXSprite2 = Main.boardService.getXSprite(Main.boardService.getSprite(EVENT.getIndex(event)).getExtra());
                pXSprite.setData1(pXSprite2.getData1());
                pXSprite.setData2(pXSprite2.getData2());
                pXSprite.setData3(pXSprite2.getData3());
                pXSprite.setBusyTime(pXSprite2.getBusyTime());
                pXSprite.setWaitTime(pXSprite2.getWaitTime());
                break;
            }
            case 22: {
                if (EVENT.getType(event) != 3) break;
                XSPRITE pXSprite2 = Main.boardService.getXSprite(Main.boardService.getSprite(EVENT.getIndex(event)).getExtra());
                if (pXSprite2 == null) {
                    throw new AssertException("pXSprite2 != null");
                }
                pXSprite.setData1(pXSprite2.getData1());
                if (pXSprite.getData1() == pXSprite.getData2()) {
                    Trigger.SetSpriteState(nSprite, pXSprite, 1);
                    break;
                }
                Trigger.SetSpriteState(nSprite, pXSprite, 0);
                break;
            }
            default: {
                pXSprite.setBusy(nBusy);
                if ((nBusy & 0xFFFF) != 0) break;
                Trigger.SetSpriteState(nSprite, pXSprite, nBusy >> 16);
            }
        }
    }

    public static void LinkWall(int nWall, XWALL pXWall, int event) {
        int nBusy;
        Wall pWall = Main.boardService.getWall(nWall);
        pXWall.busy = nBusy = Trigger.GetSourceBusy(event);
        if ((nBusy & 0xFFFF) == 0) {
            Trigger.SetWallState(nWall, pXWall, nBusy >> 16);
        }
    }

    public static void trTriggerSector(int nSector, XSECTOR pXSector, int command) {
        if (pXSector.locked != 0) {
            return;
        }
        if (pXSector.isTriggered) {
            return;
        }
        if (pXSector.triggerOnce) {
            pXSector.isTriggered = true;
        }
        if (pXSector.decoupled) {
            if (pXSector.txID != 0) {
                EVENT.evSend(nSector, 6, pXSector.txID, pXSector.command);
            }
        } else {
            Trigger.OperateSector(nSector, pXSector, command);
        }
    }

    public static void pastePropertiesInObj(int type, int nDest, int event) {
        if (EVENT.getType(event) != 3) {
            return;
        }
        BloodSprite pSource = Main.boardService.getSprite(EVENT.getIndex(event));
        XSPRITE pXSource = Main.boardService.getXSprite(pSource.getExtra());
        if (pSource.getLotag() == 8) {
            Trigger.useTeleportTarget(pXSource, Main.boardService.getSprite(nDest));
        } else if (pSource.getLotag() == 36) {
            if (Main.boardService.getXSprite(Main.boardService.getSprite(nDest).getExtra()).getHealth() > 0) {
                Trigger.useSpriteDamager(pXSource, Main.boardService.getSprite(nDest));
            }
        } else if (pSource.getLotag() == 38) {
            if (pXSource.getData2() < 0 || pXSource.getData2() >= 57) {
                return;
            }
            if (type == 3) {
                Trigger.useEffectGen(pXSource, Main.boardService.getSprite(nDest));
            }
        } else if (pSource.getLotag() == 27) {
            if (pXSource.getData2() > 0 && !Main.game.getCache().contains(pXSource.getData2(), "SEQ")) {
                return;
            }
            if (pXSource.getData2() >= 0) {
                Trigger.useSeqSpawnerGen(pXSource, type, nDest);
            }
        } else if (pSource.getLotag() == 39) {
            if (type != 6) {
                return;
            }
            Trigger.useSectorWindGen(pXSource, Main.boardService.getSector(nDest));
        } else if (pSource.getLotag() == 37) {
            long data = Trigger.getDataFieldOfObject(type, nDest, pXSource.getData1());
            if (data == -65535L) {
                throw new AssertException("Can't get data field #" + pXSource.getData1() + " of object #" + nDest + ", type " + type + "!\n");
            }
            if (pXSource.getData2() < pXSource.getData3()) {
                if (data < (long)pXSource.getData2()) {
                    data = pXSource.getData2();
                }
                if (data > (long)pXSource.getData3()) {
                    data = pXSource.getData3();
                }
                if ((data += (long)pXSource.getData4()) >= (long)pXSource.getData3()) {
                    switch (pSource.getHitag()) {
                        case 0: 
                        case 1: {
                            if (data <= (long)pXSource.getData3()) break;
                            data = pXSource.getData3();
                            break;
                        }
                        case 2: {
                            if (data > (long)pXSource.getData3()) {
                                data = pXSource.getData3();
                            }
                            if (!Trigger.goalValueIsReached(pXSource)) break;
                            short tmp = pXSource.getData3();
                            pXSource.setData3(pXSource.getData2());
                            pXSource.setData2(tmp);
                            break;
                        }
                        case 3: {
                            if (data <= (long)pXSource.getData3()) break;
                            data = pXSource.getData2();
                        }
                    }
                }
            } else if (pXSource.getData2() > pXSource.getData3()) {
                if (data > (long)pXSource.getData2()) {
                    data = pXSource.getData2();
                }
                if (data < (long)pXSource.getData3()) {
                    data = pXSource.getData3();
                }
                if ((data -= (long)pXSource.getData4()) <= (long)pXSource.getData3()) {
                    switch (pSource.getHitag()) {
                        case 0: 
                        case 1: {
                            if (data >= (long)pXSource.getData3()) break;
                            data = pXSource.getData3();
                            break;
                        }
                        case 2: {
                            if (data < (long)pXSource.getData3()) {
                                data = pXSource.getData3();
                            }
                            if (!Trigger.goalValueIsReached(pXSource)) break;
                            short tmp = pXSource.getData3();
                            pXSource.setData3(pXSource.getData2());
                            pXSource.setData2(tmp);
                            break;
                        }
                        case 3: {
                            if (data >= (long)pXSource.getData3()) break;
                            data = pXSource.getData2();
                        }
                    }
                }
            }
            Trigger.setDataValueOfObject(type, nDest, pXSource.getData1(), (short)data);
        } else if (pSource.getLotag() == 35) {
            switch (type) {
                case 6: {
                    if ((pSource.getHitag() & 1) == 0 && (pXSource.getData1() == -1 || pXSource.getData1() == Short.MAX_VALUE)) break;
                    DB.xsector[Main.boardService.getSector((int)nDest).getExtra()].data = pXSource.getData1();
                    break;
                }
                case 3: {
                    XSPRITE pXSprite = Main.boardService.getXSprite(Main.boardService.getSprite(nDest).getExtra());
                    if ((pSource.getHitag() & 1) != 0 || pXSource.getData1() != -1 && pXSource.getData1() != Short.MAX_VALUE) {
                        pXSprite.setData1(pXSource.getData1());
                    }
                    if ((pSource.getHitag() & 1) != 0 || pXSource.getData2() != -1 && pXSource.getData2() != Short.MAX_VALUE) {
                        pXSprite.setData2(pXSource.getData2());
                    }
                    if ((pSource.getHitag() & 1) != 0 || pXSource.getData3() != -1 && pXSource.getData3() != Short.MAX_VALUE) {
                        pXSprite.setData3(pXSource.getData3());
                    }
                    if ((pSource.getHitag() & 1) == 0 && (pXSource.getData4() == -1 || pXSource.getData1() == 65535)) break;
                    pXSprite.setData4(pXSource.getData4());
                    break;
                }
                case 0: {
                    if ((pSource.getHitag() & 1) == 0 && (pXSource.getData1() == -1 || pXSource.getData1() == Short.MAX_VALUE)) break;
                    DB.xwall[Main.boardService.getWall((int)nDest).getExtra()].data = pXSource.getData1();
                }
            }
        } else if (pSource.getLotag() == 34) {
            if (type != 6) {
                return;
            }
            XSECTOR pXSector = DB.xsector[Main.boardService.getSector(nDest).getExtra()];
            if (Trigger.valueIsBetween(pXSource.getData1(), -1, Short.MAX_VALUE)) {
                pXSector.wave = (short)(pXSource.getData1() > 11 ? 11 : (int)pXSource.getData1());
            }
            short oldAmplitude = pXSector.amplitude;
            if (pXSource.getData2() >= 0) {
                pXSector.amplitude = (short)(pXSource.getData2() > 127 ? 127 : (int)pXSource.getData2());
            } else if (pXSource.getData2() < -1) {
                pXSector.amplitude = (short)(pXSource.getData2() < -127 ? -127 : (int)pXSource.getData2());
            }
            if (Trigger.valueIsBetween(pXSource.getData3(), -1, Short.MAX_VALUE)) {
                pXSector.freq = (short)(pXSource.getData3() > 255 ? 255 : (int)pXSource.getData3());
            }
            if (Trigger.valueIsBetween(pXSource.getData4(), -1, 65535)) {
                pXSector.phase = (short)(pXSource.getData4() > 255 ? 255 : (short)pXSource.getData4());
            }
            if ((pSource.getHitag() & 1) != 0) {
                pXSector.shadeAlways = true;
            }
            if (oldAmplitude == 0 && pXSector.amplitude != 0) {
                int i = SECTORFX.shadeCount;
                while (i >= 0 && SECTORFX.shadeList[i] != Main.boardService.getSector(nDest).getExtra()) {
                    if (i == 0) {
                        SECTORFX.shadeList[SECTORFX.shadeCount++] = Main.boardService.getSector(nDest).getExtra();
                    }
                    --i;
                }
            }
        } else if (pSource.getLotag() == 33) {
            XSPRITE pXMateTarget;
            Sprite pMateTarget;
            Sprite pPlayer;
            if (type != 3 || !Actor.IsDudeSprite(Main.boardService.getSprite(nDest)) || Main.boardService.getSprite(nDest).getStatnum() != 6) {
                return;
            }
            BloodSprite pSprite = Main.boardService.getSprite(nDest);
            XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
            DudeExtra pXDude = pXSprite.getDudeExtra();
            BloodSprite pTarget = null;
            XSPRITE pXTarget = null;
            int receiveHp = 33 + Gameutils.Random(33);
            DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
            int matesPerEnemy = 1;
            if (pXSprite.getBurnTime() > 0) {
                if (!Actor.IsBurningDude(pSprite)) {
                    XSPRITE pXBurn;
                    BloodSprite pBurnSource = Main.boardService.getSprite(pXSprite.getBurnSource());
                    if (pBurnSource != null && (pXBurn = Main.boardService.getXSprite(pBurnSource.getExtra())) != null) {
                        if (pXSource.getData2() == 1 && Trigger.isMateOf(pXSprite, pXBurn)) {
                            pXSprite.setBurnTime(0);
                            if (pXSprite.getData4() > 0 && pXSprite.getHealth() < pXSprite.getData4()) {
                                Actor.actHealDude(pXSprite, receiveHp, pXSprite.getData4());
                            } else if (pXSprite.getHealth() < pDudeInfo.startHealth) {
                                Actor.actHealDude(pXSprite, receiveHp, pDudeInfo.startHealth);
                            }
                        } else if (pBurnSource.getXvel() == pSprite.getXvel() || pXBurn.getHealth() <= 0) {
                            pXSprite.setBurnTime(0);
                        }
                    }
                } else {
                    Actor.actKillSprite(pSource.getXvel(), pSprite, 0, 65535);
                    return;
                }
            }
            if ((pPlayer = Trigger.targetIsPlayer(pXSprite)) != null && pXSprite.getAIState() != Ai.genIdle) {
                if (pXSource.getData4() == 3) {
                    Ai.aiSetTarget(pXSprite, pSprite.getX(), pSprite.getY(), pSprite.getZ());
                    Ai.aiNewState(pSprite, pXSprite, Ai.genIdle);
                    pXDude.setActive(false);
                    if (pSprite.getLotag() == 254) {
                        AIUNICULT.removeLeech(AIUNICULT.leechIsDropped(pSprite));
                    }
                } else if (pXSource.getData4() == 4) {
                    Ai.aiSetTarget(pXSprite, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ());
                    if (pSprite.getLotag() == 254) {
                        AIUNICULT.removeLeech(AIUNICULT.leechIsDropped(pSprite));
                    }
                }
            }
            int maxAlarmDudes = 8 + Gameutils.Random(8);
            pTarget = Main.boardService.getSprite(pXSprite.getTarget());
            if (pTarget != null && (pXTarget = Main.boardService.getXSprite(pTarget.getExtra())) != null && pPlayer == null) {
                if (Trigger.unitCanFly(pSprite) && Trigger.isMeleeUnit(pTarget) && !Trigger.unitCanFly(pTarget)) {
                    pSprite.setHitag(pSprite.getHitag() | 2);
                } else if (Trigger.unitCanFly(pSprite)) {
                    pSprite.setHitag(pSprite.getHitag() & 0xFFFFFFFD);
                }
                if (!Actor.IsDudeSprite(pTarget) || pXTarget.getHealth() < 1 || !Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, pTarget)) {
                    Ai.aiSetTarget(pXSprite, pSprite.getX(), pSprite.getY(), pSprite.getZ());
                } else if (pXSource.getData1() != 666 && pXTarget.getData1() != pXSource.getData1()) {
                    if (Trigger.affectedByTargetChg(pXTarget) != null) {
                        Ai.aiSetTarget(pXSprite, pSprite.getX(), pSprite.getY(), pSprite.getZ());
                        if (pXSprite.getBurnSource() == pTarget.getXvel()) {
                            pXSprite.setBurnTime(0);
                            pXSprite.setBurnSource(-1);
                        }
                        Ai.aiSetTarget(pXTarget, pTarget.getX(), pTarget.getY(), pTarget.getZ());
                        if (pXTarget.getBurnSource() == pSprite.getXvel()) {
                            pXTarget.setBurnTime(0);
                            pXTarget.setBurnSource(-1);
                        }
                    }
                } else if (Trigger.isAnnoyingUnit(pTarget) && !Trigger.isAnnoyingUnit(pSprite) && Main.engine.getTile(pSprite.getPicnum()).getHeight() >= 60 && Trigger.getTargetDist(pSprite, pDudeInfo, pTarget) < 2) {
                    Actor.actKillSprite(pSource.getXvel(), pTarget, 0, 65535);
                    Ai.aiSetTarget(pXSprite, pSprite.getX(), pSprite.getY(), pSprite.getZ());
                } else if (pXSource.getData2() == 1 && Trigger.isMateOf(pXSprite, pXTarget)) {
                    BloodSprite pMate = pTarget;
                    XSPRITE pXMate = pXTarget;
                    if (pXSprite.getData4() > 0 && pXSprite.getHealth() < pXSprite.getData4()) {
                        Actor.actHealDude(pXSprite, receiveHp, pXSprite.getData4());
                    } else if (pXSprite.getHealth() < pDudeInfo.startHealth) {
                        Actor.actHealDude(pXSprite, receiveHp, pDudeInfo.startHealth);
                    }
                    if (pXMate.getData4() > 0 && pXMate.getHealth() < pXMate.getData4()) {
                        Actor.actHealDude(pXMate, receiveHp, pXMate.getData4());
                    } else {
                        DudeInfo pTDudeInfo = DudeInfo.dudeInfo[pMate.getLotag() - 200];
                        if (pXMate.getHealth() < pTDudeInfo.startHealth) {
                            Actor.actHealDude(pXMate, receiveHp, pTDudeInfo.startHealth);
                        }
                    }
                    if (pXMate.getTarget() > -1 && Main.boardService.getSprite(pXMate.getTarget()).getExtra() >= 0) {
                        pTarget = Main.boardService.getSprite(pXMate.getTarget());
                        if (pXMate.getTarget() == pSprite.getXvel()) {
                            Ai.aiSetTarget(pXMate, pMate.getX(), pMate.getY(), pMate.getZ());
                        } else {
                            if (!Trigger.isMateOf(pXSprite, Main.boardService.getXSprite(pTarget.getExtra()))) {
                                Ai.aiSetTarget(pXSprite, pTarget.getXvel());
                                return;
                            }
                            Ai.aiSetTarget(pXMate, pMate.getX(), pMate.getY(), pMate.getZ());
                        }
                    }
                    if (pXSprite.getTarget() == pMate.getXvel()) {
                        Ai.aiSetTarget(pXSprite, pSprite.getX(), pSprite.getY(), pSprite.getZ());
                    }
                } else if (Trigger.targetIsPlayer(pXTarget) != null) {
                    Ai.aiSetTarget(pXTarget, pSprite.getXvel());
                }
                int mDist = 3;
                if (Trigger.isMeleeUnit(pSprite)) {
                    mDist = 2;
                }
                if (pXSprite.getTarget() >= 0 && Trigger.getTargetDist(pSprite, pDudeInfo, Main.boardService.getSprite(pXSprite.getTarget())) < mDist) {
                    if (!Trigger.isActive(pXSprite)) {
                        Ai.aiActivateDude(pSprite, pXSprite);
                    }
                    return;
                }
                if ((Globals.gFrameClock & 0x100) != 0 && (pXSprite.getTarget() < 0 || Trigger.getTargetDist(pSprite, pDudeInfo, pTarget) >= mDist) && (pTarget = Trigger.getTargetInRange(pSprite, 0, mDist, pXSource.getData1(), pXSource.getData2())) != null) {
                    pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
                    if (pXSprite.getTarget() > -1) {
                        BloodSprite prvTarget = Main.boardService.getSprite(pXSprite.getTarget());
                        Ai.aiSetTarget(Main.boardService.getXSprite(prvTarget.getExtra()), prvTarget.getX(), prvTarget.getY(), prvTarget.getZ());
                        if (!Trigger.isActive(pXTarget)) {
                            Ai.aiActivateDude(pTarget, pXTarget);
                        }
                    }
                    Ai.aiSetTarget(pXSprite, pTarget.getXvel());
                    if (!Trigger.isActive(pXSprite)) {
                        Ai.aiActivateDude(pSprite, pXSprite);
                    }
                    if (pXSource.getData3() > 0 && pXTarget.getTarget() != pSprite.getXvel()) {
                        Ai.aiSetTarget(pXTarget, pSprite.getXvel());
                        if (!Trigger.isActive(pXTarget)) {
                            Ai.aiActivateDude(pTarget, pXTarget);
                        }
                    }
                    return;
                }
            }
            if ((pTarget == null || pPlayer != null) && (Globals.gFrameClock & 0x20) != 0) {
                for (ListNode<Sprite> node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
                    pTarget = (BloodSprite)node.get();
                    pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
                    if (pXTarget.getTarget() == pSprite.getXvel()) {
                        Ai.aiSetTarget(pXSprite, pTarget.getXvel());
                        return;
                    }
                    if (!Actor.IsDudeSprite(pTarget) || Gameutils.IsPlayerSprite(pTarget) && pXSource.getData4() > 0 || !Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, pTarget) || pSprite.getXvel() == pTarget.getXvel() || pTarget.getOwner() == pSprite.getXvel() || pXSource.getData1() != 666 && pXSource.getData1() != pXTarget.getData1() || Actor.IsBurningDude(pTarget) || Actor.isImmortalDude(pTarget) || pXSource.getData2() == 1 && Trigger.isMateOf(pXSprite, pXTarget)) continue;
                    if (pXSource.getData2() != 0 && (pXSource.getData2() != 1 || Trigger.isMatesHaveSameTarget(pXSprite, pTarget, matesPerEnemy))) break;
                    Ai.aiSetTarget(pXSprite, pTarget.getXvel());
                    if (!Trigger.isActive(pXSprite)) {
                        Ai.aiActivateDude(pSprite, pXSprite);
                    }
                    if (pXSource.getData3() > 0 && pXTarget.getTarget() != pSprite.getXvel()) {
                        Ai.aiSetTarget(pXTarget, pSprite.getXvel());
                        if (!Trigger.isActive(pXTarget)) {
                            Ai.aiActivateDude(pTarget, pXTarget);
                        }
                        if (pXSource.getData3() == 2) {
                            Trigger.disturbDudesInSight(pTarget, maxAlarmDudes);
                        }
                    }
                    return;
                }
            }
            if ((pXSprite.getTarget() < 0 || pPlayer != null) && pXSource.getData2() == 1 && (Globals.gFrameClock & 0x40) != 0 && (pMateTarget = Trigger.getMateTargets(pXSprite)) != null && (pXMateTarget = Main.boardService.getXSprite(pMateTarget.getExtra())) != null) {
                if (Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, pMateTarget)) {
                    if (pXMateTarget.getTarget() < 0) {
                        Ai.aiSetTarget(pXMateTarget, pSprite.getXvel());
                        if (Actor.IsDudeSprite(pMateTarget) && !Trigger.isActive(pXMateTarget)) {
                            Ai.aiActivateDude((BloodSprite)pMateTarget, pXMateTarget);
                        }
                    }
                    Ai.aiSetTarget(pXSprite, pMateTarget.getXvel());
                    if (!Trigger.isActive(pXSprite)) {
                        Ai.aiActivateDude(pSprite, pXSprite);
                    }
                } else if (pXMateTarget.getTarget() >= 0 && Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, Main.boardService.getSprite(pXMateTarget.getTarget()))) {
                    BloodSprite pMate = Main.boardService.getSprite(pXMateTarget.getTarget());
                    pXSprite.setTarget(pMateTarget.getXvel());
                    pXSprite.setTargetX(pMate.getX());
                    pXSprite.setTargetY(pMate.getY());
                    pXSprite.setTargetZ(pMate.getZ());
                    if (!Trigger.isActive(pXSprite)) {
                        Ai.aiActivateDude(pSprite, pXSprite);
                    }
                }
            }
        } else if (pSource.getLotag() == 31) {
            if (pXSource.getData1() > 255) {
                pXSource.setData1(255);
            }
            if (pXSource.getData2() > 255) {
                pXSource.setData2(255);
            }
            if (pXSource.getData3() > 255) {
                pXSource.setData3(255);
            }
            if (Trigger.valueIsBetween(pXSource.getData4(), 255, 65535)) {
                pXSource.setData4(255);
            }
            switch (type) {
                case 6: {
                    if (Trigger.valueIsBetween(pXSource.getData1(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getSector(nDest).setFloorxpanning(pXSource.getData1());
                    }
                    if (Trigger.valueIsBetween(pXSource.getData2(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getSector(nDest).setFloorypanning(pXSource.getData2());
                    }
                    if (Trigger.valueIsBetween(pXSource.getData3(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getSector(nDest).setCeilingxpanning(pXSource.getData3());
                    }
                    if (!Trigger.valueIsBetween(pXSource.getData4(), -1, 65535)) break;
                    Main.boardService.getSector(nDest).setCeilingypanning((short)pXSource.getData4());
                    break;
                }
                case 3: {
                    if (Trigger.valueIsBetween(pXSource.getData1(), -1, Short.MAX_VALUE)) {
                        if (pXSource.getData1() < 1) {
                            Main.boardService.getSprite(nDest).setXrepeat(0);
                        } else {
                            Main.boardService.getSprite(nDest).setXrepeat(pXSource.getData1());
                        }
                    }
                    if (Trigger.valueIsBetween(pXSource.getData2(), -1, Short.MAX_VALUE)) {
                        if (pXSource.getData2() < 1) {
                            Main.boardService.getSprite(nDest).setYrepeat(0);
                        } else {
                            Main.boardService.getSprite(nDest).setYrepeat(pXSource.getData2());
                        }
                    }
                    if (Trigger.valueIsBetween(pXSource.getData3(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getSprite(nDest).setXoffset(pXSource.getData3());
                    }
                    if (!Trigger.valueIsBetween(pXSource.getData4(), -1, 65535)) break;
                    Main.boardService.getSprite(nDest).setYoffset((short)pXSource.getData4());
                    break;
                }
                case 0: {
                    if (Trigger.valueIsBetween(pXSource.getData1(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getWall(nDest).setXrepeat(pXSource.getData1());
                    }
                    if (Trigger.valueIsBetween(pXSource.getData2(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getWall(nDest).setYrepeat(pXSource.getData2());
                    }
                    if (Trigger.valueIsBetween(pXSource.getData3(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getWall(nDest).setXpanning(pXSource.getData3());
                    }
                    if (!Trigger.valueIsBetween(pXSource.getData4(), -1, 65535)) break;
                    Main.boardService.getWall(nDest).setYpanning((short)pXSource.getData4());
                }
            }
        } else if (pSource.getLotag() == 29) {
            switch (type) {
                case 6: {
                    if (Trigger.valueIsBetween(pXSource.getData1(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getSector(nDest).setFloorpicnum(pXSource.getData1());
                    }
                    if (Trigger.valueIsBetween(pXSource.getData2(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getSector(nDest).setCeilingpicnum(pXSource.getData2());
                    }
                    XSECTOR pXSector = DB.xsector[Main.boardService.getSector(nDest).getExtra()];
                    if (Trigger.valueIsBetween(pXSource.getData3(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getSector(nDest).setFloorpal(pXSource.getData3());
                        if ((pSource.getHitag() & 1) != 0) {
                            pXSector.floorpal = pXSource.getData3();
                        }
                    }
                    if (!Trigger.valueIsBetween(pXSource.getData4(), -1, 65535)) break;
                    Main.boardService.getSector(nDest).setCeilingpal((short)pXSource.getData4());
                    if ((pSource.getHitag() & 1) == 0) break;
                    pXSector.ceilpal = (short)pXSource.getData4();
                    break;
                }
                case 3: {
                    if (Trigger.valueIsBetween(pXSource.getData1(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getSprite(nDest).setPicnum(pXSource.getData1());
                    }
                    if (pXSource.getData2() >= 0) {
                        Main.boardService.getSprite(nDest).setShade((byte)(pXSource.getData2() > 127 ? 127 : (int)pXSource.getData2()));
                    } else if (pXSource.getData2() < -1) {
                        Main.boardService.getSprite(nDest).setShade((byte)(pXSource.getData2() < -127 ? -127 : (int)pXSource.getData2()));
                    }
                    if (!Trigger.valueIsBetween(pXSource.getData3(), -1, Short.MAX_VALUE)) break;
                    Main.boardService.getSprite(nDest).setPal(pXSource.getData3());
                    break;
                }
                case 0: {
                    if (Trigger.valueIsBetween(pXSource.getData1(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getWall(nDest).setPicnum(pXSource.getData1());
                    }
                    if (Trigger.valueIsBetween(pXSource.getData2(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getWall(nDest).setOverpicnum(pXSource.getData2());
                    }
                    if (!Trigger.valueIsBetween(pXSource.getData3(), -1, Short.MAX_VALUE)) break;
                    Main.boardService.getWall(nDest).setPal(pXSource.getData3());
                }
            }
        } else if (pSource.getLotag() == 28) {
            switch (type) {
                case 6: {
                    XSECTOR pXSector = DB.xsector[Main.boardService.getSector(nDest).getExtra()];
                    switch (pXSource.getData1()) {
                        case 0: {
                            pXSector.Underwater = false;
                            break;
                        }
                        case 1: {
                            pXSector.Underwater = true;
                            break;
                        }
                        case 2: {
                            pXSector.Depth = 0;
                            break;
                        }
                        case 3: {
                            pXSector.Depth = 1;
                            break;
                        }
                        case 4: {
                            pXSector.Depth = (short)2;
                            break;
                        }
                        case 5: {
                            pXSector.Depth = (short)3;
                            break;
                        }
                        case 6: {
                            pXSector.Depth = (short)4;
                            break;
                        }
                        case 7: {
                            pXSector.Depth = (short)5;
                            break;
                        }
                        case 8: {
                            pXSector.Depth = (short)6;
                            break;
                        }
                        case 9: {
                            pXSector.Depth = (short)7;
                        }
                    }
                    if (Trigger.valueIsBetween(pXSource.getData2(), -1, Short.MAX_VALUE)) {
                        if (pXSource.getData2() > 255) {
                            Main.boardService.getSector(nDest).setVisibility(255);
                        } else {
                            Main.boardService.getSector(nDest).setVisibility(pXSource.getData2());
                        }
                    }
                    if (Trigger.valueIsBetween(pXSource.getData3(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getSector(nDest).setCeilingstat(pXSource.getData3());
                    }
                    if (!Trigger.valueIsBetween(pXSource.getData4(), -1, 65535)) break;
                    Main.boardService.getSector(nDest).setFloorstat((short)pXSource.getData4());
                    break;
                }
                case 3: {
                    if (Trigger.valueIsBetween(pXSource.getData3(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getSprite(nDest).setHitag(pXSource.getData3());
                    }
                    if (!Trigger.valueIsBetween(pXSource.getData4(), -1, 65535)) break;
                    pXSource.setData4(pXSource.getData4() | 0x80);
                    Main.boardService.getSprite(nDest).setCstat((short)pXSource.getData4());
                    break;
                }
                case 0: {
                    if (Trigger.valueIsBetween(pXSource.getData3(), -1, Short.MAX_VALUE)) {
                        Main.boardService.getWall(nDest).setHitag(pXSource.getData3());
                    }
                    if (!Trigger.valueIsBetween(pXSource.getData4(), -1, 65535)) break;
                    Main.boardService.getWall(nDest).setCstat((short)pXSource.getData4());
                }
            }
        }
    }

    public static void trMessageSector(int nSector, int event) {
        if (nSector >= Main.boardService.getSectorCount()) {
            throw new AssertException("nSector < boardService.getSectorCount() " + nSector + " < " + Main.boardService.getSectorCount());
        }
        if (Main.boardService.getSector(nSector).getExtra() <= 0 || Main.boardService.getSector(nSector).getExtra() >= 512) {
            throw new AssertException("boardService.getSector(nSector).extra > 0 && boardService.getSector(nSector).extra < kMaxXSectors");
        }
        XSECTOR pXSector = DB.xsector[Main.boardService.getSector(nSector).getExtra()];
        int nCommand = EVENT.getCommand(event);
        if (pXSector.locked != 0 && nCommand != 7 && nCommand != 8) {
            return;
        }
        if (nCommand == 5) {
            Trigger.LinkSector(nSector, pXSector, event);
        } else if (nCommand == 53) {
            Trigger.pastePropertiesInObj(6, nSector, event);
        } else {
            Trigger.OperateSector(nSector, pXSector, nCommand);
        }
    }

    public static void trTriggerWall(int nWall, XWALL pXWall, int command) {
        if (nWall >= Main.boardService.getWallCount()) {
            throw new AssertException("nWall < boardService.getWallCount()");
        }
        if (pXWall.locked != 0) {
            return;
        }
        if (pXWall.isTriggered) {
            return;
        }
        if (pXWall.triggerOnce) {
            pXWall.isTriggered = true;
        }
        if (pXWall.decoupled) {
            if (pXWall.txID != 0) {
                EVENT.evSend(nWall, 0, pXWall.txID, pXWall.command);
            }
        } else {
            Trigger.OperateWall(nWall, pXWall, command);
        }
    }

    public static void trMessageWall(int nWall, int event) {
        if (nWall >= Main.boardService.getWallCount()) {
            throw new AssertException("nWall < boardService.getWallCount()");
        }
        if (Main.boardService.getWall(nWall).getExtra() <= 0 || Main.boardService.getWall(nWall).getExtra() >= 512) {
            throw new AssertException("boardService.getWall(nWall).extra > 0 && boardService.getWall(nWall).extra < kMaxXWalls");
        }
        XWALL pXWall = DB.xwall[Main.boardService.getWall(nWall).getExtra()];
        int nCommand = EVENT.getCommand(event);
        if (pXWall.locked != 0 && nCommand != 7 && nCommand != 8) {
            return;
        }
        if (nCommand == 5) {
            Trigger.LinkWall(nWall, pXWall, event);
        } else if (nCommand == 53) {
            Trigger.pastePropertiesInObj(0, nWall, event);
        } else {
            Trigger.OperateWall(nWall, pXWall, nCommand);
        }
    }

    public static void trTriggerSprite(int nSprite, XSPRITE pXSprite, int command) {
        if (pXSprite.getLocked() != 0) {
            return;
        }
        if (pXSprite.isTriggered()) {
            return;
        }
        if (pXSprite.isTriggerOnce()) {
            pXSprite.setTriggered(true);
        }
        if (pXSprite.isDecoupled()) {
            if (pXSprite.getTxID() != 0) {
                EVENT.evSend(nSprite, 3, pXSprite.getTxID(), pXSprite.getCommand());
            }
        } else {
            Trigger.OperateSprite(nSprite, pXSprite, command);
        }
    }

    public static void trMessageSprite(int nSprite, int event) {
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite.getStatnum() == 1024) {
            return;
        }
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        if (pXSprite == null) {
            throw new AssertException("pXSprite != null");
        }
        int nCommand = EVENT.getCommand(event);
        if (pXSprite.getLocked() != 0 && nCommand != 7 && nCommand != 8) {
            return;
        }
        if (nCommand == 5) {
            Trigger.LinkSprite(nSprite, pXSprite, event);
        } else if (nCommand == 53) {
            Trigger.pastePropertiesInObj(3, nSprite, event);
        } else {
            Trigger.OperateSprite(nSprite, pXSprite, nCommand);
        }
    }

    public static void trProcessMotion() {
        for (int nSector = 0; nSector < Main.boardService.getSectorCount(); ++nSector) {
            Sprite pSprite;
            Sector pSector = Main.boardService.getSector(nSector);
            if (pSector.getExtra() <= 0) continue;
            XSECTOR pXSector = DB.xsector[pSector.getExtra()];
            if (pXSector.bobSpeed == 0) continue;
            if (pXSector.bobAlways) {
                pXSector.bobTheta += pXSector.bobSpeed;
            } else {
                if (pXSector.busy == 0) continue;
                pXSector.bobTheta += Pragmas.mulscale(pXSector.busy, pXSector.bobSpeed, 16);
            }
            int phase = Pragmas.mulscale((long)pXSector.bobZRange << 8, Trig.Sin(pXSector.bobTheta), 30);
            for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
                int nSprite = node.getIndex();
                Sprite pSprite2 = node.get();
                if ((pSprite2.getCstat() & 0x6000) == 0) continue;
                View.viewBackupSpriteLoc(nSprite, pSprite2);
                pSprite2.setZ(pSprite2.getZ() + phase);
            }
            if (pXSector.bobFloor) {
                int oldFloorz = pSector.getFloorz();
                View.viewBackupSectorLoc(nSector, pSector);
                pSector.setFloorz(phase + secFloorZ[nSector]);
                for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
                    int nSprite = node.getIndex();
                    pSprite = node.get();
                    if ((pSprite.getHitag() & 2) != 0) {
                        pSprite.setHitag(pSprite.getHitag() | 4);
                        continue;
                    }
                    Gameutils.GetSpriteExtents(pSprite);
                    if (Gameutils.extents_zBot < oldFloorz || (pSprite.getCstat() & 0x30) != 0) continue;
                    View.viewBackupSpriteLoc(nSprite, pSprite);
                    pSprite.setZ(pSprite.getZ() + phase);
                }
            }
            if (!pXSector.bobCeiling) continue;
            int oldCeilz = pSector.getCeilingz();
            View.viewBackupSectorLoc(nSector, pSector);
            pSector.setCeilingz(phase + secCeilZ[nSector]);
            for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
                int nSprite = node.getIndex();
                pSprite = node.get();
                Gameutils.GetSpriteExtents(pSprite);
                if (Gameutils.extents_zTop > oldCeilz || (pSprite.getCstat() & 0x30) != 0) continue;
                View.viewBackupSpriteLoc(nSprite, pSprite);
                pSprite.setZ(pSprite.getZ() + phase);
            }
        }
    }

    public static void trProcessSlope() {
        for (int nSector = 0; nSector < Main.boardService.getSectorCount(); ++nSector) {
            Sector pSector = Main.boardService.getSector(nSector);
            if (pSector.getFiller() == 0) continue;
            Wall pWall = Main.boardService.getWall(pSector.getFiller() + pSector.getWallptr());
            Wall pWall2 = Main.boardService.getWall(pWall.getPoint2());
            if (pWall.getNextsector() < 0) continue;
            int dx = (pWall2.getX() + pWall.getX()) / 2;
            int dy = (pWall2.getY() + pWall.getY()) / 2;
            View.viewBackupSectorLoc(nSector, pSector);
            int floorslope = Main.engine.getflorzofslope(pWall.getNextsector(), dx, dy);
            Main.engine.alignflorslope((short)nSector, dx, dy, floorslope);
            int ceilingslope = Main.engine.getceilzofslope(pWall.getNextsector(), dx, dy);
            Main.engine.alignceilslope((short)nSector, dx, dy, ceilingslope);
        }
    }

    public static void trProcessBusy() {
        Arrays.fill(Actor.floorVel, 0L);
        Arrays.fill(Actor.ceilingVel, 0L);
        int i = gBusyCount - 1;
        while (i >= 0) {
            int tempBusy = Trigger.gBusy[i].nBusy;
            Trigger.gBusy[i].nBusy = Gameutils.ClipRange(Trigger.gBusy[i].nBusy + Trigger.gBusy[i].nDelta * Globals.kFrameTicks, 0, 65536);
            int rcode = gBusyProc[Trigger.gBusy[i].busyProc].run(Trigger.gBusy[i].nIndex, Trigger.gBusy[i].nBusy);
            switch (rcode) {
                case 1: {
                    Trigger.gBusy[i].nBusy = tempBusy;
                    break;
                }
                case 2: {
                    Trigger.gBusy[i].nBusy = tempBusy;
                    Trigger.gBusy[i].nDelta = -Trigger.gBusy[i].nDelta;
                    break;
                }
                case 3: {
                    Trigger.gBusy[i].nIndex = Trigger.gBusy[--Trigger.gBusyCount].nIndex;
                    Trigger.gBusy[i].nBusy = Trigger.gBusy[Trigger.gBusyCount].nBusy;
                    Trigger.gBusy[i].nDelta = Trigger.gBusy[Trigger.gBusyCount].nDelta;
                    Trigger.gBusy[i].busyProc = Trigger.gBusy[Trigger.gBusyCount].busyProc;
                }
            }
            --i;
        }
        Trigger.trProcessMotion();
        Trigger.trProcessSlope();
    }

    public static void trInitStructs() {
        gBusyCount = 0;
        for (int i = 0; i < 128; ++i) {
            if (gBusy[i] == null) {
                Trigger.gBusy[i] = new BUSY();
                continue;
            }
            gBusy[i].clear();
        }
        for (int nWall = 0; nWall < kwall.length; ++nWall) {
            if (kwall[nWall] == null) {
                Trigger.kwall[nWall] = new Vector2();
                continue;
            }
            kwall[nWall].set(0.0f, 0.0f);
        }
    }

    public static void trInit(Board board) {
        Trigger.trInitStructs();
        Wall[] wall = board.getWalls();
        for (int nWall = 0; nWall < wall.length; ++nWall) {
            Trigger.kwall[nWall].x = Main.boardService.getWall(nWall).getX();
            Trigger.kwall[nWall].y = Main.boardService.getWall(nWall).getY();
        }
        List<Sprite> sprites = board.getSprites();
        for (Sprite value : sprites) {
            BloodSprite sprite = (BloodSprite)value;
            if (sprite.getStatnum() < 1024) {
                Vector3 ksprite = sprite.getKSprite();
                ksprite.x = sprite.getX();
                ksprite.y = sprite.getY();
                ksprite.z = sprite.getZ();
                sprite.setZvel(sprite.getLotag());
                continue;
            }
            sprite.setZvel(-1);
        }
        for (int nWall = 0; nWall < wall.length; ++nWall) {
            if (Main.boardService.getWall(nWall).getExtra() <= 0) continue;
            short nXWall = Main.boardService.getWall(nWall).getExtra();
            if (nXWall >= 512) {
                throw new AssertException("nXWall < kMaxXWalls");
            }
            XWALL pXWall = DB.xwall[nXWall];
            if (pXWall.state == 0) continue;
            pXWall.busy = 65536;
        }
        Sector[] sectors = board.getSectors();
        block16: for (int nSector = 0; nSector < sectors.length; ++nSector) {
            Sector pSector = sectors[nSector];
            Trigger.secFloorZ[nSector] = pSector.getFloorz();
            Trigger.secCeilZ[nSector] = pSector.getCeilingz();
            short nXSector = pSector.getExtra();
            if (nXSector <= 0) continue;
            if (nXSector >= 512) {
                throw new AssertException("nXSector < kMaxXSectors");
            }
            XSECTOR pXSector = DB.xsector[nXSector];
            if (pXSector.state != 0) {
                pXSector.busy = 65536;
            }
            switch (pSector.getLotag()) {
                case 600: 
                case 602: {
                    Trigger.zMotion(nSector, pXSector, pXSector.busy, 1);
                    continue block16;
                }
                case 612: {
                    Trigger.PathSectorInit(nSector, pXSector);
                    continue block16;
                }
                case 614: 
                case 616: {
                    int i;
                    BloodSprite pMark0 = Main.boardService.getSprite(pXSector.marker0);
                    BloodSprite pMark1 = Main.boardService.getSprite(pXSector.marker1);
                    Trigger.TranslateSector(nSector, 0, -65536, pMark0.getX(), pMark0.getY(), pMark0.getX(), pMark0.getY(), pMark0.getAng(), pMark1.getX(), pMark1.getY(), pMark1.getAng(), pSector.getLotag() == 616);
                    int startWall = pSector.getWallptr();
                    int endWall = pSector.getEndWall();
                    for (i = startWall; i <= endWall; ++i) {
                        Trigger.kwall[i].x = Main.boardService.getWall(i).getX();
                        Trigger.kwall[i].y = Main.boardService.getWall(i).getY();
                    }
                    for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
                        BloodSprite pSprite = (BloodSprite)node.get();
                        Vector3 ksprite = pSprite.getKSprite();
                        ksprite.x = pSprite.getX();
                        ksprite.y = pSprite.getY();
                        ksprite.z = pSprite.getZ();
                    }
                    Trigger.TranslateSector(nSector, 0, pXSector.busy, pMark0.getX(), pMark0.getY(), pMark0.getX(), pMark0.getY(), pMark0.getAng(), pMark1.getX(), pMark1.getY(), pMark1.getAng(), pSector.getLotag() == 616);
                    Trigger.zMotion(nSector, pXSector, pXSector.busy, 1);
                    continue block16;
                }
                case 615: 
                case 617: {
                    int i;
                    Sprite pMark = board.getSprite(pXSector.marker0);
                    Trigger.TranslateSector(nSector, 0, -65536, pMark.getX(), pMark.getY(), pMark.getX(), pMark.getY(), 0, pMark.getX(), pMark.getY(), pMark.getAng(), pSector.getLotag() == 617);
                    int startWall = pSector.getWallptr();
                    int endWall = pSector.getEndWall();
                    for (i = startWall; i <= endWall; ++i) {
                        Trigger.kwall[i].x = Main.boardService.getWall(i).getX();
                        Trigger.kwall[i].y = Main.boardService.getWall(i).getY();
                    }
                    for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
                        BloodSprite pSprite = (BloodSprite)node.get();
                        Vector3 ksprite = pSprite.getKSprite();
                        ksprite.x = pSprite.getX();
                        ksprite.y = pSprite.getY();
                        ksprite.z = pSprite.getZ();
                    }
                    Trigger.TranslateSector(nSector, 0, pXSector.busy, pMark.getX(), pMark.getY(), pMark.getX(), pMark.getY(), 0, pMark.getX(), pMark.getY(), pMark.getAng(), pSector.getLotag() == 617);
                    Trigger.zMotion(nSector, pXSector, pXSector.busy, 1);
                    continue block16;
                }
                case 619: {
                    if (DemoUtils.IsOriginalDemo()) {
                        pXSector.triggerOnce = true;
                    }
                    EVENT.evPostCallback(nSector, 6, 0L, 12);
                }
            }
        }
        for (int nSprite = 0; nSprite < sprites.size(); ++nSprite) {
            Sprite pSprite = sprites.get(nSprite);
            XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
            if (pSprite.getStatnum() >= 1024 || pXSprite == null) continue;
            if (pXSprite.getState() != 0) {
                pXSprite.setBusy(65536);
            }
            switch (pSprite.getLotag()) {
                case 23: {
                    pXSprite.setTriggerOnce(true);
                    break;
                }
                case 401: 
                case 433: {
                    pXSprite.setProximity(true);
                    break;
                }
                case 414: {
                    if (pXSprite.getState() != 0) {
                        pSprite.setHitag(pSprite.getHitag() | 7);
                        break;
                    }
                    pSprite.setHitag(pSprite.getHitag() & 0xFFFFFFF8);
                    break;
                }
                case 27: 
                case 33: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 80: 
                case 700: 
                case 701: 
                case 702: 
                case 703: 
                case 704: 
                case 705: 
                case 706: 
                case 707: 
                case 708: {
                    Trigger.InitGenerator(nSprite);
                }
            }
            if (pXSprite.isPush()) {
                pSprite.setCstat(pSprite.getCstat() | 0x1000);
            }
            if (!pXSprite.isVector()) continue;
            pSprite.setCstat(pSprite.getCstat() | 0x100);
        }
        EVENT.evSend(0, 0, 7, 1);
        if (Globals.pGameInfo.nGameType == 1) {
            EVENT.evSend(0, 0, 9, 1);
        }
        if (Globals.pGameInfo.nGameType == 2 || Globals.pGameInfo.nGameType == 3) {
            EVENT.evSend(0, 0, 8, 1);
        }
        if (Globals.pGameInfo.nGameType == 3) {
            EVENT.evSend(0, 0, 10, 1);
        }
    }

    public static void useTeleportTarget(XSPRITE pXSource, BloodSprite pSprite) {
        XSECTOR pXSector;
        BloodSprite pSource = Main.boardService.getSprite(pXSource.getReference());
        XSECTOR xSECTOR = pXSector = Main.boardService.getSector(pSource.getSectnum()).getExtra() >= 0 ? DB.xsector[Main.boardService.getSector(pSource.getSectnum()).getExtra()] : null;
        if (pSprite == null) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (pXSource.getData1() >= 8 || pXSource.getData1() == i + 1 && (pXSource.getData1() >= 239 || pXSource.getData1() < 231 || pXSource.getData1() + 230 != Globals.gPlayer[i].pSprite.getLotag())) {
                    Trigger.useTeleportTarget(pXSource, Globals.gPlayer[i].pSprite);
                    return;
                }
                i = Mmulti.connectpoint2[i];
            }
            return;
        }
        pSprite.setX(pSource.getX());
        pSprite.setY(pSource.getY());
        pSprite.setZ(pSprite.getZ() + (Main.boardService.getSector(pSource.getSectnum()).getFloorz() - Main.boardService.getSector(pSprite.getSectnum()).getFloorz()));
        if ((pSource.getHitag() & 1) != 0) {
            Trigger.TeleportDamage(pSprite.getXvel(), pSource.getSectnum());
        }
        Main.engine.changespritesect(pSprite.getXvel(), pSource.getSectnum());
        if (pXSector != null && pXSector.Underwater) {
            Main.boardService.getXSprite(pSprite.getExtra()).setPalette(1);
        } else {
            Main.boardService.getXSprite(pSprite.getExtra()).setPalette(0);
        }
        if (pXSource.getData2() == 1) {
            pSprite.setAng(pSource.getAng());
        }
        if (pXSource.getData3() == 1) {
            pSprite.setVelocity(0L, 0L, 0L);
        }
        View.viewBackupSpriteLoc(pSprite.getXvel(), pSprite);
        if (pXSource.getData4() > 0) {
            SOUND.sfxStart3DSound(pSource, pXSource.getData4(), -1, 0);
        }
        if (Gameutils.IsPlayerSprite(pSprite)) {
            PLAYER pPlayer = Globals.gPlayer[pSprite.getLotag() - 231];
            View.viewUpdatePlayerLoc(pPlayer);
            if (pXSource.getData2() == 1) {
                Globals.gPlayer[pPlayer.nPlayer].viewOffdZ = 0;
                Globals.gPlayer[pPlayer.nPlayer].weapOffdZ = 0;
                Globals.gPlayer[pPlayer.nPlayer].ang = pSprite.getAng();
            }
        }
    }

    public static void useSpriteDamager(XSPRITE pXSource, BloodSprite pSprite) {
        int dmgType;
        int dmg;
        int n = dmg = pXSource.getData4() == 0 || pXSource.getData4() > 65534 ? 65535 : pXSource.getData4();
        int n2 = pXSource.getData3() >= 7 ? Gameutils.Random(6) : (dmgType = pXSource.getData3() < 0 ? 0 : (int)pXSource.getData3());
        if (pSprite != null) {
            Actor.actDamageSprite(pSprite.getXvel(), pSprite, dmgType, dmg);
        } else if (pXSource.getData2() > 0 && pXSource.getData2() <= 8) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (pXSource.getData1() >= 8 || pXSource.getData1() == i + 1 && (pXSource.getData1() >= 239 || pXSource.getData1() < 231 || pXSource.getData1() + 230 != Globals.gPlayer[i].pSprite.getLotag())) {
                    Actor.actDamageSprite(Main.boardService.getSprite(pXSource.getReference()).getXvel(), Globals.gPlayer[i].pSprite, dmgType, dmg);
                    return;
                }
                i = Mmulti.connectpoint2[i];
            }
        }
    }

    public static void useSeqSpawnerGen(XSPRITE pXSource, int objType, int index) {
        switch (objType) {
            case 6: {
                if (pXSource.getData2() <= 0) {
                    if (pXSource.getData3() == 3 || pXSource.getData3() == 1) {
                        SeqHandling.seqKill(2, Main.boardService.getSector(index).getExtra());
                    }
                    if (pXSource.getData3() == 3 || pXSource.getData3() == 2) {
                        SeqHandling.seqKill(1, Main.boardService.getSector(index).getExtra());
                    }
                } else {
                    if (pXSource.getData3() == 3 || pXSource.getData3() == 1) {
                        SeqHandling.seqSpawn(pXSource.getData2(), 2, Main.boardService.getSector(index).getExtra(), null);
                    }
                    if (pXSource.getData3() == 3 || pXSource.getData3() == 2) {
                        SeqHandling.seqSpawn(pXSource.getData2(), 1, Main.boardService.getSector(index).getExtra(), null);
                    }
                }
                return;
            }
            case 0: {
                if (pXSource.getData2() <= 0) {
                    if (pXSource.getData3() == 3 || pXSource.getData3() == 1) {
                        SeqHandling.seqKill(0, Main.boardService.getWall(index).getExtra());
                    }
                    if ((pXSource.getData3() == 3 || pXSource.getData3() == 2) && (Main.boardService.getWall(index).getCstat() & 0x10) != 0) {
                        SeqHandling.seqKill(4, Main.boardService.getWall(index).getExtra());
                    }
                } else {
                    if (pXSource.getData3() == 3 || pXSource.getData3() == 1) {
                        SeqHandling.seqSpawn(pXSource.getData2(), 0, Main.boardService.getWall(index).getExtra(), null);
                    }
                    if (pXSource.getData3() == 3 || pXSource.getData3() == 2) {
                        if (Main.boardService.getWall(index).getNextwall() < 0) {
                            if (pXSource.getData3() == 3) {
                                SeqHandling.seqSpawn(pXSource.getData2(), 0, Main.boardService.getWall(index).getExtra(), null);
                            }
                        } else {
                            if ((Main.boardService.getWall(index).getCstat() & 0x10) == 0) {
                                Main.boardService.getWall(index).setCstat(Main.boardService.getWall(index).getCstat() | 0x10);
                            }
                            SeqHandling.seqSpawn(pXSource.getData2(), 4, Main.boardService.getWall(index).getExtra(), null);
                        }
                    }
                    if (pXSource.getData4() > 0) {
                        int cx = (Main.boardService.getWall(Main.boardService.getWall(index).getPoint2()).getX() + Main.boardService.getWall(index).getX()) / 2;
                        int cy = (Main.boardService.getWall(Main.boardService.getWall(index).getPoint2()).getY() + Main.boardService.getWall(index).getY()) / 2;
                        int nSector = Main.engine.sectorofwall((short)index);
                        Main.engine.getzsofslope((short)nSector, cx, cy, Globals.floorz, Globals.ceilz);
                        int floorz = Globals.floorz.get();
                        int ceilz = Globals.ceilz.get();
                        if (Main.boardService.getWall(index).getNextsector() != -1) {
                            Main.engine.getzsofslope(Main.boardService.getWall(index).getNextsector(), cx, cy, Globals.floorz, Globals.ceilz);
                        }
                        int nextfloorz = Globals.floorz.get();
                        int nextceilz = Globals.ceilz.get();
                        int cz = ceilz;
                        int fz = floorz;
                        if (ceilz < nextceilz) {
                            cz = nextceilz;
                        }
                        if (floorz >= nextfloorz) {
                            fz = nextfloorz;
                        }
                        SOUND.sfxCreate3DSound(cx, cy, fz + cz >> 1, pXSource.getData4(), nSector);
                    }
                }
                return;
            }
            case 3: {
                if (pXSource.getData2() <= 0) {
                    SeqHandling.seqKill(3, Main.boardService.getSprite(index).getExtra());
                    break;
                }
                SeqHandling.seqSpawn(pXSource.getData2(), 3, Main.boardService.getSprite(index).getExtra(), pXSource.getData3() > 0 ? SeqHandling.callbacks[pXSource.getData3()] : null);
                if (pXSource.getData4() <= 0) break;
                SOUND.sfxStart3DSound(Main.boardService.getSprite(index), pXSource.getData4(), -1, 0);
            }
        }
    }

    public static void useSectorWindGen(XSPRITE pXSource, Sector pSector) {
        BloodSprite pSource = Main.boardService.getSprite(pXSource.getReference());
        XSECTOR pXSector = null;
        boolean forceWind = false;
        if (pSector.getExtra() >= 0) {
            pXSector = DB.xsector[pSector.getExtra()];
        } else {
            int nXSector = DB.dbInsertXSector(Main.engine.getBoardService().getSector(pSource.getSectnum()), pSource.getSectnum());
            if (nXSector < 0) {
                return;
            }
            pXSector = DB.xsector[nXSector];
            forceWind = true;
        }
        if ((pSource.getHitag() & 1) != 0) {
            pXSector.panAlways = true;
            pXSector.windAlways = true;
        } else if (forceWind) {
            pXSector.windAlways = true;
        }
        if (pXSource.getData2() > 32766) {
            pXSource.setData2(Short.MAX_VALUE);
        }
        pXSector.windVel = pXSource.getData1() == 1 || pXSource.getData1() == 3 ? Gameutils.Random(pXSource.getData2()) : (int)pXSource.getData2();
        if (pXSource.getData1() == 2 || pXSource.getData1() == 3) {
            short ang = pSource.getAng();
            while (pSource.getAng() == ang) {
                pSource.setAng((short)Gameutils.BiRandom(2048));
            }
        }
        pXSector.windAng = pSource.getAng();
        if (pXSource.getData3() > 0 && pXSource.getData3() < 4) {
            switch (pXSource.getData3()) {
                case 1: {
                    pXSector.panFloor = true;
                    pXSector.panCeiling = false;
                    break;
                }
                case 2: {
                    pXSector.panFloor = false;
                    pXSector.panCeiling = true;
                    break;
                }
                case 3: {
                    pXSector.panFloor = true;
                    pXSector.panCeiling = true;
                }
            }
            short oldPan = pXSector.panVel;
            pXSector.panAngle = (short)pXSector.windAng;
            pXSector.panVel = (short)pXSector.windVel;
            if (oldPan == 0 && pXSector.panVel != 0) {
                int i = SECTORFX.panCount;
                while (i >= 0 && SECTORFX.panList[i] != pSector.getExtra()) {
                    if (i == 0) {
                        SECTORFX.panList[SECTORFX.panCount++] = pSector.getExtra();
                    }
                    --i;
                }
            }
        }
    }

    public static void useEffectGen(XSPRITE pXSource, Sprite pSprite) {
        if (Main.boardService.getXSprite(pSprite.getExtra()) == null) {
            return;
        }
        Gameutils.GetSpriteExtents(pSprite);
        BloodSprite pEffect = null;
        int dx = 0;
        int dy = 0;
        int cnt = Math.min(pXSource.getData4(), 32);
        while (cnt-- >= 0) {
            if (cnt > 0) {
                dx = Gameutils.BiRandom(250);
                dy = Gameutils.BiRandom(150);
            }
            if ((pEffect = Actor.actSpawnEffect(pXSource.getData2(), pSprite.getSectnum(), pSprite.getX() + dx, pSprite.getY() + dy, Gameutils.extents_zTop, 0)) == null) continue;
            if (pEffect.getPal() <= 0) {
                pEffect.setPal(pSprite.getPal());
            }
            if (pEffect.getXrepeat() <= 0) {
                pEffect.setXrepeat(pSprite.getXrepeat());
            }
            if (pEffect.getYrepeat() <= 0) {
                pEffect.setYrepeat(pSprite.getYrepeat());
            }
            if (pEffect.getShade() != 0) continue;
            pEffect.setShade(pSprite.getShade());
        }
        if (pXSource.getData3() > 0) {
            SOUND.sfxStart3DSound(pSprite, pXSource.getData3(), -1, 0);
        }
    }

    public static void stopWindOnSectors(XSPRITE pXSource) {
        BloodSprite pSource = Main.boardService.getSprite(pXSource.getReference());
        if (pXSource.getTxID() <= 0) {
            if (Main.boardService.getSector(pSource.getSectnum()).getExtra() >= 0) {
                DB.xsector[Main.boardService.getSector((int)pSource.getSectnum()).getExtra()].windVel = 0;
            }
            return;
        }
        for (int i = EVENT.bucketHead[pXSource.getTxID()]; i < EVENT.bucketHead[pXSource.getTxID() + 1]; ++i) {
            if (EVENT.rxBucket[i].type != 6) continue;
            XSECTOR pXSector = DB.xsector[Main.boardService.getSector(EVENT.rxBucket[i].index).getExtra()];
            if ((pXSector.state != 1 || pXSector.windAlways) && pSource.getHitag() != 1) continue;
            pXSector.windVel = 0;
        }
    }

    public static boolean targetMustBeForced(Sprite pDude) {
        switch (pDude.getLotag()) {
            case 205: 
            case 244: {
                return true;
            }
        }
        return false;
    }

    public static boolean dudeCanSeeTarget(XSPRITE pXDude, DudeInfo pDudeInfo, Sprite pTarget) {
        int dy;
        BloodSprite pDude = Main.boardService.getSprite(pXDude.getReference());
        int dx = pTarget.getX() - pDude.getX();
        int dist = EngineUtils.qdist(dx, dy = pTarget.getY() - pDude.getY());
        if (dist < pDudeInfo.seeDist) {
            int eyeAboveZ = pDudeInfo.eyeHeight * pDude.getYrepeat() << 2;
            return Main.engine.cansee(pDude.getX(), pDude.getY(), pDude.getZ(), pDude.getSectnum(), pTarget.getX(), pTarget.getY(), pTarget.getZ() - eyeAboveZ, pTarget.getSectnum());
        }
        return false;
    }

    public static void disturbDudesInSight(Sprite pSprite, int max) {
        Sprite pDude = null;
        XSPRITE pXDude = null;
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        for (ListNode<Sprite> node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            pDude = node.get();
            pXDude = Main.boardService.getXSprite(pDude.getExtra());
            if (pDude.getXvel() == pSprite.getXvel() || !Actor.IsDudeSprite(pDude) || pXDude == null || !Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, pDude) || pXDude.getTarget() != -1 || pXDude.getRxID() > 0) continue;
            Ai.aiSetTarget(pXDude, pDude.getX(), pDude.getY(), pDude.getZ());
            Ai.aiActivateDude((BloodSprite)pDude, pXDude);
            if (max-- < 1) break;
        }
    }

    public static int getTargetDist(Sprite pSprite, DudeInfo pDudeInfo, Sprite pTarget) {
        int dy;
        int x = pTarget.getX();
        int y = pTarget.getY();
        int dx = x - pSprite.getX();
        int dist = EngineUtils.qdist(dx, dy = y - pSprite.getY());
        if (dist <= pDudeInfo.meleeDist) {
            return 0;
        }
        if (dist >= pDudeInfo.seeDist) {
            return 13;
        }
        if (dist <= pDudeInfo.seeDist / 12) {
            return 1;
        }
        if (dist <= pDudeInfo.seeDist / 11) {
            return 2;
        }
        if (dist <= pDudeInfo.seeDist / 10) {
            return 3;
        }
        if (dist <= pDudeInfo.seeDist / 9) {
            return 4;
        }
        if (dist <= pDudeInfo.seeDist / 8) {
            return 5;
        }
        if (dist <= pDudeInfo.seeDist / 7) {
            return 6;
        }
        if (dist <= pDudeInfo.seeDist / 6) {
            return 7;
        }
        if (dist <= pDudeInfo.seeDist / 5) {
            return 8;
        }
        if (dist <= pDudeInfo.seeDist / 4) {
            return 9;
        }
        if (dist <= pDudeInfo.seeDist / 3) {
            return 10;
        }
        if (dist <= pDudeInfo.seeDist / 2) {
            return 11;
        }
        return 12;
    }

    public static int getFineTargetDist(Sprite pSprite, DudeInfo pDudeInfo, Sprite pTarget) {
        int x = pTarget.getX();
        int y = pTarget.getY();
        int dx = x - pSprite.getX();
        int dy = y - pSprite.getY();
        int dist = EngineUtils.qdist(dx, dy);
        return dist;
    }

    public static BloodSprite getTargetInRange(Sprite pSprite, int minDist, int maxDist, short data, short teamMode) {
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        BloodSprite pTarget = null;
        XSPRITE pXTarget = null;
        BloodSprite cTarget = null;
        for (ListNode<Sprite> node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            int fineDist2;
            int fineDist1;
            int dist;
            pTarget = (BloodSprite)node.get();
            pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
            if (!Trigger.dudeCanSeeTarget(pXSprite, pDudeInfo, pTarget) || (dist = Trigger.getTargetDist(pSprite, pDudeInfo, pTarget)) < minDist || dist > maxDist) continue;
            if (pXSprite.getTarget() == pTarget.getXvel()) {
                return pTarget;
            }
            if (!Actor.IsDudeSprite(pTarget) || pTarget.getXvel() == pSprite.getXvel() || Gameutils.IsPlayerSprite(pTarget) || Actor.IsBurningDude(pTarget) || Actor.isImmortalDude(pTarget) || pTarget.getOwner() == pSprite.getXvel() || teamMode == 1 && Trigger.isMateOf(pXSprite, pXTarget) || Trigger.isMatesHaveSameTarget(pXSprite, pTarget, 1) || data != 666 && pXTarget.getData1() != data || pXSprite.getTarget() > 0 && (fineDist1 = Trigger.getFineTargetDist(pSprite, pDudeInfo, cTarget = Main.boardService.getSprite(pXSprite.getTarget()))) < (fineDist2 = Trigger.getFineTargetDist(pSprite, pDudeInfo, pTarget))) continue;
            return pTarget;
        }
        return null;
    }

    public static boolean isActive(XSPRITE pXSprite) {
        AISTATEFUNC.Type type = pXSprite.getAIState().getType();
        if (type == AISTATEFUNC.Type.idle) {
            return false;
        }
        if ((Globals.gFrameClock & 0x30) != 0) {
            if (type == AISTATEFUNC.Type.tgoto || type == AISTATEFUNC.Type.search) {
                return false;
            }
            return pXSprite.getDudeExtra().isActive();
        }
        return true;
    }

    public static boolean isAnnoyingUnit(Sprite pDude) {
        switch (pDude.getLotag()) {
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: {
                return true;
            }
        }
        return false;
    }

    public static boolean unitCanFly(Sprite pDude) {
        switch (pDude.getLotag()) {
            case 206: 
            case 207: 
            case 210: 
            case 219: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMeleeUnit(Sprite pDude) {
        switch (pDude.getLotag()) {
            case 203: 
            case 205: 
            case 206: 
            case 208: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 244: 
            case 245: 
            case 250: 
            case 251: {
                return true;
            }
            case 254: {
                if (!AIUNICULT.dudeIsMelee(Main.boardService.getXSprite(pDude.getExtra()))) break;
                return true;
            }
        }
        return false;
    }

    public static Sprite targetIsPlayer(XSPRITE pXSprite) {
        if (pXSprite.getTarget() >= 0 && Gameutils.IsPlayerSprite(Main.boardService.getSprite(pXSprite.getTarget()))) {
            return Main.boardService.getSprite(pXSprite.getTarget());
        }
        return null;
    }

    public static boolean isTargetAimsDude(XSPRITE pXTarget, Sprite pDude) {
        return pXTarget.getTarget() == pDude.getXvel();
    }

    public static boolean isMateOf(XSPRITE pXDude, XSPRITE pXSprite) {
        return pXDude.getRxID() == pXSprite.getRxID();
    }

    public static boolean getDudesForTargetChg(XSPRITE pXSprite) {
        for (int i = EVENT.bucketHead[pXSprite.getTxID()]; i < EVENT.bucketHead[pXSprite.getTxID() + 1]; ++i) {
            if (EVENT.rxBucket[i].type != 3 || !Actor.IsDudeSprite(Main.boardService.getSprite(EVENT.rxBucket[i].index)) || Main.boardService.getXSprite(Main.boardService.getSprite(EVENT.rxBucket[i].index).getExtra()).getHealth() <= 0) continue;
            return true;
        }
        return false;
    }

    public static XSPRITE affectedByTargetChg(XSPRITE pXDude) {
        if (pXDude.getRxID() <= 0 || pXDude.getLocked() == 1) {
            return null;
        }
        for (ListNode<Sprite> node = Main.boardService.getStatNode(20); node != null; node = node.getNext()) {
            XSPRITE pXSprite = Main.boardService.getXSprite(node.get().getExtra());
            if (pXSprite == null || pXSprite.getTxID() <= 0 || pXSprite.getState() != 1) continue;
            for (int i = EVENT.bucketHead[pXSprite.getTxID()]; i < EVENT.bucketHead[pXSprite.getTxID() + 1]; ++i) {
                BloodSprite pSprite;
                if (EVENT.rxBucket[i].type != 3 || Main.boardService.getXSprite((pSprite = Main.boardService.getSprite(EVENT.rxBucket[i].index)).getExtra()) == null || !Actor.IsDudeSprite(pSprite) || pSprite.getXvel() != Main.boardService.getSprite(pXDude.getReference()).getXvel()) continue;
                return pXSprite;
            }
        }
        return null;
    }

    public static int getDataFieldOfObject(int objType, int objIndex, int dataIndex) {
        int data = -65535;
        switch (objType) {
            case 3: {
                XSPRITE pXSprite = Main.boardService.getXSprite(Main.boardService.getSprite(objIndex).getExtra());
                switch (dataIndex) {
                    case 1: {
                        return pXSprite.getData1();
                    }
                    case 2: {
                        return pXSprite.getData2();
                    }
                    case 3: {
                        return pXSprite.getData3();
                    }
                    case 4: {
                        return pXSprite.getData4();
                    }
                }
                return data;
            }
            case 6: {
                return DB.xsector[Main.boardService.getSector((int)objIndex).getExtra()].data;
            }
            case 0: {
                return DB.xwall[Main.boardService.getWall((int)objIndex).getExtra()].data;
            }
        }
        return data;
    }

    public static boolean setDataValueOfObject(int objType, int objIndex, int dataIndex, int value) {
        switch (objType) {
            case 3: {
                XSPRITE pXSprite = Main.boardService.getXSprite(Main.boardService.getSprite(objIndex).getExtra());
                switch (dataIndex) {
                    case 1: {
                        pXSprite.setData1(value);
                        return true;
                    }
                    case 2: {
                        pXSprite.setData2(value);
                        return true;
                    }
                    case 3: {
                        pXSprite.setData3(value);
                        return true;
                    }
                    case 4: {
                        pXSprite.setData4(value);
                        return true;
                    }
                }
                return false;
            }
            case 6: {
                DB.xsector[Main.boardService.getSector((int)objIndex).getExtra()].data = (short)value;
                return true;
            }
            case 0: {
                DB.xwall[Main.boardService.getWall((int)objIndex).getExtra()].data = (short)value;
                return true;
            }
        }
        return false;
    }

    public static boolean goalValueIsReached(XSPRITE pXSprite) {
        for (int i = EVENT.bucketHead[pXSprite.getTxID()]; i < EVENT.bucketHead[pXSprite.getTxID() + 1]; ++i) {
            if (Trigger.getDataFieldOfObject(EVENT.rxBucket[i].type, EVENT.rxBucket[i].index, pXSprite.getData1()) == pXSprite.getData3()) continue;
            return false;
        }
        return true;
    }

    public static void activateDudes(int rx) {
        for (int i = EVENT.bucketHead[rx]; i < EVENT.bucketHead[rx + 1]; ++i) {
            if (EVENT.rxBucket[i].type != 3 || !Actor.IsDudeSprite(Main.boardService.getSprite(EVENT.rxBucket[i].index))) continue;
            Ai.aiInit(Main.boardService.getSprite(EVENT.rxBucket[i].index), false);
        }
    }

    public static Sprite getMateTargets(XSPRITE pXSprite) {
        short rx = pXSprite.getRxID();
        BloodSprite pMate = null;
        XSPRITE pXMate = null;
        for (int i = EVENT.bucketHead[rx]; i < EVENT.bucketHead[rx + 1]; ++i) {
            if (EVENT.rxBucket[i].type != 3 || (pXMate = Main.boardService.getXSprite((pMate = Main.boardService.getSprite(EVENT.rxBucket[i].index)).getExtra())) == null || pMate.getXvel() == Main.boardService.getSprite(pXSprite.getReference()).getXvel() || !Actor.IsDudeSprite(pMate) || pXMate.getTarget() <= -1 || Gameutils.IsPlayerSprite(Main.boardService.getSprite(pXMate.getTarget()))) continue;
            return Main.boardService.getSprite(pXMate.getTarget());
        }
        return null;
    }

    public static boolean isMatesHaveSameTarget(XSPRITE pXLeader, Sprite pTarget, int allow) {
        short rx = pXLeader.getRxID();
        BloodSprite pMate = null;
        XSPRITE pXMate = null;
        for (int i = EVENT.bucketHead[rx]; i < EVENT.bucketHead[rx + 1]; ++i) {
            if (EVENT.rxBucket[i].type != 3 || (pXMate = Main.boardService.getXSprite((pMate = Main.boardService.getSprite(EVENT.rxBucket[i].index)).getExtra())) == null || pMate.getXvel() == Main.boardService.getSprite(pXLeader.getReference()).getXvel() || !Actor.IsDudeSprite(pMate) || pXMate.getTarget() != pTarget.getXvel() || allow-- > 0) continue;
            return true;
        }
        return false;
    }

    public static void trTextOver(int nMessage) {
        MapInfo pMap;
        if (nMessage >= 128) {
            throw new AssertException("nMessage < kMaxMessages");
        }
        if (LEVELS.currentEpisode != null && (pMap = LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel]) != null && pMap.gMessage[nMessage] != null) {
            View.viewSetMessage(pMap.gMessage[nMessage], Globals.gPlayer[View.gViewIndex].nPlayer, 2);
        }
    }

    public static void FireballTrapCallback(int nXIndex) {
        int dz;
        int dx;
        int dy;
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if ((pSprite.getCstat() & 0x20) != 0) {
            dy = 0;
            dx = 0;
            dz = (pSprite.getCstat() & 8) != 0 ? 16384 : -16384;
        } else {
            dx = Trig.Cos(pSprite.getAng()) >> 16;
            dy = Trig.Sin(pSprite.getAng()) >> 16;
            dz = 0;
        }
        Actor.actFireMissile(pSprite, 0, 0, dx, dy, dz, 305);
    }

    public static void UniMissileTrapCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int dx = 0;
        int dy = 0;
        int dz = 0;
        BloodSprite pSprite = Main.boardService.getSprite(pXSprite.getReference());
        if (pXSprite.getData1() < 300 || pXSprite.getData1() >= 318) {
            return;
        }
        if ((pSprite.getCstat() & 0x20) != 0) {
            dz = (pSprite.getCstat() & 8) != 0 ? 16384 : -16384;
        } else {
            dx = Trig.Cos(pSprite.getAng()) >> 16;
            dy = Trig.Sin(pSprite.getAng()) >> 16;
            dz = pXSprite.getData3() << 6;
            if (dz > 65536) {
                dz = 65536;
            } else if (dz < -65536) {
                dz = -65536;
            }
        }
        BloodSprite pMissile = null;
        pMissile = Actor.actFireMissile(pSprite, 0, 0, dx, dy, dz, pXSprite.getData1());
        if (pMissile != null) {
            if ((pSprite.getHitag() & 1) != 0) {
                pMissile.setXrepeat(pSprite.getXrepeat());
                pMissile.setYrepeat(pSprite.getYrepeat());
                pMissile.setPal(pSprite.getPal());
                pMissile.setShade(pSprite.getShade());
            }
            if (pXSprite.getData2() > 0) {
                long velocity = pXSprite.getData2() << 12;
                pMissile.setVelocity(Pragmas.mulscale(dx, velocity, 14), Pragmas.mulscale(dy, velocity, 14), Pragmas.mulscale(dz, velocity, 14));
            }
            if (pMissile.getLotag() != 303 && pXSprite.getData4() > 0) {
                EVENT.evPostCallback(pMissile.getXvel(), 3, Integer.toUnsignedLong(pXSprite.getData4() > 500 ? 500 : pXSprite.getData4() - 1), 23);
            }
        }
    }

    public static void MGunOpenCallback(int nXIndex) {
        SeqHandling.seqSpawn(VERSION.getSeq(4), 3, nXIndex, SeqHandling.callbacks[3]);
    }

    public static void MGunFireCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pXSprite.getData2() > 0 || pXSprite.getData1() == 0) {
            if (pXSprite.getData2() > 0) {
                pXSprite.setData2(pXSprite.getData2() - 1);
                if (pXSprite.getData2() == 0) {
                    EVENT.evPost(nSprite, 3, 1L, 0);
                }
            }
            int dx = (Trig.Cos(pSprite.getAng()) >> 16) + Gameutils.BiRandom(1000);
            int dy = (Trig.Sin(pSprite.getAng()) >> 16) + Gameutils.BiRandom(1000);
            int dz = Gameutils.BiRandom(1000);
            Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 2);
            SOUND.sfxStart3DSound(pSprite, 359, -1, 0);
        }
    }

    public static int getWave(XSECTOR pXSector, int nBusy) {
        short wave = pXSector.busy >= nBusy ? pXSector.waveTime[0] : pXSector.waveTime[1];
        return wave;
    }

    public static void InitGenerator(int nSprite) {
        if (!Main.boardService.isValidSprite(nSprite)) {
            throw new AssertException("isValidSprite(nSprite)");
        }
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite.getStatnum() == 1024) {
            throw new AssertException("pSprite.statnum != kMaxStatus");
        }
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        if (pXSprite == null) {
            throw new AssertException("pXSprite != null");
        }
        switch (pSprite.getLotag()) {
            case 33: {
                pSprite.setCstat(pSprite.getCstat() & 0xFFFFFFFE);
                pSprite.setCstat(pSprite.getCstat() | 0x8000);
                if (pXSprite.getBusyTime() <= 0) {
                    pXSprite.setBusyTime(5);
                }
                if (pXSprite.getState() != pXSprite.getRestState()) {
                    EVENT.evPost(nSprite, 3, 0L, 21);
                }
                return;
            }
            case 27: 
            case 37: 
            case 38: {
                pSprite.setCstat(pSprite.getCstat() & 0xFFFFFFFE);
                pSprite.setCstat(pSprite.getCstat() | 0x8000);
                if (pXSprite.getState() != pXSprite.getRestState()) {
                    EVENT.evPost(nSprite, 3, 0L, 21);
                }
                return;
            }
            case 39: {
                pSprite.setCstat(pSprite.getCstat() & 0xFFFFFFFE);
                if (pXSprite.getState() != pXSprite.getRestState()) {
                    EVENT.evPost(nSprite, 3, 0L, 21);
                }
                return;
            }
            case 40: 
            case 80: {
                pSprite.setCstat(pSprite.getCstat() & 0xFFFFFFFE);
                pSprite.setCstat(pSprite.getCstat() | 0x8000);
                if (pXSprite.getState() != pXSprite.getRestState()) {
                    EVENT.evPost(nSprite, 3, 0L, 21);
                }
                return;
            }
            case 700: {
                pSprite.setCstat(pSprite.getCstat() & 0xFFFFFFFE);
                pSprite.setCstat(pSprite.getCstat() | 0x8000);
                break;
            }
        }
        if (pXSprite.getState() != pXSprite.getRestState() && pXSprite.getBusyTime() > 0) {
            EVENT.evPost(nSprite, 3, Integer.toUnsignedLong((pXSprite.getBusyTime() + Gameutils.BiRandom(pXSprite.getData1())) * 120) / 10L, 21);
        }
    }

    public static void ActivateGenerator(int nSprite) {
        if (!Main.boardService.isValidSprite(nSprite)) {
            throw new AssertException("isValidSprite(nSprite)");
        }
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite.getStatnum() == 1024) {
            throw new AssertException("pSprite.statnum != kMaxStatus");
        }
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        if (pXSprite == null) {
            throw new AssertException("pXSprite != null");
        }
        switch (pSprite.getLotag()) {
            case 40: 
            case 80: {
                if (pXSprite.getDropMsg() > 0) {
                    for (ListNode<Sprite> node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
                        Sprite pItem = node.get();
                        if (pItem.getLotag() != pXSprite.getDropMsg() || pItem.getX() != pSprite.getX() || pItem.getY() != pSprite.getY() || pItem.getZ() != pSprite.getZ()) continue;
                        Actor.actSpawnEffect(29, pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 0);
                        Main.engine.deletesprite(node.getIndex());
                        break;
                    }
                }
                Actor.DropRandomPickupObject(pSprite, pXSprite.getDropMsg());
                break;
            }
            case 701: {
                Gameutils.GetSpriteExtents(pSprite);
                Actor.actSpawnThing(pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), Gameutils.extents_zBot, 423);
                break;
            }
            case 702: {
                Gameutils.GetSpriteExtents(pSprite);
                Actor.actSpawnThing(pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), Gameutils.extents_zBot, 424);
                break;
            }
            case 708: {
                if (DemoUtils.IsOriginalDemo()) {
                    SOUND.sfxStart3DSound(pSprite, pXSprite.getData2(), -1, 0);
                    break;
                }
                long pitch = (long)pXSprite.getData4() << 1;
                short volume = pXSprite.getData3();
                SOUND.sfxStart3DSoundCP(pSprite, pXSprite.getData2(), -1, 0, pitch < 2000L ? 0L : pitch, volume);
                break;
            }
            case 704: {
                if (DemoUtils.IsOriginalDemo()) break;
                Trigger.UniMissileTrapCallback(pSprite.getExtra());
                break;
            }
            case 705: {
                break;
            }
            case 703: {
                switch (pXSprite.getData2()) {
                    case 0: {
                        Trigger.FireballTrapCallback(pSprite.getExtra());
                        break;
                    }
                    case 1: {
                        SeqHandling.seqSpawn(VERSION.getSeq(0), 3, pSprite.getExtra(), SeqHandling.callbacks[4]);
                        break;
                    }
                    case 2: {
                        SeqHandling.seqSpawn(VERSION.getSeq(1), 3, pSprite.getExtra(), SeqHandling.callbacks[4]);
                    }
                }
                break;
            }
            case 706: {
                Gameutils.GetSpriteExtents(pSprite);
                Actor.actSpawnEffect(23, pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), Gameutils.extents_zTop, 0);
                break;
            }
            case 707: {
                Gameutils.GetSpriteExtents(pSprite);
                Actor.actSpawnEffect(26, pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), Gameutils.extents_zTop, 0);
            }
        }
    }

    static {
        gBusyProc = new BUSYPROC[]{Trigger::VCrushBusy, Trigger::VSpriteBusy, Trigger::VDoorBusy, Trigger::HDoorBusy, Trigger::RDoorBusy, Trigger::SRDoorBusy, (nIndex, nBusy) -> {
            if (nIndex < 0 || nIndex >= Main.boardService.getSectorCount()) {
                throw new AssertException("nSector >= 0 && nSector < boardService.getSectorCount()");
            }
            Sector pSector = Main.boardService.getSector(nIndex);
            short nXSector = pSector.getExtra();
            if (nXSector <= 0 || nXSector >= 512) {
                throw new AssertException("nXSector > 0 && nXSector < kMaxXSectors");
            }
            XSECTOR pXSector = DB.xsector[nXSector];
            pXSector.busy = nBusy;
            if (pXSector.command == 5 && pXSector.txID != 0) {
                EVENT.evSend(nIndex, 6, pXSector.txID, 5);
            }
            if ((nBusy & 0xFFFF) == 0) {
                Trigger.SetSectorState(nIndex, pXSector, nBusy >> 16);
                Trigger.sfxSectorStop(nIndex, nBusy >> 16);
                return 3;
            }
            return 0;
        }, Trigger::PathSectorBusy};
    }
}

