/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.filehandle.StreamUtils;

public class INPUT
implements BuildNet.NetInput {
    private static final int sizeof = 22;
    private static final int gdxsizeof = 27;
    public int syncFlags;
    public int Forward;
    public float Turn;
    public int Strafe;
    public float mlook;
    public boolean Run;
    public boolean Jump;
    public boolean Crouch;
    public boolean Shoot;
    public boolean AltShoot;
    public boolean Lookup;
    public boolean Lookdown;
    public boolean Use;
    public boolean InventoryLeft;
    public boolean InventoryRight;
    public boolean InventoryUse;
    public boolean PrevWeapon;
    public boolean NextWeapon;
    public boolean HolsterWeapon;
    public boolean LookCenter;
    public boolean LookLeft;
    public boolean LookRight;
    public boolean TurnAround;
    public boolean Pause;
    public boolean Quit;
    public boolean Restart;
    public boolean CrouchMode;
    public boolean LastWeapon;
    public boolean UseBeastVision;
    public boolean UseCrystalBall;
    public boolean UseJumpBoots;
    public boolean UseMedKit;
    public int newWeapon;

    public INPUT() {
    }

    public INPUT(InputStream is, int nVersion) throws IOException {
        this.setBytes(is, nVersion);
    }

    public static int sizeof(int nVersion) {
        int size = 22;
        if (nVersion >= 300) {
            size = 27;
        }
        return size;
    }

    public void writeObject(OutputStream os, int nVersion) throws IOException {
        int SYNCFLAGS = this.syncFlags;
        if (nVersion >= 277) {
            SYNCFLAGS |= this.Run ? 32 : 0;
        }
        StreamUtils.writeInt(os, SYNCFLAGS);
        StreamUtils.writeByte(os, (byte)this.Forward);
        if (nVersion < 300) {
            StreamUtils.writeShort(os, (short)this.Turn);
        } else {
            StreamUtils.writeFloat(os, this.Turn);
        }
        StreamUtils.writeByte(os, (byte)this.Strafe);
        StreamUtils.writeInt(os, this.getButtonFlag(nVersion));
        StreamUtils.writeInt(os, this.getKeyFlag(nVersion));
        StreamUtils.writeInt(os, this.getUseFlag());
        StreamUtils.writeByte(os, (byte)this.newWeapon);
        if (nVersion < 300) {
            StreamUtils.writeByte(os, (byte)this.mlook);
        } else {
            StreamUtils.writeFloat(os, this.mlook);
        }
    }

    @Override
    public BuildNet.NetInput Copy(BuildNet.NetInput netsrc) {
        INPUT src = (INPUT)netsrc;
        this.syncFlags = src.syncFlags;
        this.Forward = src.Forward;
        this.Turn = src.Turn;
        this.Strafe = src.Strafe;
        this.mlook = src.mlook;
        this.Run = src.Run;
        this.Jump = src.Jump;
        this.Crouch = src.Crouch;
        this.Shoot = src.Shoot;
        this.AltShoot = src.AltShoot;
        this.Lookup = src.Lookup;
        this.Lookdown = src.Lookdown;
        this.TurnAround = src.TurnAround;
        this.Use = src.Use;
        this.InventoryLeft = src.InventoryLeft;
        this.InventoryRight = src.InventoryRight;
        this.InventoryUse = src.InventoryUse;
        this.PrevWeapon = src.PrevWeapon;
        this.NextWeapon = src.NextWeapon;
        this.HolsterWeapon = src.HolsterWeapon;
        this.LookCenter = src.LookCenter;
        this.LookLeft = src.LookLeft;
        this.LookRight = src.LookRight;
        this.Pause = src.Pause;
        this.Quit = src.Quit;
        this.Restart = src.Restart;
        this.CrouchMode = src.CrouchMode;
        this.LastWeapon = src.LastWeapon;
        this.UseBeastVision = src.UseBeastVision;
        this.UseCrystalBall = src.UseCrystalBall;
        this.UseJumpBoots = src.UseJumpBoots;
        this.UseMedKit = src.UseMedKit;
        this.newWeapon = src.newWeapon;
        return this;
    }

    @Override
    public void reset() {
        this.syncFlags = 0;
        this.Forward = 0;
        this.Turn = 0.0f;
        this.Strafe = 0;
        this.mlook = 0.0f;
        this.Run = false;
        this.Jump = false;
        this.Crouch = false;
        this.Shoot = false;
        this.AltShoot = false;
        this.Lookup = false;
        this.Lookdown = false;
        this.TurnAround = false;
        this.Use = false;
        this.InventoryLeft = false;
        this.InventoryRight = false;
        this.InventoryUse = false;
        this.PrevWeapon = false;
        this.NextWeapon = false;
        this.HolsterWeapon = false;
        this.LookCenter = false;
        this.LookLeft = false;
        this.LookRight = false;
        this.Pause = false;
        this.Quit = false;
        this.Restart = false;
        this.CrouchMode = false;
        this.LastWeapon = false;
        this.newWeapon = 0;
        this.UseBeastVision = false;
        this.UseCrystalBall = false;
        this.UseJumpBoots = false;
        this.UseMedKit = false;
    }

    public void setBytes(InputStream is, int nVersion) throws IOException {
        int USEFLAGS;
        int KEYFLAGS;
        int BUTTONFLAGS;
        this.syncFlags = StreamUtils.readInt(is);
        this.Forward = StreamUtils.readByte(is);
        this.Turn = nVersion < 300 ? (float)StreamUtils.readShort(is) : StreamUtils.readFloat(is);
        this.Strafe = StreamUtils.readByte(is);
        if (nVersion == 256) {
            BUTTONFLAGS = StreamUtils.readInt(is);
            this.Run = (BUTTONFLAGS & 1) == 1;
            this.Jump = (BUTTONFLAGS & 2) >> 1 == 1;
            this.Crouch = (BUTTONFLAGS & 4) >> 2 == 1;
            this.Shoot = (BUTTONFLAGS & 8) >> 3 == 1;
            this.AltShoot = (BUTTONFLAGS & 0x10) >> 4 == 1;
            this.Lookup = (BUTTONFLAGS & 0x20) >> 5 == 1;
            boolean bl = this.Lookdown = (BUTTONFLAGS & 0x40) >> 6 == 1;
        }
        if (nVersion >= 277) {
            this.Run = (this.syncFlags & 0x20) >> 5 == 1;
            BUTTONFLAGS = StreamUtils.readInt(is);
            this.Jump = (BUTTONFLAGS & 1) == 1;
            this.Crouch = (BUTTONFLAGS & 2) >> 1 == 1;
            this.Shoot = (BUTTONFLAGS & 4) >> 2 == 1;
            this.AltShoot = (BUTTONFLAGS & 8) >> 3 == 1;
            this.Lookup = (BUTTONFLAGS & 0x10) >> 4 == 1;
            this.Lookdown = (BUTTONFLAGS & 0x20) >> 5 == 1;
        }
        this.Use = ((KEYFLAGS = StreamUtils.readInt(is)) & 1) == 1;
        this.InventoryLeft = (KEYFLAGS & 4) >> 2 == 1;
        this.InventoryRight = (KEYFLAGS & 8) >> 3 == 1;
        this.InventoryUse = (KEYFLAGS & 0x10) >> 4 == 1;
        this.PrevWeapon = (KEYFLAGS & 0x20) >> 5 == 1;
        this.NextWeapon = (KEYFLAGS & 0x40) >> 6 == 1;
        this.HolsterWeapon = (KEYFLAGS & 0x80) >> 7 == 1;
        this.LookCenter = (KEYFLAGS & 0x100) >> 8 == 1;
        this.LookLeft = (KEYFLAGS & 0x200) >> 9 == 1;
        this.LookRight = (KEYFLAGS & 0x400) >> 10 == 1;
        this.TurnAround = (KEYFLAGS & 0x800) >> 11 == 1;
        this.Pause = (KEYFLAGS & 0x1000) >> 12 == 1;
        this.Quit = (KEYFLAGS & 0x2000) >> 13 == 1;
        boolean bl = this.Restart = (KEYFLAGS & 0x4000) >> 14 == 1;
        if (nVersion >= 300) {
            this.CrouchMode = (KEYFLAGS & 0x8000) >> 15 == 1;
            this.LastWeapon = (KEYFLAGS & 0x10000) >> 16 == 1;
        }
        this.UseBeastVision = ((USEFLAGS = StreamUtils.readInt(is)) & 1) == 1;
        this.UseCrystalBall = (USEFLAGS & 2) >> 1 == 1;
        this.UseJumpBoots = (USEFLAGS & 4) >> 2 == 1;
        this.UseMedKit = (USEFLAGS & 8) >> 3 == 1;
        this.newWeapon = StreamUtils.readUnsignedByte(is);
        if (nVersion < 300) {
            this.mlook = StreamUtils.readByte(is);
            if (nVersion == 256 || nVersion == 277) {
                this.mlook = this.mlook >= 0.0f ? (float)((int)this.mlook >> 2) : (float)((int)this.mlook + 3 >> 2);
            }
        } else {
            this.mlook = StreamUtils.readFloat(is);
        }
    }

    public byte getButtonFlag(int nVersion) {
        byte BUTTONFLAGS = 0;
        if (nVersion == 256) {
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.Run ? (byte)1 : 0));
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.Jump ? 2 : 0));
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.Crouch ? 4 : 0));
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.Shoot ? 8 : 0));
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.AltShoot ? 16 : 0));
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.Lookup ? 32 : 0));
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.Lookdown ? 64 : 0));
        }
        if (nVersion >= 277) {
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.Jump ? (byte)1 : 0));
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.Crouch ? 2 : 0));
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.Shoot ? 4 : 0));
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.AltShoot ? 8 : 0));
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.Lookup ? 16 : 0));
            BUTTONFLAGS = (byte)(BUTTONFLAGS | (this.Lookdown ? 32 : 0));
        }
        return BUTTONFLAGS;
    }

    public int getKeyFlag(int nVersion) {
        int KEYFLAGS = 0;
        KEYFLAGS |= this.Use ? 1 : 0;
        KEYFLAGS |= this.InventoryLeft ? 4 : 0;
        KEYFLAGS |= this.InventoryRight ? 8 : 0;
        KEYFLAGS |= this.InventoryUse ? 16 : 0;
        KEYFLAGS |= this.PrevWeapon ? 32 : 0;
        KEYFLAGS |= this.NextWeapon ? 64 : 0;
        KEYFLAGS |= this.HolsterWeapon ? 128 : 0;
        KEYFLAGS |= this.LookCenter ? 256 : 0;
        KEYFLAGS |= this.LookLeft ? 512 : 0;
        KEYFLAGS |= this.LookRight ? 1024 : 0;
        KEYFLAGS |= this.TurnAround ? 2048 : 0;
        KEYFLAGS |= this.Pause ? 4096 : 0;
        KEYFLAGS |= this.Quit ? 8192 : 0;
        KEYFLAGS |= this.Restart ? 16384 : 0;
        if (nVersion >= 300) {
            KEYFLAGS |= this.CrouchMode ? 32768 : 0;
            KEYFLAGS |= this.LastWeapon ? 65536 : 0;
            KEYFLAGS |= this.Run ? 131072 : 0;
        }
        return KEYFLAGS;
    }

    public byte getUseFlag() {
        byte USEFLAGS = 0;
        USEFLAGS = (byte)(USEFLAGS | (this.UseBeastVision ? 1 : 0));
        USEFLAGS = (byte)(USEFLAGS | (this.UseCrystalBall ? 2 : 0));
        USEFLAGS = (byte)(USEFLAGS | (this.UseJumpBoots ? 4 : 0));
        USEFLAGS = (byte)(USEFLAGS | (this.UseMedKit ? 8 : 0));
        return USEFLAGS;
    }

    public String toString() {
        String out = "";
        if (this.syncFlags != 0) {
            out = out + "syncFlags " + this.syncFlags + " \r\n";
        }
        if (this.Forward != 0) {
            out = out + "Forward " + this.Forward + " \r\n";
        }
        if (this.Turn != 0.0f) {
            out = out + "Turn " + this.Turn + " \r\n";
        }
        if (this.Strafe != 0) {
            out = out + "Strafe " + this.Strafe + " \r\n";
        }
        if (this.Run) {
            out = out + "Run " + this.Run + " \r\n";
        }
        if (this.Jump) {
            out = out + "Jump " + this.Jump + " \r\n";
        }
        if (this.Crouch) {
            out = out + "Crouch " + this.Crouch + " \r\n";
        }
        if (this.Shoot) {
            out = out + "Shoot " + this.Shoot + " \r\n";
        }
        if (this.AltShoot) {
            out = out + "AltShoot " + this.AltShoot + " \r\n";
        }
        if (this.Lookup) {
            out = out + "Lookup " + this.Lookup + " \r\n";
        }
        if (this.Lookdown) {
            out = out + "Lookdown " + this.Lookdown + " \r\n";
        }
        if (this.TurnAround) {
            out = out + "TurnAround " + this.TurnAround + " \r\n";
        }
        if (this.Use) {
            out = out + "Use " + this.Use + " \r\n";
        }
        if (this.InventoryLeft) {
            out = out + "InventoryLeft " + this.InventoryLeft + " \r\n";
        }
        if (this.InventoryRight) {
            out = out + "InventoryRight " + this.InventoryRight + " \r\n";
        }
        if (this.InventoryUse) {
            out = out + "InventoryUse " + this.InventoryUse + " \r\n";
        }
        if (this.PrevWeapon) {
            out = out + "PrevWeapon " + this.PrevWeapon + " \r\n";
        }
        if (this.NextWeapon) {
            out = out + "NextWeapon " + this.NextWeapon + " \r\n";
        }
        if (this.HolsterWeapon) {
            out = out + "HolsterWeapon " + this.HolsterWeapon + " \r\n";
        }
        if (this.LookCenter) {
            out = out + "LookCenter " + this.LookCenter + " \r\n";
        }
        if (this.LookLeft) {
            out = out + "LookLeft " + this.LookLeft + " \r\n";
        }
        if (this.LookRight) {
            out = out + "LookRight " + this.LookRight + " \r\n";
        }
        if (this.Pause) {
            out = out + "Pause " + this.Pause + " \r\n";
        }
        if (this.Quit) {
            out = out + "Master " + this.Quit + " \r\n";
        }
        if (this.Restart) {
            out = out + "Restart " + this.Restart + " \r\n";
        }
        if (this.CrouchMode) {
            out = out + "CrouchMode " + this.CrouchMode + " \r\n";
        }
        if (this.LastWeapon) {
            out = out + "LastWeapon " + this.LastWeapon + " \r\n";
        }
        if (this.UseBeastVision) {
            out = out + "UseBeastVision " + this.UseBeastVision + " \r\n";
        }
        if (this.UseCrystalBall) {
            out = out + "UseCrystalBall " + this.UseCrystalBall + " \r\n";
        }
        if (this.UseJumpBoots) {
            out = out + "UseJumpBoots " + this.UseJumpBoots + " \r\n";
        }
        if (this.UseMedKit) {
            out = out + "UseMedKit " + this.UseMedKit + " \r\n";
        }
        if (this.newWeapon != 0) {
            out = out + "newWeapon " + this.newWeapon + " \r\n";
        }
        if (this.mlook != 0.0f) {
            out = out + "mlook " + this.mlook + " \r\n";
        }
        return out;
    }

    @Override
    public int GetInput(byte[] p, int offset, BuildNet.NetInput old) {
        ByteBuffer bb = ByteBuffer.wrap(p);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.position(offset);
        this.syncFlags = bb.get();
        if ((this.syncFlags & 0x20) != 0) {
            this.Forward = bb.get();
        }
        if ((this.syncFlags & 0x40) != 0) {
            this.Turn = bb.getFloat();
        }
        if ((this.syncFlags & 0x80) != 0) {
            this.Strafe = bb.get();
        }
        if ((this.syncFlags & 1) != 0) {
            byte BUTTONFLAGS = bb.get();
            this.Jump = (BUTTONFLAGS & 1) == 1;
            this.Crouch = (BUTTONFLAGS & 2) >> 1 == 1;
            this.Shoot = (BUTTONFLAGS & 4) >> 2 == 1;
            this.AltShoot = (BUTTONFLAGS & 8) >> 3 == 1;
            this.Lookup = (BUTTONFLAGS & 0x10) >> 4 == 1;
            boolean bl = this.Lookdown = (BUTTONFLAGS & 0x20) >> 5 == 1;
        }
        if ((this.syncFlags & 2) != 0) {
            int KEYFLAGS = bb.getInt();
            this.Use = (KEYFLAGS & 1) == 1;
            this.InventoryLeft = (KEYFLAGS & 4) >> 2 == 1;
            this.InventoryRight = (KEYFLAGS & 8) >> 3 == 1;
            this.InventoryUse = (KEYFLAGS & 0x10) >> 4 == 1;
            this.PrevWeapon = (KEYFLAGS & 0x20) >> 5 == 1;
            this.NextWeapon = (KEYFLAGS & 0x40) >> 6 == 1;
            this.HolsterWeapon = (KEYFLAGS & 0x80) >> 7 == 1;
            this.LookCenter = (KEYFLAGS & 0x100) >> 8 == 1;
            this.LookLeft = (KEYFLAGS & 0x200) >> 9 == 1;
            this.LookRight = (KEYFLAGS & 0x400) >> 10 == 1;
            this.TurnAround = (KEYFLAGS & 0x800) >> 11 == 1;
            this.Pause = (KEYFLAGS & 0x1000) >> 12 == 1;
            this.Quit = (KEYFLAGS & 0x2000) >> 13 == 1;
            this.Restart = (KEYFLAGS & 0x4000) >> 14 == 1;
            this.CrouchMode = (KEYFLAGS & 0x8000) >> 15 == 1;
            this.LastWeapon = (KEYFLAGS & 0x10000) >> 16 == 1;
            boolean bl = this.Run = (KEYFLAGS & 0x20000) >> 17 == 1;
        }
        if ((this.syncFlags & 4) != 0) {
            byte USEFLAGS = bb.get();
            this.UseBeastVision = (USEFLAGS & 1) == 1;
            this.UseCrystalBall = (USEFLAGS & 2) >> 1 == 1;
            this.UseJumpBoots = (USEFLAGS & 4) >> 2 == 1;
            boolean bl = this.UseMedKit = (USEFLAGS & 8) >> 3 == 1;
        }
        if ((this.syncFlags & 8) != 0) {
            this.newWeapon = bb.get() & 0xFF;
        }
        if ((this.syncFlags & 0x10) != 0) {
            this.mlook = bb.getFloat();
        }
        return bb.position();
    }

    @Override
    public int PutInput(byte[] p, int offset, BuildNet.NetInput old) {
        byte ButtonFlag = this.getButtonFlag(302);
        int KeyFlag = this.getKeyFlag(302);
        byte UseFlag = this.getUseFlag();
        if (ButtonFlag != 0) {
            this.syncFlags |= 1;
        }
        if (KeyFlag != 0) {
            this.syncFlags |= 2;
        }
        if (UseFlag != 0) {
            this.syncFlags |= 4;
        }
        if (this.newWeapon != 0) {
            this.syncFlags |= 8;
        }
        if (this.mlook != 0.0f) {
            this.syncFlags |= 0x10;
        }
        if (this.Forward != 0) {
            this.syncFlags |= 0x20;
        }
        if (this.Turn != 0.0f) {
            this.syncFlags |= 0x40;
        }
        if (this.Strafe != 0) {
            this.syncFlags |= 0x80;
        }
        int ptr = this.putByte(p, offset, this.syncFlags);
        if ((this.syncFlags & 0x20) != 0) {
            ptr = this.putByte(p, ptr, this.Forward);
        }
        if ((this.syncFlags & 0x40) != 0) {
            LittleEndian.putFloat(p, ptr, this.Turn);
            ptr += 4;
        }
        if ((this.syncFlags & 0x80) != 0) {
            ptr = this.putByte(p, ptr, this.Strafe);
        }
        if ((this.syncFlags & 1) != 0) {
            ptr = this.putByte(p, ptr, ButtonFlag);
        }
        if ((this.syncFlags & 2) != 0) {
            LittleEndian.putInt(p, ptr, KeyFlag);
            ptr += 4;
        }
        if ((this.syncFlags & 4) != 0) {
            ptr = this.putByte(p, ptr, UseFlag);
        }
        if ((this.syncFlags & 8) != 0) {
            ptr = this.putByte(p, ptr, this.newWeapon);
        }
        if ((this.syncFlags & 0x10) != 0) {
            LittleEndian.putFloat(p, ptr, this.mlook);
            ptr += 4;
        }
        return ptr;
    }

    private int putByte(byte[] p, int ptr, int value) {
        p[ptr] = (byte)value;
        return ++ptr;
    }
}

