/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import ru.m210projects.Build.StringUtils;
import ru.m210projects.Build.Types.Serializable;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class SFX
implements Serializable<SFX> {
    public int relVol;
    public int pitch;
    public int pitchrange;
    public int format;
    public int loopStart;
    public String rawName;
    public ByteBuffer hResource;
    public int size;

    public SFX(Entry entry) throws IOException {
        try (InputStream is = entry.getInputStream();){
            this.readObject(is);
        }
    }

    public SFX(int relVol, int pitch, int pitchrange, int format, int loopStart, String rawName) {
        this.relVol = relVol;
        this.pitch = pitch;
        this.pitchrange = pitchrange;
        if (format == -1) {
            format = 0;
        }
        this.format = format;
        this.loopStart = loopStart;
        this.rawName = StringUtils.toUnicode(rawName);
    }

    @Override
    public SFX readObject(InputStream is) throws IOException {
        this.relVol = StreamUtils.readInt(is);
        this.pitch = StreamUtils.readInt(is);
        this.pitchrange = StreamUtils.readInt(is);
        this.format = StreamUtils.readInt(is);
        if (this.format == -1) {
            this.format = 0;
        }
        this.loopStart = StreamUtils.readInt(is);
        this.rawName = StreamUtils.readString(is, is.available());
        this.rawName = StringUtils.toUnicode(this.rawName);
        return this;
    }

    @Override
    public SFX writeObject(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, this.relVol);
        StreamUtils.writeInt(os, this.pitch);
        StreamUtils.writeInt(os, this.pitchrange);
        StreamUtils.writeInt(os, this.format);
        StreamUtils.writeInt(os, this.loopStart);
        StreamUtils.writeString(os, this.rawName);
        return this;
    }
}

