/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Seq;

import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.Seq.ActiveList;
import ru.m210projects.Blood.Types.Seq.CeilingInst;
import ru.m210projects.Blood.Types.Seq.FloorInst;
import ru.m210projects.Blood.Types.Seq.MaskedWallInst;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.Seq.SeqType;
import ru.m210projects.Blood.Types.Seq.SpriteInst;
import ru.m210projects.Blood.Types.Seq.WallInst;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class SeqHandling {
    public static final int kMaxSequences = 4096;
    public static final int ReviveCallback = 1;
    public static final int MGunOpenCallback = 2;
    public static final int MGunFireCallback = 3;
    public static final int FireballTrapCallback = 4;
    public static final int DamageTreeCallback = 5;
    public static final int SmokeCallback = 6;
    public static final int FireballCallback = 7;
    public static final int TchernobogCallback1 = 8;
    public static final int TchernobogCallback2 = 9;
    public static final int DamageDude = 10;
    public static final int DamageDude2 = 11;
    public static final int FatalityDead = 12;
    public static final int UniMissileTrapCallback = 13;
    public static WallInst[] siWall = new WallInst[512];
    public static MaskedWallInst[] siMasked = new MaskedWallInst[512];
    public static CeilingInst[] siCeiling = new CeilingInst[512];
    public static FloorInst[] siFloor = new FloorInst[512];
    public static ActiveList activeList = new ActiveList(4096);
    public static CALLPROC[] callbacks = new CALLPROC[]{nIndex -> {}, PLAYER::FReviveCallback, Trigger::MGunOpenCallback, Trigger::MGunFireCallback, Trigger::FireballTrapCallback, Actor::DamageTreeCallback, Actor::SmokeCallback, Actor::FireballCallback, Actor::TchernobogCallback1, Actor::TchernobogCallback2, nIndex -> Actor.DamageDude(nIndex, 8), nIndex -> Actor.DamageDude(nIndex, 3), PLAYER::FatalityDeadCallback, Trigger::UniMissileTrapCallback};

    public static int getIndex(CALLPROC callback) {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callback != callbacks[i]) continue;
            return i;
        }
        if (callback != null) {
            return 0;
        }
        return -1;
    }

    public static void SeqInit() {
        int i;
        Console.out.println("Initializing SEQ animation");
        for (i = 0; i < 512; ++i) {
            SeqHandling.siWall[i] = new WallInst();
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siMasked[i] = new MaskedWallInst();
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siCeiling[i] = new CeilingInst();
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siFloor[i] = new FloorInst();
        }
    }

    public static SeqInst GetInstance(int type, int nXIndex) {
        switch (type) {
            case 0: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    throw new AssertException("nXIndex > 0 && nXIndex < kMaxXWalls: " + nXIndex);
                }
                return siWall[nXIndex];
            }
            case 1: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    throw new AssertException("nXIndex > 0 && nXIndex < kMaxXSectors: " + nXIndex);
                }
                return siCeiling[nXIndex];
            }
            case 2: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    throw new AssertException("nXIndex > 0 && nXIndex < kMaxXSectors: " + nXIndex);
                }
                return siFloor[nXIndex];
            }
            case 3: {
                XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
                if (pXSprite == null) {
                    throw new AssertException("pXSprite != null" + nXIndex);
                }
                return pXSprite.getSeqInst();
            }
            case 4: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    throw new AssertException("nXIndex > 0 && nXIndex < kMaxXWalls: " + nXIndex);
                }
                return siMasked[nXIndex];
            }
        }
        Console.out.println("Unexpected object type: " + type, OsdColor.RED);
        return null;
    }

    public static void seqKill(int type, int nXIndex) {
        SeqInst pInst = SeqHandling.GetInstance(type, nXIndex);
        if (pInst != null && pInst.isPlaying) {
            if (activeList.remove(pInst) == -1) {
                throw new AssertException("i < activeCount");
            }
            SeqHandling.UnlockInstance(pInst);
        }
    }

    public static void seqKillAll() {
        int i;
        for (i = 0; i < 512; ++i) {
            if (SeqHandling.siWall[i].isPlaying) {
                SeqHandling.UnlockInstance(siWall[i]);
            }
            if (!SeqHandling.siMasked[i].isPlaying) continue;
            SeqHandling.UnlockInstance(siMasked[i]);
        }
        for (i = 0; i < 512; ++i) {
            if (SeqHandling.siCeiling[i].isPlaying) {
                SeqHandling.UnlockInstance(siCeiling[i]);
            }
            if (!SeqHandling.siFloor[i].isPlaying) continue;
            SeqHandling.UnlockInstance(siFloor[i]);
        }
        for (ListNode<XSPRITE> node = Main.boardService.getXSpriteNode(); node != null; node = node.getNext()) {
            SeqInst pInst = node.get().getSeqInst();
            if (!pInst.isPlaying) continue;
            SeqHandling.UnlockInstance(pInst);
        }
        activeList.clear();
    }

    public static void seqSpawn(int nSeqID, int type, int nXIndex, CALLPROC callback) {
        SeqType pSequence;
        SeqInst pInst = SeqHandling.GetInstance(type, nXIndex);
        if (pInst == null) {
            throw new AssertException("pInst != null");
        }
        if (!Main.game.getCache().contains(nSeqID, "SEQ")) {
            throw new AssertException("hSeq != null, id = " + nSeqID);
        }
        boolean inList = false;
        if (pInst.isPlaying) {
            if (pInst.nSeqID == nSeqID) {
                return;
            }
            inList = activeList.getIndex(pInst) != -1;
            SeqHandling.UnlockInstance(pInst);
        }
        pInst.pSequence = pSequence = SeqType.getInstance(nSeqID);
        pInst.nSeqID = nSeqID;
        pInst.callback = callback;
        pInst.isPlaying = true;
        pInst.timeCounter = (short)pSequence.ticksPerFrame;
        pInst.frameIndex = 0;
        if (!inList && !activeList.add(pInst, nXIndex)) {
            throw new AssertException("activeCount < kMaxSequences");
        }
        pInst.update(nXIndex);
    }

    private static void UnlockInstance(SeqInst pInst) {
        if (pInst == null) {
            throw new AssertException("pInst != null");
        }
        if (pInst.pSequence == null) {
            throw new AssertException("pInst.pSequence != null");
        }
        pInst.pSequence = null;
        pInst.isPlaying = false;
    }

    public static int seqFrame(int type, int nXIndex) {
        SeqInst pInst = SeqHandling.GetInstance(type, nXIndex);
        if (pInst != null && pInst.isPlaying) {
            return pInst.frameIndex;
        }
        return -1;
    }

    public static void seqProcess(int nTicks) {
        block0: for (int i = 0; i < activeList.getSize(); ++i) {
            short index = activeList.getIndex(i);
            SeqInst pInst = activeList.getInst(i);
            SeqType pSeq = pInst.pSequence;
            if (pSeq == null) {
                throw new AssertException("pSeq != null");
            }
            if (pInst.frameIndex >= pSeq.nFrames) {
                throw new AssertException("pInst.frameIndex < pSeq.nFrames");
            }
            pInst.timeCounter = (short)(pInst.timeCounter - (short)nTicks);
            while (pInst.timeCounter < 0) {
                pInst.timeCounter = (short)(pInst.timeCounter + (short)pSeq.ticksPerFrame);
                pInst.frameIndex = (short)(pInst.frameIndex + 1);
                if (pInst.frameIndex == pSeq.nFrames) {
                    if (!pSeq.isLooping()) {
                        SeqHandling.UnlockInstance(pInst);
                        if (pSeq.isRemovable()) {
                            if (pInst instanceof SpriteInst) {
                                short nSprite = (short)Main.boardService.getXSprite(index).getReference();
                                if (!Main.boardService.isValidSprite(nSprite)) {
                                    throw new AssertException("isValidSprite(nSprite)");
                                }
                                EVENT.checkEventList(nSprite, 3);
                                if ((Main.boardService.getSprite(nSprite).getHitag() & 0x10) != 0 && Main.boardService.getSprite(nSprite).getZvel() >= 200 && Main.boardService.getSprite(nSprite).getZvel() < 256) {
                                    EVENT.evPostCallback(nSprite, 3, Integer.toUnsignedLong(Globals.pGameInfo.nWeaponSettings), 9);
                                } else {
                                    Main.engine.deletesprite(nSprite);
                                }
                            }
                            if (pInst instanceof MaskedWallInst) {
                                int nWall = DB.xwall[index].reference;
                                if (!Main.boardService.isValidWall(nWall)) {
                                    throw new AssertException("boardService.isValidWall(nWall)");
                                }
                                Main.boardService.getWall(nWall).setCstat(Main.boardService.getWall(nWall).getCstat() & 0xFFFFFFC7);
                                if (Main.boardService.getWall(nWall).getNextwall() != -1) {
                                    Main.boardService.getWall(Main.boardService.getWall(nWall).getNextwall()).setCstat(Main.boardService.getWall(Main.boardService.getWall(nWall).getNextwall()).getCstat() & 0xFFFFFFC7);
                                }
                            }
                        }
                        activeList.remove(i--);
                        continue block0;
                    }
                    pInst.frameIndex = 0;
                }
                pInst.update(index);
            }
        }
    }
}

