/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Seq;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqType;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Build.Types.Serializable;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;

public abstract class SeqInst
implements Serializable<SeqInst> {
    protected SeqType pSequence;
    protected CALLPROC callback;
    protected int nSeqID;
    protected short timeCounter;
    protected short frameIndex;
    protected boolean isPlaying;

    protected abstract void updateInstance(int var1);

    protected void update(int index) {
        if (this.frameIndex >= this.pSequence.getFrames()) {
            throw new AssertException("frameIndex < pSequence.nFrames");
        }
        this.updateInstance(index);
        if (this.pSequence.getFrame((int)this.frameIndex).trigger && this.callback != null) {
            this.callback.run(index);
        }
    }

    public int getSeqIndex() {
        return this.nSeqID;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    @Override
    public SeqInst writeObject(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, 0L);
        StreamUtils.writeInt(os, 0L);
        StreamUtils.writeInt(os, this.nSeqID);
        StreamUtils.writeInt(os, SeqHandling.getIndex(this.callback));
        StreamUtils.writeShort(os, this.timeCounter);
        StreamUtils.writeByte(os, (byte)this.frameIndex);
        StreamUtils.writeBoolean(os, this.isPlaying);
        return this;
    }

    @Override
    public SeqInst readObject(InputStream is) throws IOException {
        StreamUtils.skip(is, 4);
        StreamUtils.skip(is, 4);
        this.pSequence = null;
        this.nSeqID = StreamUtils.readInt(is);
        int callb = StreamUtils.readInt(is);
        if (callb != -1) {
            this.callback = callb > SeqHandling.callbacks.length ? VERSION.getCallback(callb) : SeqHandling.callbacks[callb];
        }
        this.timeCounter = StreamUtils.readShort(is);
        this.frameIndex = (short)StreamUtils.readUnsignedByte(is);
        this.isPlaying = StreamUtils.readBoolean(is);
        return this;
    }

    public void clear() {
        this.pSequence = null;
        this.callback = null;
        this.nSeqID = 0;
        this.timeCounter = 0;
        this.frameIndex = 0;
        this.isPlaying = false;
    }

    public void copy(SeqInst src) {
        this.pSequence = src.pSequence;
        this.nSeqID = src.nSeqID;
        this.timeCounter = src.timeCounter;
        this.frameIndex = src.frameIndex;
        this.isPlaying = src.isPlaying;
    }
}

