/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Seq;

import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.Seq.SeqFrame;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;

public class WallInst
extends SeqInst {
    @Override
    protected void updateInstance(int index) {
        if (index <= 0 || index >= 512) {
            throw new AssertException("nXWall > 0 && nXWall < kMaxXWalls");
        }
        int nWall = DB.xwall[index].reference;
        if (!Main.boardService.isValidWall(nWall)) {
            throw new AssertException("boardService.isValidWall(nWall)");
        }
        Wall pWall = Main.boardService.getWall(nWall);
        if (pWall.getExtra() != index) {
            throw new AssertException("pWall.extra == nXWall");
        }
        SeqFrame pFrame = this.pSequence.getFrame(this.frameIndex);
        pWall.setPicnum((short)pFrame.nTile);
        if (pFrame.pal != 0) {
            pWall.setPal((short)pFrame.pal);
        }
        if (pFrame.translucent) {
            pWall.setCstat(pWall.getCstat() | 0x80);
        } else {
            pWall.setCstat(pWall.getCstat() & 0xFFFFFF7F);
        }
        if (pFrame.translucentR) {
            pWall.setCstat(pWall.getCstat() | 0x200);
        } else {
            pWall.setCstat(pWall.getCstat() & 0xFFFFFDFF);
        }
        if (pFrame.blocking) {
            pWall.setCstat(pWall.getCstat() | 1);
        } else {
            pWall.setCstat(pWall.getCstat() & 0xFFFFFFFE);
        }
        if (pFrame.hitscan) {
            pWall.setCstat(pWall.getCstat() | 0x40);
        } else {
            pWall.setCstat(pWall.getCstat() & 0xFFFFFFBF);
        }
    }
}

