/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import java.util.Arrays;
import java.util.List;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.ZONE;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.exceptions.WarningException;

public class Warp {
    public static ZONE[] gStartZone = new ZONE[8];
    public static ZONE[] gStartZoneTeam1 = new ZONE[8];
    public static ZONE[] gStartZoneTeam2 = new ZONE[8];
    public static int[] gUpperLink = new int[Engine.MAXSECTORS];
    public static int[] gLowerLink = new int[Engine.MAXSECTORS];
    public static boolean gTeamsSpawnUsed = false;
    public static long checkWx;
    public static long checkWy;
    public static long checkWz;
    public static short checkWs;

    public static void InitPlayerStartZones(Board board) throws WarningException {
        Arrays.fill(gUpperLink, -1);
        Arrays.fill(gLowerLink, -1);
        List<Sprite> sprites = board.getSprites();
        int team1 = 0;
        int team2 = 0;
        block8: for (int nSprite = 0; nSprite < sprites.size(); ++nSprite) {
            XSPRITE pXSprite;
            Sprite pSprite = sprites.get(nSprite);
            if (pSprite.getStatnum() >= 1024 || (pXSprite = Main.boardService.getXSprite(pSprite.getExtra())) == null) continue;
            switch (pSprite.getLotag()) {
                case 1: {
                    ZONE pZone;
                    if (Globals.pGameInfo.nGameType < 2 && pXSprite.getData1() >= 0 && pXSprite.getData1() < 8) {
                        pZone = gStartZone[pXSprite.getData1()];
                        pZone.x = pSprite.getX();
                        pZone.y = pSprite.getY();
                        pZone.z = pSprite.getZ();
                        pZone.sector = pSprite.getSectnum();
                        pZone.angle = pSprite.getAng();
                    }
                    Main.engine.deletesprite(nSprite);
                    continue block8;
                }
                case 2: {
                    ZONE pZone;
                    if (pXSprite.getData1() >= 0 && pXSprite.getData1() < 8 && Globals.pGameInfo.nGameType >= 2) {
                        pZone = gStartZone[pXSprite.getData1()];
                        pZone.x = pSprite.getX();
                        pZone.y = pSprite.getY();
                        pZone.z = pSprite.getZ();
                        pZone.sector = pSprite.getSectnum();
                        pZone.angle = pSprite.getAng();
                        if (Globals.pGameInfo.nGameType == 3) {
                            if (pXSprite.getData2() == 1) {
                                pZone = gStartZoneTeam1[team1];
                                pZone.x = pSprite.getX();
                                pZone.y = pSprite.getY();
                                pZone.z = pSprite.getZ();
                                pZone.sector = pSprite.getSectnum();
                                pZone.angle = pSprite.getAng();
                                ++team1;
                            } else if (pXSprite.getData2() == 2) {
                                pZone = gStartZoneTeam2[team2];
                                pZone.x = pSprite.getX();
                                pZone.y = pSprite.getY();
                                pZone.z = pSprite.getZ();
                                pZone.sector = pSprite.getSectnum();
                                pZone.angle = pSprite.getAng();
                                ++team2;
                            }
                        }
                    }
                    Main.engine.deletesprite(nSprite);
                    continue block8;
                }
                case 7: {
                    Warp.gUpperLink[pSprite.getSectnum()] = (short)nSprite;
                    pSprite.setCstat(pSprite.getCstat() | 0x8000);
                    pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                    continue block8;
                }
                case 6: {
                    Warp.gLowerLink[pSprite.getSectnum()] = (short)nSprite;
                    pSprite.setCstat(pSprite.getCstat() | 0x8000);
                    pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                    continue block8;
                }
                case 9: 
                case 11: 
                case 13: {
                    Warp.gUpperLink[pSprite.getSectnum()] = (short)nSprite;
                    pSprite.setCstat(pSprite.getCstat() | 0x8000);
                    pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                    pSprite.setZ(Main.engine.getflorzofslope(pSprite.getSectnum(), pSprite.getX(), pSprite.getY()));
                    continue block8;
                }
                case 10: 
                case 12: 
                case 14: {
                    Warp.gLowerLink[pSprite.getSectnum()] = (short)nSprite;
                    pSprite.setCstat(pSprite.getCstat() | 0x8000);
                    pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
                    pSprite.setZ(Main.engine.getceilzofslope(pSprite.getSectnum(), pSprite.getX(), pSprite.getY()));
                }
            }
        }
        if (team1 > 0 || team2 > 0) {
            gTeamsSpawnUsed = true;
            if (team1 < 4 || team2 < 4) {
                throw new WarningException("At least 4 spawn positions for each team is recommended.");
            }
        }
        for (int nFrom = 0; nFrom < gUpperLink.length; ++nFrom) {
            if (gUpperLink[nFrom] < 0) continue;
            Sprite pFromSprite = sprites.get(gUpperLink[nFrom]);
            XSPRITE pXSprite = Main.boardService.getXSprite(pFromSprite.getExtra());
            if (pXSprite == null) {
                throw new AssertException("pXSprite != null");
            }
            short nID = pXSprite.getData1();
            for (int nTo = 0; nTo < gLowerLink.length; ++nTo) {
                if (gLowerLink[nTo] < 0) continue;
                Sprite pToSprite = sprites.get(gLowerLink[nTo]);
                pXSprite = Main.boardService.getXSprite(pToSprite.getExtra());
                if (pXSprite == null) {
                    throw new AssertException("pXSprite != null");
                }
                if (pXSprite.getData1() != nID) continue;
                pFromSprite.setOwner(gLowerLink[nTo]);
                pToSprite.setOwner(gUpperLink[nFrom]);
            }
        }
    }

    public static int checkWarping(Sprite pSprite) {
        int lz;
        int uz;
        int nUpper = gUpperLink[pSprite.getSectnum()];
        int nLower = gLowerLink[pSprite.getSectnum()];
        BloodSprite pUpper = Main.boardService.getSprite(nUpper);
        if (pUpper != null && (uz = pUpper.getLotag() != 7 ? Main.engine.getflorzofslope(pSprite.getSectnum(), pSprite.getX(), pSprite.getY()) : pUpper.getZ()) <= pSprite.getZ()) {
            nLower = pUpper.getOwner();
            BloodSprite pLower = Main.boardService.getSprite(nLower);
            if (pLower == null) {
                return 0;
            }
            if (!Main.boardService.isValidSector(pLower.getSectnum())) {
                throw new AssertException("boardService.isValidSector(pLower.getSectnum())");
            }
            Main.engine.changespritesect(pSprite.getXvel(), pLower.getSectnum());
            pSprite.setX(pSprite.getX() + (pLower.getX() - pUpper.getX()));
            pSprite.setY(pSprite.getY() + (pLower.getY() - pUpper.getY()));
            int lz2 = pLower.getLotag() == 6 ? pLower.getZ() : Main.engine.getceilzofslope(pSprite.getSectnum(), pSprite.getX(), pSprite.getY());
            pSprite.setZ(pSprite.getZ() + (lz2 - uz));
            Main.game.pInt.clearspriteinterpolate(pSprite.getXvel());
            return pUpper.getLotag();
        }
        BloodSprite pLower = Main.boardService.getSprite(nLower);
        if (pLower != null && (lz = pLower.getLotag() != 6 ? Main.engine.getceilzofslope(pSprite.getSectnum(), pSprite.getX(), pSprite.getY()) : pLower.getZ()) >= pSprite.getZ()) {
            nUpper = pLower.getOwner();
            pUpper = Main.boardService.getSprite(nUpper);
            if (pUpper == null) {
                return 0;
            }
            if (!Main.boardService.isValidSector(pUpper.getSectnum())) {
                throw new AssertException("boardService.isValidSector(pUpper.getSectnum())");
            }
            Main.engine.changespritesect(pSprite.getXvel(), pUpper.getSectnum());
            pSprite.setX(pSprite.getX() + (pUpper.getX() - pLower.getX()));
            pSprite.setY(pSprite.getY() + (pUpper.getY() - pLower.getY()));
            int uz2 = pUpper.getLotag() == 7 ? pUpper.getZ() : Main.engine.getflorzofslope(pSprite.getSectnum(), pSprite.getX(), pSprite.getY());
            pSprite.setZ(pSprite.getZ() + (uz2 - lz));
            Main.game.pInt.clearspriteinterpolate(pSprite.getXvel());
            return pLower.getLotag();
        }
        return 0;
    }

    public static void checkWarping(long x, long y, long z, int nSector) {
        if (nSector != -1) {
            int lz;
            int uz;
            int nUpper = gUpperLink[nSector];
            int nLower = gLowerLink[nSector];
            BloodSprite pUpper = Main.boardService.getSprite(nUpper);
            if (pUpper != null && (long)(uz = pUpper.getLotag() != 7 ? Main.engine.getflorzofslope((short)nSector, (int)x, (int)y) : pUpper.getZ()) <= z) {
                BloodSprite pLower = Main.boardService.getSprite(nLower);
                if (pLower == null) {
                    return;
                }
                if (!Main.boardService.isValidSector(pLower.getSectnum())) {
                    throw new AssertException("boardService.isValidSector(pLower.getSectnum())");
                }
                nSector = pUpper.getSectnum();
                int lz2 = pLower.getLotag() == 6 ? pLower.getZ() : Main.engine.getceilzofslope((short)nSector, (int)(x += (long)(pLower.getX() - pUpper.getX())), (int)(y += (long)(pLower.getY() - pUpper.getY())));
                checkWx = x;
                checkWy = y;
                checkWz = z += (long)(lz2 - uz);
                checkWs = (short)nSector;
                return;
            }
            BloodSprite pLower = Main.boardService.getSprite(nLower);
            if (pLower != null && (long)(lz = pLower.getLotag() != 6 ? Main.engine.getceilzofslope((short)nSector, (int)x, (int)y) : pLower.getZ()) >= z) {
                nUpper = pLower.getOwner();
                pUpper = Main.boardService.getSprite(nUpper);
                if (pUpper == null) {
                    return;
                }
                if (!Main.boardService.isValidSector(pUpper.getSectnum())) {
                    throw new AssertException("boardService.isValidSector(pUpper.getSectnum())");
                }
                nSector = pUpper.getSectnum();
                int uz2 = pUpper.getLotag() == 7 ? pUpper.getZ() : Main.engine.getflorzofslope((short)nSector, (int)(x += (long)(pUpper.getX() - pLower.getX())), (int)(y += (long)(pUpper.getY() - pLower.getY())));
                checkWx = x;
                checkWy = y;
                checkWz = z += (long)(uz2 - lz);
                checkWs = (short)nSector;
                return;
            }
        }
        checkWx = x;
        checkWy = y;
        checkWz = z;
        checkWs = (short)nSector;
    }
}

