/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.filehandlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class ChecksumInputStream
extends InputStream {
    private final Checksum checksum;
    private final InputStream parent;

    public ChecksumInputStream(InputStream parent) {
        this.parent = parent;
        this.checksum = new CRC32();
    }

    @Override
    public synchronized int read() throws IOException {
        int data = this.parent.read();
        if (data != -1) {
            this.checksum.update(data);
            return data & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int n = this.parent.read(b, off, len);
        if (n != -1) {
            this.checksum.update(b, off, len);
        }
        return n;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        byte[] skip = new byte[(int)n];
        long result = this.parent.read(skip);
        this.checksum.update(skip, 0, skip.length);
        return result;
    }

    @Override
    public int available() throws IOException {
        return this.parent.available();
    }

    @Override
    public void close() throws IOException {
        this.parent.close();
    }

    public long getChecksum() {
        return this.checksum.getValue();
    }
}

