/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.filehandlers;

import java.io.IOException;
import java.io.InputStream;

public class CryptedInputStream
extends InputStream {
    private final int cryptLength;
    private final InputStream parent;
    private long cryptKey;
    private int pos = 0;

    public CryptedInputStream(InputStream parent, long cryptKey, int cryptLength) {
        this.parent = parent;
        this.cryptKey = cryptKey;
        this.cryptLength = cryptLength;
    }

    protected long calcCryptKey() {
        return this.cryptKey++;
    }

    @Override
    public synchronized int read() throws IOException {
        int data = this.parent.read();
        if (data != -1) {
            if (this.pos < this.cryptLength) {
                data = (int)((long)data ^ this.calcCryptKey());
            }
            ++this.pos;
            return data & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int n = this.parent.read(b, off, len);
        if (n != -1) {
            if (this.pos < this.cryptLength) {
                this.encrypt(b, off, Math.min(this.cryptLength - this.pos, n));
            }
            this.pos += n;
        }
        return n;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long len;
        long result = 0L;
        do {
            len = this.parent.skip(n);
            this.pos = (int)((long)this.pos + len);
            this.cryptKey += len;
            result += len;
        } while ((n -= len) > 0L);
        return result;
    }

    @Override
    public int available() throws IOException {
        return this.parent.available();
    }

    @Override
    public void close() throws IOException {
        this.parent.close();
    }

    protected void encrypt(byte[] buffer, int offs, int size) {
        for (int i = 0; i < size; ++i) {
            int n = offs + i;
            buffer[n] = (byte)((long)buffer[n] ^ this.calcCryptKey());
        }
    }
}

