/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.filehandlers;

import java.util.Locale;
import ru.m210projects.Blood.Main;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.FileEntry;

public interface EpisodeEntry {
    public String getHashKey();

    public FileEntry getFileEntry();

    public Entry getIniFile();

    public Group getGroup();

    public boolean isPackageEpisode();

    public static class File
    extends FileEntry
    implements EpisodeEntry {
        public File(FileEntry fileEntry) {
            super(fileEntry);
        }

        @Override
        public String getHashKey() {
            return this.getRelativePath().toString().toUpperCase(Locale.ROOT);
        }

        @Override
        public FileEntry getFileEntry() {
            return this;
        }

        @Override
        public Entry getIniFile() {
            return this;
        }

        @Override
        public Group getGroup() {
            return this.getParent();
        }

        @Override
        public boolean isPackageEpisode() {
            return false;
        }
    }

    public static class Pack
    extends FileEntry
    implements EpisodeEntry {
        private final Entry iniFile;
        private final FileEntry groupFile;

        public Pack(FileEntry group, Entry iniFile) {
            super(group.getPath(), String.format("%s:%s", group.getName(), iniFile.getName()), group.getSize());
            this.iniFile = iniFile;
            this.groupFile = group;
            this.setParent(group.getParent());
        }

        @Override
        public String getHashKey() {
            return String.format("%s:%s", this.groupFile.getRelativePath().toString(), this.iniFile.getName()).toUpperCase(Locale.ROOT);
        }

        @Override
        public FileEntry getFileEntry() {
            return this.groupFile;
        }

        @Override
        public Entry getIniFile() {
            return this.iniFile;
        }

        @Override
        public Group getGroup() {
            return Main.game.getCache().newGroup(this.groupFile);
        }

        @Override
        public boolean isPackageEpisode() {
            return true;
        }

        @Override
        public String getExtension() {
            return this.groupFile.getExtension();
        }
    }
}

