/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Architecture.common;

import com.badlogic.gdx.Graphics;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResolutionUtils {
    public static String getDisplayModeAsString(Graphics.DisplayMode mode) {
        return String.format("%sx%s", mode.width, mode.height);
    }

    public static String getDisplayModeAsString(int width, int height) {
        return String.format("%sx%s", width, height);
    }

    public static Map<String, List<Graphics.DisplayMode>> getDisplayModes(Graphics.DisplayMode[] modes) {
        return Arrays.stream(modes).sorted(Comparator.comparingInt(a -> a.width)).collect(Collectors.groupingBy(e -> ResolutionUtils.getDisplayModeAsString(e.width, e.height), LinkedHashMap::new, Collectors.toList()));
    }

    public static List<Graphics.DisplayMode> getBestDisplayModes(Map<String, List<Graphics.DisplayMode>> resolutions, int bpp) {
        return resolutions.keySet().stream().map(e -> {
            List modes = (List)resolutions.get(e);
            return modes.stream().sorted(Comparator.comparingInt(mode -> Math.abs(mode.bitsPerPixel - bpp))).max(Comparator.comparingInt(a -> a.refreshRate)).orElse(null);
        }).collect(Collectors.toList());
    }

    public static Graphics.DisplayMode findDisplayMode(Graphics.DisplayMode[] modes, String resolution) {
        return Arrays.stream(modes).filter(e -> ResolutionUtils.getDisplayModeAsString(e.width, e.height).equals(resolution)).max(Comparator.comparingInt(a -> a.refreshRate)).orElse(null);
    }

    public static Graphics.DisplayMode findDisplayMode(Graphics.DisplayMode[] modes, int width, int height) {
        return Arrays.stream(modes).filter(e -> ResolutionUtils.getDisplayModeAsString(e.width, e.height).equals(ResolutionUtils.getDisplayModeAsString(width, height))).max(Comparator.comparingInt(a -> a.refreshRate)).orElse(null);
    }

    public static Graphics.DisplayMode findDisplayMode(Map<String, List<Graphics.DisplayMode>> resolutions, int width, int height) {
        return ResolutionUtils.getBestDisplayModes(resolutions, 32).stream().filter(e -> ResolutionUtils.getDisplayModeAsString(e.width, e.height).equals(ResolutionUtils.getDisplayModeAsString(width, height))).max(Comparator.comparingInt(a -> a.refreshRate)).orElse(null);
    }

    public static class UserDisplayMode
    extends Graphics.DisplayMode {
        public UserDisplayMode(int width, int height, int rate, int bpp) {
            super(width, height, rate, bpp);
        }

        public UserDisplayMode(int width, int height) {
            super(width, height, -1, -1);
        }

        public boolean isFullScreenSupport() {
            return this.bitsPerPixel != -1;
        }

        @Override
        public String toString() {
            return ResolutionUtils.getDisplayModeAsString(this.width, this.height);
        }
    }
}

