/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Architecture.common.audio;

import com.badlogic.gdx.Audio;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.lwjgl3.audio.OggDecoder;
import com.badlogic.gdx.backends.lwjgl3.audio.mock.MockAudio;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.Architecture.common.audio.AudioChannel;
import ru.m210projects.Build.Architecture.common.audio.AudioDriver;
import ru.m210projects.Build.Architecture.common.audio.AudioResampler;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.Architecture.common.audio.WAVDecoder;
import ru.m210projects.Build.exceptions.InitializationException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.AudioContext;
import ru.m210projects.Build.settings.GameConfig;

public interface BuildAudio
extends Audio {
    public String getName();

    public void stopAllSounds();

    public boolean canPlay(int var1);

    public void setListener(int var1, int var2, int var3, int var4);

    public void registerDecoder(String var1, SoundData.Decoder var2);

    @NotNull
    public SoundData.Decoder getSoundDecoder(String var1);

    public boolean isEFXSupport();

    public float getReverb();

    public void setReverb(boolean var1, float var2);

    public float getEcho();

    public void setEcho(boolean var1, float var2);

    public void update();

    @Nullable
    public Sound newSound(ByteBuffer var1, int var2, int var3, AudioChannel var4, int var5);

    @Nullable
    public Sound newSound(ByteBuffer var1, int var2, int var3, int var4);

    @Nullable
    public Music newMusic(Entry var1);

    public List<AudioResampler> getResamplerList();

    public void dispose();

    public BuildAudio open() throws InitializationException;

    public boolean isOpen();

    public AudioDriver getAudioDriver();

    public static class DummyAudio
    extends MockAudio
    implements BuildAudio {
        private final GameConfig config;
        private boolean opened = false;
        private final Map<String, SoundData.Decoder> decoders = new HashMap<String, SoundData.Decoder>();

        public DummyAudio(GameConfig config) {
            this.config = config;
            this.registerDecoder("wav", new WAVDecoder());
            this.registerDecoder("ogg", new OggDecoder());
        }

        @Override
        public String getName() {
            return "Dummy audio driver";
        }

        @Override
        public void stopAllSounds() {
        }

        @Override
        public boolean canPlay(int priority) {
            return false;
        }

        @Override
        public void setListener(int x, int y, int z, int ang) {
        }

        @Override
        public void registerDecoder(String extension, SoundData.Decoder decoder) {
            this.decoders.put(extension.toUpperCase(), decoder);
        }

        @Override
        public @NotNull SoundData.Decoder getSoundDecoder(String extension) {
            SoundData.Decoder decoder = this.decoders.getOrDefault(extension.toUpperCase(), SoundData.DUMMY_DECODER);
            if (decoder == null) {
                DummyAudio.$$$reportNull$$$0(0);
            }
            return decoder;
        }

        @Override
        public boolean isEFXSupport() {
            return false;
        }

        @Override
        public float getReverb() {
            return 0.0f;
        }

        @Override
        public void setReverb(boolean enable, float delay) {
        }

        @Override
        public float getEcho() {
            return 0.0f;
        }

        @Override
        public void setEcho(boolean enable, float delay) {
        }

        @Override
        @Nullable
        public Sound newSound(ByteBuffer buffer, int rate, int bits, AudioChannel channel, int priority) {
            return null;
        }

        @Override
        @Nullable
        public Sound newSound(ByteBuffer buffer, int rate, int bits, int priority) {
            return null;
        }

        @Override
        @Nullable
        public Music newMusic(Entry file) {
            if (file == null) {
                throw new IllegalArgumentException("file cannot be null.");
            }
            if (!file.exists()) {
                return null;
            }
            return this.config.getMidiDevice().newMusic(file);
        }

        @Override
        public List<AudioResampler> getResamplerList() {
            return Collections.singletonList(AudioResampler.DUMMY_RESAMPLER);
        }

        @Override
        public BuildAudio open() {
            Console.out.println("Initialization " + this.getName() + "...");
            this.config.setAudioContext(new AudioContext());
            this.opened = true;
            return this;
        }

        @Override
        public boolean isOpen() {
            return this.opened;
        }

        @Override
        public void dispose() {
            super.dispose();
            this.opened = false;
        }

        @Override
        public AudioDriver getAudioDriver() {
            return AudioDriver.DUMMY_AUDIO;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Build/Architecture/common/audio/BuildAudio$DummyAudio", "getSoundDecoder"));
        }
    }
}

