/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.LinkedList;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class Board {
    private final BuildPos pos;
    private final Sector[] sectors;
    private final Wall[] walls;
    private final List<Sprite> sprites;

    public Board(BuildPos pos, Sector[] sectors, Wall[] walls, List<Sprite> sprites) {
        this.pos = pos;
        this.sectors = sectors;
        this.walls = walls;
        this.sprites = sprites;
        for (int s = 0; s < sectors.length; ++s) {
            Sector sec = sectors[s];
            LinkedList<Wall> wallList = new LinkedList<Wall>();
            int startWall = sec.getWallptr();
            int endWall = startWall + sec.getWallnum() - 1;
            for (int i = startWall; i <= endWall; ++i) {
                Wall wal2;
                Wall wal = this.getWall(i);
                if (wal == null || (wal2 = this.getWall(wal.getPoint2())) == null) {
                    wallList = new LinkedList();
                    break;
                }
                wal.setWall2(wal2);
                wallList.addLast(wal.buildNode(i));
            }
            if (wallList.getSize() >= 3) {
                sec.setWallList(wallList);
                continue;
            }
            Console.out.println(String.format("Sector %d has corrupt contour", s), OsdColor.RED);
            sec.setAsBroken();
        }
    }

    public BuildPos getPos() {
        return this.pos;
    }

    public List<Sprite> getSprites() {
        return this.sprites;
    }

    public Sector[] getSectors() {
        return this.sectors;
    }

    public Wall[] getWalls() {
        return this.walls;
    }

    @Nullable
    public Sprite getSprite(int index) {
        if (!this.isValidSprite(index)) {
            return null;
        }
        return this.sprites.get(index);
    }

    @Nullable
    public Wall getWall(int index) {
        if (!this.isValidWall(index)) {
            return null;
        }
        return this.walls[index];
    }

    @Nullable
    public Sector getSector(int index) {
        if (!this.isValidSector(index)) {
            return null;
        }
        return this.sectors[index];
    }

    public int getWallCount() {
        return this.walls.length;
    }

    public int getSectorCount() {
        return this.sectors.length;
    }

    public int getSpriteCount() {
        return this.sprites.size();
    }

    public boolean isValidSector(int sectnum) {
        return sectnum >= 0 && sectnum < this.sectors.length;
    }

    public boolean isValidWall(int wallnum) {
        return wallnum >= 0 && wallnum < this.walls.length;
    }

    public boolean isValidSprite(int spritenum) {
        return spritenum >= 0 && spritenum < this.sprites.size();
    }
}

