/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Render.listeners.WorldListener;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.LinkedMap;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.collections.SpriteMap;
import ru.m210projects.Build.Types.collections.ValueSetter;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class BoardService {
    protected final AtomicInteger floorz = new AtomicInteger();
    protected final AtomicInteger ceilingz = new AtomicInteger();
    protected final Map<Integer, Class<? extends Sector>> versionToSectorClass = new HashMap<Integer, Class<? extends Sector>>();
    protected final Map<Integer, Class<? extends Wall>> versionToWallClass = new HashMap<Integer, Class<? extends Wall>>();
    protected final Map<Integer, Class<? extends Sprite>> versionToSpriteClass = new HashMap<Integer, Class<? extends Sprite>>();
    protected final Set<Integer> versions = new HashSet<Integer>();
    protected Board board;
    protected LinkedMap<Sprite> spriteStatMap = this.createSpriteMap(1, new ArrayList<Sprite>(), 1, Sprite::setStatnum);
    protected LinkedMap<Sprite> spriteSectMap = this.createSpriteMap(1, new ArrayList<Sprite>(), 1, Sprite::setSectnum);
    protected WorldListener listener = WorldListener.DUMMY_LISTENER;

    public BoardService() {
        this.registerBoard(7, Sector.class, Wall.class, Sprite.class);
    }

    public void setListener(WorldListener listener) {
        this.listener = listener;
    }

    protected void initSpriteLists(Board board) {
        List<Sprite> sprites = board.getSprites();
        this.spriteStatMap = this.createSpriteMap(1024, sprites, 4096, Sprite::setStatnum);
        this.spriteSectMap = this.createSpriteMap(board.getSectorCount(), sprites, 4096, Sprite::setSectnum);
    }

    protected void registerBoard(int version, Class<? extends Sector> sectorClass, Class<? extends Wall> wallClass, Class<? extends Sprite> spriteClass) {
        this.versionToSectorClass.put(version, sectorClass);
        this.versionToWallClass.put(version, wallClass);
        this.versionToSpriteClass.put(version, spriteClass);
        this.versions.add(version);
    }

    protected Board loadBoard(Entry entry) throws IOException {
        Board board;
        block12: {
            InputStream is = entry.getInputStream();
            try {
                int version = StreamUtils.readInt(is);
                if (!this.versions.contains(version)) {
                    throw new WarningException("Wrong version: " + version);
                }
                BuildPos startPos = new BuildPos(StreamUtils.readInt(is), StreamUtils.readInt(is), StreamUtils.readInt(is), StreamUtils.readShort(is), StreamUtils.readShort(is));
                ArrayList<Sprite> sprites = new ArrayList<Sprite>();
                Constructor<? extends Sector> sectorConstructor = this.versionToSectorClass.get(version).getConstructor(new Class[0]);
                Constructor<? extends Wall> wallConstructor = this.versionToWallClass.get(version).getConstructor(new Class[0]);
                Constructor<? extends Sprite> spriteConstructor = this.versionToSpriteClass.get(version).getConstructor(new Class[0]);
                Sector[] sectors = new Sector[StreamUtils.readShort(is)];
                for (int i = 0; i < sectors.length; ++i) {
                    sectors[i] = sectorConstructor.newInstance(new Object[0]).readObject(is);
                }
                Wall[] walls = new Wall[StreamUtils.readShort(is)];
                for (int i = 0; i < walls.length; ++i) {
                    walls[i] = wallConstructor.newInstance(new Object[0]).readObject(is);
                }
                int numSprites = StreamUtils.readShort(is);
                for (int i = 0; i < numSprites; ++i) {
                    sprites.add(spriteConstructor.newInstance(new Object[0]).readObject(is));
                }
                board = new Board(startPos, sectors, walls, sprites);
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReflectiveOperationException e) {
                    throw new WarningException(e.toString());
                }
            }
            is.close();
        }
        return board;
    }

    public Board prepareBoard(Board board) throws WarningException {
        Sector startSector;
        Wall[] walls = board.getWalls();
        Sector[] sectors = board.getSectors();
        List<Sprite> sprites = board.getSprites();
        this.board = board;
        this.initSpriteLists(board);
        for (Sprite spr : sprites) {
            this.insertsprite(spr.getSectnum(), spr.getStatnum());
        }
        BuildPos startPos = board.getPos();
        int sectnum = this.updatesector(startPos.getX(), startPos.getY(), startPos.getSectnum());
        if (sectnum != startPos.getSectnum()) {
            startPos = new BuildPos(startPos.getX(), startPos.getY(), startPos.getZ(), startPos.getAng(), sectnum);
            this.board = new Board(startPos, sectors, walls, sprites);
        }
        if ((startSector = this.board.getSector(startPos.getSectnum())) == null || !startSector.inside(startPos.getX(), startPos.getY())) {
            throw new WarningException("Player should be in a sector!");
        }
        return this.board;
    }

    public void notifyBoardChanged() {
        this.listener.onLoadBoard(this.board);
    }

    protected SpriteMap createSpriteMap(int listCount, List<Sprite> spriteList, int spriteCount, ValueSetter<Sprite> valueSetter) {
        return new SpriteMap(listCount, spriteList, spriteCount, valueSetter);
    }

    public int insertspritesect(int sectnum) {
        return this.spriteSectMap.insert(sectnum);
    }

    public void insertspritestat(int newstatnum) {
        this.spriteStatMap.insert(newstatnum);
    }

    public int insertsprite(int sectnum, int statnum) {
        this.insertspritestat(statnum);
        int spritenum = this.insertspritesect(sectnum);
        this.listener.onAddSprite(spritenum);
        return spritenum;
    }

    public boolean deletesprite(int spritenum) {
        this.listener.onRemoveSprite(spritenum);
        this.deletespritestat(spritenum);
        return this.deletespritesect(spritenum);
    }

    public boolean changespritesect(int spritenum, int newsectnum) {
        if (newsectnum < 0 || newsectnum > this.board.getSectorCount()) {
            return false;
        }
        Sprite sprite = this.board.getSprite(spritenum);
        if (sprite == null || !this.isValidSector(sprite.getSectnum())) {
            return false;
        }
        return this.spriteSectMap.set(spritenum, newsectnum);
    }

    public boolean changespritestat(int spritenum, int newstatnum) {
        if (newstatnum < 0 || newstatnum > 1024) {
            return false;
        }
        Sprite sprite = this.board.getSprite(spritenum);
        if (sprite == null || sprite.getStatnum() == 1024) {
            return false;
        }
        return this.spriteStatMap.set(spritenum, newstatnum);
    }

    public boolean deletespritesect(int spritenum) {
        return this.spriteSectMap.remove(spritenum);
    }

    public void deletespritestat(int spritenum) {
        this.spriteStatMap.remove(spritenum);
    }

    public boolean setSprite(int spritenum, int newx, int newy, int newz, boolean checkZ) {
        Sprite sprite = this.board.getSprite(spritenum);
        if (sprite == null) {
            return false;
        }
        sprite.setX(newx);
        sprite.setY(newy);
        sprite.setZ(newz);
        int sectnum = sprite.getSectnum();
        sectnum = checkZ ? this.updatesectorz(newx, newy, newz, sectnum) : this.updatesector(newx, newy, sectnum);
        if (sectnum < 0) {
            return false;
        }
        if (sectnum != sprite.getSectnum()) {
            this.changespritesect(spritenum, sectnum);
        }
        return true;
    }

    public int getLastWall(int point) {
        Wall[] walls = this.board.getWalls();
        if (point > 0 && walls[point - 1].getPoint2() == point) {
            return point - 1;
        }
        int i = point;
        int cnt = this.board.getWallCount();
        do {
            short j;
            if ((j = walls[i].getPoint2()) == point) {
                return i;
            }
            i = j;
        } while (--cnt > 0);
        return point;
    }

    public int updatesector(int x, int y, int sector) {
        Sector sec = this.board.getSector(sector);
        if (sec != null) {
            if (sec.inside(x, y)) {
                return sector;
            }
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall wall = wn.get();
                sector = wall.getNextsector();
                sec = this.board.getSector(sector);
                if (sec == null || !sec.inside(x, y)) continue;
                return sector;
            }
        }
        Sector[] sectors = this.board.getSectors();
        for (int i = sectors.length - 1; i >= 0; --i) {
            if (!sectors[i].inside(x, y)) continue;
            return i;
        }
        return -1;
    }

    public int updatesectorz(int x, int y, int z, int sectnum) {
        Sector sec = this.board.getSector(sectnum);
        if (sec != null) {
            if (this.insidez(x, y, z, sec)) {
                return sectnum;
            }
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall wall = wn.get();
                sectnum = wall.getNextsector();
                if (!this.insidez(x, y, z, this.board.getSector(sectnum))) continue;
                return sectnum;
            }
        }
        for (int i = this.board.getSectorCount() - 1; i >= 0; --i) {
            if (!this.insidez(x, y, z, this.board.getSector(i))) continue;
            return i;
        }
        return -1;
    }

    public boolean getzsofslope(Sector sec, int dax, int day, AtomicInteger floorZ, AtomicInteger ceilingZ) {
        if (sec != null) {
            sec.getzsofslope(dax, day, floorZ, ceilingZ);
            return true;
        }
        return false;
    }

    public int getceilzofslope(Sector sec, int x, int y) {
        this.getzsofslope(sec, x, y, null, this.ceilingz);
        return this.ceilingz.get();
    }

    public int getflorzofslope(Sector sec, int x, int y) {
        this.getzsofslope(sec, x, y, this.floorz, null);
        return this.floorz.get();
    }

    public int sectorOfWall(int theline) {
        int gap;
        Wall wall = this.board.getWall(theline);
        if (wall == null) {
            return -1;
        }
        Wall nextWall = this.board.getWall(wall.getNextwall());
        if (nextWall != null) {
            return nextWall.getNextsector();
        }
        Sector[] sectors = this.board.getSectors();
        int i = gap = this.board.getSectorCount() >> 1;
        while (gap > 1) {
            gap >>= 1;
            if (sectors[i].getWallptr() < theline) {
                i += gap;
                continue;
            }
            i -= gap;
        }
        while (sectors[i].getWallptr() > theline) {
            --i;
        }
        while (sectors[i].getWallptr() + sectors[i].getWallnum() <= theline) {
            ++i;
        }
        return i;
    }

    public boolean insidez(int x, int y, int z, Sector sector) {
        if (sector == null) {
            return false;
        }
        if (this.getzsofslope(sector, x, y, this.floorz, this.ceilingz) && z >= this.ceilingz.get() && z <= this.floorz.get()) {
            return this.inside(x, y, sector);
        }
        return sector.inside(x, y, z);
    }

    public boolean inside(int x, int y, Sector sector) {
        if (sector == null) {
            return false;
        }
        int cnt = 0;
        for (ListNode<Wall> wn = sector.getWallNode(); wn != null; wn = wn.getNext()) {
            int x2;
            int y2;
            Wall wal = wn.get();
            Wall wal2 = this.getNextWall(wal);
            int y1 = wal.getY() - y;
            if ((y1 ^ (y2 = wal2.getY() - y)) >= 0) continue;
            int x1 = wal.getX() - x;
            if ((x1 ^ (x2 = wal2.getX() - x)) >= 0) {
                cnt ^= x1;
                continue;
            }
            cnt ^= x1 * y2 - x2 * y1 ^ y2;
        }
        return cnt >>> 31 != 0;
    }

    public int nextSectorNeighborZ(int sectnum, int thez, int topbottom, int direction) {
        Sector sec = this.board.getSector(sectnum);
        if (sec == null) {
            return -1;
        }
        int sectorToUse = -1;
        int nextz = Integer.MIN_VALUE;
        if (direction == 1) {
            nextz = Integer.MAX_VALUE;
        }
        for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
            Wall wal = wn.get();
            short nextSectNum = wal.getNextsector();
            Sector nextSector = this.board.getSector(nextSectNum);
            if (nextSector == null) continue;
            int testz = topbottom == 1 ? nextSector.getFloorz() : nextSector.getCeilingz();
            if (direction == 1) {
                if (testz <= thez || testz >= nextz) continue;
                nextz = testz;
                sectorToUse = nextSectNum;
                continue;
            }
            if (testz >= thez || testz <= nextz) continue;
            nextz = testz;
            sectorToUse = nextSectNum;
        }
        return sectorToUse;
    }

    public Board getBoard() {
        return this.board;
    }

    public void setBoard(Board board) {
        this.board = board;
        this.initSpriteLists(board);
        List<Sprite> sprites = board.getSprites();
        for (int i = 0; i < sprites.size(); ++i) {
            Sprite spr = sprites.get(i);
            this.changespritestat(i, spr.getStatnum());
            this.changespritesect(i, spr.getSectnum());
        }
    }

    public ListNode<Sprite> getSectNode(int sector) {
        return this.spriteSectMap.getFirst(sector);
    }

    public ListNode<Sprite> getStatNode(int statnum) {
        return this.spriteStatMap.getFirst(statnum);
    }

    public boolean isValidSector(int index) {
        return this.board.isValidSector(index);
    }

    public boolean isValidWall(int index) {
        return this.board.isValidWall(index);
    }

    public boolean isValidSprite(int index) {
        return this.board.isValidSprite(index);
    }

    @Nullable
    public Sector getSector(int index) {
        return this.board.getSector(index);
    }

    @Nullable
    public Wall getWall(int index) {
        return this.board.getWall(index);
    }

    @Nullable
    public Sprite getSprite(int index) {
        return this.board.getSprite(index);
    }

    public Wall getNextWall(Wall wall) {
        return this.board.getWall(wall.getPoint2());
    }

    public int getSectorCount() {
        return this.board.getSectorCount();
    }

    public int getWallCount() {
        return this.board.getWallCount();
    }

    public int getSpriteCount() {
        return this.board.getSpriteCount();
    }
}

