/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.ClipInfo;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Variable;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.IntSet;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class ClipMover {
    protected static final int MAXCLIPDIST = 1024;
    protected final ClipInfo info;
    protected final Engine engine;
    protected final IntSet sectorSet;
    protected final Variable rx = new Variable();
    protected final Variable ry = new Variable();
    protected final Variable rz = new Variable();
    protected final List<ClipLine> clipLines = new ArrayList<ClipLine>();
    protected int clipNum = 0;
    protected int traceNum = 3;
    protected int[] hitwalls = new int[this.traceNum + 1];
    private boolean needUpdateSector = true;

    public ClipMover(Engine engine) {
        this.engine = engine;
        this.info = new ClipInfo();
        this.sectorSet = new IntSet(Engine.MAXSECTORS);
    }

    public void setNeedUpdateSector(boolean needUpdateSector) {
        this.needUpdateSector = needUpdateSector;
    }

    public void setTraceNum(int num) {
        this.traceNum = num;
        if (num > this.hitwalls.length - 1) {
            this.hitwalls = new int[num + 1];
        }
    }

    public int invoke(int x, int y, int z, int sectnum, long xvect, long yvect, int walldist, int ceildist, int flordist, int cliptype) {
        int hitwall;
        BoardService service = this.engine.getBoardService();
        if ((xvect | yvect) == 0L || !service.isValidSector(sectnum)) {
            this.info.set(x, y, z, sectnum);
            return 0;
        }
        int retval = 0;
        this.clipNum = 0;
        long oxvect = xvect;
        long oyvect = yvect;
        int goalx = x + (int)(xvect >> 14);
        int goaly = y + (int)(yvect >> 14);
        int cx = x + goalx >> 1;
        int cy = y + goaly >> 1;
        int gx = goalx - x;
        int gy = goaly - y;
        int rad = EngineUtils.sqrt(gx * gx + gy * gy) + 1024 + walldist + 8;
        int xmin = cx - rad;
        int ymin = cy - rad;
        int xmax = cx + rad;
        int ymax = cy + rad;
        int dawalclipmask = cliptype & 0xFFFF;
        int dasprclipmask = cliptype >> 16;
        this.sectorSet.clear();
        this.sectorSet.addValue(sectnum);
        for (int dacnt = 0; dacnt < this.sectorSet.size(); ++dacnt) {
            int dasect = this.sectorSet.getValue(dacnt);
            Sector sec = service.getSector(dasect);
            if (sec == null) continue;
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                int day;
                int y2;
                int dy;
                Wall wal = wn.get();
                Wall wal2 = wal.getWall2();
                if (wal.getX() < xmin && wal2.getX() < xmin || wal.getX() > xmax && wal2.getX() > xmax || wal.getY() < ymin && wal2.getY() < ymin || wal.getY() > ymax && wal2.getY() > ymax) continue;
                int x1 = wal.getX();
                int y1 = wal.getY();
                int x2 = wal2.getX();
                int dx = x2 - x1;
                if (dx * (y - y1) < (x - x1) * (dy = (y2 = wal2.getY()) - y1)) continue;
                int dax = dx > 0 ? dx * (ymin - y1) : dx * (ymax - y1);
                int n = day = dy > 0 ? dy * (xmax - x1) : dy * (xmin - x1);
                if (dax >= day) continue;
                boolean clipyou = false;
                if (wal.getNextsector() < 0 || (wal.getCstat() & dawalclipmask) != 0) {
                    clipyou = true;
                } else {
                    if (this.engine.notIntersect(x, y, 0, gx, gy, 0, x1, y1, x2, y2, this.rx, this.ry, this.rz)) {
                        dax = x;
                        day = y;
                    } else {
                        dax = this.rx.get();
                        day = this.ry.get();
                    }
                    Sector sec2 = service.getSector(wal.getNextsector());
                    if (sec2 == null) continue;
                    int daz = service.getflorzofslope(sec, dax, day);
                    int daz2 = service.getflorzofslope(sec2, dax, day);
                    if (daz2 < daz - 256 && !sec2.isParallaxFloor() && z >= daz2 - (flordist - 1)) {
                        clipyou = true;
                    }
                    if (!clipyou) {
                        daz = service.getceilzofslope(sec, dax, day);
                        daz2 = service.getceilzofslope(sec2, dax, day);
                        if (daz2 > daz + 256 && !sec2.isParallaxCeiling() && z <= daz2 + (ceildist - 1)) {
                            clipyou = true;
                        }
                    }
                }
                if (clipyou) {
                    int j = wn.getIndex();
                    int bsz = walldist;
                    if (gx < 0) {
                        bsz = -bsz;
                    }
                    this.addclipline(x1 - bsz, y1 - bsz, x1 - bsz, y1 + bsz, j | Integer.MIN_VALUE);
                    this.addclipline(x2 - bsz, y2 - bsz, x2 - bsz, y2 + bsz, j | Integer.MIN_VALUE);
                    bsz = walldist;
                    if (gy < 0) {
                        bsz = -bsz;
                    }
                    this.addclipline(x1 + bsz, y1 - bsz, x1 - bsz, y1 - bsz, j | Integer.MIN_VALUE);
                    this.addclipline(x2 + bsz, y2 - bsz, x2 - bsz, y2 - bsz, j | Integer.MIN_VALUE);
                    dax = walldist;
                    if (dy > 0) {
                        dax = -dax;
                    }
                    day = walldist;
                    if (dx < 0) {
                        day = -day;
                    }
                    this.addclipline(x1 + dax, y1 + day, x2 + dax, y2 + day, j | Integer.MIN_VALUE);
                    continue;
                }
                short nextsector = wal.getNextsector();
                this.sectorSet.addValue(nextsector);
            }
            block7: for (ListNode<Sprite> node = service.getSectNode(dasect); node != null; node = node.getNext()) {
                int j = node.getIndex();
                Sprite spr = node.get();
                short cstat = spr.getCstat();
                if ((cstat & dasprclipmask) == 0) continue;
                int x1 = spr.getX();
                int y1 = spr.getY();
                ArtEntry pic = this.engine.getTile(spr.getPicnum());
                switch (cstat & 0x30) {
                    case 0: {
                        if (x1 < xmin || x1 > xmax || y1 < ymin || y1 > ymax) continue block7;
                        int daz = spr.getZ();
                        int k = pic.getHeight() * spr.getYrepeat() << 2;
                        if ((spr.getCstat() & 0x80) != 0) {
                            daz += k >> 1;
                        }
                        if (pic.hasYOffset()) {
                            daz -= pic.getOffsetY() * spr.getYrepeat() << 2;
                        }
                        if (z >= daz + ceildist || z <= daz - k - flordist) continue block7;
                        int bsz = (spr.getClipdist() << 2) + walldist;
                        if (gx < 0) {
                            bsz = -bsz;
                        }
                        this.addclipline(x1 - bsz, y1 - bsz, x1 - bsz, y1 + bsz, j | 0xC0000000);
                        bsz = (spr.getClipdist() << 2) + walldist;
                        if (gy < 0) {
                            bsz = -bsz;
                        }
                        this.addclipline(x1 + bsz, y1 - bsz, x1 - bsz, y1 - bsz, j | 0xC0000000);
                        continue block7;
                    }
                    case 16: {
                        int y2;
                        int daz = spr.getZ();
                        int k = pic.getHeight() * spr.getYrepeat() << 2;
                        if ((spr.getCstat() & 0x80) != 0) {
                            daz += k >> 1;
                        }
                        if (pic.hasYOffset()) {
                            daz -= pic.getOffsetY() * spr.getYrepeat() << 2;
                        }
                        int daz2 = daz - k;
                        if (z >= (daz += ceildist) || z <= (daz2 -= flordist)) continue block7;
                        byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                        if ((cstat & 4) > 0) {
                            xoff = -xoff;
                        }
                        k = spr.getAng();
                        int l = spr.getXrepeat();
                        int dax = EngineUtils.sin(k) * l;
                        int day = EngineUtils.cos(k + 1024) * l;
                        l = pic.getWidth();
                        k = (l >> 1) + xoff;
                        int x2 = (x1 -= Pragmas.mulscale(dax, k, 16)) + Pragmas.mulscale(dax, l, 16);
                        if (this.engine.clipInsideBoxLine(cx, cy, x1, y1 -= Pragmas.mulscale(day, k, 16), x2, y2 = y1 + Pragmas.mulscale(day, l, 16), rad) == 0) continue block7;
                        dax = Pragmas.mulscale(EngineUtils.cos(spr.getAng() + 256), walldist, 14);
                        day = Pragmas.mulscale(EngineUtils.sin(spr.getAng() + 256), walldist, 14);
                        if ((x1 - x) * (y2 - y) >= (x2 - x) * (y1 - y)) {
                            this.addclipline(x1 + dax, y1 + day, x2 + day, y2 - dax, j | 0xC0000000);
                        } else {
                            if ((cstat & 0x40) != 0) continue block7;
                            this.addclipline(x2 - dax, y2 - day, x1 - day, y1 + dax, j | 0xC0000000);
                        }
                        if ((x2 - x1) * (x - x1) + (y2 - y1) * (y - y1) < 0) {
                            this.addclipline(x1 - day, y1 + dax, x1 + dax, y1 + day, j | 0xC0000000);
                            continue block7;
                        }
                        if ((x1 - x2) * (x - x2) + (y1 - y2) * (y - y2) >= 0) continue block7;
                        this.addclipline(x2 + day, y2 - dax, x2 - dax, y2 - day, j | 0xC0000000);
                        continue block7;
                    }
                    case 32: {
                        int daz = spr.getZ() + ceildist;
                        int daz2 = spr.getZ() - flordist;
                        if (z >= daz || z <= daz2 || (cstat & 0x40) != 0 && z > spr.getZ() == ((cstat & 8) == 0)) continue block7;
                        byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                        byte yoff = (byte)(pic.getOffsetY() + spr.getYoffset());
                        if ((cstat & 4) > 0) {
                            xoff = -xoff;
                        }
                        if ((cstat & 8) > 0) {
                            yoff = -yoff;
                        }
                        int k = spr.getAng();
                        int cosang = EngineUtils.cos(k);
                        int sinang = EngineUtils.sin(k);
                        int xspan = pic.getWidth();
                        short xrepeat = spr.getXrepeat();
                        int yspan = pic.getHeight();
                        short yrepeat = spr.getYrepeat();
                        int dax = ((xspan >> 1) + xoff) * xrepeat;
                        int day = ((yspan >> 1) + yoff) * yrepeat;
                        int rxi0 = x1 + Pragmas.dmulscale(sinang, dax, cosang, day, 16);
                        int ryi0 = y1 + Pragmas.dmulscale(sinang, day, -cosang, dax, 16);
                        int l = xspan * xrepeat;
                        int rxi1 = rxi0 - Pragmas.mulscale(sinang, l, 16);
                        int ryi1 = ryi0 + Pragmas.mulscale(cosang, l, 16);
                        l = yspan * yrepeat;
                        k = -Pragmas.mulscale(cosang, l, 16);
                        int rxi2 = rxi1 + k;
                        int rxi3 = rxi0 + k;
                        k = -Pragmas.mulscale(sinang, l, 16);
                        int ryi2 = ryi1 + k;
                        int ryi3 = ryi0 + k;
                        dax = Pragmas.mulscale(EngineUtils.cos(spr.getAng() - 256), walldist, 14);
                        day = Pragmas.mulscale(EngineUtils.sin(spr.getAng() - 256), walldist, 14);
                        if ((rxi0 - x) * (ryi1 - y) < (rxi1 - x) * (ryi0 - y)) {
                            if (this.engine.clipInsideBoxLine(cx, cy, rxi1, ryi1, rxi0, ryi0, rad) != 0) {
                                this.addclipline(rxi1 - day, ryi1 + dax, rxi0 + dax, ryi0 + day, j | 0xC0000000);
                            }
                        } else if ((rxi2 - x) * (ryi3 - y) < (rxi3 - x) * (ryi2 - y) && this.engine.clipInsideBoxLine(cx, cy, rxi3, ryi3, rxi2, ryi2, rad) != 0) {
                            this.addclipline(rxi3 + day, ryi3 - dax, rxi2 - dax, ryi2 - day, j | 0xC0000000);
                        }
                        if ((rxi1 - x) * (ryi2 - y) < (rxi2 - x) * (ryi1 - y)) {
                            if (this.engine.clipInsideBoxLine(cx, cy, rxi2, ryi2, rxi1, ryi1, rad) == 0) continue block7;
                            this.addclipline(rxi2 - dax, ryi2 - day, rxi1 - day, ryi1 + dax, j | 0xC0000000);
                            continue block7;
                        }
                        if ((rxi3 - x) * (ryi0 - y) >= (rxi0 - x) * (ryi3 - y) || this.engine.clipInsideBoxLine(cx, cy, rxi0, ryi0, rxi3, ryi3, rad) == 0) continue block7;
                        this.addclipline(rxi0 + dax, ryi0 + day, rxi3 + day, ryi3 - dax, j | 0xC0000000);
                    }
                }
            }
        }
        int cnt = this.traceNum;
        do {
            this.rx.set(goalx);
            this.ry.set(goaly);
            hitwall = this.raytrace(x, y, this.rx, this.ry);
            int intx = this.rx.get();
            int inty = this.ry.get();
            if (hitwall != -1) {
                int i;
                int templong1;
                ClipLine clipit = this.clipLines.get(hitwall);
                int lx = clipit.x2 - clipit.x1;
                int ly = clipit.y2 - clipit.y1;
                int templong2 = lx * lx + ly * ly;
                if (templong2 > 0) {
                    templong1 = (goalx - intx) * lx + (goaly - inty) * ly;
                    i = 0;
                    if (Math.abs(templong1) >> 11 < templong2) {
                        i = Pragmas.divscale(templong1, templong2, 20);
                    }
                    goalx = Pragmas.mulscale(lx, i, 20) + intx;
                    goaly = Pragmas.mulscale(ly, i, 20) + inty;
                }
                templong1 = Pragmas.dmulscale(lx, oxvect, ly, oyvect, 6);
                for (i = cnt + 1; i <= this.traceNum; ++i) {
                    ClipLine cl = this.clipLines.get(this.hitwalls[i]);
                    templong2 = Pragmas.dmulscale(cl.x2 - cl.x1, oxvect, cl.y2 - cl.y1, oyvect, 6);
                    if ((templong1 ^ templong2) >= 0) continue;
                    if (this.needUpdateSector) {
                        sectnum = service.updatesector(x, y, sectnum);
                    }
                    this.info.set(x, y, z, sectnum);
                    return retval;
                }
                this.rx.set(goalx);
                this.ry.set(goaly);
                this.keepaway(this.rx, this.ry, clipit);
                goalx = this.rx.get();
                goaly = this.ry.get();
                xvect = (long)(goalx - intx) << 14;
                yvect = (long)(goaly - inty) << 14;
                if (cnt == this.traceNum) {
                    retval = clipit.objectIndex;
                }
                this.hitwalls[cnt] = hitwall;
            }
            x = intx;
            y = inty;
        } while ((xvect | yvect) != 0L && hitwall != -1 && --cnt > 0);
        for (int dacnt = 0; dacnt < this.sectorSet.size(); ++dacnt) {
            int sect = this.sectorSet.getValue(dacnt);
            if (!service.inside(x, y, service.getSector(sect))) continue;
            this.info.set(x, y, z, sect);
            return retval;
        }
        int clipmove_sectnum = -1;
        int templong1 = Integer.MAX_VALUE;
        for (int j = service.getSectorCount() - 1; j >= 0; --j) {
            Sector sec = service.getSector(j);
            if (sec == null || !service.inside(x, y, sec)) continue;
            int templong2 = (sec.isCeilingSlope() ? service.getceilzofslope(sec, x, y) : sec.getCeilingz()) - z;
            if (templong2 <= 0 && (templong2 = z - (sec.isFloorSlope() ? service.getflorzofslope(sec, x, y) : sec.getFloorz())) <= 0) {
                this.info.set(x, y, z, j);
                return retval;
            }
            if (templong2 >= templong1) continue;
            clipmove_sectnum = j;
            templong1 = templong2;
        }
        this.info.set(x, y, z, clipmove_sectnum);
        return retval;
    }

    protected void addclipline(int dax1, int day1, int dax2, int day2, int daoval) {
        if (this.clipNum >= this.clipLines.size()) {
            this.clipLines.add(new ClipLine());
        }
        ClipLine clipit = this.clipLines.get(this.clipNum);
        clipit.x1 = dax1;
        clipit.y1 = day1;
        clipit.x2 = dax2;
        clipit.y2 = day2;
        clipit.objectIndex = daoval;
        ++this.clipNum;
    }

    protected int raytrace(int x3, int y3, Variable rayX, Variable rayY) {
        int hitwall = -1;
        for (int z = this.clipNum - 1; z >= 0; --z) {
            int nintx;
            int ninty;
            int bot;
            int y43;
            int x43;
            ClipLine clipit = this.clipLines.get(z);
            int x2 = clipit.x2;
            int x1 = clipit.x1;
            int x21 = x2 - x1;
            int y1 = clipit.y1;
            int y2 = clipit.y2;
            int y21 = y2 - y1;
            int topu = x21 * (y3 - y1) - (x3 - x1) * y21;
            if (topu <= 0 || x21 * (rayY.get() - y1) > (rayX.get() - x1) * y21 || (x43 = rayX.get() - x3) * (y1 - y3) > (x1 - x3) * (y43 = rayY.get() - y3) || x43 * (y2 - y3) <= (x2 - x3) * y43 || (bot = x43 * y21 - x21 * y43) == 0) continue;
            int cnt = 256;
            do {
                if (--cnt < 0) {
                    rayX.set(x3);
                    rayY.set(y3);
                    return z;
                }
                nintx = x3 + Pragmas.scale(x43, topu, bot);
                ninty = y3 + Pragmas.scale(y43, topu, bot);
                --topu;
            } while (x21 * (ninty - y1) <= (nintx - x1) * y21);
            if (Math.abs(x3 - nintx) + Math.abs(y3 - ninty) >= Math.abs(x3 - rayX.get()) + Math.abs(y3 - rayY.get())) continue;
            rayX.set(nintx);
            rayY.set(ninty);
            hitwall = z;
        }
        return hitwall;
    }

    protected void keepaway(Variable x, Variable y, ClipLine clipit) {
        boolean first;
        int px = x.get();
        int py = y.get();
        int x1 = clipit.x1;
        int dx = clipit.x2 - x1;
        int y1 = clipit.y1;
        int dy = clipit.y2 - y1;
        int ox = Integer.compare(-dy, 0);
        int oy = Integer.compare(dx, 0);
        boolean bl = first = Math.abs(dx) <= Math.abs(dy);
        while (true) {
            if (dx * (py - y1) > (px - x1) * dy) {
                x.set(px);
                y.set(py);
                return;
            }
            if (!first) {
                px += ox;
            } else {
                py += oy;
            }
            first ^= true;
        }
    }

    public ClipInfo getInfo() {
        return this.info;
    }

    protected static class ClipLine {
        int x1;
        int y1;
        int x2;
        int y2;
        int objectIndex;

        protected ClipLine() {
        }
    }
}

