/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.RangeZInfo;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.IntSet;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class GetZRange {
    protected static final int MAXCLIPDIST = 1024;
    private final Engine engine;
    private final RangeZInfo info;
    private final IntSet sectorSet;

    public GetZRange(Engine engine) {
        this.engine = engine;
        this.info = new RangeZInfo();
        this.sectorSet = new IntSet(Engine.MAXSECTORS);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RangeZInfo invoke(int x, int y, int z, int sectnum, int walldist, int cliptype) {
        BoardService service = this.engine.getBoardService();
        this.info.init();
        if (!service.isValidSector(sectnum)) {
            return this.info;
        }
        int i = walldist + 1024 + 1;
        int xmin = x - i;
        int ymin = y - i;
        int xmax = x + i;
        int ymax = y + i;
        service.getzsofslope(service.getSector(sectnum), x, y, service.floorz, service.ceilingz);
        this.info.setCeilhit(sectnum | 0x40000000);
        this.info.setFlorhit(sectnum | 0x40000000);
        this.info.setCeilz(service.ceilingz.get());
        this.info.setFlorz(service.floorz.get());
        int dawalclipmask = cliptype & 0xFFFF;
        int dasprclipmask = cliptype >> 16;
        this.sectorSet.clear();
        this.sectorSet.addValue(sectnum);
        int dacnt = 0;
        while (true) {
            block20: {
                if (dacnt >= this.sectorSet.size()) break;
                int dasector = this.sectorSet.getValue(dacnt);
                Sector s = service.getSector(dasector);
                if (s == null) break block20;
                for (ListNode<Wall> wn = s.getWallNode(); wn != null; wn = wn.getNext()) {
                    Sector sec;
                    int day;
                    int dy;
                    int dx;
                    Wall wal = wn.get();
                    short k = wal.getNextsector();
                    if (k < 0) continue;
                    Wall wal2 = service.getNextWall(wal);
                    int x1 = wal.getX();
                    int x2 = wal2.getX();
                    if (x1 < xmin && x2 < xmin || x1 > xmax && x2 > xmax) continue;
                    int y1 = wal.getY();
                    int y2 = wal2.getY();
                    if (y1 < ymin && y2 < ymin || y1 > ymax && y2 > ymax || (dx = x2 - x1) * (y - y1) < (x - x1) * (dy = y2 - y1)) continue;
                    int dax = dx > 0 ? dx * (ymin - y1) : dx * (ymax - y1);
                    int n = day = dy > 0 ? dy * (xmax - x1) : dy * (xmin - x1);
                    if (dax >= day || (wal.getCstat() & dawalclipmask) != 0 || (sec = service.getSector(k)) == null || !sec.isParallaxCeiling() && z <= sec.getCeilingz() + 768 || !sec.isParallaxFloor() && z >= sec.getFloorz() - 768) continue;
                    this.sectorSet.addValue(k);
                    if (x1 < xmin + 1024 && x2 < xmin + 1024 || x1 > xmax - 1024 && x2 > xmax - 1024 || y1 < ymin + 1024 && y2 < ymin + 1024 || y1 > ymax - 1024 && y2 > ymax - 1024) continue;
                    dax = dx > 0 ? (dax += dx * 1024) : (dax -= dx * 1024);
                    day = dy > 0 ? (day -= dy * 1024) : (day += dy * 1024);
                    if (dax >= day) continue;
                    service.getzsofslope(sec, x, y, service.floorz, service.ceilingz);
                    if (service.ceilingz.get() > this.info.getCeilz()) {
                        this.info.setCeilz(service.ceilingz.get());
                        this.info.setCeilhit(k | 0x40000000);
                    }
                    if (service.floorz.get() >= this.info.getFlorz()) continue;
                    this.info.setFlorz(service.floorz.get());
                    this.info.setFlorhit(k | 0x40000000);
                }
            }
            ++dacnt;
        }
        i = 0;
        while (i < this.sectorSet.size()) {
            block8: for (ListNode<Sprite> node = service.getSectNode(this.sectorSet.getValue(i)); node != null; node = node.getNext()) {
                int j = node.getIndex();
                Sprite spr = node.get();
                short cstat = spr.getCstat();
                if ((cstat & dasprclipmask) == 0) continue;
                ArtEntry pic = this.engine.getTile(spr.getPicnum());
                int x1 = spr.getX();
                int y1 = spr.getY();
                int clipyou = 0;
                int fz = 0;
                int cz = 0;
                switch (cstat & 0x30) {
                    case 0: {
                        int k = walldist + (spr.getClipdist() << 2) + 1;
                        if (Pragmas.klabs(x1 - x) > k || Pragmas.klabs(y1 - y) > k) break;
                        cz = spr.getZ();
                        k = pic.getHeight() * spr.getYrepeat() << 1;
                        if ((cstat & 0x80) != 0) {
                            cz += k;
                        }
                        if (pic.hasYOffset()) {
                            cz -= pic.getOffsetY() * spr.getYrepeat() << 2;
                        }
                        fz = cz - (k << 1);
                        clipyou = 1;
                        break;
                    }
                    case 16: {
                        int y2;
                        byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                        if ((cstat & 4) > 0) {
                            xoff = -xoff;
                        }
                        int dax = EngineUtils.cos(spr.getAng() - 512) * spr.getXrepeat();
                        int day = EngineUtils.sin(spr.getAng() - 512) * spr.getXrepeat();
                        int picWidth = pic.getWidth();
                        int k = (picWidth >> 1) + xoff;
                        int x2 = (x1 -= Pragmas.mulscale(dax, k, 16)) + Pragmas.mulscale(dax, picWidth, 16);
                        if (this.engine.clipInsideBoxLine(x, y, x1, y1 -= Pragmas.mulscale(day, k, 16), x2, y2 = y1 + Pragmas.mulscale(day, picWidth, 16), walldist + 1) == 0) break;
                        cz = spr.getZ();
                        k = pic.getHeight() * spr.getYrepeat() << 1;
                        if ((cstat & 0x80) != 0) {
                            cz += k;
                        }
                        if (pic.hasYOffset()) {
                            cz -= pic.getOffsetY() * spr.getYrepeat() << 2;
                        }
                        fz = cz - (k << 1);
                        clipyou = 1;
                        break;
                    }
                    case 32: {
                        fz = cz = spr.getZ();
                        if ((cstat & 0x40) != 0 && z > cz == ((cstat & 8) == 0)) continue block8;
                        byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                        byte yoff = (byte)(pic.getOffsetY() + spr.getYoffset());
                        if ((cstat & 4) > 0) {
                            xoff = -xoff;
                        }
                        if ((cstat & 8) > 0) {
                            yoff = -yoff;
                        }
                        short ang = spr.getAng();
                        int cosang = EngineUtils.cos(ang);
                        int sinang = EngineUtils.sin(ang);
                        int xspan = pic.getWidth();
                        short xrepeat = spr.getXrepeat();
                        int yspan = pic.getHeight();
                        short yrepeat = spr.getYrepeat();
                        int dax = ((xspan >> 1) + xoff) * xrepeat;
                        int day = ((yspan >> 1) + yoff) * yrepeat;
                        int l = xspan * xrepeat;
                        int x2 = (x1 += Pragmas.dmulscale(sinang, dax, cosang, day, 16) - x) - Pragmas.mulscale(sinang, l, 16);
                        int y2 = (y1 += Pragmas.dmulscale(sinang, day, -cosang, dax, 16) - y) + Pragmas.mulscale(cosang, l, 16);
                        l = yspan * yrepeat;
                        int k = -Pragmas.mulscale(cosang, l, 16);
                        int x3 = x2 + k;
                        int x4 = x1 + k;
                        k = -Pragmas.mulscale(sinang, l, 16);
                        int y3 = y2 + k;
                        int y4 = y1 + k;
                        dax = Pragmas.mulscale(EngineUtils.cos(spr.getAng() - 256), walldist + 4, 14);
                        day = Pragmas.mulscale(EngineUtils.sin(spr.getAng() - 256), walldist + 4, 14);
                        clipyou = GetZRange.calcClipYou(x1 += dax, y1 += day, x2 -= day, y2 += dax, clipyou);
                        clipyou = GetZRange.calcClipYou(x2, y2, x3 -= dax, y3 -= day, clipyou);
                        clipyou = GetZRange.calcClipYou(x3, y3, x4 += day, y4 -= dax, clipyou);
                        clipyou = GetZRange.calcClipYou(x4, y4, x1, y1, clipyou);
                    }
                }
                if (clipyou == 0) continue;
                if (z > cz && cz > this.info.getCeilz()) {
                    this.info.setCeilz(cz);
                    this.info.setCeilhit(j | 0xC0000000);
                }
                if (z >= fz || fz >= this.info.getFlorz()) continue;
                this.info.setFlorz(fz);
                this.info.setFlorhit(j | 0xC0000000);
            }
            ++i;
        }
        return this.info;
    }

    static int calcClipYou(int x1, int y1, int x2, int y2, int clipyou) {
        if ((y1 ^ y2) < 0) {
            if ((x1 ^ x2) < 0) {
                clipyou ^= (x1 * y2 < x2 * y1 ? 1 : 0) ^ (y1 < y2 ? 1 : 0);
            } else if (x1 >= 0) {
                clipyou ^= 1;
            }
        }
        return clipyou;
    }
}

