/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.GetZRange;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.HitInfo;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Variable;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.IntSet;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class HitScanner {
    private final IntSet sectorSet;
    private final Engine engine;
    private final HitInfo info;
    private final Variable rx = new Variable();
    private final Variable ry = new Variable();
    private final Variable rz = new Variable();
    private int goalx = 0x1FFFFFFF;
    private int goaly = 0x1FFFFFFF;

    public HitScanner(Engine engine) {
        this.engine = engine;
        this.info = new HitInfo();
        this.sectorSet = new IntSet(Engine.MAXSECTORS);
    }

    public void setGoal(int x, int y) {
        this.goalx = x;
        this.goaly = y;
    }

    public boolean run(int xs, int ys, int zs, int sectnum, int vx, int vy, int vz, int cliptype) {
        BoardService service = this.engine.getBoardService();
        this.info.init();
        if (!service.isValidSector(sectnum)) {
            return false;
        }
        this.info.setX(this.goalx);
        this.info.setY(this.goaly);
        this.sectorSet.clear();
        int dawalclipmask = cliptype & 0xFFFF;
        int dasprclipmask = cliptype >> 16;
        int y1 = 0;
        int z1 = 0;
        this.sectorSet.addValue(sectnum);
        for (int dacnt = 0; dacnt < this.sectorSet.size(); ++dacnt) {
            ListNode<Object> node;
            int i;
            int j;
            int day;
            int dax;
            int i2;
            Wall wal2;
            Wall wal;
            ListNode<Wall> wn;
            int dasector = this.sectorSet.getValue(dacnt);
            Sector sec = service.getSector(dasector);
            if (sec == null || (wn = sec.getWallNode()) == null) continue;
            int x1 = Integer.MAX_VALUE;
            if (sec.isCeilingSlope()) {
                wal = wn.get();
                wal2 = service.getNextWall(wal);
                if (wal2 == null || (i2 = EngineUtils.sqrt((dax = wal2.getX() - wal.getX()) * dax + (day = wal2.getY() - wal.getY()) * day)) == 0) continue;
                i2 = Pragmas.divscale(sec.getCeilingheinum(), i2, 15);
                j = (vz << 8) - Pragmas.dmulscale(dax *= i2, vy, -(day *= i2), vx, 15);
                if (j != 0 && ((i2 = (sec.getCeilingz() - zs << 8) + Pragmas.dmulscale(dax, ys - wal.getY(), -day, xs - wal.getX(), 15)) ^ j) >= 0 && Math.abs(i2) >> 1 < Math.abs(j)) {
                    i2 = Pragmas.divscale(i2, j, 30);
                    x1 = xs + Pragmas.mulscale(vx, i2, 30);
                    y1 = ys + Pragmas.mulscale(vy, i2, 30);
                    z1 = zs + Pragmas.mulscale(vz, i2, 30);
                }
            } else if (vz < 0 && zs >= sec.getCeilingz() && Math.abs(i = (z1 = sec.getCeilingz()) - zs) >> 1 < -vz) {
                i = Pragmas.divscale(i, vz, 30);
                x1 = xs + Pragmas.mulscale(vx, i, 30);
                y1 = ys + Pragmas.mulscale(vy, i, 30);
            }
            if (x1 != Integer.MAX_VALUE && Math.abs(x1 - xs) + Math.abs(y1 - ys) < Math.abs(this.info.getX() - xs) + Math.abs(this.info.getY() - ys) && service.inside(x1, y1, sec)) {
                this.info.set(x1, y1, z1, dasector, -1, -1);
            }
            x1 = Integer.MAX_VALUE;
            if (sec.isFloorSlope()) {
                wal = wn.get();
                wal2 = service.getNextWall(wal);
                if (wal2 == null || (i2 = EngineUtils.sqrt((dax = wal2.getX() - wal.getX()) * dax + (day = wal2.getY() - wal.getY()) * day)) == 0) continue;
                i2 = Pragmas.divscale(sec.getFloorheinum(), i2, 15);
                j = (vz << 8) - Pragmas.dmulscale(dax *= i2, vy, -(day *= i2), vx, 15);
                if (j != 0 && ((i2 = (sec.getFloorz() - zs << 8) + Pragmas.dmulscale(dax, ys - wal.getY(), -day, xs - wal.getX(), 15)) ^ j) >= 0 && Math.abs(i2) >> 1 < Math.abs(j)) {
                    i2 = Pragmas.divscale(i2, j, 30);
                    x1 = xs + Pragmas.mulscale(vx, i2, 30);
                    y1 = ys + Pragmas.mulscale(vy, i2, 30);
                    z1 = zs + Pragmas.mulscale(vz, i2, 30);
                }
            } else if (vz > 0 && zs <= sec.getFloorz() && Math.abs(i = (z1 = sec.getFloorz()) - zs) >> 1 < vz) {
                i = Pragmas.divscale(i, vz, 30);
                x1 = xs + Pragmas.mulscale(vx, i, 30);
                y1 = ys + Pragmas.mulscale(vy, i, 30);
            }
            if (x1 != Integer.MAX_VALUE && Math.abs(x1 - xs) + Math.abs(y1 - ys) < Math.abs(this.info.getX() - xs) + Math.abs(this.info.getY() - ys) && service.inside(x1, y1, sec)) {
                this.info.set(x1, y1, z1, dasector, -1, -1);
            }
            for (node = sec.getWallNode(); node != null; node = node.getNext()) {
                Wall wal3 = node.get();
                Wall wal22 = service.getNextWall(wal3);
                if (wal22 == null) continue;
                x1 = wal3.getX();
                y1 = wal3.getY();
                int x2 = wal22.getX();
                int y2 = wal22.getY();
                if ((x1 - xs) * (y2 - ys) < (x2 - xs) * (y1 - ys) || this.engine.notIntersect(xs, ys, zs, vx, vy, vz, x1, y1, x2, y2, this.rx, this.ry, this.rz)) continue;
                int intx = this.rx.get();
                int inty = this.ry.get();
                int intz = this.rz.get();
                if (Math.abs(intx - xs) + Math.abs(inty - ys) >= Math.abs(this.info.getX() - xs) + Math.abs(this.info.getY() - ys)) continue;
                int z = node.getIndex();
                short nextsector = wal3.getNextsector();
                if (nextsector < 0 || (wal3.getCstat() & dawalclipmask) != 0) {
                    this.info.set(intx, inty, intz, dasector, z, -1);
                    continue;
                }
                service.getzsofslope(service.getSector(nextsector), intx, inty, service.floorz, service.ceilingz);
                if (intz <= service.ceilingz.get() || intz >= service.floorz.get()) {
                    this.info.set(intx, inty, intz, dasector, z, -1);
                    continue;
                }
                this.sectorSet.addValue(nextsector);
            }
            block7: for (node = service.getSectNode(dasector); node != null; node = node.getNext()) {
                int z = node.getIndex();
                Sprite spr = (Sprite)node.get();
                if ((spr.getCstat() & dasprclipmask) == 0) continue;
                x1 = spr.getX();
                y1 = spr.getY();
                z1 = spr.getZ();
                ArtEntry pic = this.engine.getTile(spr.getPicnum());
                switch (spr.getCstat() & 0x30) {
                    case 0: {
                        int bot;
                        int topt = vx * (x1 - xs) + vy * (y1 - ys);
                        if (topt <= 0 || (bot = vx * vx + vy * vy) == 0) continue block7;
                        int intz = zs + Pragmas.scale(vz, topt, bot);
                        int i3 = pic.getHeight() * spr.getYrepeat() << 2;
                        if ((spr.getCstat() & 0x80) != 0) {
                            z1 += i3 >> 1;
                        }
                        if (pic.hasYOffset()) {
                            z1 -= pic.getOffsetY() * spr.getYrepeat() << 2;
                        }
                        if (intz > z1 || intz < z1 - i3) continue block7;
                        int topu = vx * (y1 - ys) - vy * (x1 - xs);
                        int offx = Pragmas.scale(vx, topu, bot);
                        int offy = Pragmas.scale(vy, topu, bot);
                        int dist = offx * offx + offy * offy;
                        i3 = pic.getWidth() * spr.getXrepeat();
                        if (dist > (i3 *= i3) >> 7) continue block7;
                        int intx = xs + Pragmas.scale(vx, topt, bot);
                        int inty = ys + Pragmas.scale(vy, topt, bot);
                        if (Math.abs(intx - xs) + Math.abs(inty - ys) > Math.abs(this.info.getX() - xs) + Math.abs(this.info.getY() - ys)) continue block7;
                        this.info.set(intx, inty, intz, dasector, -1, z);
                        continue block7;
                    }
                    case 16: {
                        byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                        if ((spr.getCstat() & 4) > 0) {
                            xoff = -xoff;
                        }
                        int k = spr.getAng();
                        int l = spr.getXrepeat();
                        int dax2 = EngineUtils.sin(k) * l;
                        int day2 = EngineUtils.cos(k + 1024) * l;
                        l = pic.getWidth();
                        k = (l >> 1) + xoff;
                        int x2 = (x1 -= Pragmas.mulscale(dax2, k, 16)) + Pragmas.mulscale(dax2, l, 16);
                        int y2 = (y1 -= Pragmas.mulscale(day2, k, 16)) + Pragmas.mulscale(day2, l, 16);
                        if ((spr.getCstat() & 0x40) != 0 && (x1 - xs) * (y2 - ys) < (x2 - xs) * (y1 - ys) || this.engine.notIntersect(xs, ys, zs, vx, vy, vz, x1, y1, x2, y2, this.rx, this.ry, this.rz)) continue block7;
                        int intx = this.rx.get();
                        int inty = this.ry.get();
                        int intz = this.rz.get();
                        if (Math.abs(intx - xs) + Math.abs(inty - ys) > Math.abs(this.info.getX() - xs) + Math.abs(this.info.getY() - ys)) continue block7;
                        int cz = spr.getZ();
                        k = pic.getHeight() * spr.getYrepeat() << 2;
                        if ((spr.getCstat() & 0x80) != 0) {
                            cz = spr.getZ() + (k >> 1);
                        }
                        if (pic.hasYOffset()) {
                            cz -= pic.getOffsetY() * spr.getYrepeat() << 2;
                        }
                        if (intz >= cz || intz <= cz - k) continue block7;
                        this.info.set(intx, inty, intz, dasector, -1, z);
                        continue block7;
                    }
                    case 32: {
                        int intz;
                        if (vz == 0 || ((intz = z1) - zs ^ vz) < 0 || (spr.getCstat() & 0x40) != 0 && zs > intz == ((spr.getCstat() & 8) == 0)) continue block7;
                        int intx = xs + Pragmas.scale(intz - zs, vx, vz);
                        int inty = ys + Pragmas.scale(intz - zs, vy, vz);
                        if (Math.abs(intx - xs) + Math.abs(inty - ys) > Math.abs(this.info.getX() - xs) + Math.abs(this.info.getY() - ys)) continue block7;
                        byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                        byte yoff = (byte)(pic.getOffsetY() + spr.getYoffset());
                        if ((spr.getCstat() & 4) > 0) {
                            xoff = -xoff;
                        }
                        if ((spr.getCstat() & 8) > 0) {
                            yoff = -yoff;
                        }
                        int cosang = EngineUtils.cos(spr.getAng());
                        int sinang = EngineUtils.sin(spr.getAng());
                        int xspan = pic.getWidth();
                        int yspan = pic.getHeight();
                        int dax3 = ((xspan >> 1) + xoff) * spr.getXrepeat();
                        int day3 = ((yspan >> 1) + yoff) * spr.getYrepeat();
                        int l = xspan * spr.getXrepeat();
                        int x2 = (x1 += Pragmas.dmulscale(sinang, dax3, cosang, day3, 16) - intx) - Pragmas.mulscale(sinang, l, 16);
                        int y2 = (y1 += Pragmas.dmulscale(sinang, day3, -cosang, dax3, 16) - inty) + Pragmas.mulscale(cosang, l, 16);
                        l = yspan * spr.getYrepeat();
                        int k = -Pragmas.mulscale(cosang, l, 16);
                        int x3 = x2 + k;
                        int x4 = x1 + k;
                        k = -Pragmas.mulscale(sinang, l, 16);
                        int y3 = y2 + k;
                        int y4 = y1 + k;
                        int clipyou = this.getClip(x2, y2, x1, y1, 0);
                        clipyou = this.getClip(x3, y3, x2, y2, clipyou);
                        clipyou = this.getClip(x4, y4, x3, y3, clipyou);
                        if ((clipyou = this.getClip(x1, y1, x4, y4, clipyou)) == 0) continue block7;
                        this.info.set(intx, inty, intz, dasector, -1, z);
                    }
                }
            }
        }
        return true;
    }

    private int getClip(int x1, int y1, int x2, int y2, int clipyou) {
        clipyou = GetZRange.calcClipYou(x2, y2, x1, y1, clipyou);
        return clipyou;
    }

    public HitInfo getInfo() {
        return this.info;
    }
}

