/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.NearInfo;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Variable;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.BitMap;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class NearScanner {
    private final List<Integer> sectorList = new ArrayList<Integer>();
    private final BitMap sectBitMap = new BitMap();
    private final Engine engine;
    private final NearInfo info;
    private final Variable rx = new Variable();
    private final Variable ry = new Variable();
    private final Variable rz = new Variable();

    public NearScanner(Engine engine) {
        this.engine = engine;
        this.info = new NearInfo();
    }

    public NearInfo getInfo() {
        return this.info;
    }

    public int scan(int xs, int ys, int zs, int sectnum, int ange, int neartagrange, int tagsearch) {
        BoardService service = this.engine.getBoardService();
        this.info.init(-1, -1, -1, 0);
        if (!service.isValidSector(sectnum) || (tagsearch & 3) == 0) {
            return 0;
        }
        this.sectorList.clear();
        this.sectBitMap.clear();
        int cosang = EngineUtils.cos(ange + 2048);
        int sinang = EngineUtils.sin(ange + 2048);
        int vx = Pragmas.mulscale(cosang, neartagrange, 14);
        int vy = Pragmas.mulscale(sinang, neartagrange, 14);
        boolean vz = false;
        int xe = xs + vx;
        int ye = ys + vy;
        int ze = 0;
        this.sectBitMap.setBit(sectnum);
        this.sectorList.add(sectnum);
        for (int dacnt = 0; dacnt < this.sectorList.size(); ++dacnt) {
            int dasector = this.sectorList.get(dacnt);
            Sector sec = service.getSector(dasector);
            if (sec == null) continue;
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall wal = wn.get();
                Wall wal2 = service.getNextWall(wal);
                if (wal2 == null) continue;
                int x1 = wal.getX();
                int y1 = wal.getY();
                int x2 = wal2.getX();
                int y2 = wal2.getY();
                short nextsector = wal.getNextsector();
                int good = 0;
                Sector sec2 = service.getSector(nextsector);
                if (sec2 != null) {
                    if ((tagsearch & 1) != 0 && sec2.getLotag() != 0) {
                        good |= 1;
                    }
                    if ((tagsearch & 2) != 0 && sec2.getHitag() != 0) {
                        good |= 1;
                    }
                }
                if ((tagsearch & 1) != 0 && wal.getLotag() != 0) {
                    good |= 2;
                }
                if ((tagsearch & 2) != 0 && wal.getHitag() != 0) {
                    good |= 2;
                }
                if (good == 0 && nextsector < 0 || (x1 - xs) * (y2 - ys) < (x2 - xs) * (y1 - ys) || !this.engine.lIntersect(xs, ys, zs, xe, ye, ze, x1, y1, x2, y2, this.rx, this.ry, this.rz)) continue;
                if (good != 0) {
                    if ((good & 1) != 0) {
                        this.info.setSector(nextsector);
                    }
                    if ((good & 2) != 0) {
                        this.info.setWall(wn.getIndex());
                    }
                    this.info.setDistance(Pragmas.dmulscale(this.rx.get() - xs, cosang, this.ry.get() - ys, sinang, 14));
                    xe = this.rx.get();
                    ye = this.ry.get();
                    ze = this.rz.get();
                }
                if (nextsector < 0 || this.sectBitMap.getBit(nextsector)) continue;
                this.sectBitMap.setBit(nextsector);
                this.sectorList.add(Integer.valueOf(nextsector));
            }
            for (ListNode<Sprite> node = service.getSectNode(dasector); node != null; node = node.getNext()) {
                int bot;
                int z = node.getIndex();
                Sprite spr = node.get();
                boolean good = false;
                if ((tagsearch & 1) != 0 && spr.getLotag() != 0) {
                    good |= true;
                }
                if ((tagsearch & 2) != 0 && spr.getHitag() != 0) {
                    good |= true;
                }
                if (!good) continue;
                int x1 = spr.getX();
                int y1 = spr.getY();
                int z1 = spr.getZ();
                int topt = vx * (x1 - xs) + vy * (y1 - ys);
                if (topt <= 0 || (bot = vx * vx + vy * vy) == 0) continue;
                int intz = zs + Pragmas.scale(0L, topt, bot);
                ArtEntry pic = this.engine.getTile(spr.getPicnum());
                int i = pic.getHeight() * spr.getYrepeat();
                if ((spr.getCstat() & 0x80) != 0) {
                    z1 += i << 1;
                }
                if (pic.hasYOffset()) {
                    z1 -= pic.getOffsetY() * spr.getYrepeat() << 2;
                }
                if (intz > z1 || intz < z1 - (i << 2)) continue;
                int topu = vx * (y1 - ys) - vy * (x1 - xs);
                int offx = Pragmas.scale(vx, topu, bot);
                int offy = Pragmas.scale(vy, topu, bot);
                int dist = offx * offx + offy * offy;
                i = pic.getWidth() * spr.getXrepeat();
                if (dist > (i *= i) >> 7) continue;
                int intx = xs + Pragmas.scale(vx, topt, bot);
                int inty = ys + Pragmas.scale(vy, topt, bot);
                if (Math.abs(intx - xs) + Math.abs(inty - ys) >= Math.abs(xe - xs) + Math.abs(ye - ys)) continue;
                this.info.setSprite(z);
                this.info.setDistance(Pragmas.dmulscale(intx - xs, cosang, inty - ys, sinang, 14));
                xe = intx;
                ye = inty;
                ze = intz;
            }
        }
        return 0;
    }
}

