/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Architecture.DialogUtil;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.CommonMenus.MenuVideoMode;
import ru.m210projects.Build.Pattern.Date;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.LogSender;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Pattern.ScreenAdapters.DummyScreen;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pattern.ScreenAdapters.InitScreen;
import ru.m210projects.Build.Pattern.ScreenAdapters.MessageScreen;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Render.DummyRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.exceptions.RendererException;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.Cache;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.fs.AbsoluteFileEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.ConsoleLogger;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;

public abstract class BuildGame
extends Game
implements Thread.UncaughtExceptionHandler {
    public final String appName;
    public final String appVersion;
    public final boolean release;
    public final String OS = System.getProperty("os.name");
    public final Date date;
    public Engine pEngine;
    public GameConfig pCfg;
    public MenuHandler pMenu;
    public FontHandler pFonts;
    public BuildNet pNet;
    public Interpolation pInt;
    public SaveManager pSavemgr;
    public SliderDrawable pSlider;
    public boolean gExit = false;
    public boolean gPaused = false;
    public DefScript baseDef;
    public DefScript currentDef;
    public NetMode nNetMode;
    public Cache cache;
    protected GameProcessor controller;
    protected boolean active;
    @NotNull
    protected Renderer renderer;
    Screen gCurrScreen;
    Screen gPrevScreen;
    private Directory userDirectory;
    protected Map<String, String> args = new HashMap<String, String>();

    public BuildGame(GameConfig cfg, String appName, String appVersion, boolean release) throws IOException {
        this(new ArrayList<String>(), cfg, appName, appVersion, release);
    }

    public BuildGame(List<String> args, GameConfig cfg, String appName, String appVersion, boolean release) throws IOException {
        this.appName = appName;
        this.appVersion = appVersion;
        this.release = release;
        this.pCfg = cfg;
        this.date = new Date("MMM dd, yyyy HH:mm:ss");
        this.controller = this.createGameProcessor();
        this.renderer = DummyRenderer.DUMMY_RENDERER;
        this.initCache(new Directory.Game(cfg.getGamePath()), new Directory(cfg.getCfgPath().getParent(), true));
        try {
            Path path = this.userDirectory.getPath().resolve(Strhandler.toLowerCase(appName + ".log"));
            Console.out.setLogger(new ConsoleLogger(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < args.size() - 1; i += 2) {
            this.args.put(args.get(i), args.get(i + 1));
        }
    }

    public String getTitle() {
        return this.appName + " " + this.appVersion;
    }

    @Override
    public final void create() {
        InitScreen scr = new InitScreen(this);
        super.setScreen(scr);
        scr.start();
    }

    protected abstract MessageScreen createMessage(String var1, String var2, MessageType var3);

    public MessageScreen showGameMessage(String header, String text, MessageType type) {
        if (Mmulti.numplayers > 1) {
            this.pNet.NetDisconnect(Mmulti.myconnectindex);
        }
        MessageScreen messageScreen = this.createMessage(header, text, type);
        this.changeScreen(messageScreen);
        return messageScreen;
    }

    @NotNull
    public Renderer getRenderer() {
        if (this.renderer instanceof DummyRenderer) {
            throw new RuntimeException("Dummy renderer!");
        }
        Renderer renderer = this.renderer;
        if (renderer == null) {
            BuildGame.$$$reportNull$$$0(0);
        }
        return renderer;
    }

    public void setRenderer(Renderer renderer) {
        if (this.renderer.isInited()) {
            this.renderer.uninit();
        }
        this.renderer = renderer;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public GameProcessor getProcessor() {
        return this.controller;
    }

    public abstract GameProcessor createGameProcessor();

    public Cache createFileCache(Directory gameDirectory) {
        return new Cache(gameDirectory);
    }

    public void initCache(Directory gameDirectory, Directory userDirectory) {
        this.userDirectory = userDirectory;
        this.cache = this.createFileCache(gameDirectory);
    }

    public Directory getUserDirectory() {
        return this.userDirectory;
    }

    public Cache getCache() {
        return this.cache;
    }

    public abstract BuildFactory getFactory();

    public abstract boolean init() throws Exception;

    public abstract void show();

    public abstract DefaultPrecacheScreen getPrecacheScreen(Runnable var1, PrecacheListener var2);

    public abstract LogSender getLogSender();

    @Override
    public void dispose() {
        if (this.pCfg.getMidiDevice().isOpen()) {
            this.pCfg.getMidiDevice().close();
        }
        this.pCfg.getAudio().dispose();
        try (FileOutputStream os = new FileOutputStream(this.pCfg.getCfgPath().toFile());){
            this.pCfg.save(os);
        }
        catch (IOException e) {
            Console.out.println(e.toString());
        }
        Console.out.getLogger().close();
        if (this.getScreen() instanceof InitScreen) {
            this.getScreen().dispose();
        }
        if (Mmulti.numplayers > 1) {
            this.pNet.NetDisconnect(Mmulti.myconnectindex);
        }
        Gdx.app.postRunnable(() -> {
            try {
                this.setRenderer(DummyRenderer.DUMMY_RENDERER);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (this.pEngine != null) {
            this.pEngine.uninit();
        }
        System.out.println("disposed");
    }

    public Font getFont(int i) {
        return this.pFonts.getFont(i);
    }

    public void syncInput(BuildNet net) {
        if (Mmulti.numplayers > 1) {
            net.GetPackets();
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            if (i != Mmulti.myconnectindex && net.gNetFifoHead[Mmulti.myconnectindex] - 200 > net.gNetFifoHead[i]) {
                return;
            }
            i = Mmulti.connectpoint2[i];
        }
        this.controller.processInput(this.pNet.gInput);
        if ((net.gNetFifoHead[Mmulti.myconnectindex] & net.MovesPerPacket - 1) != 0) {
            net.gFifoInput[net.gNetFifoHead[Mmulti.myconnectindex] & 0xFF][Mmulti.myconnectindex].Copy(net.gFifoInput[net.gNetFifoHead[Mmulti.myconnectindex] - 1 & 0xFF][Mmulti.myconnectindex]);
            short s = Mmulti.myconnectindex;
            net.gNetFifoHead[s] = net.gNetFifoHead[s] + 1;
            return;
        }
        net.gFifoInput[net.gNetFifoHead[Mmulti.myconnectindex] & 0xFF][Mmulti.myconnectindex].Copy(net.gInput);
        short s = Mmulti.myconnectindex;
        net.gNetFifoHead[s] = net.gNetFifoHead[s] + 1;
        if (this.nNetMode == NetMode.Multiplayer && Mmulti.numplayers < 2) {
            i = Mmulti.connecthead;
            while (i >= 0) {
                if (i != Mmulti.myconnectindex) {
                    net.ComputerInput(i);
                    short s2 = i;
                    net.gNetFifoHead[s2] = net.gNetFifoHead[s2] + 1;
                }
                i = Mmulti.connectpoint2[i];
            }
            return;
        }
        net.GetNetworkInput();
    }

    @Override
    public void render() {
        try {
            if (!this.gExit) {
                super.render();
            } else {
                Gdx.app.exit();
            }
        }
        catch (AssertException | WarningException assertEx) {
            this.softExceptionScreen(assertEx);
        }
        catch (Throwable e) {
            if (!this.release) {
                e.printStackTrace();
                this.dispose();
                System.exit(1);
            }
            this.ThrowError(e.getClass().getSimpleName() + "[BuildGame]: " + (e.getMessage() == null ? "" : e.getMessage()), e.getStackTrace());
        }
    }

    public void changeScreen(Screen screen) {
        this.gPrevScreen = this.gCurrScreen;
        this.gCurrScreen = screen;
        super.setScreen(DummyScreen.DUMMY_SCREEN);
        Gdx.app.postRunnable(() -> super.setScreen(screen));
    }

    @Override
    public void setScreen(Screen screen) {
        throw new UnsupportedOperationException();
    }

    public boolean isCurrentScreen(Screen screen) {
        return this.gCurrScreen == screen;
    }

    public void setPrevScreen() {
        this.gCurrScreen = this.gPrevScreen;
        this.changeScreen(this.gPrevScreen);
    }

    public String getScrName() {
        if (this.gCurrScreen != null) {
            return this.gCurrScreen.getClass().getSimpleName();
        }
        if (Gdx.app != null) {
            return "Create frame";
        }
        return "Init frame";
    }

    public boolean setDefs(DefScript script) {
        if (this.currentDef != script) {
            if (this.currentDef != null) {
                this.currentDef.dispose();
            }
            this.currentDef = script;
            this.currentDef.apply();
            this.pEngine.setDefs(script);
            this.renderer.setDefs(this.currentDef);
            return true;
        }
        return false;
    }

    public String getStackTraceAsString(StackTraceElement[] getStackTrace, int depth) {
        StringBuilder sb = new StringBuilder();
        int depthCount = 0;
        for (StackTraceElement element : getStackTrace) {
            if (depth != -1 && depthCount >= depth) break;
            sb.append("\t").append(element.toString());
            sb.append("\r\n");
            ++depthCount;
        }
        return sb.toString();
    }

    public void ThrowError(String msg) {
        this.ThrowError(msg, Thread.currentThread().getStackTrace());
    }

    public void ThrowError(String msg, StackTraceElement[] stackTrace) {
        DialogUtil.DialogResult result;
        String stackTraceMessage = msg;
        stackTraceMessage = stackTraceMessage + "\r\nFull stack trace: ";
        stackTraceMessage = stackTraceMessage + this.getStackTraceAsString(stackTrace, -1);
        Console.out.println("FatalError: " + stackTraceMessage, OsdColor.RED);
        Console.out.getLogger().close();
        if (this.nNetMode == NetMode.Multiplayer) {
            this.pNet.NetDisconnect(Mmulti.myconnectindex);
        }
        if ((result = DialogUtil.showMessage("Error", msg, MessageType.Crash)).isApproved()) {
            this.getLogSender().send(result.getComment());
        }
        this.dispose();
        System.exit(0);
    }

    public void softExceptionScreen(Exception exception) {
        String title = exception.getMessage();
        if (title == null || title.isEmpty()) {
            title = title + exception.toString();
        }
        String stackTraceMessage = title;
        stackTraceMessage = stackTraceMessage + "\r\nFull stack trace: ";
        stackTraceMessage = stackTraceMessage + this.getStackTraceAsString(exception.getStackTrace(), -1);
        Console.out.println("Exception: " + stackTraceMessage, OsdColor.RED);
        String finalTitle = title;
        Gdx.app.postRunnable(() -> this.showGameMessage("Error!", finalTitle, MessageType.Crash).setMessageListener(approved -> {
            if (approved) {
                this.getLogSender().send("");
            }
            this.show();
        }));
    }

    public void GameMessage(String msg) {
        Console.out.println("Message: " + msg, OsdColor.YELLOW);
        Gdx.app.postRunnable(() -> this.showGameMessage("Message: ", msg, MessageType.Info).setMessageListener(approved -> {
            if (approved) {
                this.getLogSender().send("");
            }
            this.show();
        }));
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (e instanceof GdxRuntimeException && e.getCause() != null) {
            e = e.getCause();
        }
        String message = e.getMessage();
        String title = "UncaughtException[" + e.getClass().getSimpleName() + "]";
        if (message != null) {
            int maxSymbols = 128;
            StringBuilder wrappedMessage = new StringBuilder();
            int curLineWidth = 0;
            for (char c : message.toCharArray()) {
                if (curLineWidth >= maxSymbols) {
                    wrappedMessage.append("\r\n");
                    curLineWidth = 0;
                }
                wrappedMessage.append(c);
                ++curLineWidth;
            }
            title = title + ":\r\n" + wrappedMessage;
        }
        this.ThrowError(title, e.getStackTrace());
    }

    public void initRenderer() {
        Screen prevScreen;
        GameProcessor processor = this.getProcessor();
        processor.resetPollingStates();
        Gdx.input.setInputProcessor(processor);
        this.pCfg.setRawInput(this.pCfg.isRawInput());
        this.renderer.init(this.pEngine);
        this.pEngine.setbrightness(this.pEngine.getPaletteManager().getPaletteGamma(), this.pEngine.getPaletteManager().getBasePalette());
        if (!this.renderer.isInited()) {
            throw new RendererException("Renderer initialization failed");
        }
        Console.out.setFunc(this.getFactory().getOsdFunc());
        this.pCfg.setScreenMode(this.pCfg.getScreenWidth(), this.pCfg.getScreenHeight(), this.pCfg.isFullscreen());
        this.renderer.resize(this.pCfg.getScreenWidth(), this.pCfg.getScreenHeight());
        Console.out.revalidate();
        if (this.pMenu != null && this.pMenu.getCurrentMenu() instanceof MenuVideoMode) {
            ((MenuVideoMode)this.pMenu.getCurrentMenu()).onRenderChanged(this.renderer.getType());
        }
        if (this.renderer instanceof PrecacheListener && (prevScreen = this.getScreen()) instanceof GameAdapter) {
            this.doPrecache(() -> this.changeScreen(prevScreen));
        }
    }

    public void doPrecache(Runnable readyCallback) {
        PrecacheListener listener = PrecacheListener.DUMMY_PRECACHE_LISTENER;
        if (this.renderer instanceof PrecacheListener) {
            listener = (PrecacheListener)((Object)this.renderer);
        }
        this.changeScreen(this.getPrecacheScreen(readyCallback, listener));
    }

    public boolean isSoftwareRenderer() {
        return this.renderer.getType() == Renderer.RenderType.Software;
    }

    public void onFilesDropped(String[] files) {
        Directory gameDirectory = this.cache.getGameDirectory();
        for (String spath : files) {
            try {
                FileEntry entry;
                Path absolutePath = FileUtils.getPath(spath, new String[0]);
                Path gamePath = gameDirectory.getPath();
                if (absolutePath.startsWith(gamePath)) {
                    entry = gameDirectory.getEntry(gamePath.relativize(absolutePath));
                    if (!entry.exists()) continue;
                    this.onDropEntry(entry);
                    return;
                }
                entry = new AbsoluteFileEntry(absolutePath);
                if (entry.exists()) {
                    this.onDropEntry(entry);
                }
                return;
            }
            catch (Exception e) {
                Console.out.println("Can't handle the file " + spath, OsdColor.RED);
            }
        }
    }

    protected void parseArgumentsCommon() {
        if (!this.args.isEmpty()) {
            Console.out.println("Parsing arguments", OsdColor.YELLOW);
            String ip = this.args.getOrDefault("-ip", "");
            String port = this.args.getOrDefault("-port", "");
            String name = this.args.getOrDefault("-name", "");
            if (!name.isEmpty()) {
                Console.out.println("Setting name to " + name, OsdColor.YELLOW);
                this.pCfg.setpName(name);
            }
            if (!ip.isEmpty()) {
                Console.out.println("Setting ip to " + ip, OsdColor.YELLOW);
                this.pCfg.setmAddress(ip);
            }
            if (!port.isEmpty()) {
                Console.out.println("Setting port to " + port, OsdColor.YELLOW);
                try {
                    this.pCfg.setPort(Integer.parseInt(port));
                }
                catch (Exception i) {
                    Console.out.println("Setting port failed", OsdColor.RED);
                }
            }
        }
    }

    public void onDropEntry(FileEntry entry) {
    }

    @Override
    public void resize(int width, int height) {
        if (width == this.renderer.getWidth() && height == this.renderer.getHeight()) {
            return;
        }
        width = Math.max(1, width);
        height = Math.max(1, height);
        this.renderer.resize(width, height);
        Console.out.revalidate();
        if (this.pMenu != null && this.pMenu.getCurrentMenu() instanceof MenuVideoMode) {
            ((MenuVideoMode)this.pMenu.getCurrentMenu()).onResize(width, height);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Build/Pattern/BuildGame", "getRenderer"));
    }

    public static enum NetMode {
        Single,
        Multiplayer;

    }
}

