/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import java.util.List;
import java.util.stream.IntStream;
import ru.m210projects.Build.Architecture.common.audio.AudioResampler;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.MidiDevice;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.settings.GameConfig;

public abstract class MenuAudio
extends BuildMenu {
    public MenuButton mApplyChanges;
    public MenuConteiner sSoundDrv;
    public MenuConteiner sMusicDrv;
    public MenuConteiner sResampler;
    public MenuSlider sSound;
    public MenuSlider sVoices;
    public MenuSwitch sSoundSwitch;
    public MenuSlider sMusic;
    public MenuSwitch sMusicSwitch;
    public MenuConteiner sMusicType;
    public int snddriver;
    public int middriver;
    public AudioResampler resampler;
    public int osnddriver;
    public int omiddriver;
    public AudioResampler oresampler;
    public int voices;
    public int ovoices;
    public int cdaudio;
    public int ocdaudio;
    private AudioListener listener;

    public MenuAudio(final BuildGame app, int posx, int posy, int width, int menuHeight, int separatorHeight, Font menuItems) {
        super(app.pMenu);
        final GameConfig cfg = app.pCfg;
        this.addItem(this.getTitle(app, "Audio setup"), false);
        this.sSoundDrv = new MenuConteiner(this, "Sound driver", menuItems, posx, posy += menuHeight, width, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            this.snddriver = item.num;
        }){
            final /* synthetic */ MenuAudio this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, list, num, callback);
            }

            @Override
            public void open() {
                int audioIndex;
                String[] names = (String[])app.pCfg.getAudioDevices().stream().map(BuildAudio::getName).toArray(String[]::new);
                BuildAudio currentAudio = app.pCfg.getAudio();
                if (this.list == null) {
                    this.list = new char[names.length][];
                    for (int i = 0; i < this.list.length; ++i) {
                        this.list[i] = names[i].toCharArray();
                    }
                }
                this.this$0.snddriver = this.this$0.osnddriver = (audioIndex = IntStream.range(0, names.length).filter(e -> names[e].equalsIgnoreCase(currentAudio.getName())).boxed().findAny().orElse(0).intValue());
                this.num = this.this$0.osnddriver;
            }
        };
        this.sMusicDrv = new MenuConteiner(this, "Midi driver", menuItems, posx, posy += menuHeight, width, null, 0, (h, pItem) -> {
            this.middriver = ((MenuConteiner)pItem).num;
        }){
            final /* synthetic */ MenuAudio this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, list, num, callback);
            }

            @Override
            public void open() {
                int midiIndex;
                String[] names = (String[])app.pCfg.getMidiDevices().stream().map(MidiDevice::getName).toArray(String[]::new);
                MidiDevice currentDevice = app.pCfg.getMidiDevice();
                if (this.list == null) {
                    this.list = new char[names.length][];
                    for (int i = 0; i < this.list.length; ++i) {
                        this.list[i] = names[i].toCharArray();
                    }
                }
                this.this$0.middriver = this.this$0.omiddriver = (midiIndex = IntStream.range(0, names.length).filter(e -> names[e].equalsIgnoreCase(currentDevice.getName())).boxed().findAny().orElse(0).intValue());
                this.num = this.this$0.omiddriver;
            }
        };
        this.sResampler = new MenuConteiner(this, "Resampler", menuItems, posx, posy += menuHeight, width, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            List<AudioResampler> resamplers = cfg.getAudio().getResamplerList();
            if (resamplers.size() > item.num) {
                this.resampler = resamplers.get(item.num);
            }
        }){
            final /* synthetic */ MenuAudio this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, list, num, callback);
            }

            @Override
            public void open() {
                if (this.list == null) {
                    this.this$0.updateSoftResamplers(this, cfg);
                }
                List<AudioResampler> resamplers = cfg.getAudio().getResamplerList();
                this.this$0.resampler = this.this$0.oresampler = cfg.getResampler();
                this.num = Gameutils.listIndexOf(resamplers, i -> ((AudioResampler)resamplers.get(i)).equals(this.this$0.resampler));
            }
        };
        int oposy = posy += separatorHeight;
        posy += menuHeight;
        this.sSound = new MenuSlider(this, app.pSlider, "Sound volume", menuItems, posx, posy += menuHeight, width, (int)(cfg.getSoundVolume() * 256.0f), 0, 256, 16, (handler, pItem) -> {
            MenuSlider slider = (MenuSlider)pItem;
            cfg.setSoundVolume((float)slider.value / 256.0f);
            if (this.listener != null) {
                this.listener.SoundVolumeChange();
            }
        }, false){
            final /* synthetic */ MenuAudio this$0;
            {
                this.this$0 = this$0;
                super(slider, text, textStyle, x, y, width, value, min, max, step, callback, digital);
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!cfg.isNoSound());
                super.draw(handler);
            }
        };
        this.sVoices = new MenuSlider(this, app.pSlider, "Voices", menuItems, posx, posy += menuHeight, width, 0, 8, 256, 8, (handler, pItem) -> {
            MenuSlider slider = (MenuSlider)pItem;
            this.voices = slider.value;
        }, true){
            final /* synthetic */ MenuAudio this$0;
            {
                this.this$0 = this$0;
                super(slider, text, textStyle, x, y, width, value, min, max, step, callback, digital);
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!cfg.isNoSound());
                super.draw(handler);
            }

            @Override
            public void open() {
                this.this$0.voices = this.this$0.ovoices = cfg.getMaxvoices();
                this.value = this.this$0.ovoices;
            }
        };
        this.sSoundSwitch = new MenuSwitch("Sound", menuItems, posx, oposy + menuHeight, width, !cfg.isNoSound(), (handler, pItem) -> {
            MenuSwitch sw = (MenuSwitch)pItem;
            cfg.setNoSound(!sw.value);
            this.sSound.mCheckEnableItem(!cfg.isNoSound());
            this.sVoices.mCheckEnableItem(!cfg.isNoSound());
            if (this.listener != null) {
                if (sw.value) {
                    this.listener.SoundOn();
                } else {
                    this.listener.SoundOff();
                }
            }
        }, null, null);
        oposy = posy += separatorHeight;
        posy += menuHeight;
        this.sMusic = new MenuSlider(this, app.pSlider, "Music volume", menuItems, posx, posy += menuHeight, width, (int)(cfg.getMusicVolume() * 256.0f), 0, 256, 8, (handler, pItem) -> {
            MenuSlider slider = (MenuSlider)pItem;
            cfg.setMusicVolume((float)slider.value / 256.0f);
        }, false){
            final /* synthetic */ MenuAudio this$0;
            {
                this.this$0 = this$0;
                super(slider, text, textStyle, x, y, width, value, min, max, step, callback, digital);
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!cfg.isMuteMusic());
                super.draw(handler);
            }
        };
        this.sMusicSwitch = new MenuSwitch(this, "Music", menuItems, posx, oposy + menuHeight, width, !cfg.isMuteMusic(), (handler, pItem) -> {
            MenuSwitch sw = (MenuSwitch)pItem;
            cfg.setMuteMusic(!sw.value);
            this.sMusic.mCheckEnableItem(!cfg.isMuteMusic());
            if (this.listener != null) {
                if (sw.value) {
                    this.listener.MusicOn();
                } else {
                    this.listener.MusicOff();
                }
            }
        }, null, null){
            final /* synthetic */ MenuAudio this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, value, callback, onMessage, offMessage);
            }

            @Override
            public void draw(MenuHandler handler) {
                this.value = !cfg.isMuteMusic();
                super.draw(handler);
            }
        };
        this.sMusicType = new MenuConteiner(this, "Music type", menuItems, posx, posy += menuHeight, width, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            this.cdaudio = item.num;
        }){
            final /* synthetic */ MenuAudio this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, list, num, callback);
            }

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = this.this$0.getMusicTypeList();
                }
                this.this$0.ocdaudio = this.num = cfg.getMusicType();
                this.this$0.cdaudio = this.num;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!cfg.isMuteMusic());
                super.draw(handler);
            }
        };
        MenuProc applyCallback = (handler, pItem) -> {
            if (this.snddriver != this.osnddriver || this.voices != this.ovoices || this.resampler != this.oresampler) {
                if (this.listener != null) {
                    this.listener.PreDrvChange();
                }
                if (this.snddriver != this.osnddriver) {
                    BuildAudio device = app.pCfg.getAudioDevices().get(this.snddriver);
                    app.pCfg.setAudioDriver(device.getAudioDriver());
                    int oldSelected = this.sSoundDrv.num;
                    this.sSoundDrv.open();
                    if (oldSelected == this.sSoundDrv.num) {
                        this.sSoundDrv.list[this.sSoundDrv.num] = app.pCfg.getAudio().getName().toCharArray();
                    }
                    this.updateSoftResamplers(this.sResampler, cfg);
                }
                if (this.voices != this.ovoices) {
                    cfg.setMaxvoices(this.voices);
                    this.ovoices = this.voices = cfg.getMaxvoices();
                }
                if (!this.resampler.equals(this.oresampler)) {
                    cfg.setResampler(this.resampler);
                    this.oresampler = this.resampler = cfg.getResampler();
                    List<AudioResampler> resamplers = cfg.getAudio().getResamplerList();
                    this.updateSoftResamplers(this.sResampler, cfg);
                    this.sResampler.num = Gameutils.listIndexOf(resamplers, i -> ((AudioResampler)resamplers.get(i)).equals(this.resampler));
                }
            } else {
                if (this.listener != null) {
                    this.listener.PreDrvChange();
                }
                if (this.middriver != this.omiddriver) {
                    MidiDevice device = app.pCfg.getMidiDevices().get(this.middriver);
                    if (app.pCfg.setMidiDevice(device)) {
                        this.omiddriver = this.middriver;
                    }
                    this.sMusicDrv.list[this.sMusicDrv.num] = app.pCfg.getMidiDevice().getName().toCharArray();
                }
                if (this.cdaudio != this.ocdaudio) {
                    cfg.setMusicType(this.cdaudio);
                    this.ocdaudio = this.cdaudio;
                }
            }
            if (this.listener != null) {
                this.listener.PostDrvChange();
            }
        };
        this.mApplyChanges = new MenuButton("Apply changes", menuItems, 0, posy += 2 * separatorHeight, 320, 1, 0, null, -1, applyCallback, 0){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuAudio.this.snddriver != MenuAudio.this.osnddriver || MenuAudio.this.middriver != MenuAudio.this.omiddriver || MenuAudio.this.resampler != MenuAudio.this.oresampler || MenuAudio.this.voices != MenuAudio.this.ovoices || MenuAudio.this.cdaudio != MenuAudio.this.ocdaudio);
                super.draw(handler);
            }

            @Override
            public void mCheckEnableItem(boolean nEnable) {
                this.flags = nEnable ? 7 : 3;
            }
        };
        this.addItem(this.sSoundDrv, true);
        this.addItem(this.sMusicDrv, false);
        this.addItem(this.sResampler, false);
        this.addItem(this.sSoundSwitch, false);
        this.addItem(this.sSound, false);
        this.addItem(this.sVoices, false);
        this.addItem(this.sMusicSwitch, false);
        this.addItem(this.sMusic, false);
        this.addItem(this.sMusicType, false);
        this.addItem(this.mApplyChanges, false);
    }

    void updateSoftResamplers(MenuConteiner resamplersContainer, GameConfig cfg) {
        List<AudioResampler> resamplers = cfg.getAudio().getResamplerList();
        resamplersContainer.list = new char[resamplers.size()][];
        for (int i = 0; i < resamplers.size(); ++i) {
            resamplersContainer.list[i] = resamplers.get(i).getName().toCharArray();
        }
        if (resamplersContainer.num >= resamplers.size()) {
            resamplersContainer.num = 0;
            this.resampler = this.oresampler = cfg.getResampler();
        }
    }

    protected char[][] getMusicTypeList() {
        char[][] list = new char[][]{"midi".toCharArray(), "external".toCharArray(), "cd audio".toCharArray()};
        return list;
    }

    protected void setListener(AudioListener listener) {
        this.listener = listener;
    }

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public static interface AudioListener {
        default public void PreDrvChange() {
        }

        default public void PostDrvChange() {
        }

        default public void SoundVolumeChange() {
        }

        default public void SoundOn() {
        }

        default public void SoundOff() {
        }

        default public void MusicOn() {
        }

        default public void MusicOff() {
        }
    }
}

