/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTextField;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Pattern.ScreenAdapters.ConnectAdapter;
import ru.m210projects.Build.Types.font.Font;

public abstract class MenuCreate
extends BuildMenu {
    protected int mPlayers = 2;
    protected boolean mUseFakeMultiplayer = false;
    public MenuSlider mPlayerNum;
    public MenuTextField mPortnum;
    public MenuTextField mPlayer;
    public MenuSwitch mMenuFakeMM;
    public MenuButton mCreate;

    public MenuCreate(final BuildGame app, int posx, int posy, int menuHeight, int width, Font style, int kMaxPlayers) {
        super(app.pMenu);
        this.addItem(this.getTitle(app, "Multiplayer"), false);
        this.mPlayerNum = new MenuSlider(app.pSlider, "Number of players", style, posx, posy += menuHeight, width, this.mPlayers, 1, kMaxPlayers, 1, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                MenuCreate.this.mPlayers = slider.value;
            }
        }, true);
        this.mPortnum = new MenuTextField(this, "Network socket number", "", style, posx, posy += menuHeight, width, 2, (handler, pItem) -> {
            MenuTextField item = (MenuTextField)pItem;
            String numbers = item.getText();
            if (numbers.length() < 8) {
                app.pCfg.setPort(Integer.parseInt(numbers));
            } else {
                this.mPortnum.setText("" + app.pCfg.getPort());
            }
        }){
            final /* synthetic */ MenuCreate this$0;
            {
                this.this$0 = this$0;
                super(text, input, font, x, y, width, charFlag, confirmCallback);
            }

            @Override
            public void open() {
                this.setText("" + app.pCfg.getPort());
            }
        };
        this.mPlayer = new MenuTextField(this, "Player name", "", style, posx, posy += menuHeight, width, 3, (handler, pItem) -> app.pCfg.setpName(((MenuTextField)pItem).getText())){
            final /* synthetic */ MenuCreate this$0;
            {
                this.this$0 = this$0;
                super(text, input, font, x, y, width, charFlag, confirmCallback);
            }

            @Override
            public void open() {
                this.setText(app.pCfg.getpName());
            }
        };
        this.mMenuFakeMM = new MenuSwitch("Use fake multiplayer", style, posx, posy += menuHeight, width, false, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                MenuCreate.this.mUseFakeMultiplayer = sw.value;
            }
        }, "Yes", "No"){

            @Override
            public void open() {
                this.value = MenuCreate.this.mUseFakeMultiplayer;
            }
        };
        this.mCreate = new MenuButton("Create", style, 0, posy + 2 * menuHeight, 320, 1, 0, null, -1, new MenuProc(){
            final /* synthetic */ MenuCreate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                if (app.getScreen() instanceof ConnectAdapter) {
                    return;
                }
                String[] param = new String[]{"-n0" + (this.this$0.mPlayers != 2 ? ":" + this.this$0.mPlayers : ""), app.pCfg.getPort() != 23513 ? "-p " + app.pCfg.getPort() : null};
                this.this$0.createGame(this.this$0.mPlayers, this.this$0.mUseFakeMultiplayer, param);
            }
        }, 0);
        this.addItem(this.mPlayerNum, true);
        this.addItem(this.mPortnum, false);
        this.addItem(this.mPlayer, false);
        this.addItem(this.mMenuFakeMM, false);
        this.addItem(this.mCreate, false);
    }

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public abstract void createGame(int var1, boolean var2, String[] var3);
}

