/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern;

import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.ConsoleLogger;

public abstract class LogSender {
    private final BuildGame game;
    private final String ftp = new String(new byte[]{102, 116, 112, 58, 47, 47});
    private final String address = new String(new byte[]{64, 109, 50, 49, 48, 46, 117, 99, 111, 122, 46, 114, 117, 47, 70, 105, 108, 101, 115, 47, 76, 111, 103, 115});

    public LogSender(BuildGame game) {
        this.game = game;
    }

    private void decryptBuffer(byte[] buffer, int size, long key) {
        for (int i = 0; i < size; ++i) {
            int n = i;
            buffer[n] = (byte)(buffer[n] ^ (byte)(key + (long)i));
        }
    }

    public abstract byte[] reportData();

    public void send(String comment) {
        if (!this.game.release) {
            return;
        }
        byte[] data1 = new byte[]{86, 10, 90, 88, 90};
        byte[] data2 = new byte[]{87, 87, 44, 12, 9, 90, 85, 85, 89};
        byte[] data3 = new byte[]{102, 116, 116, 112};
        int key = LittleEndian.getInt(data3);
        this.decryptBuffer(data1, data1.length, key);
        String field1 = new String(data1);
        this.decryptBuffer(data2, data2.length, key);
        String field2 = new String(data2);
        String name = this.game.appName;
        String version = this.game.appVersion;
        String filename = version + "_" + this.game.date.getDate(System.currentTimeMillis());
        filename = filename.replaceAll("[^a-zA-Z0-9_]", "").toLowerCase();
        String text = this.getLog();
        if (!comment.isEmpty()) {
            text = text + "Comment: " + comment + "\r\n";
        }
        try {
            URI uri = new URI(this.ftp + field1 + ":" + field2 + this.address + "/" + name + "/" + filename + ".log;type=i");
            URLConnection urlConnection = uri.toURL().openConnection();
            try (OutputStream os = urlConnection.getOutputStream();){
                os.write(text.getBytes());
                byte[] report = this.reportData();
                if (report != null) {
                    os.write(report);
                }
            }
        }
        catch (UnknownHostException e) {
            System.err.println("No internet connection");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    private String getLog() {
        String text = this.game.appName + this.game.appVersion + " log: \r\n";
        String currScreen = this.game.getScrName();
        String prevScreen = this.game.gPrevScreen != null ? this.game.gPrevScreen.getClass().getSimpleName() : "";
        Renderer renderer = this.game.getRenderer();
        ConsoleLogger logger = Console.out.getLogger();
        if (logger != null) {
            text = text + logger.toString();
            text = text + "\r\n";
        }
        text = text + "Screen: " + currScreen + "\r\n";
        text = text + "PrevScreen: " + prevScreen + "\r\n";
        text = text + "Renderer: " + renderer.getType().getName() + "\r\n";
        if (this.game.isSoftwareRenderer()) {
            text = text + "\txdim: " + renderer.getWidth() + "\r\n";
            text = text + "\tydim: " + renderer.getHeight() + "\r\n";
        }
        String string = text;
        if (string == null) {
            LogSender.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Build/Pattern/LogSender", "getLog"));
    }
}

