/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;

public class MenuButton
extends MenuItem {
    public BuildMenu nextMenu;
    public int nItem;
    public MenuProc specialCall;
    public int specialOpt;

    public MenuButton(Object text, Font font, int x, int y, int width, int align, int pal, BuildMenu nextMenu, int nItem, MenuProc specialCall, int specialOpt) {
        super(text, font);
        this.flags = 7;
        this.pal = pal;
        this.x = x;
        this.y = y;
        this.width = width;
        this.align = align;
        this.nextMenu = nextMenu;
        this.nItem = nItem;
        this.specialCall = specialCall;
        this.specialOpt = specialOpt;
    }

    @Override
    public void draw(MenuHandler handler) {
        if (this.text != null) {
            int shade = handler.getShade(this);
            int px = this.x;
            int pal = handler.getPal(this.font, this);
            if (this.align == 1) {
                px = this.width / 2 + this.x - this.font.getWidth(this.text, 1.0f) / 2;
            }
            if (this.align == 2) {
                px = this.x + this.width - 1 - this.font.getWidth(this.text, 1.0f);
            }
            this.font.drawTextScaled(handler.getRenderer(), px, this.y, this.text, 1.0f, shade, pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
        }
        handler.mPostDraw(this);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if ((this.flags & 4) != 0 && (opt == MenuHandler.MenuOpt.ENTER || opt == MenuHandler.MenuOpt.LMB)) {
            if (this.specialCall != null) {
                this.specialCall.run(handler, this);
            }
            if (this.nextMenu != null) {
                handler.mOpen(this.nextMenu, this.nItem);
            }
        } else {
            return this.m_pMenu.mNavigation(opt);
        }
        return false;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.text != null) {
            int wd = this.font.getWidth(this.text, 1.0f);
            int px = this.x;
            if (this.align == 1) {
                px = this.width / 2 + this.x - wd / 2;
            }
            if (this.align == 2) {
                px = this.x + this.width - 1 - wd;
            }
            if (mx > px && mx < px + wd) {
                return my > this.y && my < this.y + this.font.getSize();
            }
        }
        return false;
    }
}

