/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.CharInfo;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;

public class MenuConteiner
extends MenuItem {
    public int num;
    public MenuProc callback;
    public char[][] list;
    public Font listFont;
    public boolean listShadow;

    public MenuConteiner(Object text, Font font, int x, int y, int width, String[] list, int num, MenuProc callback) {
        super(text, font);
        this.listFont = font;
        this.flags = 7;
        if (list != null) {
            this.list = new char[list.length][];
            for (int i = 0; i < list.length; ++i) {
                this.list[i] = list[i].toCharArray();
            }
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.callback = callback;
        this.num = num;
        this.pal = 0;
    }

    public MenuConteiner(Object text, Font font, Font listFont, int x, int y, int width, String[] list, int num, MenuProc callback) {
        this(text, font, x, y, width, list, num, callback);
        this.listFont = listFont;
    }

    @Override
    public void draw(MenuHandler handler) {
        int px = this.x;
        int py = this.y;
        char[] key = null;
        if (this.list != null && this.num != -1 && this.num < this.list.length) {
            key = this.list[this.num];
        }
        int pal = handler.getPal(this.font, this);
        int shade = handler.getShade(this);
        int w1 = this.font.drawTextScaled(handler.getRenderer(), px, py, this.text, 1.0f, shade, pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
        if (key != null) {
            int bound = 10;
            int tx = px + w1 + bound;
            int ty = py + (this.font.getSize() - this.listFont.getSize()) / 2;
            this.brDrawText(handler.getRenderer(), this.listFont, key, tx, ty, shade, handler.getPal(this.listFont, this), px + this.width - 1);
        }
        handler.mPostDraw(this);
    }

    protected void brDrawText(Renderer renderer, Font font, char[] text, int x, int y, int shade, int pal, int x2) {
        for (int tptr = text.length - 1; tptr >= 0 && x2 > x; --tptr) {
            CharInfo charInfo = font.getCharInfo(text[tptr]);
            font.drawCharScaled(renderer, x2 -= charInfo.getCellSize(), y, text[tptr], 1.0f, shade, pal, Transparent.None, ConvertType.Normal, this.listShadow);
        }
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case LEFT: 
            case MWDW: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                this.num = this.num > 0 ? --this.num : 0;
                if (this.callback != null) {
                    this.callback.run(handler, this);
                }
                return false;
            }
            case RIGHT: 
            case MWUP: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (this.list != null) {
                    this.num = this.num < this.list.length - 1 ? ++this.num : this.list.length - 1;
                }
                if (this.callback != null) {
                    this.callback.run(handler, this);
                }
                return false;
            }
            case ENTER: 
            case LMB: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (this.list != null) {
                    this.num = this.num < this.list.length - 1 ? ++this.num : 0;
                }
                if (this.callback != null) {
                    this.callback.run(handler, this);
                }
                return false;
            }
        }
        return this.m_pMenu.mNavigation(opt);
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        char[] key;
        int fontx;
        int px;
        if (this.text != null && mx > this.x && mx < this.x + this.font.getWidth(this.text, 1.0f) && my > this.y && my < this.y + this.font.getSize()) {
            return true;
        }
        if (this.list == null) {
            return false;
        }
        if (this.num != -1 && this.num < this.list.length && mx > (px = this.x + this.width - 1 - (fontx = this.listFont.getWidth(key = this.list[this.num], 1.0f))) && mx < px + fontx) {
            return my > this.y && my < this.y + this.font.getSize();
        }
        return false;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }
}

