/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import com.badlogic.gdx.controllers.Controller;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.ScrollableMenuItem;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.input.keymap.ControllerAxis;
import ru.m210projects.Build.input.keymap.ControllerButton;
import ru.m210projects.Build.settings.ControllerMapping;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.GameKeys;

public class MenuJoyList
extends MenuList
implements ScrollableMenuItem,
InputListener {
    protected SliderDrawable slider;
    protected GameConfig cfg;
    protected List<String> components = new ArrayList<String>();
    public int l_set = 0;
    protected int scrollerX;
    protected int scrollerHeight;
    protected boolean isLocked;
    public int pal_left;
    public int pal_right;
    public int axispal;

    public MenuJoyList(BuildGame app, Font font, int x, int y, int width, int rowCount, MenuProc callback) {
        super(null, font, x, y, width, 0, callback, rowCount);
        this.slider = app.pSlider;
        this.cfg = app.pCfg;
        ControllerAxis[] axes = ControllerAxis.values();
        for (int i = 1; i < axes.length; ++i) {
            this.components.add(axes[i].name());
        }
        ControllerButton[] buttons = ControllerButton.values();
        for (int i = 1; i < buttons.length; ++i) {
            this.components.add(buttons[i].name());
        }
        this.len = this.components.size();
    }

    @Override
    public void draw(MenuHandler handler) {
        int px = this.x;
        int py = this.y;
        int totalclock = handler.game.pEngine.getTotalClock();
        for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.rowCount && i < this.len; ++i) {
            String componentName;
            int shade = handler.getShade(i == this.l_nFocus ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
            int pal1 = i < 4 ? this.axispal : this.pal_left;
            int pal2 = this.pal_right;
            if (i == this.l_nFocus) {
                pal2 = pal1 = handler.getPal(this.font, this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus]);
            }
            ControllerMapping mapping = this.cfg.getControllerMapping(this.cfg.getControllerName());
            String name = this.components.get(i);
            if (i < 4) {
                ControllerAxis axis = this.getAxis(name);
                componentName = mapping.getAxisName(axis);
            } else {
                ControllerButton button = this.getButton(name);
                componentName = mapping.getButtonName(button);
            }
            if (i == this.l_nFocus && this.l_set == 1 && (totalclock & 0x20) != 0) {
                componentName = "____";
            }
            this.font.drawTextScaled(handler.getRenderer(), px, py, name.toCharArray(), 1.0f, shade, pal1, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
            this.font.drawTextScaled(handler.getRenderer(), this.x + this.width - this.slider.getScrollerWidth() - 2, py, componentName, 1.0f, shade, pal2, TextAlign.Right, Transparent.None, ConvertType.Normal, this.fontShadow);
            py += this.mFontOffset();
        }
        this.scrollerHeight = this.rowCount * this.mFontOffset();
        int nList = Gameutils.BClipLow(this.len - this.rowCount, 1);
        int posy = this.y + (this.scrollerHeight - this.slider.getScrollerHeight()) * this.l_nMin / nList;
        this.scrollerX = this.x + this.width - this.slider.getScrollerWidth() + 5;
        this.slider.drawScrollerBackground(this.scrollerX, this.y, this.scrollerHeight, 0, 0);
        this.slider.drawScroller(this.scrollerX, posy, handler.getShade(this.isLocked ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null), 0);
        handler.mPostDraw(this);
    }

    private ControllerAxis getAxis(String name) {
        try {
            return ControllerAxis.valueOf(name);
        }
        catch (Exception exception) {
            return ControllerAxis.NULL;
        }
    }

    private ControllerButton getButton(String name) {
        try {
            return ControllerButton.valueOf(name);
        }
        catch (Exception exception) {
            return ControllerButton.NULL;
        }
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (this.l_set == 1 && GameKeys.Menu_Toggle.equals(gameKey)) {
            this.l_set = 0;
            return true;
        }
        return this.l_set == 1;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (this.l_set == 1) {
            if (keycode == 111) {
                this.l_set = 0;
            }
            return true;
        }
        if (keycode == 112) {
            ControllerMapping mapping = this.cfg.getControllerMapping(this.cfg.getControllerName());
            if (this.l_nFocus < 4) {
                mapping.removeAxis(this.getAxis(this.components.get(this.l_nFocus)));
            } else {
                mapping.removeButton(this.getButton(this.components.get(this.l_nFocus)));
            }
        }
        return false;
    }

    @Override
    public boolean buttonDown(Controller controller, int buttonCode) {
        if (this.l_set == 1 && this.l_nFocus > 3) {
            ControllerMapping mapping = this.cfg.getControllerMapping(controller.getName());
            ControllerButton button = this.getButton(this.components.get(this.l_nFocus));
            if (button != ControllerButton.NULL) {
                mapping.putButton(button, buttonCode);
                this.l_set = 0;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean axisMoved(Controller controller, int axisCode, float value) {
        if (this.l_set == 1 && this.l_nFocus < 4 && Math.abs(value) >= 0.5f) {
            ControllerMapping mapping = this.cfg.getControllerMapping(controller.getName());
            ControllerAxis axis = this.getAxis(this.components.get(this.l_nFocus));
            if (axis != ControllerAxis.NULL) {
                mapping.putAxis(axis, axisCode);
                this.l_set = 0;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.l_set != 0) {
            return false;
        }
        int py = this.y;
        for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.rowCount && i < this.len; ++i) {
            if (my >= py && my < py + this.font.getSize()) {
                this.l_nFocus = i;
                return true;
            }
            py += this.mFontOffset();
        }
        return false;
    }

    @Override
    public boolean onMoveSlider(MenuHandler handler, int scaledX, int scaledY) {
        if (this.isLocked) {
            if (this.len <= this.rowCount) {
                return false;
            }
            int nList = Gameutils.BClipLow(this.len - this.rowCount, 1);
            int nRange = this.scrollerHeight;
            int py = this.y;
            this.l_nFocus = -1;
            this.l_nMin = Gameutils.BClipRange((scaledY - py) * nList / nRange, 0, nList);
            return true;
        }
        return false;
    }

    @Override
    public boolean onLockSlider(MenuHandler handler, int mx, int my) {
        if (this.l_set != 0) {
            return false;
        }
        if (mx > this.scrollerX && mx < this.scrollerX + this.slider.getScrollerWidth()) {
            this.isLocked = true;
            this.onMoveSlider(handler, mx, my);
            return true;
        }
        return false;
    }

    @Override
    public void onUnlockSlider() {
        this.isLocked = false;
    }

    @Override
    public void close() {
        this.menuHandler.game.getProcessor().resetPollingStates();
    }
}

