/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.ScrollableMenuItem;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.GameKeys;

public abstract class MenuKeyboardList
extends MenuList
implements ScrollableMenuItem,
InputListener {
    public int l_set = 0;
    public MenuHandler.MenuOpt l_pressedId;
    public int pal_left;
    public int pal_right;
    protected GameKey[] keynames;
    protected GameConfig cfg;
    protected SliderDrawable slider;
    protected int scrollerX;
    protected int scrollerHeight;
    protected boolean isLocked;

    public MenuKeyboardList(SliderDrawable slider, GameConfig cfg, Font font, int x, int y, int width, int len, MenuProc callback) {
        super(null, font, x, y, width, 0, callback, len);
        this.slider = slider;
        this.cfg = cfg;
        this.keynames = cfg.getKeymap();
        this.len = this.keynames.length;
    }

    public abstract String getKeyName(int var1);

    @Override
    public void draw(MenuHandler handler) {
        int px = this.x;
        int py = this.y;
        int totalclock = handler.game.pEngine.getTotalClock();
        for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.rowCount && i < this.len; ++i) {
            int shade = handler.getShade(i == this.l_nFocus ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
            int pal1 = this.pal_left;
            int pal2 = this.pal_right;
            if (i == this.l_nFocus) {
                pal2 = pal1 = handler.getPal(this.font, this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus]);
            }
            String text = this.keynames[i].getName();
            String key = this.getKeyName(this.cfg.getKeyCode(this.keynames[i], 0));
            int secondKey = this.cfg.getKeyCode(this.keynames[i], 1);
            if (secondKey > 0) {
                key = key + " or " + this.getKeyName(secondKey);
            }
            if (i == this.l_nFocus && this.l_set == 1 && (totalclock & 0x20) != 0) {
                key = "____";
            }
            char[] k = key.toCharArray();
            this.font.drawTextScaled(handler.getRenderer(), px, py, text.toCharArray(), 1.0f, shade, pal1, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
            this.font.drawTextScaled(handler.getRenderer(), this.x + this.width / 2 - 1 + 40, py, k, 1.0f, shade, pal2, TextAlign.Right, Transparent.None, ConvertType.Normal, this.fontShadow);
            int mouseCode = this.cfg.getKeyCode(this.keynames[i], 2);
            int joyCode = this.cfg.getKeyCode(this.keynames[i], 3);
            key = (mouseCode > 0 ? this.getKeyName(mouseCode) : "") + (mouseCode > 0 && joyCode > 0 ? " or " : "") + (joyCode > 0 ? this.getKeyName(joyCode) : "");
            String string = key = key.isEmpty() ? "-" : key;
            if (i == this.l_nFocus && this.l_set == 1 && (totalclock & 0x20) != 0) {
                key = "____";
            }
            k = key.toCharArray();
            this.font.drawTextScaled(handler.getRenderer(), this.x + this.width - this.slider.getScrollerWidth() - 2, py, k, 1.0f, shade, pal2, TextAlign.Right, Transparent.None, ConvertType.Normal, this.fontShadow);
            py += this.mFontOffset();
        }
        this.scrollerHeight = this.rowCount * this.mFontOffset();
        int nList = Gameutils.BClipLow(this.len - this.rowCount, 1);
        int posy = this.y + (this.scrollerHeight - this.slider.getScrollerHeight()) * this.l_nMin / nList;
        this.scrollerX = this.x + this.width - this.slider.getScrollerWidth() + 5;
        this.slider.drawScrollerBackground(this.scrollerX, this.y, this.scrollerHeight, 0, 0);
        this.slider.drawScroller(this.scrollerX, posy, handler.getShade(this.isLocked ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null), 0);
        handler.mPostDraw(this);
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        return this.l_set == 1;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (this.l_set == 1) {
            if (this.l_nFocus != -1 && (GameKeys.Menu_Toggle.equals(this.keynames[this.l_nFocus]) || keycode != 111)) {
                this.cfg.bindKey(this.keynames[this.l_nFocus], keycode);
            }
            this.l_set = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.l_set == 1) {
            if (this.l_nFocus != -1) {
                this.cfg.bindMouse(this.keynames[this.l_nFocus], 226 + button);
            }
            this.l_set = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        if (this.l_set == 1) {
            if (this.l_nFocus != -1) {
                this.cfg.bindMouse(this.keynames[this.l_nFocus], amountY > 0.0f ? 224 : 225);
            }
            this.l_set = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if (this.l_set == 0) {
            switch (opt) {
                case MWUP: {
                    this.ListMouseWheelUp(handler);
                    return false;
                }
                case MWDW: {
                    this.ListMouseWheelDown(handler, this.len);
                    return false;
                }
                case UP: {
                    this.ListUp(handler, this.len);
                    return false;
                }
                case DW: {
                    this.ListDown(handler, this.len);
                    return false;
                }
                case ENTER: 
                case LMB: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    if (this.l_nFocus != -1 && this.callback != null) {
                        this.callback.run(handler, this);
                    }
                    return false;
                }
                case DELETE: {
                    if (this.l_nFocus == -1) {
                        return false;
                    }
                    this.cfg.unbindAll(this.keynames[this.l_nFocus]);
                    return false;
                }
                case PGUP: {
                    this.ListPGUp(handler);
                    return false;
                }
                case PGDW: {
                    this.ListPGDown(handler, this.len);
                    return false;
                }
                case HOME: {
                    this.ListHome(handler);
                    return false;
                }
                case END: {
                    this.ListEnd(handler, this.len);
                    return false;
                }
            }
            return this.m_pMenu.mNavigation(opt);
        }
        this.l_pressedId = opt;
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.l_set != 0) {
            return false;
        }
        int py = this.y;
        for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.rowCount && i < this.len; ++i) {
            if (my >= py && my < py + this.font.getSize()) {
                this.l_nFocus = i;
                return true;
            }
            py += this.mFontOffset();
        }
        return false;
    }

    @Override
    public boolean onMoveSlider(MenuHandler handler, int scaledX, int scaledY) {
        if (this.isLocked) {
            if (this.len <= this.rowCount) {
                return false;
            }
            int nList = Gameutils.BClipLow(this.len - this.rowCount, 1);
            int nRange = this.scrollerHeight;
            int py = this.y;
            this.l_nFocus = -1;
            this.l_nMin = Gameutils.BClipRange((scaledY - py) * nList / nRange, 0, nList);
            return true;
        }
        return false;
    }

    @Override
    public boolean onLockSlider(MenuHandler handler, int mx, int my) {
        if (this.l_set != 0) {
            return false;
        }
        if (mx > this.scrollerX && mx < this.scrollerX + this.slider.getScrollerWidth()) {
            this.isLocked = true;
            this.onMoveSlider(handler, mx, my);
            return true;
        }
        return false;
    }

    @Override
    public void onUnlockSlider() {
        this.isLocked = false;
    }

    @Override
    public void close() {
        this.menuHandler.game.getProcessor().resetPollingStates();
    }
}

