/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import java.util.List;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;

public class MenuList
extends MenuItem {
    public int len;
    public int l_nMin = 0;
    public int l_nFocus;
    public int rowCount;
    public List<char[]> text;
    public MenuProc callback;

    public MenuList(List<char[]> text, Font font, int x, int y, int width, int align, MenuProc callback, int rowCount) {
        super(null, font);
        this.text = text;
        this.align = align;
        this.flags = 7;
        this.m_pMenu = null;
        this.x = x;
        this.y = y;
        this.width = width;
        this.rowCount = rowCount;
        this.callback = callback;
        if (text != null) {
            this.len = text.size();
        }
    }

    public int mFontOffset() {
        return this.font.getSize() + 2;
    }

    @Override
    public void draw(MenuHandler handler) {
        if (!this.text.isEmpty()) {
            int px = this.x;
            int py = this.y;
            for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.rowCount && i < this.len; ++i) {
                int pal = this.pal;
                if (i == this.l_nFocus) {
                    pal = handler.getPal(this.font, this);
                }
                int shade = handler.getShade(i == this.l_nFocus ? this : null);
                if (this.align == 1) {
                    px = this.width / 2 + this.x - this.font.getWidth(this.text.get(i), 1.0f) / 2;
                }
                if (this.align == 2) {
                    px = this.x + this.width - 1 - this.font.getWidth(this.text.get(i), 1.0f);
                }
                this.font.drawTextScaled(handler.getRenderer(), px, py, this.text.get(i), 1.0f, shade, pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
                py += this.mFontOffset();
            }
        } else {
            int pal = handler.getPal(this.font, this);
            String text = "List is empty";
            int fontx = this.font.getWidth(text.toCharArray(), 1.0f);
            int px = this.x;
            int py = this.y;
            if (this.align == 1) {
                px = this.width / 2 + this.x - fontx / 2;
            }
            if (this.align == 2) {
                px = this.x + this.width - 1 - fontx;
            }
            int shade = handler.getShade(this);
            this.font.drawTextScaled(handler.getRenderer(), px, py, text.toCharArray(), 1.0f, shade, pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
        }
        handler.mPostDraw(this);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case MWUP: {
                this.ListMouseWheelUp(handler);
                return false;
            }
            case MWDW: {
                this.ListMouseWheelDown(handler, this.len);
                return false;
            }
            case UP: {
                this.ListUp(handler, this.len);
                return false;
            }
            case DW: {
                this.ListDown(handler, this.len);
                return false;
            }
            case LEFT: {
                this.ListLeft(handler);
                return false;
            }
            case RIGHT: {
                this.ListRight(handler);
                return false;
            }
            case ENTER: 
            case LMB: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (this.len > 0) {
                    this.ListCallback(handler, opt);
                }
                return false;
            }
            case ESC: 
            case RMB: {
                this.ListEscape(handler, opt);
                return true;
            }
            case PGUP: {
                this.ListPGUp(handler);
                return false;
            }
            case PGDW: {
                this.ListPGDown(handler, this.len);
                return false;
            }
            case HOME: {
                this.ListHome(handler);
                return false;
            }
            case END: {
                this.ListEnd(handler, this.len);
                return false;
            }
        }
        this.ListDefault(handler, opt);
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.len > 0) {
            int px = this.x;
            int py = this.y;
            for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.rowCount && i < this.len; ++i) {
                int wd = this.font.getWidth(this.text.get(i), 1.0f);
                if (this.align == 1) {
                    px = this.width / 2 + this.x - wd / 2;
                }
                if (this.align == 2) {
                    px = this.x + this.width - 1 - wd;
                }
                if (mx > px && mx < px + wd && my > py && my < py + this.font.getSize()) {
                    this.l_nFocus = i;
                    return true;
                }
                py += this.mFontOffset();
            }
        }
        return false;
    }

    protected void ListEnd(MenuHandler handler, int len) {
        this.l_nFocus = len - 1;
        if (len >= this.rowCount) {
            this.l_nMin = len - this.rowCount;
        } else if (this.l_nFocus >= this.l_nMin + this.rowCount) {
            this.l_nMin = len - 1;
        }
    }

    protected void ListHome(MenuHandler handler) {
        this.l_nFocus = 0;
        this.l_nMin = 0;
    }

    protected void ListPGUp(MenuHandler handler) {
        this.l_nFocus -= this.rowCount - 1;
        if (this.l_nFocus >= 0 && this.l_nFocus < this.l_nMin) {
            this.l_nMin -= this.rowCount - 1;
        }
        if (this.l_nFocus < 0 || this.l_nMin < 0) {
            this.l_nFocus = 0;
            this.l_nMin = 0;
        }
    }

    protected void ListPGDown(MenuHandler handler, int len) {
        this.l_nFocus += this.rowCount - 1;
        if (this.l_nFocus >= this.l_nMin + this.rowCount && this.l_nFocus < len) {
            this.l_nMin += this.rowCount - 1;
        }
        if (this.l_nFocus >= len || this.l_nMin > len - this.rowCount) {
            this.l_nFocus = len - 1;
            if (len >= this.rowCount) {
                this.l_nMin = len - this.rowCount;
            } else if (this.l_nFocus >= this.l_nMin + this.rowCount) {
                this.l_nMin = len - 1;
            }
        }
    }

    protected void ListUp(MenuHandler handler, int len) {
        --this.l_nFocus;
        if (this.l_nFocus >= 0 && this.l_nFocus < this.l_nMin) {
            --this.l_nMin;
        }
        if (this.l_nFocus < 0) {
            this.l_nFocus = len - 1;
            this.l_nMin = len - this.rowCount;
            if (this.l_nMin < 0) {
                this.l_nMin = 0;
            }
        }
    }

    protected void ListDown(MenuHandler handler, int len) {
        ++this.l_nFocus;
        if (this.l_nFocus >= this.l_nMin + this.rowCount && this.l_nFocus < len) {
            ++this.l_nMin;
        }
        if (this.l_nFocus >= len) {
            this.l_nFocus = 0;
            this.l_nMin = 0;
        }
    }

    protected void ListLeft(MenuHandler handler) {
        this.m_pMenu.mNavUp();
    }

    protected void ListRight(MenuHandler handler) {
        this.m_pMenu.mNavDown();
    }

    protected void ListMouseWheelUp(MenuHandler handler) {
        if (this.l_nMin > 0) {
            --this.l_nMin;
        }
    }

    protected void ListMouseWheelDown(MenuHandler handler, int len) {
        if (this.l_nMin < len - this.rowCount) {
            ++this.l_nMin;
        }
    }

    protected void ListEscape(MenuHandler handler, MenuHandler.MenuOpt opt) {
    }

    protected void ListDefault(MenuHandler handler, MenuHandler.MenuOpt opt) {
    }

    protected void ListCallback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if (this.callback != null) {
            this.callback.run(handler, this);
        }
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }
}

