/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;

public class MenuText
extends MenuItem {
    public MenuText(Object text, Font font, int x, int y, int align) {
        super(text, font);
        this.flags = 1;
        this.x = x;
        this.y = y;
        this.width = 0;
        this.align = align;
    }

    @Override
    public void draw(MenuHandler handler) {
        if (this.text != null) {
            int px = this.x;
            if (this.align == 1) {
                px = this.width / 2 + this.x - this.font.getWidth(this.text, 1.0f) / 2;
            }
            if (this.align == 2) {
                px = this.x + this.width - 1 - this.font.getWidth(this.text, 1.0f);
            }
            this.font.drawTextScaled(handler.getRenderer(), px, this.y, this.text, 1.0f, -128, this.pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
        }
        handler.mPostDraw(this);
    }

    public MenuText setFontShadow(boolean shadow) {
        this.fontShadow = shadow;
        return this;
    }

    @Override
    public boolean mouseAction(int x, int y) {
        return false;
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        return this.m_pMenu.mNavigation(opt);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }
}

