/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuPrompt;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.CharInfo;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.osd.OsdCommandPrompt;

public class MenuTextField
extends MenuItem
implements InputListener {
    public static final int LETTERS = 1;
    public static final int NUMBERS = 2;
    public static final int SYMBOLS = 4;
    public static final int POINT = 8;
    private final OsdCommandPrompt prompt;
    protected String oldInput = "";

    public MenuTextField(Object text, String input, Font font, int x, int y, int width, final int charFlag, MenuProc confirmCallback) {
        super(text, font);
        this.flags = 7;
        this.m_pMenu = null;
        this.x = x;
        this.y = y;
        this.width = width;
        this.prompt = new MenuPrompt(this, 32, 32){
            final /* synthetic */ MenuTextField this$0;
            {
                this.this$0 = this$0;
                super(editLength, historyDepth);
            }

            @Override
            public boolean isCharacterAllowed(char ch) {
                return Strhandler.isalpha(ch) && (charFlag & 1) != 0 || Strhandler.isdigit(ch) && (charFlag & 2) != 0 || !Strhandler.isdigit(ch) && !Strhandler.isalpha(ch) && ((charFlag & 4) != 0 || (charFlag & 8) != 0 && ch == '.');
            }
        };
        this.prompt.setActionListener(i -> confirmCallback.run(this.menuHandler, this));
        this.prompt.setTextInput(input);
    }

    public String getText() {
        return this.prompt.getTextInput();
    }

    public void setText(String text) {
        this.prompt.setTextInput(text);
    }

    @Override
    public void draw(MenuHandler handler) {
        if (this.text != null) {
            int pal = handler.getPal(this.font, this);
            int shade = handler.getShade(this);
            this.font.drawTextScaled(handler.getRenderer(), this.x, this.y, this.text, 1.0f, shade, pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
            int px = this.x + this.width - 1;
            if (this.prompt.isCaptured()) {
                shade = -128;
            }
            this.drawPrompt(handler.getRenderer(), px, this.y, shade, pal);
        }
        handler.mPostDraw(this);
    }

    protected void drawPrompt(Renderer renderer, int pos, int y, int shade, int pal) {
        String input = this.prompt.getTextInput();
        int cursorPos = this.prompt.getCursorPosition();
        int fptr = input.length() - 1;
        int curX = pos;
        for (int i = fptr; i >= 0; --i) {
            CharInfo charInfo = this.font.getCharInfo(input.charAt(i));
            this.font.drawCharScaled(renderer, pos -= charInfo.getCellSize(), y, input.charAt(i), 1.0f, shade, pal, Transparent.None, ConvertType.Normal, false);
            if (i != cursorPos) continue;
            curX = pos;
        }
        if (this.prompt.isCaptured() && (System.currentTimeMillis() & 0x100L) == 0L) {
            char ch = '_';
            if (this.prompt.isOsdOverType()) {
                ch = '#';
            }
            this.font.drawCharScaled(renderer, curX, y, ch, 1.0f, shade, pal, Transparent.None, ConvertType.Normal, false);
        }
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if (this.prompt.isCaptured()) {
            return false;
        }
        switch (opt) {
            case ESC: 
            case RMB: {
                return true;
            }
            case UP: {
                this.m_pMenu.mNavUp();
                return false;
            }
            case DW: {
                this.m_pMenu.mNavDown();
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.text != null) {
            if (mx > this.x && mx < this.x + this.font.getWidth(this.text, 1.0f) && my > this.y && my < this.y + this.font.getSize()) {
                return true;
            }
            if (mx > this.x + this.width - this.font.getWidth(this.prompt.getTextInput(), 1.0f) && mx < this.x + this.width - 1) {
                return my > this.y && my < this.y + this.font.getSize();
            }
        }
        return false;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        this.onCancel();
    }

    @Override
    public boolean keyRepeat(int keycode) {
        if (this.prompt.isCaptured()) {
            return this.prompt.keyRepeat(keycode);
        }
        return false;
    }

    @Override
    public boolean keyDown(int i) {
        if (this.prompt.isCaptured()) {
            switch (i) {
                case 66: 
                case 96: {
                    this.onConfirm();
                    return true;
                }
                case 111: {
                    this.onCancel();
                    return true;
                }
            }
            return this.prompt.keyDown(i);
        }
        if (i == 66) {
            this.onStartEdit();
        }
        return false;
    }

    @Override
    public boolean keyUp(int i) {
        this.prompt.keyUp(i);
        return false;
    }

    @Override
    public boolean keyTyped(char c) {
        if (this.prompt.isCaptured()) {
            this.prompt.keyTyped(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (button == 0) {
            if (!this.prompt.isCaptured()) {
                this.onStartEdit();
            }
        } else if (button == 1) {
            this.onCancel();
        }
        return false;
    }

    @Override
    public boolean mouseMoved(int mx, int my) {
        return this.prompt.isCaptured();
    }

    public void onCancel() {
        if (!this.prompt.isCaptured()) {
            return;
        }
        this.prompt.setTextInput(this.oldInput);
        this.prompt.setCaptureInput(false);
    }

    protected void onConfirm() {
        this.prompt.onEnter();
        this.prompt.setCaptureInput(false);
    }

    protected void onStartEdit() {
        this.oldInput = this.prompt.getTextInput();
        this.prompt.setCaptureInput(true);
    }
}

