/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.input.InputListener;

public abstract class MenuVariants
extends MenuTitle
implements InputListener {
    public MenuVariants(Engine draw, String text, Font font, int x, int y) {
        super(draw, text, font, x, y, -1);
        this.flags = 7;
    }

    @Override
    public void draw(MenuHandler handler) {
        if (this.text != null) {
            this.font.drawTextScaled(handler.getRenderer(), this.x, this.y - this.font.getSize() / 2, this.text, 1.0f, handler.getShade(this), this.pal, TextAlign.Center, Transparent.None, ConvertType.Normal, this.fontShadow);
        }
        handler.mPostDraw(this);
    }

    public abstract void positive(MenuHandler var1);

    public void negative(MenuHandler handler) {
        handler.mMenuBack();
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        switch (button) {
            case 0: {
                this.positive(this.menuHandler);
                return true;
            }
            case 1: {
                this.negative(this.menuHandler);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyDown(int keycode) {
        switch (keycode) {
            case 53: 
            case 66: 
            case 96: {
                this.positive(this.menuHandler);
                return true;
            }
            case 42: 
            case 111: {
                this.negative(this.menuHandler);
                return true;
            }
        }
        return false;
    }
}

