/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Serializable;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public abstract class SaveReader {
    protected final String signature;
    protected final int version;
    protected final Engine engine;
    protected final List<Savable> components = new ArrayList<Savable>();

    public SaveReader(Engine engine, String signature, int version) {
        this.engine = engine;
        this.signature = signature;
        this.version = version;
    }

    protected abstract SaveHeader getNewHeader(String var1);

    protected void updateScreenshot(SaveHeader header) {
        ArtEntry pic = this.engine.getTile(SaveManager.Screenshot);
        if (!(pic instanceof DynamicArtEntry) || !pic.exists() || pic.getWidth() != header.picWidth || pic.getHeight() != header.picHeight) {
            pic = this.engine.allocatepermanenttile(SaveManager.Screenshot, header.picWidth, header.picHeight);
        }
        ((DynamicArtEntry)pic).copyData(header.picData);
    }

    public SaveHeader loadHeader(Entry file) {
        SaveHeader header = this.getNewHeader("");
        file.load(header::readObject);
        if (header.hasScreenshot()) {
            this.updateScreenshot(header);
        }
        return header;
    }

    public boolean checkVersion(SaveHeader header) {
        return header.getSignature().equals(this.signature) && header.getVersion() == this.version;
    }

    public SaveHeader saveGame(Directory dir, String saveName, String fileName) throws IOException {
        FileEntry file = dir.getEntry(fileName);
        if (file.exists() && !file.delete()) {
            throw new AccessDeniedException("Game not saved. Access denied!");
        }
        Path path = dir.getPath().resolve(fileName);
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            SaveHeader header = this.getNewHeader(saveName);
            header.writeObject(os);
            for (Savable component : this.components) {
                component.writeObject(os);
            }
            file = dir.addEntry(path);
            if (!file.exists()) {
                throw new FileNotFoundException(fileName);
            }
            SaveHeader saveHeader = header;
            return saveHeader;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadGame(Entry file) {
        if (!file.exists()) return false;
        if (file.getSize() <= 0L) return false;
        try (InputStream is = file.getInputStream();){
            SaveHeader header = this.getNewHeader("");
            header.readObject(is);
            if (this.checkVersion(header)) {
                boolean bl = false;
                return bl;
            }
            for (Savable component : this.components) {
                component.readObject(is);
            }
            if (is.available() != 0) return false;
            for (Savable component : this.components) {
                component.apply();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Console.out.println(String.format("Failed to load saved game file %s: %s", file.getName(), e), OsdColor.RED);
        }
        return false;
    }

    public static class SaveHeader
    implements Serializable<SaveHeader> {
        protected String signature;
        protected int version;
        protected long time = System.currentTimeMillis();
        protected String name;
        protected int picWidth;
        protected int picHeight;
        protected byte[] picData;

        public void setScreenshot(int width, int height) {
            this.picWidth = width;
            this.picHeight = height;
            this.picData = new byte[width * height];
        }

        @Override
        public SaveHeader readObject(InputStream is) throws IOException {
            this.signature = StreamUtils.readString(is, 4);
            this.version = StreamUtils.readInt(is);
            this.time = StreamUtils.readLong(is);
            this.name = StreamUtils.readDataString(is);
            int picWidth = StreamUtils.readInt(is);
            int picHeight = StreamUtils.readInt(is);
            this.picData = StreamUtils.readBytes(is, picWidth * picHeight);
            return this;
        }

        @Override
        public SaveHeader writeObject(OutputStream os) throws IOException {
            StreamUtils.writeString(os, this.signature, 4);
            StreamUtils.writeInt(os, this.version);
            StreamUtils.writeLong(os, this.time);
            StreamUtils.writeDataString(os, this.name);
            StreamUtils.writeInt(os, this.picWidth);
            StreamUtils.writeInt(os, this.picHeight);
            StreamUtils.writeBytes(os, this.picData);
            return this;
        }

        public String getSignature() {
            return this.signature;
        }

        public int getVersion() {
            return this.version;
        }

        public long getTime() {
            return this.time;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasScreenshot() {
            return this.picWidth > 0 && this.picHeight > 0 && this.picData != null;
        }
    }

    public static interface Savable<T>
    extends Serializable<T> {
        public void apply();
    }

    public static class MapReader
    implements Savable<MapReader> {
        protected Board board;
        protected String boardfilename;
        protected BoardService boardService;

        public MapReader(BoardService boardService, String boardfilename) {
            this.board = boardService.getBoard();
            this.boardService = boardService;
            this.boardfilename = boardfilename;
        }

        @Override
        public MapReader readObject(InputStream is) throws IOException {
            this.boardfilename = StreamUtils.readDataString(is);
            int numsectors = StreamUtils.readInt(is);
            Sector[] sector = new Sector[numsectors];
            for (int i = 0; i < sector.length; ++i) {
                sector[i] = new Sector().readObject(is);
            }
            Wall[] wall = new Wall[StreamUtils.readInt(is)];
            for (int i = 0; i < wall.length; ++i) {
                wall[i] = new Wall().readObject(is);
            }
            int numSprites = StreamUtils.readInt(is);
            ArrayList<Sprite> sprite = new ArrayList<Sprite>(numSprites * 2);
            for (int i = 0; i < numSprites; ++i) {
                sprite.add(new Sprite().readObject(is));
            }
            this.board = new Board(null, sector, wall, sprite);
            return this;
        }

        @Override
        public MapReader writeObject(OutputStream os) throws IOException {
            StreamUtils.writeDataString(os, this.boardfilename);
            Sector[] sectors = this.board.getSectors();
            StreamUtils.writeInt(os, sectors.length);
            for (Sector s : sectors) {
                s.writeObject(os);
            }
            Wall[] walls = this.board.getWalls();
            StreamUtils.writeInt(os, walls.length);
            for (Wall wal : walls) {
                wal.writeObject(os);
            }
            List<Sprite> sprites = this.board.getSprites();
            StreamUtils.writeInt(os, sprites.size());
            for (Sprite s : sprites) {
                s.writeObject(os);
            }
            return this;
        }

        public Board getBoard() {
            return this.board;
        }

        public String getBoardfilename() {
            return this.boardfilename;
        }

        @Override
        public void apply() {
            this.boardService.setBoard(this.board);
        }
    }
}

