/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.ScreenAdapter;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public abstract class ConnectAdapter
extends ScreenAdapter {
    protected BuildGame game;
    private NetFlag gNetFlag;
    private String[] gNetParam;
    private int ConnectStep = 0;
    private final int nTile;
    private final Font style;

    public ConnectAdapter(BuildGame game, int nTile, Font style) {
        this.game = game;
        this.nTile = nTile;
        this.style = style;
    }

    public abstract void back();

    public abstract void connect();

    @Override
    public void show() {
        this.game.pNet.ResetNetwork();
        this.game.getProcessor().resetPollingStates();
        Mmulti.initmultiplayers(this.gNetParam, 0);
        this.ConnectStep = 0;
    }

    public ScreenAdapter setFlag(NetFlag flag, String[] param) {
        this.gNetFlag = flag;
        this.gNetParam = param;
        return this;
    }

    @Override
    public void render(float delta) {
        Renderer renderer = this.game.getRenderer();
        renderer.clearview(0);
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, this.nTile, 0, 0, 74);
        switch (this.gNetFlag.ordinal()) {
            case 0: 
            case 1: {
                if (Mmulti.inet.waiting()) {
                    if (this.game.getProcessor().isKeyPressed(111)) {
                        Mmulti.inet.cancel();
                        return;
                    }
                    if (Mmulti.myconnectindex == Mmulti.connecthead) {
                        this.style.drawTextScaled(renderer, 160, 150, "Local IP: " + Mmulti.inet.myip, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                        if (Mmulti.inet.useUPnP) {
                            String extip = "Public IP: ";
                            if (Mmulti.inet.extip != null) {
                                extip = extip + Mmulti.inet.extip;
                            }
                            this.style.drawTextScaled(renderer, 160, 160, extip, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                        }
                    }
                    if (Mmulti.inet.message != null && !Mmulti.inet.message.isEmpty()) {
                        this.style.drawTextScaled(renderer, 160, 180, Mmulti.inet.message, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    } else {
                        this.style.drawTextScaled(renderer, 160, 180, "Initializing...", 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    }
                    this.game.pEngine.nextpage(delta);
                    return;
                }
                if (Mmulti.inet.netready == 0) {
                    Console.out.println(Mmulti.inet.message, OsdColor.YELLOW);
                    this.back();
                    this.game.pEngine.nextpage(delta);
                    return;
                }
                if (this.ConnectStep == 0) {
                    if (Mmulti.inet.message != null) {
                        this.style.drawTextScaled(renderer, 160, 180, Mmulti.inet.message, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    } else {
                        this.style.drawTextScaled(renderer, 160, 180, "Connected! Waiting for other players...", 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    }
                    this.ConnectStep = 1;
                    this.game.pNet.StartWaiting(5000);
                    this.game.pEngine.nextpage(delta);
                    return;
                }
                this.connect();
            }
        }
        this.game.pEngine.nextpage(delta);
    }

    public static enum NetFlag {
        Create,
        Connect;

    }
}

