/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Types.AnimType;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class DefaultPrecacheScreen
extends ScreenAdapter
implements InputListener {
    protected final Runnable readyCallback;
    protected final BuildGame game;
    protected final PrecacheListener listener;
    private final byte[] tiles;
    private final List<PrecacheQueue> queues = new ArrayList<PrecacheQueue>();
    private int currentIndex = 0;

    public DefaultPrecacheScreen(BuildGame game, Runnable readyCallback, PrecacheListener listener) {
        this.game = game;
        this.listener = listener;
        this.readyCallback = readyCallback;
        this.tiles = new byte[Engine.MAXTILES >> 3];
        this.queues.add(new PrecacheQueue("Preload world...", () -> game.pEngine.getBoardService().notifyBoardChanged()));
        this.queues.add(new PrecacheQueue("Preload models...", listener::loadModels));
        this.queues.add(new PrecacheQueue("Preload fonts...", () -> {
            for (int i = 0; i < game.pFonts.getSize(); ++i) {
                Font font = game.getFont(i);
                for (int c = 0; c < 255; ++c) {
                    int tile = font.getCharInfo((char)((char)c)).tile;
                    if (tile == -1) continue;
                    this.addTile(tile);
                }
            }
        }));
    }

    public void addQueue(String name, Runnable runnable) {
        this.queues.add(new PrecacheQueue(name, runnable));
    }

    @Override
    public void show() {
        this.currentIndex = 0;
        this.game.getProcessor().resetPollingStates();
        Arrays.fill(this.tiles, (byte)0);
    }

    public void addTile(int tile) {
        Renderer renderer = this.game.getRenderer();
        ArtEntry pic = renderer.getTile(tile);
        if (pic.getType() != AnimType.NONE) {
            int frames;
            for (int i = frames = pic.getAnimFrames(); i >= 0; --i) {
                if (pic.getType() == AnimType.BACKWARD) {
                    int n = tile - i >> 3;
                    this.tiles[n] = (byte)(this.tiles[n] | (byte)(1 << (tile - i & 7)));
                    continue;
                }
                int n = tile + i >> 3;
                this.tiles[n] = (byte)(this.tiles[n] | (byte)(1 << (tile + i & 7)));
            }
        } else {
            int n = tile >> 3;
            this.tiles[n] = (byte)(this.tiles[n] | (byte)Engine.pow2char[tile & 7]);
        }
    }

    protected void draw(String title, int index) {
    }

    @Override
    public void render(float delta) {
        this.game.getRenderer().clearview(0);
        if (this.currentIndex >= this.queues.size()) {
            this.draw("Getting ready...", -1);
            this.listener.onPrecacheReady();
            Console.out.println("Done", OsdColor.BLUE);
            if (this.readyCallback != null) {
                Gdx.app.postRunnable(this.readyCallback);
            }
        } else {
            PrecacheQueue current = this.queues.get(this.currentIndex);
            this.draw(current.name, this.currentIndex);
            Gdx.app.postRunnable(current.runnable);
            ++this.currentIndex;
        }
        this.game.pEngine.nextpage(delta);
    }

    protected void doprecache(int method) {
        for (int i = 0; i < Engine.MAXTILES; ++i) {
            if (this.tiles[i >> 3] == 0) {
                i += 7;
                continue;
            }
            if ((this.tiles[i >> 3] & Engine.pow2char[i & 7]) == 0) continue;
            this.listener.onPrecacheTile(i, method == 1);
        }
        Arrays.fill(this.tiles, (byte)0);
    }

    @Override
    public InputListener getInputListener() {
        return null;
    }

    private static class PrecacheQueue {
        private final String name;
        private final Runnable runnable;

        public PrecacheQueue(String name, Runnable runnable) {
            this.name = name;
            this.runnable = runnable;
        }
    }
}

