/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.ScreenAdapter;
import java.io.ByteArrayOutputStream;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.ScreenAdapters.LoadingAdapter;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.GameKeys;

public abstract class GameAdapter
extends ScreenAdapter
implements InputListener {
    protected BuildGame game;
    protected BuildNet pNet;
    protected MenuHandler pMenu;
    protected Engine pEngine;
    protected GameConfig pCfg;
    protected Runnable gScreenCapture;
    protected LoadingAdapter load;
    public byte[] captBuffer;
    private final Runnable startboard = new Runnable(){

        @Override
        public void run() {
            GameAdapter.this.pNet.WaitForAllPlayers(0);
            GameAdapter.this.pNet.ResetTimers();
            GameAdapter.this.pNet.ready2send = true;
            GameAdapter.this.game.changeScreen(GameAdapter.this);
        }
    };

    public GameAdapter(BuildGame game, LoadingAdapter load) {
        this.game = game;
        this.pNet = game.pNet;
        this.pMenu = game.pMenu;
        this.pEngine = game.pEngine;
        this.pCfg = game.pCfg;
        this.load = load;
    }

    public void PreFrame(BuildNet net) {
    }

    public void PostFrame(BuildNet net) {
    }

    public abstract void ProcessFrame(BuildNet var1);

    public abstract void DrawWorld(float var1);

    public abstract void DrawHud(float var1);

    public abstract void sndHandlePause(boolean var1);

    protected abstract boolean prepareboard(Entry var1);

    public GameAdapter setTitle(String title) {
        this.load.setTitle(title);
        return this;
    }

    public GameAdapter loadboard(Entry mapEntry, Runnable prestart) {
        this.pNet.ready2send = false;
        this.game.changeScreen(this.load);
        this.load.init(() -> {
            if (this.prepareboard(mapEntry)) {
                if (prestart != null) {
                    prestart.run();
                }
                if (this.game.currentDef.mapInfo.load(mapEntry)) {
                    System.err.println("Maphack loaded for map: " + mapEntry.getName());
                }
                this.startboard(this.startboard);
            }
        });
        return this;
    }

    protected void startboard(Runnable startboard) {
        this.game.doPrecache(startboard);
    }

    @Override
    public void show() {
        this.game.getProcessor().resetPollingStates();
        this.pMenu.mClose();
        this.pNet.ready2send = true;
    }

    @Override
    public void hide() {
        this.pNet.ready2send = false;
    }

    @Override
    public synchronized void render(float delta) {
        if (Mmulti.numplayers > 1) {
            this.pNet.GetPackets();
            while (this.pNet.gPredictTail < this.pNet.gNetFifoHead[Mmulti.myconnectindex] && !this.game.gPaused) {
                this.pNet.UpdatePrediction(this.pNet.gFifoInput[this.pNet.gPredictTail & 0xFF][Mmulti.myconnectindex]);
            }
        } else {
            this.pNet.bufferJitter = 0;
        }
        this.PreFrame(this.pNet);
        while (this.pNet.gNetFifoHead[Mmulti.myconnectindex] - this.pNet.gNetFifoTail > this.pNet.bufferJitter && !this.game.gExit) {
            short i = Mmulti.connecthead;
            while (i >= 0 && this.pNet.gNetFifoTail != this.pNet.gNetFifoHead[i]) {
                i = Mmulti.connectpoint2[i];
            }
            if (i >= 0) break;
            this.pEngine.faketimerhandler();
            this.game.pInt.clearinterpolations();
            this.ProcessFrame(this.pNet);
        }
        this.pNet.CheckSync();
        float smoothratio = 65536.0f;
        if (!(this.game.gPaused || this.game.nNetMode == BuildGame.NetMode.Single && (this.pMenu.gShowMenu || Console.out.isShowing()) || !((smoothratio = (float)this.pEngine.getTimer().getsmoothratio(delta)) < 0.0f) && !(smoothratio > 65536.0f))) {
            smoothratio = Gameutils.BClipRange(smoothratio, 0.0f, 65536.0f);
        }
        this.game.pInt.dointerpolations(smoothratio);
        this.DrawWorld(smoothratio);
        if (this.gScreenCapture != null) {
            this.gScreenCapture.run();
            this.gScreenCapture = null;
        }
        this.DrawHud(smoothratio);
        this.game.pInt.restoreinterpolations();
        if (this.pMenu.gShowMenu) {
            this.pMenu.mDrawMenu();
        }
        this.PostFrame(this.pNet);
        this.pEngine.nextpage(delta);
    }

    public void capture(int width, int height) {
        Renderer renderer = this.game.getRenderer();
        this.gScreenCapture = () -> {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            renderer.screencapture(os, width, height, TileData.PixelFormat.Pal8);
            this.captBuffer = os.toByteArray();
        };
    }

    public boolean isScreenSaving() {
        return this.gScreenCapture != null;
    }

    @Override
    public void pause() {
        if (this.game.nNetMode == BuildGame.NetMode.Single && Mmulti.numplayers < 2) {
            this.game.gPaused = true;
            this.sndHandlePause(true);
        }
    }

    @Override
    public void resume() {
        if (this.game.nNetMode == BuildGame.NetMode.Single && Mmulti.numplayers < 2) {
            this.game.gPaused = false;
            this.pNet.ototalclock = this.game.pEngine.getTotalClock();
            this.sndHandlePause(this.game.gPaused);
        }
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (GameKeys.Show_Console.equals(gameKey)) {
            Console.out.onToggle();
            return true;
        }
        return false;
    }

    @Override
    public InputListener getInputListener() {
        if (Console.out.isShowing()) {
            return Console.out;
        }
        if (this.game.pMenu.isShowing()) {
            return this.game.pMenu;
        }
        return this;
    }
}

