/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.input.InputListener;

public abstract class LoadingAdapter
extends ScreenAdapter
implements InputListener {
    public BuildNet net;
    public Engine engine;
    protected Runnable toLoad;
    protected int frames;
    protected BuildGame game;
    protected MenuHandler menu;
    private String title;

    public LoadingAdapter(BuildGame game) {
        this.game = game;
        this.engine = game.pEngine;
        this.net = game.pNet;
        this.menu = game.pMenu;
    }

    @Override
    public void show() {
        this.game.getProcessor().resetPollingStates();
        this.net.ready2send = false;
        this.frames = 0;
    }

    @Override
    public void hide() {
        this.title = null;
    }

    public ScreenAdapter init(Runnable toLoad) {
        this.toLoad = toLoad;
        return this;
    }

    public ScreenAdapter setTitle(String title) {
        this.title = title;
        return this;
    }

    protected abstract void draw(String var1, float var2);

    @Override
    public void render(float delta) {
        this.game.getRenderer().clearview(0);
        this.draw(this.title, delta);
        if (this.toLoad != null && this.frames > 10) {
            Runnable runnable = this.toLoad;
            Gdx.app.postRunnable(() -> {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    this.game.softExceptionScreen(e);
                }
            });
            this.toLoad = null;
        }
        if (this.toLoad == null && this.frames > 100) {
            this.game.show();
            return;
        }
        this.engine.nextpage(delta);
        ++this.frames;
    }

    @Override
    public InputListener getInputListener() {
        return null;
    }
}

