/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.ScreenAdapter;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.GameKeys;

public abstract class MenuAdapter
extends ScreenAdapter
implements InputListener {
    protected BuildGame game;
    protected MenuHandler menu;
    protected Engine engine;
    protected GameConfig cfg;
    protected BuildMenu mainMenu;

    public MenuAdapter(BuildGame game, @NotNull BuildMenu mainMenu) {
        if (mainMenu == null) {
            MenuAdapter.$$$reportNull$$$0(0);
        }
        this.game = game;
        this.menu = game.pMenu;
        this.engine = game.pEngine;
        this.cfg = game.pCfg;
        this.mainMenu = mainMenu;
    }

    public abstract void draw(float var1);

    public void process(float delta) {
    }

    @Override
    public void render(float delta) {
        this.game.getRenderer().clearview(0);
        this.draw(delta);
        if (this.menu.gShowMenu) {
            this.menu.mDrawMenu();
        }
        this.process(delta);
        this.engine.nextpage(delta);
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (GameKeys.Show_Console.equals(gameKey)) {
            Console.out.onToggle();
            return true;
        }
        if (GameKeys.Menu_Toggle.equals(gameKey) && !this.menu.isShowing()) {
            this.game.pMenu.mOpen(this.mainMenu, -1);
            return true;
        }
        return false;
    }

    @Override
    public InputListener getInputListener() {
        if (Console.out.isShowing()) {
            return Console.out;
        }
        if (this.game.pMenu.isShowing()) {
            return this.game.pMenu;
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainMenu", "ru/m210projects/Build/Pattern/ScreenAdapters/MenuAdapter", "<init>"));
    }
}

