/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.controllers.Controller;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.settings.GameKeys;

public abstract class SkippableAdapter
extends ScreenAdapter
implements InputListener {
    protected BuildGame game;
    protected Engine engine;
    protected boolean escSkip;
    protected Runnable skipCallback;

    public SkippableAdapter(BuildGame game) {
        this.game = game;
        this.engine = game.pEngine;
    }

    public SkippableAdapter setSkipping(Runnable skipCallback) {
        this.skipCallback = skipCallback;
        return this;
    }

    public SkippableAdapter escSkipping(boolean escSkip) {
        this.escSkip = escSkip;
        return this;
    }

    public abstract void draw(float var1);

    public void skip() {
        if (this.skipCallback != null) {
            Gdx.app.postRunnable(this.skipCallback);
            this.skipCallback = null;
        }
    }

    @Override
    public final void render(float delta) {
        Renderer renderer = this.game.getRenderer();
        renderer.clearview(0);
        this.draw(delta);
        this.engine.nextpage(delta);
    }

    private boolean onSkipPressed(GameKey gameKey) {
        if (!this.escSkip || GameKeys.Menu_Toggle.equals(gameKey)) {
            this.skip();
            return true;
        }
        return false;
    }

    @Override
    public InputListener getInputListener() {
        return this;
    }

    @Override
    public void processInput(GameProcessor processor) {
        processor.prepareNext();
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        return this.onSkipPressed(gameKey);
    }

    @Override
    public boolean keyDown(int keycode) {
        if (!this.escSkip || keycode == 111) {
            this.skip();
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (!this.escSkip) {
            this.skip();
            return true;
        }
        return false;
    }

    @Override
    public boolean buttonDown(Controller controller, int buttonCode) {
        if (!this.escSkip) {
            this.skip();
            return true;
        }
        return false;
    }
}

