/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.Tools;

import com.badlogic.gdx.utils.Array;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.BitMap;
import ru.m210projects.Build.Types.collections.DynamicArray;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class Interpolation {
    protected final int MAXINTERPOLATIONS = 4096;
    protected Array<ILoc> gOldSpriteLoc = new DynamicArray<ILoc>(4096, ILoc.class);
    protected int InterpolationCount = 0;
    protected IData[] gInterpolationData = new IData[4096];
    protected BitMap gWallLoc = new BitMap(8192);
    protected int[] gFloorHeinumLoc = new int[Engine.MAXSECTORS >> 3];
    protected int[] gFloorLoc = new int[Engine.MAXSECTORS >> 3];
    protected int[] gCeilLoc = new int[Engine.MAXSECTORS >> 3];
    protected int[] gCeilHeinumLoc = new int[Engine.MAXSECTORS >> 3];
    protected BitMap gSpriteLoc = new BitMap(4096);

    public Interpolation() {
        for (int i = 0; i < 4096; ++i) {
            this.gInterpolationData[i] = new IData();
        }
    }

    protected void setinterpolation(Object obj, InterpolationType type) {
        if (this.InterpolationCount == 4096) {
            Console.out.println("Too many interpolations", OsdColor.RED);
            return;
        }
        IData data = this.gInterpolationData[this.InterpolationCount++];
        data.ptr = obj;
        data.type = type;
        switch (type.ordinal()) {
            case 0: {
                data.oldpos = ((Wall)obj).getX();
                break;
            }
            case 1: {
                data.oldpos = ((Wall)obj).getY();
                break;
            }
            case 2: {
                data.oldpos = ((Sector)obj).getFloorz();
                break;
            }
            case 3: {
                data.oldpos = ((Sector)obj).getCeilingz();
                break;
            }
            case 4: {
                data.oldpos = ((Sector)obj).getFloorheinum();
                break;
            }
            case 5: {
                data.oldpos = ((Sector)obj).getCeilingheinum();
            }
        }
    }

    protected void stopinterpolation(Object obj, InterpolationType type) {
        for (int i = this.InterpolationCount - 1; i >= 0; --i) {
            IData data = this.gInterpolationData[i];
            if (obj != data.ptr || data.type != type) continue;
            --this.InterpolationCount;
            this.gInterpolationData[i] = this.gInterpolationData[this.InterpolationCount];
        }
    }

    public void clearinterpolations() {
        this.InterpolationCount = 0;
        this.gWallLoc.clear();
        Arrays.fill(this.gFloorHeinumLoc, 0);
        Arrays.fill(this.gCeilHeinumLoc, 0);
        Arrays.fill(this.gFloorLoc, 0);
        Arrays.fill(this.gCeilLoc, 0);
        this.gSpriteLoc.clear();
    }

    public void dospriteinterp(Sprite tsp, int smoothratio) {
        ILoc oldLoc = this.getsprinterpolate(tsp.getOwner());
        if (oldLoc != null) {
            int x = oldLoc.x;
            int y = oldLoc.y;
            int z = oldLoc.z;
            short nAngle = oldLoc.ang;
            nAngle = (short)(nAngle + Pragmas.mulscale((tsp.getAng() - oldLoc.ang + 1024 & 0x7FF) - 1024, smoothratio, 16));
            tsp.setX(x += Pragmas.mulscale(tsp.getX() - oldLoc.x, smoothratio, 16));
            tsp.setY(y += Pragmas.mulscale(tsp.getY() - oldLoc.y, smoothratio, 16));
            tsp.setZ(z += Pragmas.mulscale(tsp.getZ() - oldLoc.z, smoothratio, 16));
            tsp.setAng(nAngle);
        }
    }

    public int getValue(IData obj) {
        switch (obj.type.ordinal()) {
            case 0: {
                return ((Wall)obj.ptr).getX();
            }
            case 1: {
                return ((Wall)obj.ptr).getY();
            }
            case 2: {
                return ((Sector)obj.ptr).getFloorz();
            }
            case 3: {
                return ((Sector)obj.ptr).getCeilingz();
            }
            case 4: {
                return ((Sector)obj.ptr).getFloorheinum();
            }
            case 5: {
                return ((Sector)obj.ptr).getCeilingheinum();
            }
        }
        return 0;
    }

    public void dointerpolations(float smoothratio) {
        block8: for (int i = 0; i < this.InterpolationCount; ++i) {
            IData gInt = this.gInterpolationData[i];
            Object obj = gInt.ptr;
            int value = gInt.bakpos = this.getValue(gInt);
            value = (int)((float)gInt.oldpos + (float)(value - gInt.oldpos) * smoothratio / 65536.0f);
            switch (gInt.type.ordinal()) {
                case 0: {
                    ((Wall)obj).setX(value);
                    continue block8;
                }
                case 1: {
                    ((Wall)obj).setY(value);
                    continue block8;
                }
                case 2: {
                    ((Sector)obj).setFloorz(value);
                    continue block8;
                }
                case 3: {
                    ((Sector)obj).setCeilingz(value);
                    continue block8;
                }
                case 4: {
                    ((Sector)obj).setFloorheinum((short)value);
                    continue block8;
                }
                case 5: {
                    ((Sector)obj).setCeilingheinum((short)value);
                }
            }
        }
    }

    public void restoreinterpolations() {
        block8: for (int i = 0; i < this.InterpolationCount; ++i) {
            IData gInt = this.gInterpolationData[i];
            Object obj = gInt.ptr;
            switch (gInt.type.ordinal()) {
                case 0: {
                    ((Wall)obj).setX(gInt.bakpos);
                    continue block8;
                }
                case 1: {
                    ((Wall)obj).setY(gInt.bakpos);
                    continue block8;
                }
                case 2: {
                    ((Sector)obj).setFloorz(gInt.bakpos);
                    continue block8;
                }
                case 3: {
                    ((Sector)obj).setCeilingz(gInt.bakpos);
                    continue block8;
                }
                case 4: {
                    ((Sector)obj).setFloorheinum((short)gInt.bakpos);
                    continue block8;
                }
                case 5: {
                    ((Sector)obj).setCeilingheinum((short)gInt.bakpos);
                }
            }
        }
    }

    public boolean setsprinterpolate(int nSprite, Sprite pSprite) {
        if (!this.gSpriteLoc.getBit(nSprite)) {
            ILoc pLocation = this.gOldSpriteLoc.get(nSprite);
            pLocation.x = pSprite.getX();
            pLocation.y = pSprite.getY();
            pLocation.z = pSprite.getZ();
            pLocation.ang = pSprite.getAng();
            this.gSpriteLoc.setBit(nSprite);
            return true;
        }
        return false;
    }

    public void clearspriteinterpolate(int nSprite) {
        this.gSpriteLoc.clearBit(nSprite);
    }

    public ILoc getsprinterpolate(int nSprite) {
        if (this.gSpriteLoc.getBit(nSprite)) {
            return this.gOldSpriteLoc.get(nSprite);
        }
        return null;
    }

    public void setwallinterpolate(int nWall, Wall pWall) {
        if (!this.gWallLoc.getBit(nWall)) {
            this.setinterpolation(pWall, InterpolationType.WallX);
            this.setinterpolation(pWall, InterpolationType.WallY);
            this.gWallLoc.setBit(nWall);
        }
    }

    public void clearwallinterpolate(int nWall, Wall pWall) {
        if (this.gWallLoc.getBit(nWall)) {
            this.stopinterpolation(pWall, InterpolationType.WallX);
            this.stopinterpolation(pWall, InterpolationType.WallY);
            this.gWallLoc.clearBit(nWall);
        }
    }

    public void setfheinuminterpolate(int nSector, Sector pSector) {
        if ((this.gFloorHeinumLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) == 0) {
            this.setinterpolation(pSector, InterpolationType.FloorH);
            int n = nSector >> 3;
            this.gFloorHeinumLoc[n] = this.gFloorHeinumLoc[n] | Engine.pow2char[nSector & 7];
        }
    }

    public void clearfheinuminterpolate(int nSector, Sector pSector) {
        if ((this.gFloorHeinumLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) != 0) {
            this.stopinterpolation(pSector, InterpolationType.FloorH);
            int n = nSector >> 3;
            this.gFloorHeinumLoc[n] = this.gFloorHeinumLoc[n] & ~Engine.pow2char[nSector & 7];
        }
    }

    public void setcheinuminterpolate(int nSector, Sector pSector) {
        if ((this.gCeilHeinumLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) == 0) {
            this.setinterpolation(pSector, InterpolationType.CeilH);
            int n = nSector >> 3;
            this.gCeilHeinumLoc[n] = this.gCeilHeinumLoc[n] | Engine.pow2char[nSector & 7];
        }
    }

    public void clearcheinuminterpolate(int nSector, Sector pSector) {
        if ((this.gCeilHeinumLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) != 0) {
            this.stopinterpolation(pSector, InterpolationType.CeilH);
            int n = nSector >> 3;
            this.gCeilHeinumLoc[n] = this.gCeilHeinumLoc[n] & ~Engine.pow2char[nSector & 7];
        }
    }

    public boolean setfloorinterpolate(int nSector, Sector pSector) {
        if ((this.gFloorLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) == 0) {
            this.setinterpolation(pSector, InterpolationType.FloorZ);
            int n = nSector >> 3;
            this.gFloorLoc[n] = this.gFloorLoc[n] | Engine.pow2char[nSector & 7];
            return true;
        }
        return false;
    }

    public void clearfloorinterpolate(int nSector, Sector pSector) {
        if ((this.gFloorLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) != 0) {
            this.stopinterpolation(pSector, InterpolationType.FloorZ);
            int n = nSector >> 3;
            this.gFloorLoc[n] = this.gFloorLoc[n] & ~Engine.pow2char[nSector & 7];
        }
    }

    public boolean setceilinterpolate(int nSector, Sector pSector) {
        if ((this.gCeilLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) == 0) {
            this.setinterpolation(pSector, InterpolationType.CeilZ);
            int n = nSector >> 3;
            this.gCeilLoc[n] = this.gCeilLoc[n] | Engine.pow2char[nSector & 7];
            return true;
        }
        return false;
    }

    public void clearceilinterpolate(int nSector, Sector pSector) {
        if ((this.gCeilLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) != 0) {
            this.stopinterpolation(pSector, InterpolationType.CeilZ);
            int n = nSector >> 3;
            this.gCeilLoc[n] = this.gCeilLoc[n] & ~Engine.pow2char[nSector & 7];
        }
    }

    public static class ILoc {
        public int x;
        public int y;
        public int z;
        public short ang;
    }

    public static class IData {
        public Object ptr;
        public InterpolationType type;
        public int oldpos;
        public int bakpos;
    }

    public static enum InterpolationType {
        WallX,
        WallY,
        FloorZ,
        CeilZ,
        FloorH,
        CeilH;

    }
}

