/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.ClipInfo;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.IntSet;

public class PushMover {
    private final ClipInfo info;
    private final Engine engine;
    private final IntSet sectorSet;

    public PushMover(Engine engine) {
        this.engine = engine;
        this.info = new ClipInfo();
        this.sectorSet = new IntSet(Engine.MAXSECTORS);
    }

    public int move(int x, int y, int z, int sectnum, int walldist, int ceildist, int flordist, int cliptype) {
        int bad;
        this.info.set(x, y, z, sectnum);
        BoardService service = this.engine.getBoardService();
        if (!service.isValidSector(sectnum)) {
            return -1;
        }
        int k = 32;
        int dir = 1;
        int dawalclipmask = cliptype & 0xFFFF;
        do {
            bad = 0;
            this.sectorSet.clear();
            this.sectorSet.addValue(sectnum);
            for (int dacnt = 0; dacnt < this.sectorSet.size(); ++dacnt) {
                int dasect = this.sectorSet.getValue(dacnt);
                Sector sec = service.getSector(dasect);
                if (sec == null) continue;
                int startwall = dir > 0 ? sec.getWallptr() : sec.getWallptr() + sec.getWallnum();
                int endwall = dir > 0 ? sec.getWallptr() + sec.getWallnum() : sec.getWallptr();
                for (int i = startwall; i != endwall; i += dir) {
                    Wall wal = service.getWall(i);
                    if (wal == null || this.engine.clipInsideBox(x, y, i, walldist - 4) != 1) continue;
                    int j = 0;
                    Wall wal2 = service.getNextWall(wal);
                    if (wal.getNextsector() < 0 || (wal.getCstat() & dawalclipmask) != 0) {
                        j = 1;
                    }
                    if (j == 0) {
                        int daz2;
                        Sector sec2 = service.getSector(wal.getNextsector());
                        if (sec2 == null) continue;
                        int dax = wal2.getX() - wal.getX();
                        int day = wal2.getY() - wal.getY();
                        int daz = dax * (x - wal.getX()) + day * (y - wal.getY());
                        int t = 0;
                        if (daz > 0) {
                            daz2 = dax * dax + day * day;
                            t = daz >= daz2 ? 0x40000000 : Pragmas.divscale(daz, daz2, 30);
                        }
                        dax = wal.getX() + Pragmas.mulscale(dax, t, 30);
                        day = wal.getY() + Pragmas.mulscale(day, t, 30);
                        daz = service.getflorzofslope(sec, dax, day);
                        daz2 = service.getflorzofslope(sec2, dax, day);
                        if (daz2 < daz - 256 && (sec2.getFloorstat() & 1) == 0 && z >= daz2 - (flordist - 1)) {
                            j = 1;
                        }
                        daz = service.getceilzofslope(sec, dax, day);
                        daz2 = service.getceilzofslope(sec2, dax, day);
                        if (daz2 > daz + 256 && (sec2.getCeilingstat() & 1) == 0 && z <= daz2 + (ceildist - 1)) {
                            j = 1;
                        }
                    }
                    if (j != 0) {
                        j = EngineUtils.getAngle(wal2.getX() - wal.getX(), wal2.getY() - wal.getY());
                        int dx = EngineUtils.cos(j + 512) >> 11;
                        int dy = EngineUtils.sin(j + 512) >> 11;
                        int bad2 = 16;
                        while (--bad2 != 0 && this.engine.clipInsideBox(x += dx, y += dy, i, walldist - 4) != 0) {
                        }
                        bad = -1;
                        if (--k <= 0) {
                            this.info.set(x, y, z, sectnum);
                            return bad;
                        }
                        if ((sectnum = service.updatesector(x, y, sectnum)) >= 0) continue;
                        this.info.set(x, y, z, sectnum);
                        return -1;
                    }
                    this.sectorSet.addValue(wal.getNextsector());
                }
            }
            dir = -dir;
        } while (bad != 0);
        this.info.set(x, y, z, sectnum);
        return bad;
    }

    public ClipInfo getInfo() {
        return this.info;
    }
}

