/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class GLInfo {
    public static String version;
    public static float maxanisotropy;
    public static boolean bgra;
    public static byte texcompr;
    public static byte texnpot;
    public static byte multisample;
    public static byte nvmultisamplehint;
    public static byte multitex;
    public static byte envcombine;
    public static byte vbos;
    public static boolean hack_nofog;
    public static boolean supportsGenerateMipmaps;
    public static int gltexmaxsize;

    public static void init(GL20 gl) {
        int i;
        gl.glEnable(3553);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.5f);
        gl.glDisable(3024);
        version = gl.glGetString(7938);
        maxanisotropy = 1.0f;
        bgra = false;
        texcompr = 0;
        gltexmaxsize = 0;
        if (Gdx.graphics.supportsExtension("GL_EXT_texture_filter_anisotropic")) {
            FloatBuffer buf = BufferUtils.newFloatBuffer(16);
            gl.glGetFloatv(34047, buf);
            maxanisotropy = buf.get();
        }
        if (Gdx.graphics.supportsExtension("GL_EXT_bgra")) {
            bgra = true;
        }
        if (Gdx.graphics.supportsExtension("GL_ARB_texture_compression")) {
            texcompr = 1;
        }
        if (Gdx.graphics.supportsExtension("GL_ARB_texture_non_power_of_two")) {
            // empty if block
        }
        if (Gdx.graphics.supportsExtension("WGL_3DFX_gamma_control")) {
            hack_nofog = true;
        }
        if (Gdx.graphics.supportsExtension("GL_ARB_multisample")) {
            multisample = 1;
        }
        if (Gdx.graphics.supportsExtension("GL_NV_multisample_filter_hint")) {
            nvmultisamplehint = 1;
        }
        if (Gdx.graphics.supportsExtension("GL_ARB_multitexture")) {
            multitex = 1;
        }
        if (Gdx.graphics.supportsExtension("GL_ARB_texture_env_combine")) {
            envcombine = 1;
        }
        if (Gdx.graphics.supportsExtension("GL_ARB_vertex_buffer_object")) {
            vbos = 1;
        }
        if (Gdx.graphics.supportsExtension("GL_ARB_framebuffer_object") || Gdx.graphics.supportsExtension("GL_EXT_framebuffer_object") || Gdx.gl30 != null || Gdx.app.getType() == Application.ApplicationType.Android || Gdx.app.getType() == Application.ApplicationType.WebGL || Gdx.app.getType() == Application.ApplicationType.iOS) {
            supportsGenerateMipmaps = true;
        }
        IntBuffer textureSize = BufferUtils.newIntBuffer(16);
        gl.glGetIntegerv(3379, textureSize);
        if (i == 0) {
            gltexmaxsize = 6;
        } else {
            gltexmaxsize = 0;
            for (i = textureSize.get(); i > 1; i >>= 1) {
                ++gltexmaxsize;
            }
        }
    }

    public static float getMaxAnisotropicFilterLevel() {
        return maxanisotropy;
    }

    public static int calcSize(int size) {
        if (texnpot == 0) {
            int nsize;
            for (nsize = 1; nsize < size; nsize *= 2) {
            }
            return nsize;
        }
        return size == 0 ? 1 : size;
    }
}

