/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Frustum;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import ru.m210projects.Build.Gameutils;

public class BuildCamera
extends PerspectiveCamera {
    public final Frustum frustum;
    public final float xscale;
    public final float yscale;
    private final Vector3 tmp = new Vector3();
    private final Vector3 projectorX = new Vector3();
    private final Vector3 projectorY = new Vector3();
    private float halfwidth;
    private float halfheight;
    private float divhalfw;
    private float divhalfh;

    public BuildCamera(float fov, int width, int height, final float xscale, final float yscale) {
        this.setFieldOfView(fov);
        this.viewportWidth = width;
        this.viewportHeight = height;
        this.frustum = new Frustum(this){
            final /* synthetic */ BuildCamera this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void update(Matrix4 inverseProjectionView) {
                System.arraycopy(clipSpacePlanePointsArray, 0, this.planePointsArray, 0, clipSpacePlanePointsArray.length);
                Matrix4.prj(inverseProjectionView.val, this.planePointsArray, 0, 8, 3);
                int j = 0;
                for (int i = 0; i < 8; ++i) {
                    Vector3 v = this.planePoints[i];
                    v.x = this.planePointsArray[j++] * xscale;
                    v.y = this.planePointsArray[j++] * xscale;
                    v.z = this.planePointsArray[j++] * yscale;
                }
                this.set(this.planes[0], this.planePoints[1], this.planePoints[0], this.planePoints[2]);
                this.set(this.planes[1], this.planePoints[4], this.planePoints[5], this.planePoints[7]);
                this.set(this.planes[2], this.planePoints[0], this.planePoints[4], this.planePoints[3]);
                this.set(this.planes[3], this.planePoints[5], this.planePoints[1], this.planePoints[6]);
                this.set(this.planes[4], this.planePoints[2], this.planePoints[3], this.planePoints[6]);
                this.set(this.planes[5], this.planePoints[4], this.planePoints[0], this.planePoints[1]);
            }

            private void set(Plane p, Vector3 pos, Vector3 p1, Vector3 p2) {
                p.normal.set(pos).sub(p1).crs(p1.x - p2.x, p1.y - p2.y, p1.z - p2.z);
                p.d = -p.normal.dot(pos);
            }
        };
        this.xscale = xscale;
        this.yscale = yscale;
        this.rotate(-90.0f, 1.0f, 0.0f, 0.0f);
        this.up.set(0.0f, 0.0f, -1.0f);
        this.near = 0.01f;
        this.far = 400.0f;
        this.update();
    }

    public void setPosition(int x, int y, int z) {
        this.position.set((float)x / this.xscale, (float)y / this.xscale, (float)z / this.yscale);
    }

    public float getX() {
        return this.position.x * this.xscale;
    }

    public float getY() {
        return this.position.y * this.xscale;
    }

    public float getZ() {
        return this.position.z * this.yscale;
    }

    public float getAngle() {
        float angle = MathUtils.atan2(this.direction.y, this.direction.x);
        if (angle < 0.0f) {
            angle += (float)Math.PI * 2;
        }
        return Gameutils.BClampAngle(angle * 325.9493f);
    }

    public void setDirection(double ang, double horiz, double tilt) {
        float yaw = (float)Gameutils.AngleToRadians(ang);
        float gcosang = MathUtils.cos(yaw);
        float gsinang = MathUtils.sin(yaw);
        float pitch = -MathUtils.atan2((float)horiz, 128.0f);
        float gchang = MathUtils.cos(pitch);
        float gshang = MathUtils.sin(pitch);
        this.direction.set(gcosang * gchang, gsinang * gchang, gshang);
        this.direction.nor();
        this.up.set(0.0f, 0.0f, -1.0f);
        this.up.rotate(this.direction, (float)(-tilt));
    }

    public void setDirection(Vector3 dir, double tilt) {
        this.direction.set(dir);
        this.direction.nor();
        this.up.set(0.0f, 0.0f, -1.0f);
        this.up.rotate(this.direction, (float)(-tilt));
    }

    public void setDirection(float dirx, float diry, float dirz, double tilt) {
        this.direction.set(dirx, diry, dirz);
        this.direction.nor();
        this.up.set(0.0f, 0.0f, -1.0f);
        this.up.rotate(this.direction, (float)(-tilt));
    }

    public boolean polyInCamera(ArrayList<? extends Vector3> list) {
        if (list == null) {
            return false;
        }
        Plane[] planes = this.frustum.planes;
        block0: for (int i = 2; i < planes.length; ++i) {
            Plane plane = planes[i];
            for (int p = 0; p < list.size(); ++p) {
                if (plane.testPoint(list.get(p)) != Plane.PlaneSide.Back) continue block0;
            }
            return false;
        }
        return true;
    }

    public void setFieldOfView(float fov) {
        float aspect = 1.3333334f;
        this.fieldOfView = (float)Math.toDegrees(2.0 * Math.atan(Math.tan(Math.toRadians(fov / 2.0f)) / (double)aspect));
    }

    @Override
    public void update(boolean updateFrustum) {
        float aspect = this.viewportWidth / this.viewportHeight;
        this.projection.setToProjection(Math.abs(this.near), Math.abs(this.far), this.fieldOfView, aspect);
        this.view.setToLookAt(this.position, this.tmp.set(this.position).add(this.direction), this.up);
        this.combined.set(this.projection);
        Matrix4.mul(this.combined.val, this.view.val);
        if (updateFrustum) {
            this.invProjectionView.set(this.combined);
            Matrix4.inv(this.invProjectionView.val);
            this.frustum.update(this.invProjectionView);
            float[] mat = this.combined.val;
            this.projectorX.set(mat[0], mat[4], mat[8]);
            this.projectorY.set(-mat[1], -mat[5], -mat[9]);
            this.halfwidth = this.viewportWidth / 2.0f;
            this.halfheight = this.viewportHeight / 2.0f;
            this.divhalfw = 1.0f / this.halfwidth;
            this.divhalfh = 1.0f / this.halfheight;
        }
    }

    @Override
    public Vector3 project(Vector3 worldCoords) {
        worldCoords.scl(1.0f / this.xscale, 1.0f / this.xscale, 1.0f / this.yscale);
        float dx = worldCoords.x - this.position.x;
        float dy = worldCoords.y - this.position.y;
        float dz = worldCoords.z - this.position.z;
        float l_w = 1.0f / this.direction.dot(dx, dy, dz);
        worldCoords.x = this.projectorX.dot(dx, dy, dz) * l_w;
        worldCoords.y = this.projectorY.dot(dx, dy, dz) * l_w;
        worldCoords.x = this.halfwidth * (worldCoords.x + 1.0f);
        worldCoords.y = this.halfheight * (worldCoords.y + 1.0f);
        return worldCoords;
    }

    @Override
    public Vector3 unproject(Vector3 screenCoords) {
        float x = screenCoords.x;
        float y = this.viewportHeight - screenCoords.y;
        screenCoords.x = x * this.divhalfw - 1.0f;
        screenCoords.y = y * this.divhalfh - 1.0f;
        screenCoords.z = 1.0f;
        screenCoords.prj(this.invProjectionView);
        screenCoords.scl(this.xscale, this.xscale, this.yscale);
        return screenCoords;
    }
}

