/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.NumberUtils;
import java.nio.ByteBuffer;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.GDXRenderer;
import ru.m210projects.Build.Render.GdxRender.Shaders.ShaderManager;
import ru.m210projects.Build.Render.GdxRender.WorldMesh;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.OrphoRenderer;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.Render.TextureHandle.DummyTileData;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.IndexedShader;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.Color;
import ru.m210projects.Build.Render.Types.Hudtyp;
import ru.m210projects.Build.Render.Types.Tile2model;
import ru.m210projects.Build.Types.AnimType;
import ru.m210projects.Build.Types.Palette;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.AtlasCharInfo;
import ru.m210projects.Build.Types.font.BitmapFont;
import ru.m210projects.Build.Types.font.CharInfo;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.FontType;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.net.Mmulti;

public class GDXOrtho
extends OrphoRenderer {
    protected final float[] vertices;
    protected final Matrix4 projectionMatrix = new Matrix4();
    protected final GDXRenderer parent;
    private final BoardService boardService;
    private final int maxSpriteCount = 128;
    protected Mesh mesh;
    protected Mesh linesMesh;
    protected int idx = 0;
    protected GLTile lastTexture = null;
    protected GLTile lineTile = null;
    protected int lastType = 4;
    protected float invTexWidth = 0.0f;
    protected float invTexHeight = 0.0f;
    protected boolean drawing = false;
    protected boolean blendingDisabled = false;
    protected float color = com.badlogic.gdx.graphics.Color.WHITE_FLOAT_BITS;
    protected int cx1;
    protected int cy1;
    protected int cx2;
    protected int cy2;
    protected ShaderManager manager;
    private Sprite hudsprite;

    public GDXOrtho(GDXRenderer parent, IOverheadMapSettings settings) {
        super(parent, settings);
        this.parent = parent;
        this.manager = parent.manager;
        this.boardService = parent.getEngine().getBoardService();
        int VERTEX_SIZE = 5;
        int SPRITE_SIZE = 4 * VERTEX_SIZE;
        this.vertices = new float[128 * SPRITE_SIZE];
    }

    @Override
    public void init() {
        int size = 128;
        this.mesh = new Mesh(false, size * 4, size * 6, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.linesMesh = new Mesh(false, size * 2, 0, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"));
        this.resize(this.xdim, this.ydim);
        int len = size * 6;
        short[] indices = new short[len];
        short j = 0;
        int i = 0;
        while (i < len) {
            indices[i] = j;
            indices[i + 1] = (short)(j + 1);
            indices[i + 2] = (short)(j + 2);
            indices[i + 3] = (short)(j + 2);
            indices[i + 4] = (short)(j + 3);
            indices[i + 5] = j;
            i += 6;
            j = (short)(j + 4);
        }
        this.mesh.setIndices(indices);
        this.lineTile = this.allocLineTile();
    }

    @Override
    public void uninit() {
        if (this.mesh != null) {
            this.mesh.dispose();
        }
        if (this.linesMesh != null) {
            this.linesMesh.dispose();
        }
        if (this.lineTile != null) {
            this.lineTile.dispose();
        }
        this.idx = 0;
        this.drawing = false;
    }

    @Override
    public int printext(Font font, int xpos, int ypos, char[] text, float scale, int shade, int col, TextAlign textAlign, Transparent transparent, boolean shadow) {
        if (font == null || text == null || text.length == 0) {
            return 0;
        }
        if (col < 0) {
            return 0;
        }
        if (shadow) {
            this.printext(font, xpos + (int)scale, ypos + (int)scale, text, scale, 127, col, textAlign, transparent, false);
        }
        float scaleyf = scale;
        if (font.isVerticalScaled()) {
            scaleyf *= 1.2f;
        }
        int alignx = 0;
        if (textAlign != TextAlign.Left) {
            int width = 0;
            for (int pos = 0; pos < text.length && text[pos] != '\u0000'; ++pos) {
                CharInfo charInfo = font.getCharInfo(text[pos]);
                width += (int)((float)charInfo.getCellSize() * scale);
            }
            if (textAlign == TextAlign.Center) {
                width >>= 1;
            }
            xpos -= width;
        }
        this.parent.globalpal = col;
        this.parent.globalshade = shade;
        Gdx.gl.glDisable(2884);
        Gdx.gl.glDisable(2929);
        this.setType(4);
        this.setViewport(0, 0, this.xdim - 1, this.ydim - 1);
        GLTile pth = null;
        int currentTile = -1;
        int numshades = this.parent.getPaletteManager().getShadeCount();
        for (int c = 0; c < text.length && text[c] != '\u0000'; ++c) {
            CharInfo charInfo = font.getCharInfo(text[c]);
            int tile = charInfo.tile;
            float cellsizx = scale * (float)charInfo.getCellSize();
            if (tile != -1) {
                float ty2;
                float tx2;
                float ty1;
                float tx1;
                int charsizex = (int)(scale * (float)charInfo.getWidth());
                int charsizey = (int)(scaleyf * (float)charInfo.getHeight());
                int xoffset = (int)(scale * (float)charInfo.xOffset);
                int yoffset = (int)(scaleyf * (float)charInfo.yOffset);
                if (currentTile != tile) {
                    this.flush();
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    if (charInfo.getFontType() == FontType.BITMAP_FONT) {
                        pth = this.parent.textureCache.getBitmapFontAtlas((BitmapFont)charInfo.getParent());
                        this.parent.textureCache.bind(pth);
                        Palette curpalette = this.parent.getPaletteManager().getCurrentPalette();
                        col = this.parent.getPaletteManager().getColorIndex(0, col, shade);
                        r = (float)curpalette.getRed(col) / 255.0f;
                        g = (float)curpalette.getGreen(col) / 255.0f;
                        b = (float)curpalette.getBlue(col) / 255.0f;
                    } else {
                        ArtEntry charTile;
                        if (!this.parent.getPaletteManager().isValidPalette(col)) {
                            col = 0;
                        }
                        if (!(charTile = this.parent.getTile(tile)).exists()) {
                            currentTile = -1;
                            continue;
                        }
                        pth = this.parent.bind(charTile, col, shade, 0, 4);
                        if (pth.getPixelFormat() != TileData.PixelFormat.Pal8) {
                            float sh;
                            g = b = (sh = (float)(numshades - Math.min(Math.max(shade, 0), numshades)) / (float)numshades);
                            r = b;
                        }
                    }
                    if (pth == null) {
                        currentTile = -1;
                        continue;
                    }
                    currentTile = tile;
                    this.switchOrphoShader(this.getShader(pth));
                    this.switchTexture(pth);
                    float alpha = 1.0f;
                    if (transparent == Transparent.Bit1) {
                        alpha = this.parent.TRANSLUSCENT1;
                    }
                    if (transparent == Transparent.Bit2) {
                        alpha = this.parent.TRANSLUSCENT2;
                    }
                    if (pth.getPixelFormat() == TileData.PixelFormat.Pal8) {
                        this.switchTextureParams(col, shade, alpha, false);
                    } else {
                        this.setColor(r, g, b, alpha);
                    }
                    this.enableBlending();
                }
                int vx1 = xpos + xoffset;
                int vy1 = ypos + yoffset;
                int vx2 = vx1 + charsizex;
                int vy2 = vy1 + charsizey;
                if (charInfo instanceof AtlasCharInfo) {
                    AtlasCharInfo atlasCharInfo = (AtlasCharInfo)charInfo;
                    tx1 = atlasCharInfo.getTx1();
                    ty1 = atlasCharInfo.getTy1();
                    tx2 = atlasCharInfo.getTx2();
                    ty2 = atlasCharInfo.getTy2();
                } else {
                    tx1 = 0.0f;
                    ty1 = 0.0f;
                    float tileScale = charInfo.getTileScale();
                    float tsizx = pth.getWidth();
                    float tsizy = pth.getHeight();
                    if (pth.isHighTile()) {
                        tsizx = (float)pth.getWidth() / pth.getXScale();
                        tsizy = (float)GLInfo.calcSize(pth.getHeight()) / pth.getYScale();
                    }
                    tx2 = (float)charInfo.getWidth() / (tsizx * tileScale);
                    ty2 = (float)charInfo.getHeight() / (tsizy * tileScale);
                }
                float color = this.color;
                this.addVertex(vx1, vy1, color, tx1, ty1);
                this.addVertex(vx1, vy2, color, tx1, ty2);
                this.addVertex(vx2, vy2, color, tx2, ty2);
                this.addVertex(vx2, vy1, color, tx2, ty1);
                if (this.idx == this.vertices.length) {
                    this.flush();
                }
            }
            xpos += (int)cellsizx;
            alignx += (int)cellsizx;
        }
        Gdx.gl.glDepthMask(true);
        return (int)((float)alignx / scale);
    }

    private void addVertex(float vx, float vy, float color, float tx, float ty) {
        this.vertices[this.idx++] = vx;
        this.vertices[this.idx++] = vy;
        this.vertices[this.idx++] = color;
        this.vertices[this.idx++] = tx;
        this.vertices[this.idx++] = ty;
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int col) {
        float sx1 = (float)x1 / 4096.0f;
        float sy1 = (float)y1 / 4096.0f;
        float sx2 = (float)x2 / 4096.0f;
        float sy2 = (float)y2 / 4096.0f;
        if (sx1 < 0.0f && sx2 < 0.0f || sx1 > (float)this.xdim && sx2 > (float)this.xdim) {
            return;
        }
        if (sy1 < 0.0f && sy2 < 0.0f || sy1 > (float)this.ydim && sy2 > (float)this.ydim) {
            return;
        }
        byte[][] palookup = this.parent.getPaletteManager().getPalookupBuffer();
        col = palookup[0][col] & 0xFF;
        Gdx.gl.glDisable(2884);
        Gdx.gl.glDisable(2929);
        this.setType(1);
        this.switchOrphoShader(ShaderManager.Shader.BitmapShader);
        this.switchTexture(this.lineTile);
        Palette curpalette = this.parent.getPaletteManager().getCurrentPalette();
        this.setColor((float)curpalette.getRed(col) / 255.0f, (float)curpalette.getGreen(col) / 255.0f, (float)curpalette.getBlue(col) / 255.0f, 1.0f);
        this.disableBlending();
        if (this.idx >= 256) {
            this.flush();
        }
        float color = this.color;
        int idx = this.idx;
        float[] vertices = this.vertices;
        vertices[idx + 0] = sx1;
        vertices[idx + 1] = sy1;
        vertices[idx + 2] = color;
        vertices[idx + 3] = sx2;
        vertices[idx + 4] = sy2;
        vertices[idx + 5] = color;
        this.idx = idx + 6;
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        PaletteManager paletteManager;
        ArtEntry pic;
        if (!Gameutils.isValidTile(picnum)) {
            return;
        }
        if (cx1 > cx2 || cy1 > cy2) {
            return;
        }
        if (z <= 16) {
            return;
        }
        if (this.parent.getConfig().isUseModels() && this.parent.defs != null && this.parent.defs.mdInfo.getHudInfo(picnum, dastat) != null && this.parent.defs.mdInfo.getHudInfo((int)picnum, (int)dastat).angadd != 0) {
            Tile2model entry;
            Tile2model tile2model = entry = this.parent.defs != null ? this.parent.defs.mdInfo.getParams(picnum) : null;
            if (entry != null && entry.model != null && entry.framenum >= 0 && this.dorotatesprite3d(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2)) {
                return;
            }
        }
        if (this.parent.getTile(picnum).getType() != AnimType.NONE) {
            picnum += this.parent.animateoffs(picnum, 0);
        }
        if (!(pic = this.parent.getTile(picnum)).hasSize()) {
            return;
        }
        int method = 0;
        if ((dastat & 0x40) == 0) {
            method = 1;
            if ((dastat & 1) != 0) {
                method = (dastat & 0x20) == 0 ? 2 : 3;
            }
        } else {
            method |= 0x100;
        }
        method |= 4;
        int xsiz = pic.getWidth();
        int ysiz = pic.getHeight();
        int xoff = 0;
        int yoff = 0;
        if ((dastat & 0x10) == 0) {
            xoff = pic.getOffsetX() + (xsiz >> 1);
            yoff = pic.getOffsetY() + (ysiz >> 1);
        }
        if ((dastat & 4) != 0) {
            yoff = ysiz - yoff;
        }
        if (!(paletteManager = this.parent.getPaletteManager()).isValidPalette(dapalnum & 0xFF)) {
            dapalnum = 0;
        }
        this.parent.setgotpic(picnum);
        GLTile pth = this.parent.textureCache.get(this.parent.getTexFormat(), pic, dapalnum, 0, method);
        if (pth == null) {
            return;
        }
        pth.bind();
        if ((method & 3) == 0) {
            this.disableBlending();
        } else {
            this.enableBlending();
        }
        float alpha = 1.0f;
        switch (method & 3) {
            case 2: {
                alpha = this.parent.TRANSLUSCENT1;
                break;
            }
            case 3: {
                alpha = this.parent.TRANSLUSCENT2;
            }
        }
        Gdx.gl.glDisable(2884);
        Gdx.gl.glDisable(2929);
        ShaderManager.Shader shader = pth.getPixelFormat() != TileData.PixelFormat.Pal8 ? ShaderManager.Shader.RGBWorldShader : ShaderManager.Shader.IndexedWorldShader;
        this.switchOrphoShader(shader);
        this.setType(4);
        this.setViewport(cx1, cy1, cx2, cy2);
        if (pth.getPixelFormat() != TileData.PixelFormat.Pal8) {
            float shade;
            int numshades = paletteManager.getShadeCount();
            float r = shade = (float)(numshades - Math.min(Math.max(dashade, 0), numshades)) / (float)numshades;
            float g = shade;
            float b = shade;
            if (pth.isHighTile() && this.parent.defs != null && this.parent.defs.texInfo != null) {
                if (pth.getPal() != dapalnum) {
                    Color p = this.parent.defs.texInfo.getTints(dapalnum);
                    r *= (float)p.r / 255.0f;
                    g *= (float)p.g / 255.0f;
                    b *= (float)p.b / 255.0f;
                }
                Color pdetail = this.parent.defs.texInfo.getTints(255);
                if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                    r *= (float)pdetail.r / 255.0f;
                    g *= (float)pdetail.g / 255.0f;
                    b *= (float)pdetail.b / 255.0f;
                }
            }
            this.setColor(r, g, b, alpha);
        } else {
            this.switchTextureParams(dapalnum, dashade, alpha, this.blendingDisabled || (method & 0x100) != 0);
        }
        this.draw(pth, sx, sy, xsiz, ysiz, xoff, yoff, a, z, dastat, cx1, cy1, cx2, cy2);
    }

    protected ShaderManager.Shader getShader(GLTile glTile) {
        switch (glTile.getPixelFormat()) {
            case Pal8: {
                return ShaderManager.Shader.IndexedWorldShader;
            }
            case Bitmap: {
                return ShaderManager.Shader.BitmapShader;
            }
        }
        return ShaderManager.Shader.RGBWorldShader;
    }

    public boolean dorotatesprite3d(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        Hudtyp hudInfo;
        if (this.parent.defs == null || (hudInfo = this.parent.defs.mdInfo.getHudInfo(picnum, dastat)) != null && (hudInfo.flags & 1) != 0) {
            return true;
        }
        if (this.isDrawing()) {
            this.end();
        }
        float yaw = (float)Gameutils.AngleToRadians(this.parent.globalang);
        float gcosang = MathUtils.cos(yaw);
        float gsinang = MathUtils.sin(yaw);
        float x1 = hudInfo.xadd;
        float y1 = hudInfo.yadd;
        float z1 = hudInfo.zadd;
        if ((hudInfo.flags & 2) == 0) {
            float fx = (float)sx * 1.5258789E-5f;
            float fy = (float)sy * 1.5258789E-5f;
            if ((dastat & 0x10) != 0) {
                float sinang;
                float cosang;
                ArtEntry pic = this.parent.getTile(picnum);
                int xsiz = pic.getWidth();
                int ysiz = pic.getHeight();
                int xoff = pic.getOffsetX() + (xsiz >> 1);
                int yoff = pic.getOffsetY() + (ysiz >> 1);
                float d = (float)z / 1.0737418E9f;
                float cosang2 = cosang = (float)EngineUtils.cos(a) * d;
                float sinang2 = sinang = (float)EngineUtils.sin(a) * d;
                if ((dastat & 2) != 0 || (dastat & 8) == 0) {
                    d = (float)this.parent.xyaspect / 65536.0f;
                    cosang2 *= d;
                    sinang2 *= d;
                }
                fx += (float)(-xoff) * cosang2 + (float)yoff * sinang2;
                fy += (float)(-xoff) * sinang - (float)yoff * cosang;
            }
            if ((dastat & 2) == 0) {
                x1 += fx / (float)(this.xdim << 15) - 1.0f;
                y1 += fy / (float)(this.ydim << 15) - 1.0f;
            } else {
                x1 += fx / 160.0f - 1.0f;
                y1 += fy / 100.0f - 1.0f;
            }
        }
        if ((dastat & 4) != 0) {
            x1 = -x1;
            y1 = -y1;
        }
        if (this.hudsprite == null) {
            this.hudsprite = new Sprite();
        }
        this.hudsprite.reset((byte)0);
        this.hudsprite.setAng((short)((float)hudInfo.angadd + this.parent.globalang));
        this.hudsprite.setXrepeat(32);
        this.hudsprite.setYrepeat(32);
        this.hudsprite.setX((int)((gcosang * z1 - gsinang * x1) * 800.0f + (float)this.parent.globalposx));
        this.hudsprite.setY((int)((gsinang * z1 + gcosang * x1) * 800.0f + (float)this.parent.globalposy));
        this.hudsprite.setZ((int)((float)this.parent.globalposz + y1 * 16384.0f * 0.8f));
        this.hudsprite.setPicnum((short)picnum);
        this.hudsprite.setShade((byte)dashade);
        this.hudsprite.setPal((short)dapalnum);
        this.hudsprite.setOwner(this.boardService.getSpriteCount());
        this.hudsprite.setCstat((short)((dastat & 1) + ((dastat & 0x20) << 4) + (dastat & 4) << 1));
        if ((dastat & 0xA) == 2) {
            this.parent.resizeglcheck();
        } else {
            this.parent.set2dview();
        }
        if ((hudInfo.flags & 8) != 0) {
            Gdx.gl.glDisable(2929);
        } else {
            Gdx.gl.glEnable(2929);
            Gdx.gl.glClear(256);
        }
        BuildCamera cam = this.parent.cam;
        float aspect = (float)this.xdim / (float)this.ydim;
        float f = 1.0f;
        if (hudInfo.fov != -1) {
            f = (float)hudInfo.fov / 420.0f;
        }
        cam.projection.setToProjection(cam.near, cam.far, 90.0f * f, aspect);
        cam.view.setToLookAt(cam.direction.set(gcosang, gsinang, 0.0f), cam.up.set(0.0f, 0.0f, (dastat & 4) != 0 ? 1.0f : -1.0f)).translate(-cam.position.x, -cam.position.y, -cam.position.z);
        cam.combined.set(cam.projection);
        Matrix4.mul(cam.combined.val, cam.view.val);
        return this.parent.mdR.mddraw(this.parent.modelManager.getModel(picnum, dapalnum), this.hudsprite);
    }

    public void draw(GLTile tex, int sx, int sy, int sizx, int sizy, int xoffset, int yoffset, int angle, int z, int dastat, int cx1, int cy1, int cx2, int cy2) {
        this.draw(tex, sx, sy, sizx, sizy, xoffset, yoffset, 0.0f, 0.0f, sizx, sizy, angle, z, dastat, cx1, cy1, cx2, cy2);
    }

    @Override
    public void nextpage() {
        if (this.isDrawing()) {
            this.end();
        }
    }

    protected void drawoverheadline(int w, int cposx, int cposy, float cos, float sin, int col) {
        if (col < 0) {
            return;
        }
        Wall wal = this.boardService.getWall(w);
        int ox = cposx - this.mapSettings.getWallX(w);
        int oy = cposy - this.mapSettings.getWallY(w);
        float x1 = (float)ox * cos - (float)oy * sin + (float)(this.xdim * 2048);
        float y1 = (float)ox * sin + (float)oy * cos + (float)(this.ydim * 2048);
        ox = cposx - this.mapSettings.getWallX(wal.getPoint2());
        oy = cposy - this.mapSettings.getWallY(wal.getPoint2());
        float x2 = (float)ox * cos - (float)oy * sin + (float)(this.xdim * 2048);
        float y2 = (float)ox * sin + (float)oy * cos + (float)(this.ydim * 2048);
        this.drawline256((int)x1, (int)y1, (int)x2, (int)y2, col);
    }

    @Override
    public void drawoverheadmap(BoardService service, int cposx, int cposy, int czoom, short cang) {
        int i;
        float cos = (float)Math.cos((float)(512 - cang) * 0.0030679617f) * (float)czoom / 4.0f;
        float sin = (float)Math.sin((float)(512 - cang) * 0.0030679617f) * (float)czoom / 4.0f;
        for (i = 0; i < this.boardService.getSectorCount(); ++i) {
            Sector sec;
            if (!this.mapSettings.isFullMap() && !Engine.show2dsector.getBit(i) || !this.boardService.isValidSector(i) || !this.boardService.isValidWall((sec = this.boardService.getSector(i)).getWallptr()) || sec.getWallnum() < 3) continue;
            int walnum = sec.getWallptr();
            int j = 0;
            while (j < sec.getWallnum()) {
                if (this.boardService.isValidWall(walnum) && this.boardService.isValidWall(this.boardService.getWall(walnum).getPoint2())) {
                    ArtEntry pic;
                    Wall wal = this.boardService.getWall(walnum);
                    if (this.mapSettings.isShowRedWalls() && this.boardService.isValidWall(wal.getNextwall()) && this.boardService.isValidSector(wal.getNextsector()) && this.mapSettings.isWallVisible(walnum, i)) {
                        this.drawoverheadline(walnum, cposx, cposy, cos, sin, this.mapSettings.getWallColor(walnum, i));
                    }
                    if (wal.getNextwall() < 0 && (pic = this.parent.getTile(wal.getPicnum())).hasSize()) {
                        this.drawoverheadline(walnum, cposx, cposy, cos, sin, this.mapSettings.getWallColor(walnum, i));
                    }
                }
                ++j;
                ++walnum;
            }
        }
        if (this.mapSettings.isShowSprites(IOverheadMapSettings.MapView.Lines)) {
            for (i = 0; i < this.boardService.getSectorCount(); ++i) {
                if (!this.mapSettings.isFullMap() && !Engine.show2dsector.getBit(i)) continue;
                block8: for (ListNode<Sprite> node = this.boardService.getSectNode(i); node != null; node = node.getNext()) {
                    int j = node.getIndex();
                    Sprite spr = node.get();
                    if ((spr.getCstat() & 0x8000) != 0 || spr.getXrepeat() == 0 || spr.getYrepeat() == 0 || !this.mapSettings.isSpriteVisible(IOverheadMapSettings.MapView.Lines, j)) continue;
                    switch (spr.getCstat() & 0x30) {
                        case 0: {
                            if ((this.parent.gotsector[i >> 3] & 1 << (i & 7)) <= 0 || czoom <= 96) continue block8;
                            int ox = cposx - this.mapSettings.getSpriteX(j);
                            int oy = cposy - this.mapSettings.getSpriteY(j);
                            float dx = (float)ox * cos - (float)oy * sin;
                            float dy = (float)ox * sin + (float)oy * cos;
                            int daang = spr.getAng() - cang & 0x7FF;
                            int nZoom = czoom * spr.getYrepeat();
                            int sx = (int)(dx + (float)(this.xdim * 2048));
                            int sy = (int)(dy + (float)(this.ydim * 2048));
                            this.rotatesprite(sx * 16, sy * 16, nZoom, (short)daang, spr.getPicnum(), spr.getShade(), spr.getPal(), (spr.getCstat() & 2) >> 1, this.parent.wx1, this.parent.wy1, this.parent.wx2, this.parent.wy2);
                            continue block8;
                        }
                        case 16: {
                            ArtEntry pic = this.parent.getTile(spr.getPicnum());
                            int x1 = this.mapSettings.getSpriteX(j);
                            int y1 = this.mapSettings.getSpriteY(j);
                            byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                            if ((spr.getCstat() & 4) > 0) {
                                xoff = -xoff;
                            }
                            int dax = EngineUtils.cos(spr.getAng() - 512) * spr.getXrepeat();
                            int day = EngineUtils.sin(spr.getAng() - 512) * spr.getXrepeat();
                            int k = (pic.getWidth() >> 1) + xoff;
                            int x2 = (x1 -= Pragmas.mulscale(dax, k, 16)) + Pragmas.mulscale(dax, pic.getWidth(), 16);
                            int y2 = (y1 -= Pragmas.mulscale(day, k, 16)) + Pragmas.mulscale(day, pic.getWidth(), 16);
                            int ox = cposx - x1;
                            int oy = cposy - y1;
                            x1 = (int)((float)ox * cos - (float)oy * sin) + (this.xdim << 11);
                            y1 = (int)((float)ox * sin + (float)oy * cos) + (this.ydim << 11);
                            ox = cposx - x2;
                            oy = cposy - y2;
                            x2 = (int)((float)ox * cos - (float)oy * sin) + (this.xdim << 11);
                            y2 = (int)((float)ox * sin + (float)oy * cos) + (this.ydim << 11);
                            int col = this.mapSettings.getSpriteColor(j);
                            if (col < 0) continue block8;
                            this.drawline256(x1, y1, x2, y2, col);
                            continue block8;
                        }
                        case 32: {
                            ArtEntry pic = this.parent.getTile(spr.getPicnum());
                            byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                            byte yoff = (byte)(pic.getOffsetY() + spr.getYoffset());
                            if ((spr.getCstat() & 4) > 0) {
                                xoff = -xoff;
                            }
                            if ((spr.getCstat() & 8) > 0) {
                                yoff = -yoff;
                            }
                            int cosang = EngineUtils.cos(spr.getAng());
                            int sinang = EngineUtils.sin(spr.getAng());
                            int dax = ((pic.getWidth() >> 1) + xoff) * spr.getXrepeat();
                            int day = ((pic.getHeight() >> 1) + yoff) * spr.getYrepeat();
                            int x1 = this.mapSettings.getSpriteX(j) + Pragmas.dmulscale(sinang, dax, cosang, day, 16);
                            int y1 = this.mapSettings.getSpriteY(j) + Pragmas.dmulscale(sinang, day, -cosang, dax, 16);
                            int l = pic.getWidth() * spr.getXrepeat();
                            int x2 = x1 - Pragmas.mulscale(sinang, l, 16);
                            int y2 = y1 + Pragmas.mulscale(cosang, l, 16);
                            l = pic.getHeight() * spr.getYrepeat();
                            int k = -Pragmas.mulscale(cosang, l, 16);
                            int x3 = x2 + k;
                            int x4 = x1 + k;
                            k = -Pragmas.mulscale(sinang, l, 16);
                            int y3 = y2 + k;
                            int y4 = y1 + k;
                            int ox = cposx - x1;
                            int oy = cposy - y1;
                            x1 = (int)((float)ox * cos - (float)oy * sin) + (this.xdim << 11);
                            y1 = (int)((float)ox * sin + (float)oy * cos) + (this.ydim << 11);
                            ox = cposx - x2;
                            oy = cposy - y2;
                            x2 = (int)((float)ox * cos - (float)oy * sin) + (this.xdim << 11);
                            y2 = (int)((float)ox * sin + (float)oy * cos) + (this.ydim << 11);
                            ox = cposx - x3;
                            oy = cposy - y3;
                            x3 = (int)((float)ox * cos - (float)oy * sin) + (this.xdim << 11);
                            y3 = (int)((float)ox * sin + (float)oy * cos) + (this.ydim << 11);
                            ox = cposx - x4;
                            oy = cposy - y4;
                            x4 = (int)((float)ox * cos - (float)oy * sin) + (this.xdim << 11);
                            y4 = (int)((float)ox * sin + (float)oy * cos) + (this.ydim << 11);
                            int col = this.mapSettings.getSpriteColor(j);
                            if (col < 0) continue block8;
                            this.drawline256(x1, y1, x2, y2, col);
                            this.drawline256(x2, y2, x3, y3, col);
                            this.drawline256(x3, y3, x4, y4, col);
                            this.drawline256(x4, y4, x1, y1, col);
                        }
                    }
                }
            }
        }
        i = Mmulti.connecthead;
        while (i >= 0) {
            int spr = this.mapSettings.getPlayerSprite(i);
            if (spr != -1 && this.boardService.isValidSector(this.boardService.getSprite(spr).getSectnum())) {
                Sprite pPlayer = this.boardService.getSprite(spr);
                int ox = cposx - this.mapSettings.getSpriteX(spr);
                int oy = cposy - this.mapSettings.getSpriteY(spr);
                float dx = (float)ox * cos - (float)oy * sin;
                float dy = (float)ox * sin + (float)oy * cos;
                int dang = pPlayer.getAng() - cang & 0x7FF;
                int viewindex = this.mapSettings.getViewPlayer();
                if (i == viewindex && !this.mapSettings.isScrollMode()) {
                    dx = 0.0f;
                    dy = viewindex ^ i;
                    dang = 0;
                }
                if (i == viewindex || this.mapSettings.isShowAllPlayers()) {
                    int picnum = this.mapSettings.getPlayerPicnum(i);
                    if (picnum == -1) {
                        int x2 = 0;
                        int y2 = -(this.mapSettings.getPlayerZoom(i, czoom) << 1);
                        int col = this.mapSettings.getSpriteColor(spr);
                        if (col >= 0) {
                            int sx = (int)dx;
                            int sy = (int)dy;
                            this.drawline256(sx - x2 + (this.xdim << 11), sy - y2 + (this.ydim << 11), sx + x2 + (this.xdim << 11), sy + y2 + (this.ydim << 11), col);
                            this.drawline256(sx - y2 + (this.xdim << 11), sy + x2 + (this.ydim << 11), sx + x2 + (this.xdim << 11), sy + y2 + (this.ydim << 11), col);
                            this.drawline256(sx + y2 + (this.xdim << 11), sy - x2 + (this.ydim << 11), sx + x2 + (this.xdim << 11), sy + y2 + (this.ydim << 11), col);
                        }
                    } else {
                        int nZoom = this.mapSettings.getPlayerZoom(i, czoom);
                        int sx = (int)(dx + (float)(this.xdim * 2048));
                        int sy = (int)(dy + (float)(this.ydim * 2048));
                        this.rotatesprite(sx * 16, sy * 16, nZoom, (short)dang, picnum, pPlayer.getShade(), pPlayer.getPal(), (pPlayer.getCstat() & 2) >> 1, this.parent.wx1, this.parent.wy1, this.parent.wx2, this.parent.wy2);
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
        this.parent.beforedrawrooms = 0;
        if (this.isDrawing()) {
            this.end();
        }
        Matrix4 tmpMat = this.parent.transform;
        BuildCamera cam = this.parent.cam;
        cam.projection.setToOrtho((float)this.xdim / 2.0f, (float)(-this.xdim) / 2.0f, -((float)this.ydim / 2.0f), (float)this.ydim / 2.0f, 0.0f, 1.0f);
        cam.projection.scale((float)zoome / 32.0f, (float)zoome / 32.0f, 0.0f);
        cam.view.set(this.parent.identity);
        cam.combined.set(cam.projection);
        Matrix4.mul(cam.combined.val, cam.view.val);
        int showSprites = this.mapSettings.isShowFloorSprites() ? 1 : 0;
        showSprites |= this.mapSettings.isShowSprites(IOverheadMapSettings.MapView.Polygons) ? 2 : 0;
        for (int s = 0; s < this.boardService.getSectorCount(); ++s) {
            int i;
            ListNode<Sprite> node;
            Sector sec = this.boardService.getSector(s);
            if (!this.mapSettings.isFullMap() && !Engine.show2dsector.getBit(s)) continue;
            if ((showSprites & 1) != 0) {
                for (node = this.boardService.getSectNode(s); node != null; node = node.getNext()) {
                    i = node.getIndex();
                    if ((node.get().getCstat() & 0x30) != 32 || (this.boardService.getSprite(i).getCstat() & 0x48) == 72 || !this.mapSettings.isSpriteVisible(IOverheadMapSettings.MapView.Polygons, i)) continue;
                    this.parent.addRenderedSprite(i);
                }
            }
            if ((showSprites & 2) != 0) {
                for (node = this.boardService.getSectNode(s); node != null; node = node.getNext()) {
                    i = node.getIndex();
                    if ((node.get().getCstat() & 0x30) == 32 || !Engine.show2dsprite.getBit(i) || !this.mapSettings.isSpriteVisible(IOverheadMapSettings.MapView.Polygons, i) || i == this.mapSettings.getPlayerSprite(this.mapSettings.getViewPlayer())) continue;
                    this.parent.addRenderedSprite(i);
                }
            }
            int n = s >> 3;
            this.parent.gotsector[n] = (byte)(this.parent.gotsector[n] | Engine.pow2char[s & 7]);
            if (sec.isParallaxFloor()) continue;
            this.parent.globalpal = sec.getFloorpal();
            int globalpicnum = sec.getFloorpicnum();
            if (globalpicnum >= Engine.MAXTILES) {
                globalpicnum = 0;
            }
            this.parent.setgotpic(globalpicnum);
            ArtEntry pic = this.parent.getTile(globalpicnum);
            if (!pic.hasSize()) continue;
            if (pic.getType() != AnimType.NONE) {
                globalpicnum += this.parent.animateoffs(globalpicnum, s);
                pic = this.parent.getTile(globalpicnum);
            }
            this.parent.globalshade = Math.max(Math.min(sec.getFloorshade(), this.parent.getPaletteManager().getShadeCount() - 1), 0);
            WorldMesh.GLSurface flor = this.parent.world.getFloor(s);
            if (flor == null) continue;
            tmpMat.setToRotation(0.0f, 0.0f, 1.0f, (float)(512 - ang) * 0.17578125f);
            tmpMat.translate((float)(-dax) / this.parent.cam.xscale, (float)(-day) / this.parent.cam.xscale, (float)(-this.boardService.getSector(s).getFloorz()) / this.parent.cam.yscale);
            this.parent.drawSurf(flor, 0, tmpMat, null);
        }
        if (showSprites != 0) {
            int j;
            float cos = (float)Math.cos((float)(512 - ang) * 0.0030679617f) * (float)zoome / 4.0f;
            float sin = (float)Math.sin((float)(512 - ang) * 0.0030679617f) * (float)zoome / 4.0f;
            int gap = 1;
            RenderedSpriteList tsprite = this.parent.getRenderedSprites();
            int sortnum = this.parent.getRenderedSprites().getSize();
            while (gap < sortnum) {
                gap = (gap << 1) + 1;
            }
            gap >>= 1;
            while (gap > 0) {
                block5: for (int i = 0; i < sortnum - gap; ++i) {
                    for (j = i; j >= 0; j -= gap) {
                        TSprite tspr1 = (TSprite)tsprite.get(j);
                        TSprite tspr2 = (TSprite)tsprite.get(j + gap);
                        if (this.boardService.getSprite(tspr1.getOwner()).getZ() <= this.boardService.getSprite(tspr2.getOwner()).getZ()) continue block5;
                        short owner1 = tspr1.getOwner();
                        tspr1.setOwner(tspr2.getOwner());
                        tspr2.setOwner(owner1);
                    }
                }
                gap >>= 1;
            }
            for (int s = sortnum - 1; s >= 0; --s) {
                j = ((TSprite)tsprite.get(s)).getOwner();
                Sprite spr = this.boardService.getSprite(j);
                if ((spr.getCstat() & 0x8000) != 0) continue;
                if (spr.getPicnum() >= Engine.MAXTILES) {
                    spr.setPicnum(0);
                }
                int ox = dax - this.mapSettings.getSpriteX(j);
                int oy = day - this.mapSettings.getSpriteY(j);
                float dx = (float)ox * cos - (float)oy * sin;
                float dy = (float)ox * sin + (float)oy * cos;
                int daang = spr.getAng() - ang & 0x7FF;
                int nZoom = zoome * spr.getYrepeat();
                int sx = (int)(dx + (float)(this.xdim * 2048));
                int sy = (int)(dy + (float)(this.ydim * 2048));
                this.rotatesprite(sx * 16, sy * 16, nZoom, (short)daang, this.mapSettings.getSpritePicnum(j), spr.getShade(), spr.getPal(), (spr.getCstat() & 2) >> 1 | 8, this.parent.wx1, this.parent.wy1, this.parent.wx2, this.parent.wy2);
            }
        }
        this.flush();
        this.manager.unbind();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        this.projectionMatrix.setToOrtho(0.0f, width - 1, height - 1, 0.0f, 0.0f, 1.0f);
    }

    protected void begin(ShaderManager.Shader shader) {
        if (this.drawing) {
            throw new IllegalStateException("GdxBatch.end must be called before begin.");
        }
        Gdx.gl20.glDepthMask(false);
        this.manager.bind(shader);
        this.setupMatrices();
        this.drawing = true;
    }

    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("GdxBatch.begin must be called before end.");
        }
        if (this.idx > 0) {
            this.flush();
        }
        this.lastTexture = null;
        this.cx1 = 0;
        this.cy1 = 0;
        this.cx2 = 0;
        this.cy2 = 0;
        this.lastType = -1;
        this.drawing = false;
        GL20 gl = this.parent.gl;
        gl.glDepthMask(true);
        if (this.isBlendingEnabled()) {
            gl.glDisable(3042);
        }
        this.manager.unbind();
    }

    protected void flush() {
        Mesh mesh;
        int count;
        if (this.idx == 0) {
            return;
        }
        this.lastTexture.bind();
        if (this.lastType == 1) {
            int spritesInBatch = this.idx / 6;
            count = spritesInBatch * 2;
            mesh = this.linesMesh;
            mesh.setVertices(this.vertices, 0, this.idx);
        } else {
            int spritesInBatch = this.idx / 20;
            count = spritesInBatch * 6;
            mesh = this.mesh;
            mesh.setVertices(this.vertices, 0, this.idx);
            mesh.getIndicesBuffer(true).position(0);
            mesh.getIndicesBuffer(true).limit(count);
        }
        if (this.blendingDisabled) {
            Gdx.gl20.glDisable(3042);
        } else {
            Gdx.gl20.glEnable(3042);
        }
        this.manager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.manager.textureTransform(this.parent.texture_transform.idt(), 0);
        mesh.render(this.manager.getProgram(), this.lastType, 0, count);
        this.idx = 0;
    }

    public void draw(GLTile tex, int sx, int sy, int sizx, int sizy, int xoffset, int yoffset, float srcX, float srcY, float srcWidth, float srcHeight, int angle, int z, int dastat, int cx1, int cy1, int cx2, int cy2) {
        float v2;
        float v;
        float y3;
        float x3;
        float y2;
        float x2;
        float y4;
        float x4;
        float y1;
        float x1;
        if (!this.drawing) {
            throw new IllegalStateException("GdxBatch.begin must be called before draw.");
        }
        this.switchTexture(tex);
        if (this.idx == this.vertices.length) {
            this.flush();
        }
        int ourxyaspect = this.parent.xyaspect;
        if ((dastat & 2) == 0) {
            if ((dastat & 0x400) == 0 && 4 * this.ydim <= 3 * this.xdim) {
                ourxyaspect = 54613;
            }
        } else {
            int zoomsc;
            int oxdim;
            int xdim = oxdim = this.xdim;
            int ouryxaspect = this.parent.yxaspect;
            ourxyaspect = this.parent.xyaspect;
            int normxofs = sx - 0xA00000;
            int normyofs = sy - 0x640000;
            if ((dastat & 0x400) == 0 && 4 * this.ydim <= 3 * xdim) {
                xdim = 4 * this.ydim / 3;
                ouryxaspect = 78643;
                ourxyaspect = 54613;
            }
            if ((dastat & 8) == 0) {
                int twice_midcx = cx1 + cx2 + 2;
                int scaledxofs = Pragmas.scale(normxofs, Pragmas.scale(this.parent.xdimen, xdim, oxdim), 320L);
                int xbord = 0;
                if ((dastat & 0x300) != 0) {
                    xbord = Pragmas.scale(oxdim - xdim, twice_midcx, oxdim);
                    if ((dastat & 0x200) == 0) {
                        xbord = -xbord;
                    }
                }
                sx = (twice_midcx + xbord << 15) + scaledxofs;
                zoomsc = this.parent.xdimenscale;
                sy = (cy1 + cy2 + 2 << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            } else {
                sx = (xdim << 15) + Pragmas.scale(normxofs, xdim, 320L);
                if ((dastat & 0x200) != 0) {
                    sx += oxdim - xdim << 16;
                } else if ((dastat & 0x100) == 0) {
                    sx += oxdim - xdim << 15;
                }
                zoomsc = Pragmas.scale(xdim, ouryxaspect, 320L);
                sy = (this.ydim << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            }
            z = Pragmas.mulscale(z, zoomsc, 16);
        }
        float aspectFix = (dastat & 2) != 0 || (dastat & 8) == 0 ? (float)ourxyaspect / 65536.0f : 1.0f;
        float scale = (float)z / 65536.0f;
        float xoffs = (float)xoffset * scale;
        float yoffs = (float)yoffset * scale;
        float width = scale * (float)sizx;
        float height = scale * (float)sizy;
        float[] vertices = this.vertices;
        float OriginX = (float)sx / 65536.0f;
        float OriginY = (float)sy / 65536.0f;
        if (angle != 0) {
            float rotation = 360.0f * (float)angle / 2048.0f;
            float cos = MathUtils.cosDeg(rotation);
            float sin = MathUtils.sinDeg(rotation);
            x1 = OriginX + (sin * yoffs - cos * xoffs) * aspectFix;
            y1 = OriginY - xoffs * sin - yoffs * cos;
            x4 = x1 + width * cos * aspectFix;
            y4 = y1 + width * sin;
            x2 = x1 - height * sin * aspectFix;
            y2 = y1 + height * cos;
            x3 = x2 + (x4 - x1);
            y3 = y2 + (y4 - y1);
        } else {
            x1 = x2 = OriginX - xoffs * aspectFix;
            y1 = y4 = OriginY - yoffs;
            x3 = x4 = x1 + width * aspectFix;
            y2 = y3 = y1 + height;
        }
        if ((dastat & 8) == 0) {
            float yaspect = (float)this.parent.windowy2 / (float)this.ydim;
            y1 *= yaspect;
            y2 *= yaspect;
            y3 *= yaspect;
            y4 *= yaspect;
        }
        if (tex.isHighTile()) {
            srcWidth = tex.getWidth();
            for (sizy = 1; sizy < tex.getHeight(); sizy += sizy) {
            }
            float scaley = (float)sizy / (float)tex.getHeight();
            srcHeight = (float)tex.getHeight() / scaley;
        }
        float u = srcX * this.invTexWidth;
        float u2 = (srcX + srcWidth) * this.invTexWidth;
        if ((dastat & 4) == 0) {
            v = srcY * this.invTexHeight;
            v2 = (srcY + srcHeight) * this.invTexHeight;
        } else {
            v = (srcY + srcHeight) * this.invTexHeight;
            v2 = srcY * this.invTexHeight;
        }
        if (tex.isHighTile() && (tex.getHiresXScale() != 1.0f || tex.getHiresYScale() != 1.0f)) {
            u *= tex.getHiresXScale();
            v *= tex.getHiresYScale();
            u2 *= tex.getHiresXScale();
            v2 *= tex.getHiresYScale();
        }
        float color = this.color;
        this.addVertex(x1, y1, color, u, v);
        this.addVertex(x2, y2, color, u, v2);
        this.addVertex(x3, y3, color, u2, v2);
        this.addVertex(x4, y4, color, u2, v);
    }

    protected void switchTextureParams(int pal, int shade, float alpha, boolean drawLastIndex) {
        IndexedShader shader = (IndexedShader)this.manager.getProgram();
        if (shader.getDrawLastIndex() == drawLastIndex && shader.getPal() == pal && shader.getShade() == shade && shader.getTransparent() == alpha) {
            return;
        }
        this.flush();
        this.manager.textureParams8(pal, shade, alpha, drawLastIndex);
    }

    protected void switchTexture(GLTile texture) {
        if (texture == this.lastTexture) {
            return;
        }
        this.flush();
        this.lastTexture = texture;
        this.invTexWidth = 1.0f / (float)texture.getWidth();
        this.invTexHeight = 1.0f / (float)texture.getHeight();
        this.manager.textureSize(texture.getWidth(), texture.getHeight());
        this.manager.paletteFiltered(this.parent.getConfig().getPaletteFiltered());
        this.manager.softShading(this.parent.getConfig().getSoftShading());
    }

    protected void setColor(float r, float g, float b, float a) {
        int intBits = (int)(255.0f * a) << 24 | (int)(255.0f * b) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        this.color = NumberUtils.intToFloatColor(intBits);
    }

    protected boolean isBlendingEnabled() {
        return !this.blendingDisabled;
    }

    public boolean isDrawing() {
        return this.drawing;
    }

    protected void disableBlending() {
        if (this.blendingDisabled) {
            return;
        }
        this.flush();
        this.blendingDisabled = true;
    }

    protected void enableBlending() {
        if (!this.blendingDisabled) {
            return;
        }
        this.flush();
        this.blendingDisabled = false;
    }

    protected void switchOrphoShader(ShaderManager.Shader shader) {
        if (!this.isDrawing()) {
            this.begin(shader);
        }
        if (shader == this.manager.getShader()) {
            return;
        }
        if (this.isDrawing()) {
            this.flush();
        }
        this.manager.bind(shader);
        this.setupMatrices();
    }

    protected void setupMatrices() {
        this.manager.mirror(false);
        this.manager.fog(false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.manager.getShader() != ShaderManager.Shader.BitmapShader) {
            this.manager.projection(this.projectionMatrix).view(this.parent.identity);
            this.manager.transform(this.parent.identity);
            this.manager.viewport(0, 0, (int)((float)(this.xdim - 1) * this.parent.backBufferScale), (int)((float)(this.ydim - 1) * this.parent.backBufferScale));
            this.cy1 = 0;
            this.cx1 = 0;
            this.cx2 = this.xdim - 1;
            this.cy2 = this.ydim - 1;
        } else {
            this.manager.projection(this.projectionMatrix);
        }
    }

    protected void setType(int type) {
        if (type == this.lastType) {
            return;
        }
        this.flush();
        this.lastType = type;
    }

    protected GLTile allocLineTile() {
        DummyTileData data = new DummyTileData(TileData.PixelFormat.Bitmap, 1, 1);
        ByteBuffer b = data.getPixels();
        b.put((byte)-1);
        b.rewind();
        return this.parent.textureCache.newTile(data, 0, TexFilter.NONE);
    }

    protected void setViewport(int cx1, int cy1, int cx2, int cy2) {
        if (cx1 == this.cx1 && cx2 == this.cx2 && cy1 == this.cy1 && cy2 == this.cy2) {
            return;
        }
        this.flush();
        this.manager.viewport((int)((float)cx1 * this.parent.backBufferScale), (int)((float)cy1 * this.parent.backBufferScale), (int)((float)cx2 * this.parent.backBufferScale), (int)((float)cy2 * this.parent.backBufferScale));
        this.cx1 = cx1;
        this.cx2 = cx2;
        this.cy1 = cy1;
        this.cy2 = cy2;
    }
}

