/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Plane;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.AbstractRenderer;
import ru.m210projects.Build.Render.DefaultMapSettings;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.GDXModelManager;
import ru.m210projects.Build.Render.GdxRender.GDXModelRenderer;
import ru.m210projects.Build.Render.GdxRender.GDXOrtho;
import ru.m210projects.Build.Render.GdxRender.GDXVideoContext;
import ru.m210projects.Build.Render.GdxRender.Scanner.SectorScanner;
import ru.m210projects.Build.Render.GdxRender.Scanner.VisibleSector;
import ru.m210projects.Build.Render.GdxRender.Shaders.FadeShader;
import ru.m210projects.Build.Render.GdxRender.Shaders.ShaderManager;
import ru.m210projects.Build.Render.GdxRender.SpriteRenderer;
import ru.m210projects.Build.Render.GdxRender.WorldMesh;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.ModelHandle.GLModel;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDAnimation;
import ru.m210projects.Build.Render.ModelHandle.ModelManager;
import ru.m210projects.Build.Render.ModelHandle.Voxel.GLVoxel;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.RenderingType;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.GLTileArray;
import ru.m210projects.Build.Render.TextureHandle.IndexedShader;
import ru.m210projects.Build.Render.TextureHandle.IndexedTileData;
import ru.m210projects.Build.Render.TextureHandle.RGBTileData;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileAtlas;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.Color;
import ru.m210projects.Build.Render.Types.ScreenFade;
import ru.m210projects.Build.Render.Types.Spriteext;
import ru.m210projects.Build.Render.listeners.PaletteListener;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Render.listeners.TileListener;
import ru.m210projects.Build.Render.listeners.WorldListener;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Script.ModelsInfo;
import ru.m210projects.Build.Types.AnimType;
import ru.m210projects.Build.Types.FastColorLookup;
import ru.m210projects.Build.Types.Palette;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;

public class GDXRenderer
extends AbstractRenderer
implements PaletteListener,
WorldListener,
TileListener,
PrecacheListener {
    protected final float FULLVIS_BEGIN = 2.9E30f;
    protected final float FULLVIS_END = 3.0E30f;
    protected final GLTileArray skycache = new GLTileArray(Engine.MAXTILES);
    private final ArrayList<WorldMesh.GLSurface> bunchfirst = new ArrayList();
    public RenderingType renderingType = RenderingType.Nothing;
    protected TextureManager textureCache;
    protected ModelManager modelManager;
    protected boolean isInited = false;
    protected GL20 gl;
    protected float defznear = 0.001f;
    protected float defzfar = 1.0f;
    protected float fov = 90.0f;
    protected float fovFactor = 1.0f;
    protected float gtang = 0.0f;
    protected WorldMesh world;
    protected SectorScanner scanner;
    protected BuildCamera cam;
    protected SpriteRenderer sprR;
    protected GDXModelRenderer mdR;
    protected GDXOrtho orphoRen;
    protected DefScript defs;
    protected ShaderManager manager;
    protected boolean isUseIndexedTextures;
    protected Matrix4 transform = new Matrix4();
    protected Matrix3 texture_transform = new Matrix3();
    protected Matrix4 identity = new Matrix4();
    protected ArrayList<VisibleSector> sectors = new ArrayList();
    protected boolean[] mirrorTextures = new boolean[Engine.MAXTILES];
    protected int FOGDISTCONST = 48;
    private boolean clearStatus = false;
    private float glox1;
    private float gloy1;
    private float glox2;
    private float gloy2;
    private Mesh fadeMesh;
    private float ALPHA_CUT_DISABLE = 0.01f;

    public GDXRenderer(GameConfig config) {
        super(config);
        this.config.setVideoContext(new GDXVideoContext(this));
        this.manager = new ShaderManager();
        Arrays.fill(this.mirrorTextures, false);
        int[] mirrors = this.getMirrorTextures();
        if (mirrors != null) {
            for (int mirror : mirrors) {
                this.mirrorTextures[mirror] = true;
            }
        }
    }

    @Override
    public PaletteManager getPaletteManager() {
        return this.paletteManager;
    }

    @Override
    public void init(Engine engine) {
        super.init(engine);
        try {
            this.textureCache = this.getTextureManager();
            this.paletteManager.setListener(this);
            this.boardService.setListener(this);
            this.tileManager.setTileListener(this);
            this.modelManager = new GDXModelManager(this);
            this.sprR = new SpriteRenderer(engine, this);
            this.mdR = new GDXModelRenderer(this);
            this.orphoRen = this.allocOrphoRenderer(engine);
            this.scanner = new SectorScanner(engine){

                @Override
                protected Matrix4 getSpriteMatrix(Sprite tspr) {
                    ArtEntry pic = GDXRenderer.this.getTile(tspr.getPicnum());
                    return GDXRenderer.this.sprR.getMatrix(tspr, pic.getWidth(), pic.getHeight());
                }
            };
            this.setDefs(engine.getDefs());
            this.gl = Gdx.graphics.getGL20();
            GLInfo.init(this.gl);
            this.gl.glBlendFunc(770, 771);
            this.gl.glPixelStorei(3333, 1);
            this.cam = new BuildCamera(this.fov, this.xdim, this.ydim, 512.0f, 8192.0f);
            PaletteManager paletteManager = engine.getPaletteManager();
            this.manager.init(this.textureCache, paletteManager.getShadeCount());
            if (!this.manager.isInited()) {
                return;
            }
            this.fadeMesh = new Mesh(true, 3, 0, new VertexAttribute(1, 2, "a_position")).setVertices(new float[]{-2.5f, 1.0f, 2.5f, 1.0f, 0.0f, -2.5f});
            this.textureCache.changePalette(paletteManager.getCurrentPalette().getBytes());
            Console.out.println("Polygdx renderer is initialized", OsdColor.GREEN);
            Console.out.println(Gdx.graphics.getGLVersion().getRendererString() + " " + this.gl.glGetString(7938), OsdColor.YELLOW);
            this.orphoRen.init();
            if (this.world != null && this.world.isInvalid()) {
                this.world = new WorldMesh(engine);
            }
            this.config.setGlfilter(this.config.getGlfilter());
            this.config.setPaletteEmulation(this.config.isPaletteEmulation());
            this.config.setUseHighTiles(this.config.isUseHighTiles());
            this.config.setDetailMapping(this.config.isDetailMapping());
            this.config.setGlowMapping(this.config.isGlowMapping());
            this.isInited = true;
        }
        catch (Throwable t) {
            this.isInited = false;
        }
    }

    @Override
    public void resize(int width, int height) {
        if (width == this.xdim && height == this.ydim) {
            return;
        }
        this.xdim = width;
        this.ydim = height;
        this.config.setgFov(this.config.getgFov());
        this.setview(0, 0, this.xdim - 1, this.ydim - 1);
        this.resizeglcheck();
    }

    @Override
    public int getWidth() {
        return this.xdim;
    }

    @Override
    public int getHeight() {
        return this.ydim;
    }

    @Override
    public void uninit() {
        System.err.println("uninit");
        this.paletteManager.setListener(PaletteListener.DUMMY_PALETTE_CHANGE_LISTENER);
        this.engine.getBoardService().setListener(WorldListener.DUMMY_LISTENER);
        this.engine.getTileManager().setTileListener(TileListener.DUMMY_LISTENER);
        this.isInited = false;
        if (this.world != null) {
            this.world.dispose();
        }
        this.orphoRen.uninit();
        this.manager.dispose();
        this.fadeMesh.dispose();
        this.texturesUninit();
        this.modelManager.dispose();
    }

    private void texturesUninit() {
        this.textureCache.uninit();
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            this.skycache.dispose(i);
        }
    }

    @Override
    public void drawrooms() {
        int i;
        if (this.orphoRen.isDrawing()) {
            this.orphoRen.flush();
        }
        this.gl.glClear(256);
        this.gl.glDisable(3042);
        this.gl.glEnable(3553);
        this.gl.glEnable(2929);
        this.gl.glDepthFunc(513);
        this.gl.glDepthRangef(this.defznear, this.defzfar);
        this.gl.glEnable(2884);
        this.gl.glFrontFace(2304);
        this.resizeglcheck();
        this.cam.setPosition(this.globalposx, this.globalposy, this.globalposz);
        this.cam.setDirection(this.globalang, this.globalhoriz, this.inpreparemirror ? (double)(-this.gtang) : (double)this.gtang);
        this.cam.update(true);
        this.globalvisibility = Engine.visibility << 2;
        if (this.globalcursectnum >= this.boardService.getSectorCount()) {
            this.globalcursectnum -= this.boardService.getSectorCount();
        } else {
            i = this.globalcursectnum;
            this.globalcursectnum = this.engine.updatesectorz(this.globalposx, this.globalposy, this.globalposz, this.globalcursectnum);
            if (this.globalcursectnum < 0) {
                this.globalcursectnum = i;
            }
        }
        this.sectors.clear();
        this.scanner.clear();
        this.scanner.setShowInvisibility(this.showinvisibility);
        this.scanner.process(this.sectors, this.cam, this.world, this.globalcursectnum, this.windowx2 + 1, this.windowy2 + 1);
        this.renderingType = RenderingType.Nothing;
        if (this.inpreparemirror) {
            this.gl.glCullFace(1028);
        } else {
            this.gl.glCullFace(1029);
        }
        this.prerender(this.sectors);
        this.drawbackground();
        int n = i = this.inpreparemirror ? 1 : 0;
        while (i < this.sectors.size()) {
            this.drawSector(this.sectors.get(i));
            ++i;
        }
        this.tSpriteList = this.scanner.getSprites();
        this.manager.unbind();
    }

    @Override
    public void drawmasks() {
        int[] maskwalls = this.scanner.getMaskwalls();
        int maskwallcnt = this.scanner.getMaskwallCount();
        RenderedSpriteList spriteList = this.getRenderedSprites();
        int spritesortcnt = spriteList.getSize();
        this.sprR.sort((Sprite[])spriteList.getArray(), spritesortcnt);
        while (spritesortcnt > 0 && maskwallcnt > 0) {
            int j = maskwalls[maskwallcnt - 1];
            if (!this.spritewallfront((Sprite)spriteList.get(spritesortcnt - 1), j)) {
                spriteList.removeLast();
                this.drawsprite(--spritesortcnt);
                continue;
            }
            for (int i = spritesortcnt - 2; i >= 0; --i) {
                TSprite tsprite = (TSprite)spriteList.get(i);
                if (this.spritewallfront(tsprite, j)) continue;
                this.drawsprite(i);
                tsprite.setOwner(-1);
            }
            this.drawmaskwall(--maskwallcnt);
        }
        while (spritesortcnt != 0) {
            TSprite tsprite;
            if ((tsprite = (TSprite)spriteList.get(--spritesortcnt)).getOwner() == -1) continue;
            this.drawsprite(spritesortcnt);
        }
        while (maskwallcnt > 0) {
            this.drawmaskwall(--maskwallcnt);
        }
        this.renderDrunkEffect();
        this.manager.unbind();
    }

    private void drawMask(int w) {
        this.gl.glDepthFunc(513);
        this.gl.glDepthRangef(1.0E-4f, 0.99999f);
        this.drawSurf(this.world.getMaskedWall(w), 0, null, null);
        this.gl.glDepthFunc(513);
        this.gl.glDepthRangef(this.defznear, this.defzfar);
    }

    protected void renderDrunkEffect() {
    }

    public void drawsprite(int i) {
        Sprite tspr = (Sprite)this.tSpriteList.get(i);
        if (tspr == null || tspr.getOwner() == -1) {
            return;
        }
        Spriteext sprext = this.defs.mapInfo.getSpriteInfo(tspr.getOwner());
        if (sprext == null || !sprext.isNotModel()) {
            GLModel md;
            this.renderingType = RenderingType.Model.setIndex(i);
            if (this.engine.getConfig().isUseModels() && (md = this.modelManager.getModel(tspr.getPicnum(), tspr.getPal())) != null) {
                if (this.boardService.isValidSprite(tspr.getOwner()) ? this.mdR.mddraw(md, tspr) : this.mdR.mddraw(md, tspr)) {
                    return;
                }
            } else if (this.engine.getConfig().isUseVoxels()) {
                GLVoxel vox;
                int dist;
                int picnum = tspr.getPicnum();
                if (this.getTile(picnum).getType() != AnimType.NONE) {
                    picnum += this.animateoffs(picnum, tspr.getOwner() + 32768);
                }
                if ((long)(dist = (tspr.getX() - this.globalposx) * (tspr.getX() - this.globalposx) + (tspr.getY() - this.globalposy) * (tspr.getY() - this.globalposy)) < 2304000000L && (vox = (GLVoxel)this.modelManager.getVoxel(picnum)) != null) {
                    if ((tspr.getCstat() & 0x30) != 48) {
                        if (this.mdR.mddraw(vox, tspr)) {
                            return;
                        }
                    } else if ((tspr.getCstat() & 0x30) == 48) {
                        this.mdR.mddraw(vox, tspr);
                        return;
                    }
                }
            }
        }
        this.renderingType = RenderingType.Sprite.setIndex(i);
        this.sprR.begin(this.cam);
        this.sprR.draw(tspr);
        this.sprR.end();
    }

    private void drawmaskwall(int i) {
        this.renderingType = RenderingType.MaskWall.setIndex(i);
        this.drawMask(this.scanner.getMaskwalls()[i]);
    }

    protected void drawbackground() {
        int i;
        this.renderingType = RenderingType.Skybox;
        this.drawSkyPlanes();
        int n = i = this.inpreparemirror ? 1 : 0;
        while (i < this.sectors.size()) {
            this.drawSkySector(this.sectors.get(i));
            ++i;
        }
    }

    private void prerender(ArrayList<VisibleSector> sectors) {
        int i;
        if (this.inpreparemirror) {
            return;
        }
        this.bunchfirst.clear();
        for (i = 0; i < sectors.size(); ++i) {
            int z;
            int w;
            VisibleSector sec = sectors.get(i);
            int sectnum = sec.index;
            if ((sec.secflags & 1) != 0) {
                this.checkMirror(this.world.getFloor(sectnum));
            }
            if ((sec.secflags & 2) != 0) {
                this.checkMirror(this.world.getCeiling(sectnum));
            }
            for (w = 0; w < sec.walls.size; ++w) {
                z = sec.walls.get(w);
                int flags = sec.wallflags.get(w);
                this.checkMirror(this.world.getWall(z, sectnum));
                if ((flags & 1) != 0) {
                    this.checkMirror(this.world.getLower(z));
                }
                if ((flags & 2) != 0) {
                    this.checkMirror(this.world.getUpper(z));
                }
                this.checkMirror(this.world.getMaskedWall(z));
            }
            for (w = 0; w < sec.skywalls.size; ++w) {
                z = sec.skywalls.get(w);
                this.checkMirror(this.world.getParallaxCeiling(z));
                this.checkMirror(this.world.getParallaxFloor(z));
            }
        }
        for (i = 0; i < this.bunchfirst.size(); ++i) {
            this.drawSurf(this.bunchfirst.get(i), 0, null, null);
        }
    }

    private void checkMirror(WorldMesh.GLSurface surf) {
        if (surf == null) {
            return;
        }
        int picnum = surf.picnum;
        if (this.mirrorTextures[picnum]) {
            this.bunchfirst.add(surf);
        }
    }

    private void drawSkyPlanes() {
        short picnum;
        byte shade;
        short pal;
        this.gl.glDisable(2884);
        this.gl.glDepthMask(false);
        Sector skysector = this.scanner.getLastSkySector(WorldMesh.Heinum.SkyUpper);
        if (skysector != null) {
            pal = skysector.getCeilingpal();
            shade = skysector.getCeilingshade();
            picnum = skysector.getCeilingpicnum();
            this.drawSky(this.world.getQuad(), picnum, shade, pal, 0, this.transform.setToTranslation(this.cam.position.x, this.cam.position.y, this.cam.position.z - 100.0f).scale(this.cam.far, this.cam.far, 1.0f));
        }
        if ((skysector = this.scanner.getLastSkySector(WorldMesh.Heinum.SkyLower)) != null) {
            pal = skysector.getFloorpal();
            shade = skysector.getFloorshade();
            picnum = skysector.getFloorpicnum();
            this.drawSky(this.world.getQuad(), picnum, shade, pal, 0, this.transform.setToTranslation(this.cam.position.x, this.cam.position.y, this.cam.position.z + 100.0f).scale(this.cam.far, this.cam.far, 1.0f));
        }
        this.gl.glDepthMask(true);
        this.gl.glEnable(2884);
    }

    private void drawSector(VisibleSector sec) {
        int sectnum = sec.index;
        int n = sectnum >> 3;
        this.gotsector[n] = (byte)(this.gotsector[n] | Engine.pow2char[sectnum & 7]);
        if ((sec.secflags & 1) != 0) {
            this.renderingType = RenderingType.Floor.setIndex(sectnum);
            this.drawSurf(this.world.getFloor(sectnum), 0, null, sec.clipPlane);
        }
        if ((sec.secflags & 2) != 0) {
            this.renderingType = RenderingType.Ceiling.setIndex(sectnum);
            this.drawSurf(this.world.getCeiling(sectnum), 0, null, sec.clipPlane);
        }
        for (int w = 0; w < sec.walls.size; ++w) {
            int flags = sec.wallflags.get(w);
            int z = sec.walls.get(w);
            this.renderingType = RenderingType.Wall.setIndex(z);
            this.drawSurf(this.world.getWall(z, sectnum), flags, null, sec.clipPlane);
            this.drawSurf(this.world.getUpper(z), flags, null, sec.clipPlane);
            this.drawSurf(this.world.getLower(z), flags, null, sec.clipPlane);
        }
    }

    public void drawSkySector(VisibleSector sec) {
        for (int w = 0; w < sec.skywalls.size; ++w) {
            WorldMesh.GLSurface floor;
            int z = sec.skywalls.get(w);
            WorldMesh.GLSurface ceil = this.world.getParallaxCeiling(z);
            if (ceil != null) {
                this.drawSky(ceil, ceil.picnum, ceil.getShade(), ceil.getPal(), ceil.getMethod(), this.identity);
            }
            if ((floor = this.world.getParallaxFloor(z)) == null) continue;
            this.drawSky(floor, floor.picnum, floor.getShade(), floor.getPal(), floor.getMethod(), this.identity);
        }
    }

    private void drawSky(WorldMesh.GLSurface surf, int picnum, int shade, int palnum, int method, Matrix4 worldTransform) {
        GLTile pth;
        ArtEntry pic;
        if (surf.count == 0) {
            return;
        }
        if (this.getTile(picnum).getType() != AnimType.NONE) {
            picnum += this.animateoffs(picnum, 0);
        }
        if (!(pic = this.getTile(picnum)).exists()) {
            method = 1;
        }
        this.setgotpic(picnum);
        if (!this.engine.getPaletteManager().isValidPalette(palnum)) {
            palnum = 0;
        }
        if ((pth = this.bindSky(pic, palnum, shade, method)) != null) {
            Gdx.gl.glDisable(3042);
            if ((method & 3) != 0) {
                Gdx.gl.glEnable(3042);
            }
            this.manager.fog(false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            this.manager.transform(worldTransform);
            this.manager.frustum(null);
            surf.render(this.manager.getProgram());
        }
    }

    protected void drawSurf(WorldMesh.GLSurface surf, int flags, Matrix4 worldTransform, Plane[] clipPlane) {
        if (surf == null) {
            return;
        }
        if (surf.count != 0 && (flags == 0 || (surf.visflag & flags) != 0)) {
            int picnum = surf.picnum;
            if (this.getTile(picnum).getType() != AnimType.NONE) {
                picnum += this.animateoffs(picnum, 0);
            }
            ArtEntry pic = this.getTile(picnum);
            int method = surf.getMethod();
            if (!pic.exists()) {
                method = 1;
            }
            this.setgotpic(picnum);
            GLTile pth = this.bind(pic, surf.getPal(), surf.getShade(), 0, method);
            if (pth != null) {
                int combvis = this.globalvisibility;
                int vis = surf.getVisibility();
                if (vis != 0) {
                    combvis = Pragmas.mulscale(this.globalvisibility, vis + 16 & 0xFF, 4);
                }
                if (pth.getPixelFormat() == TileData.PixelFormat.Pal8) {
                    ((IndexedShader)this.manager.getProgram()).setVisibility((int)((float)(-combvis) / 64.0f));
                } else {
                    this.calcFog(surf.getPal(), surf.getShade(), combvis);
                }
                this.manager.color(1.0f, 1.0f, 1.0f, 1.0f);
                if (pth.isHighTile()) {
                    int tsizy;
                    for (tsizy = 1; tsizy < pic.getHeight(); tsizy += tsizy) {
                    }
                    if ((float)pic.getWidth() / (float)pic.getHeight() != (float)pth.getWidth() / (float)pth.getHeight()) {
                        this.texture_transform.scale(1.0f, (float)tsizy * pth.getYScale() / (float)pth.getHeight());
                    }
                    this.manager.textureTransform(this.texture_transform, 0);
                    if (this.defs != null && this.defs.texInfo != null) {
                        float r = 1.0f;
                        float g = 1.0f;
                        float b = 1.0f;
                        if (pth.getPal() != surf.getPal()) {
                            Color p = this.defs.texInfo.getTints(surf.getPal());
                            r *= (float)p.r / 255.0f;
                            g *= (float)p.g / 255.0f;
                            b *= (float)p.b / 255.0f;
                        }
                        Color pdetail = this.defs.texInfo.getTints(255);
                        if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                            r *= (float)pdetail.r / 255.0f;
                            g *= (float)pdetail.g / 255.0f;
                            b *= (float)pdetail.b / 255.0f;
                        }
                        this.manager.color(r, g, b, 1.0f);
                    }
                }
                if (worldTransform == null) {
                    this.manager.transform(this.identity);
                } else {
                    this.manager.transform(worldTransform);
                }
                if (clipPlane != null && !this.inpreparemirror) {
                    this.manager.frustum(clipPlane);
                } else {
                    this.manager.frustum(null);
                }
                if ((method & 3) == 0) {
                    Gdx.gl.glDisable(3042);
                } else {
                    Gdx.gl.glEnable(3042);
                }
                surf.render(this.manager.getProgram());
            }
        }
    }

    protected void calcFog(int pal, int shade, float combvis) {
        float start = 2.9E30f;
        float end = 3.0E30f;
        PaletteManager paletteManager = this.engine.getPaletteManager();
        if (combvis != 0.0f) {
            if (shade >= paletteManager.getShadeCount() - 1) {
                start = -1.0f;
                end = 0.001f;
            } else {
                start = shade > 0 ? 0.0f : (float)(-(this.FOGDISTCONST * shade)) / combvis;
                end = (float)(this.FOGDISTCONST * (paletteManager.getShadeCount() - 1 - shade)) / combvis;
            }
        }
        Color palookupfog = paletteManager.getFogColor(pal);
        float r = (float)palookupfog.r / 63.0f;
        float g = (float)palookupfog.g / 63.0f;
        float b = (float)palookupfog.b / 63.0f;
        this.manager.fog(true, start, end, r, g, b);
    }

    @Override
    public void clearview(int dacol) {
        PaletteManager paletteManager = this.engine.getPaletteManager();
        Palette curpalette = paletteManager.getCurrentPalette();
        this.gl.glClearColor((float)curpalette.getRed(dacol) / 255.0f, (float)curpalette.getGreen(dacol) / 255.0f, (float)curpalette.getBlue(dacol) / 255.0f, 0.0f);
        this.gl.glClear(16384);
    }

    @Override
    public void changepalette(byte[] palette) {
        super.changepalette(palette);
        this.textureCache.changePalette(palette);
        this.textureCache.invalidateall();
        this.clearskins(true);
        DEFAULT_SCREEN_FADE.set(0, 0, 0, 0);
    }

    @Override
    public void nextpage() {
        super.nextpage();
        this.clearStatus = false;
        if (this.world != null) {
            this.world.nextpage();
        }
        this.orphoRen.nextpage();
        this.manager.reset();
        this.textureCache.unbind();
        MDAnimation.omdtims = MDAnimation.mdtims;
        MDAnimation.mdtims = this.engine.getCurrentTimeMillis();
        if (this.boardService.getBoard() != null) {
            for (int i = 0; i < this.boardService.getSpriteCount(); ++i) {
                ModelsInfo.SpriteAnim sprext;
                if (MDAnimation.mdpause == 0 || (sprext = this.defs.mdInfo.getAnimParams(i)) == null) continue;
                boolean isAnimationDisabled = false;
                Spriteext inf = this.defs.mapInfo.getSpriteInfo(i);
                if (inf != null) {
                    isAnimationDisabled = inf.isAnimationDisabled();
                }
                if ((MDAnimation.mdpause == 0 || sprext.mdanimtims == 0L) && !isAnimationDisabled) continue;
                sprext.mdanimtims += MDAnimation.mdtims - MDAnimation.omdtims;
            }
        }
        this.beforedrawrooms = 1;
        this.gl.glFlush();
    }

    @Override
    public void setview(int x1, int y1, int x2, int y2) {
        this.xdimen = x2 - x1 + 1;
        this.ydimen = y2 - y1 + 1;
        super.setview(x1, y1, x2, y2);
        this.orphoRen.resize(x2, y2);
    }

    @Override
    public void setviewtotile(DynamicArtEntry pic) {
        this.bakwindowx1[this.setviewcnt] = this.windowx1;
        this.bakwindowy1[this.setviewcnt] = this.windowy1;
        this.bakwindowx2[this.setviewcnt] = this.windowx2;
        this.bakwindowy2[this.setviewcnt] = this.windowy2;
        if (this.setviewcnt == 0) {
            this.baktile = pic;
        }
        this.offscreenrendering = true;
        ++this.setviewcnt;
        this.setview(0, 0, pic.getHeight() - 1, pic.getWidth() - 1);
    }

    @Override
    public void setviewback() {
        if (this.setviewcnt <= 0) {
            this.offscreenrendering = false;
            this.setaspect();
            return;
        }
        --this.setviewcnt;
        boolean bl = this.offscreenrendering = this.setviewcnt > 0;
        if (this.setviewcnt == 0 && this.baktile.exists()) {
            this.baktile.copyData(this.setviewbuf());
        }
        this.setview(this.bakwindowx1[this.setviewcnt], this.bakwindowy1[this.setviewcnt], this.bakwindowx2[this.setviewcnt], this.bakwindowy2[this.setviewcnt]);
    }

    protected byte[] setviewbuf() {
        int width = this.baktile.getWidth();
        int heigth = this.baktile.getHeight();
        byte[] data = this.baktile.getBytes();
        ByteBuffer frame = this.getFrame(TileData.PixelFormat.Pal8, width, heigth);
        int sptr = 0;
        for (int i = width - 1; i >= 0; --i) {
            int dptr = i;
            for (int j = 0; j < heigth; ++j) {
                data[dptr] = frame.get(sptr++);
                dptr += width;
            }
        }
        return data;
    }

    @Override
    public void setFieldOfView(int fov) {
        this.fovFactor = (float)Math.tan((double)fov * Math.PI / 360.0);
        this.setaspect();
    }

    protected void setaspect(int daxrange, int daaspect) {
        this.viewingrange = this.offscreenrendering ? daxrange : (int)((float)daxrange * this.fovFactor);
        this.yxaspect = daaspect;
        this.xyaspect = Pragmas.divscale(1L, this.yxaspect, 32);
        this.xdimenscale = Pragmas.scale(this.xdimen, this.yxaspect, 320L);
        this.xdimscale = Pragmas.scale(320L, this.xyaspect, this.xdimen);
        int w = 320;
        if (4 * this.xdim / 5 == this.ydim) {
            w = 300;
        }
        float k = (float)daxrange / (float)Pragmas.divscale((long)this.xdim * 240L, (long)this.ydim * (long)w, 16);
        float fov = this.offscreenrendering ? 110.0f : (float)Math.toDegrees(2.0 * Math.atan(k * this.fovFactor));
        this.cam.setFieldOfView(fov);
    }

    @Override
    public void setaspect() {
        if (this.offscreenrendering) {
            this.setaspect(65536, 65536);
            return;
        }
        if (this.config.getWidescreen() == 1 && 4 * this.xdim / 5 != this.ydim) {
            int yx = 81664;
            int vr = Pragmas.divscale((long)this.xdim * 3L, (long)this.ydim * 4L, 16);
            this.setaspect(vr, yx);
        } else {
            this.setaspect(65536, Pragmas.divscale((long)this.ydim * 320L, (long)this.xdim * 200L, 16));
        }
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        this.renderingType = RenderingType.Tile.setIndex(picnum);
        this.set2dview();
        this.orphoRen.rotatesprite(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2);
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
        this.set2dview();
        Arrays.fill(this.gotsector, (byte)0);
        this.orphoRen.drawmapview(dax, day, zoome, ang);
    }

    @Override
    public void drawoverheadmap(int cposx, int cposy, int czoom, short cang) {
        this.set2dview();
        this.orphoRen.drawoverheadmap(this.boardService, cposx, cposy, czoom, cang);
    }

    @Override
    public int printext(Font font, int x, int y, char[] text, float scale, int shade, int palnum, TextAlign align, Transparent transparent, boolean shadow) {
        this.renderingType = RenderingType.Tile.setIndex(0);
        this.set2dview();
        return this.orphoRen.printext(font, x, y, text, scale, shade, palnum, align, transparent, shadow);
    }

    @Override
    public ByteBuffer getFrame(TileData.PixelFormat format, int xsiz, int ysiz) {
        boolean reverse = false;
        if (ysiz < 0) {
            ysiz *= -1;
            reverse = true;
        }
        int byteperpixel = 3;
        int fmt = 6407;
        if (Gdx.app.getType() == Application.ApplicationType.Android) {
            byteperpixel = 4;
            fmt = 6408;
        }
        ByteBuffer frameBuffer = ByteBuffer.allocateDirect(xsiz * ysiz * byteperpixel);
        this.gl.glPixelStorei(3333, 1);
        this.gl.glReadPixels(0, this.ydim - ysiz, xsiz, ysiz, fmt, 5121, frameBuffer);
        if (format == TileData.PixelFormat.Rgb) {
            if (reverse) {
                int b2 = 0;
                for (int y = 0; y < ysiz / 2; ++y) {
                    int b1 = byteperpixel * (ysiz - y - 1) * xsiz;
                    for (int x = 0; x < xsiz; ++x) {
                        for (int p = 0; p < byteperpixel; ++p) {
                            byte tmp = frameBuffer.get(b1 + p);
                            frameBuffer.put(b1 + p, frameBuffer.get(b2 + p));
                            frameBuffer.put(b2 + p, tmp);
                        }
                        b1 += byteperpixel;
                        b2 += byteperpixel;
                    }
                }
            }
            frameBuffer.rewind();
            return frameBuffer;
        }
        ByteBuffer pix8Buffer = ByteBuffer.allocateDirect(xsiz * ysiz);
        PaletteManager paletteManager = this.engine.getPaletteManager();
        byte[] basePalette = paletteManager.getBasePalette();
        FastColorLookup fastColorLookup = paletteManager.getFastColorLookup();
        int base = 0;
        if (reverse) {
            for (int y = 0; y < ysiz; ++y) {
                base = byteperpixel * (ysiz - y - 1) * xsiz;
                for (int x = 0; x < xsiz; ++x) {
                    int r = (frameBuffer.get(base++) & 0xFF) >> 2;
                    int g = (frameBuffer.get(base++) & 0xFF) >> 2;
                    int b = (frameBuffer.get(base++) & 0xFF) >> 2;
                    pix8Buffer.put(fastColorLookup.getClosestColorIndex(basePalette, r, g, b));
                }
            }
        } else {
            for (int i = 0; i < pix8Buffer.capacity(); ++i) {
                int r = (frameBuffer.get(base++) & 0xFF) >> 2;
                int g = (frameBuffer.get(base++) & 0xFF) >> 2;
                int b = (frameBuffer.get(base++) & 0xFF) >> 2;
                if (byteperpixel == 4) {
                    ++base;
                }
                pix8Buffer.put(fastColorLookup.getClosestColorIndex(basePalette, r, g, b));
            }
        }
        pix8Buffer.rewind();
        return pix8Buffer;
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int col) {
        this.set2dview();
        this.orphoRen.drawline256(x1, y1, x2, y2, col);
    }

    @Override
    public void settiltang(int tilt) {
        this.gtang = tilt == 0 ? 0.0f : (float)Gameutils.AngleToDegrees(tilt);
    }

    @Override
    public void setDefs(DefScript defs) {
        this.textureCache.setTextureInfo(defs != null ? defs.texInfo : null);
        this.modelManager.setModelsInfo(defs != null ? defs.mdInfo : null);
        if (this.defs != null) {
            this.texturesUninit();
            this.textureCache.invalidateall();
            this.clearskins(false);
        }
        this.defs = defs;
    }

    @Override
    public void showScreenFade(ScreenFade screenFade) {
        int count = screenFade.getIntensive();
        int r = screenFade.getRed();
        int g = screenFade.getGreen();
        int b = screenFade.getBlue();
        int fr = 0;
        int fg = 0;
        int fb = 0;
        if (r > 0) {
            fr = Math.min(count - 128, r / 2);
        }
        if (g > 0) {
            fg = Math.min(count - 128, g / 2);
        }
        if (b > 0) {
            fb = Math.min(count - 128, b / 2);
        }
        if (this.orphoRen.isDrawing()) {
            this.orphoRen.flush();
        }
        this.gl.glDisable(2929);
        this.gl.glDisable(3553);
        this.gl.glEnable(3042);
        this.set2dview();
        FadeShader shader = (FadeShader)this.manager.bind(ShaderManager.Shader.FadeShader);
        this.gl.glBlendFunc(771, 771);
        shader.setColor(Math.min(63, fr) << 2, Math.min(63, fg) << 2, Math.min(63, fb) << 2, 4);
        this.fadeMesh.render(shader, 4);
        this.gl.glBlendFunc(770, 771);
    }

    public TextureManager getTextureManager() {
        if (this.textureCache == null) {
            this.textureCache = new TextureManager(this.engine, TextureManager.ExpandTexture.Vertical);
        }
        return this.textureCache;
    }

    public void enableIndexedShader(boolean enable) {
        if (this.isUseIndexedTextures != enable) {
            if (this.isInited) {
                this.texturesUninit();
            }
            this.clearskins(false);
            this.isUseIndexedTextures = enable;
        }
    }

    public void clearskins(boolean bit8only) {
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            this.modelManager.clearSkins(i, bit8only);
        }
    }

    @Override
    public void loadModels() {
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            int pal = 0;
            this.modelManager.preload(i, pal, false);
        }
    }

    @Override
    public void onPrecacheTile(int dapicnum, boolean ifSprite) {
        int datype;
        int dapalnum = 0;
        int n = datype = ifSprite ? 4 : 0;
        if (!this.engine.getPaletteManager().isValidPalette(dapalnum) && dapalnum < 252) {
            return;
        }
        this.textureCache.precache(this.getTexFormat(), this.getTile(dapicnum), dapalnum, datype);
        if (datype == 0) {
            return;
        }
        this.modelManager.preload(dapicnum, dapalnum, true);
    }

    public void gltexapplyprops() {
        TexFilter filter = this.config.getGlfilter();
        this.textureCache.setFilter(filter);
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            this.skycache.setFilter(i, filter);
        }
        this.modelManager.setTextureFilter(filter);
    }

    public void invalidatetile(int tilenume, int pal, int how) {
        int firstpal;
        int numpal;
        TileData.PixelFormat fmt = this.textureCache.getFmt(tilenume);
        if (fmt == null) {
            return;
        }
        if (fmt == TileData.PixelFormat.Pal8) {
            numpal = 1;
            firstpal = 0;
        } else if (pal < 0) {
            numpal = 256;
            firstpal = 0;
        } else {
            numpal = 1;
            firstpal = pal % 256;
        }
        for (int hp = 0; hp < 8; hp += 4) {
            if ((how & Engine.pow2long[hp]) == 0) continue;
            for (int np = firstpal; np < firstpal + numpal; ++np) {
                this.textureCache.invalidate(tilenume, np, this.textureCache.clampingMode(hp));
            }
        }
    }

    protected GLTile bind(ArtEntry tile, int dapalnum, int dashade, int skybox, int method) {
        GLTile pth;
        if (!this.engine.getPaletteManager().isValidPalette(dapalnum)) {
            dapalnum = 0;
        }
        if ((pth = this.textureCache.get(this.getTexFormat(), tile, dapalnum, skybox, method)) == null) {
            return null;
        }
        this.textureCache.bind(pth);
        if (this.manager.getShader() == null || this.isSkyShader() || pth.getPixelFormat() != this.manager.getPixelFormat()) {
            this.switchShader(pth.getPixelFormat() != TileData.PixelFormat.Pal8 ? ShaderManager.Shader.RGBWorldShader : ShaderManager.Shader.IndexedWorldShader);
        }
        this.setTextureParameters(pth, tile, dapalnum, dashade, skybox, method);
        return pth;
    }

    protected GLTile bindSky(ArtEntry tile, int dapalnum, int dashade, int method) {
        GLTile pth;
        if (!this.engine.getPaletteManager().isValidPalette(dapalnum)) {
            dapalnum = 0;
        }
        if ((pth = this.getSkyTexture(this.getTexFormat(), tile, dapalnum)) == null) {
            return null;
        }
        this.textureCache.bind(pth);
        if (this.manager.getShader() == null || !this.isSkyShader() || pth.getPixelFormat() != this.manager.getPixelFormat()) {
            this.switchShader(pth.getPixelFormat() != TileData.PixelFormat.Pal8 ? ShaderManager.Shader.RGBSkyShader : ShaderManager.Shader.IndexedSkyShader);
        }
        this.setTextureParameters(pth, tile, dapalnum, dashade, 0, 0);
        return pth;
    }

    public void setTextureParameters(GLTile tile, ArtEntry artEntry, int pal, int shade, int skybox, int method) {
        float alpha = 1.0f;
        switch (method & 3) {
            case 2: {
                alpha = this.TRANSLUSCENT1;
                break;
            }
            case 3: {
                alpha = this.TRANSLUSCENT2;
            }
        }
        if (!artEntry.exists()) {
            alpha = this.ALPHA_CUT_DISABLE;
        }
        if (tile.getPixelFormat() == TileData.PixelFormat.Pal8) {
            this.manager.textureSize(tile.getWidth(), tile.getHeight());
            this.manager.paletteFiltered(this.config.getPaletteFiltered());
            this.manager.softShading(this.config.getSoftShading());
            this.manager.textureTransform(this.texture_transform.idt(), 0);
            this.manager.textureParams8(pal, shade, alpha, (method & 3) == 0 || !this.textureCache.alphaMode(method));
        } else {
            float b;
            this.texture_transform.idt();
            if (tile.isHighTile() && (tile.getHiresXScale() != 1.0f || tile.getHiresYScale() != 1.0f) && RenderingType.Skybox.getIndex() == 0) {
                this.texture_transform.scale(tile.getHiresXScale(), tile.getHiresYScale());
            }
            this.manager.textureTransform(this.texture_transform, 0);
            if (GLInfo.multisample == 0 || !this.config.isUseHighTiles() || RenderingType.Skybox.getIndex() == 0) {
                // empty if block
            }
            int numshades = this.engine.getPaletteManager().getShadeCount();
            float fshade = Math.min(Math.max((float)shade * 1.04f, 0.0f), (float)numshades);
            float g = b = ((float)numshades - fshade) / (float)numshades;
            float r = b;
            if (this.defs != null && tile.isHighTile() && this.defs.texInfo != null) {
                if (tile.getPal() != pal) {
                    Color p = this.defs.texInfo.getTints(pal);
                    r *= (float)p.r / 255.0f;
                    g *= (float)p.g / 255.0f;
                    b *= (float)p.b / 255.0f;
                }
                Color pdetail = this.defs.texInfo.getTints(255);
                if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                    r *= (float)pdetail.r / 255.0f;
                    g *= (float)pdetail.g / 255.0f;
                    b *= (float)pdetail.b / 255.0f;
                }
            }
            this.manager.color(r, g, b, alpha);
        }
    }

    public void addSpriteCorr(int snum) {
    }

    public void removeSpriteCorr(int snum) {
    }

    @Override
    public void completemirror() {
        this.inpreparemirror = false;
    }

    private boolean spritewallfront(Sprite s, int w) {
        if (s == null) {
            return false;
        }
        Wall wal = this.boardService.getWall(w);
        int x1 = wal.getX();
        int y1 = wal.getY();
        return Pragmas.dmulscale((wal = this.boardService.getWall(wal.getPoint2())).getX() - x1, s.getY() - y1, -(s.getX() - x1), wal.getY() - y1, 32) >= 0;
    }

    protected void glViewport(float x, float y, float x2, float y2) {
        this.gl.glViewport((int)(x *= this.backBufferScale), (int)(y *= this.backBufferScale), (int)(x2 *= this.backBufferScale), (int)(y2 *= this.backBufferScale));
    }

    protected void set2dview() {
        if (this.gloy1 != -1.0f) {
            this.glViewport(0.0f, 0.0f, this.xdim, this.ydim);
            this.orphoRen.resize(this.xdim, this.ydim);
        }
        this.gloy1 = -1.0f;
    }

    protected void resizeglcheck() {
        if (this.glox1 != (float)this.windowx1 || this.gloy1 != (float)this.windowy1 || this.glox2 != (float)this.windowx2 || this.gloy2 != (float)this.windowy2) {
            this.glox1 = this.windowx1;
            this.gloy1 = this.windowy1;
            this.glox2 = this.windowx2;
            this.gloy2 = this.windowy2;
            this.glViewport(this.windowx1, this.ydim - (this.windowy2 + 1), this.windowx2 - this.windowx1 + 1, this.windowy2 - this.windowy1 + 1);
            this.cam.viewportWidth = this.windowx2;
            this.cam.viewportHeight = this.windowy2;
        }
    }

    protected GDXOrtho allocOrphoRenderer(Engine engine) {
        return new GDXOrtho(this, (IOverheadMapSettings)new DefaultMapSettings(engine.getBoardService()));
    }

    protected int[] getMirrorTextures() {
        return null;
    }

    @Override
    public Renderer.RenderType getType() {
        return Renderer.RenderType.PolyGDX;
    }

    @Override
    public TileData.PixelFormat getTexFormat() {
        return this.isUseIndexedTextures ? TileData.PixelFormat.Pal8 : TileData.PixelFormat.Rgba;
    }

    @Override
    public boolean isInited() {
        return this.isInited;
    }

    protected void switchShader(ShaderManager.Shader shader) {
        if (this.orphoRen.isDrawing()) {
            this.orphoRen.flush();
        }
        this.manager.bind(shader);
        this.manager.mirror(this.inpreparemirror);
        this.manager.prepare(this.cam, (int)((float)this.windowx1 * this.backBufferScale), (int)((float)this.windowy1 * this.backBufferScale), (int)((float)this.windowx2 * this.backBufferScale), (int)((float)this.windowy2 * this.backBufferScale));
        if (this.orphoRen.isDrawing()) {
            this.orphoRen.setupMatrices();
        }
    }

    protected GLTile getSkyTexture(TileData.PixelFormat fmt, ArtEntry artEntry, int palnum) {
        if (!artEntry.hasSize()) {
            return this.textureCache.get(fmt, artEntry, palnum, 0, 0);
        }
        GLTile tile = this.skycache.get(artEntry.getNum(), palnum, false, 0);
        if (tile != null) {
            if (tile.isInvalidated()) {
                tile.setInvalidated(false);
                TileData data = this.loadPic(fmt, artEntry, palnum);
                tile.update(data, palnum, this.config.getGlfilter());
            }
        } else {
            TileData data = this.loadPic(fmt, artEntry, palnum);
            if (data == null) {
                return null;
            }
            this.skycache.add(this.textureCache.newTile(data, fmt == TileData.PixelFormat.Pal8 ? 0 : palnum, this.config.getGlfilter()), artEntry.getNum());
        }
        return tile;
    }

    protected TileData loadPic(TileData.PixelFormat fmt, ArtEntry tile, int palnum) {
        short[] dapskyoff = Engine.zeropskyoff;
        short dapskybits = Engine.pskybits;
        if (dapskybits < 0) {
            dapskybits = 0;
        }
        TileAtlas sky = new TileAtlas(fmt, tile.getWidth() * (1 << dapskybits), tile.getHeight(), tile.getWidth(), tile.getHeight(), false);
        int tileNum = tile.getNum();
        for (int i = 0; i < 1 << dapskybits; ++i) {
            tile = this.getTile(dapskyoff[i] + tileNum);
            TileData dat = fmt == TileData.PixelFormat.Pal8 ? new IndexedTileData(tile, false, false, 0) : new RGBTileData(this.engine.getPaletteManager(), tile, palnum, false, false, 0, this.config.getGlfilter() != TexFilter.NONE);
            sky.addTile(tile.getNum(), dat);
        }
        return sky.atlas.get(0);
    }

    protected boolean isSkyShader() {
        return this.manager.getShader() == ShaderManager.Shader.RGBSkyShader || this.manager.getShader() == ShaderManager.Shader.IndexedSkyShader;
    }

    @Override
    public void onPalookupChanged(int palnum) {
        this.textureCache.invalidatepalookup(palnum);
    }

    @Override
    public void onChangePalette(byte[] palette) {
        this.changepalette(palette);
    }

    @Override
    public void onLoadBoard(Board board) {
        if (this.world != null) {
            this.world.dispose();
        }
        this.world = new WorldMesh(this.engine);
        this.scanner.init();
        for (int i = 0; i < board.getSpriteCount(); ++i) {
            this.removeSpriteCorr(i);
            Sprite spr = board.getSprite(i);
            if (spr == null || (spr.getCstat() >> 4 & 3) != 1 || spr.getStatnum() == 1024) continue;
            this.addSpriteCorr(i);
        }
    }

    @Override
    public void onAddSprite(int spriteNum) {
        this.addSpriteCorr(spriteNum);
    }

    @Override
    public void onRemoveSprite(int spriteNum) {
        this.removeSpriteCorr(spriteNum);
    }

    @Override
    public void onInvalidate(int tileNum) {
        this.invalidatetile(tileNum, -1, -1);
    }
}

