/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.Gdx;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.GdxRender.GDXRenderer;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.settings.VideoContext;

public class GDXVideoContext
extends VideoContext {
    private final GDXRenderer gdxRenderer;

    public GDXVideoContext(GDXRenderer gdxRenderer) {
        this.gdxRenderer = gdxRenderer;
    }

    @Override
    public void setgFov(int gFov) {
        this.gFov = gFov;
        this.gdxRenderer.setFieldOfView(gFov);
    }

    @Override
    public void setTextureFilter(TexFilter textureFilter) {
        int maxAnisotropy;
        int anisotropy = textureFilter.getAnisotropy();
        if (anisotropy > 1 && anisotropy > (maxAnisotropy = (int)GLInfo.getMaxAnisotropicFilterLevel())) {
            TexFilter bestFilter = TexFilter.TRILINEAR;
            for (TexFilter filter : TexFilter.values()) {
                if (filter.getAnisotropy() == 1 || filter.getAnisotropy() > maxAnisotropy) continue;
                bestFilter = filter;
            }
            textureFilter = bestFilter;
        }
        this.gdxRenderer.textureCache.setFilter(textureFilter);
        this.gdxRenderer.modelManager.setTextureFilter(textureFilter);
        super.setTextureFilter(textureFilter);
    }

    @Override
    public void setUseHighTiles(boolean useHighTiles) {
        if (this.isUseHighTiles() == useHighTiles) {
            return;
        }
        Gdx.app.postRunnable(() -> {
            this.gdxRenderer.textureCache.uninit();
            this.gdxRenderer.clearskins(true);
            super.setUseHighTiles(useHighTiles);
        });
    }

    @Override
    public void setPaletteEmulation(boolean paletteEmulation) {
        this.gdxRenderer.enableIndexedShader(paletteEmulation);
        super.setPaletteEmulation(paletteEmulation);
    }
}

