/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Scanner;

import java.util.Arrays;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.Scanner.RayCaster;
import ru.m210projects.Build.Render.GdxRender.Scanner.SectorInfo;
import ru.m210projects.Build.Render.GdxRender.Scanner.WallFrustum2d;
import ru.m210projects.Build.Render.GdxRender.WorldMesh;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.Pool;

public class PotentiallyVisibleSet {
    private final WallFrustum2d[] portqueue;
    private final int queuemask;
    private final byte[] handled;
    private final WallFrustum2d[] gotviewport;
    private final byte[] gotwall;
    private final RayCaster ray;
    private final Pool<WallFrustum2d> pWallFrustumPool = new Pool<WallFrustum2d>(WallFrustum2d::new);
    protected SectorInfo info = new SectorInfo();
    private int pqhead;
    private int pqtail;
    private int[] sectorqueue;
    private int secindex = 0;
    private Engine engine;

    public PotentiallyVisibleSet(Engine engine) {
        this.engine = engine;
        this.ray = new RayCaster(engine.getBoardService());
        this.portqueue = new WallFrustum2d[512];
        this.queuemask = this.portqueue.length - 1;
        this.gotviewport = new WallFrustum2d[Engine.MAXSECTORS];
        this.sectorqueue = new int[Engine.MAXSECTORS];
        this.handled = new byte[Engine.MAXSECTORS >> 3];
        this.gotwall = new byte[Engine.MAXWALLS >> 3];
        this.sectorqueue = new int[Engine.MAXSECTORS];
    }

    public void process(BuildCamera cam, WorldMesh mesh, int sectnum) {
        int z;
        int endwall;
        int startwall;
        WallFrustum2d pFrustum;
        BoardService boardService = this.engine.getBoardService();
        if (!boardService.isValidSector(sectnum)) {
            return;
        }
        int cursectnum = sectnum;
        float cameraX = cam.getX();
        float cameraY = cam.getY();
        Arrays.fill(this.gotviewport, null);
        Gameutils.fill(this.gotwall, 0);
        Gameutils.fill(this.handled, 0);
        this.pWallFrustumPool.reset();
        this.secindex = 0;
        this.pqtail = 0;
        this.pqhead = 0;
        this.portqueue[this.pqtail++ & this.queuemask] = this.pWallFrustumPool.obtain().set(cam, sectnum);
        this.gotviewport[sectnum] = pFrustum = this.portqueue[this.pqhead];
        while (this.pqhead != this.pqtail) {
            sectnum = pFrustum.sectnum;
            if (!pFrustum.handled) {
                pFrustum.handled = true;
                if (this.info.hasOccluders(sectnum)) {
                    this.ray.init(cam, false);
                    startwall = boardService.getSector(sectnum).getWallptr();
                    endwall = boardService.getSector(sectnum).getWallnum() + startwall;
                    for (z = startwall; z < endwall; ++z) {
                        if (!this.WallFacingCheck(cameraX, cameraY, boardService.getWall(z))) continue;
                        this.ray.add(cursectnum, z, null);
                    }
                    this.ray.update();
                }
                startwall = boardService.getSector(sectnum).getWallptr();
                endwall = boardService.getSector(sectnum).getWallnum() + startwall;
                for (z = startwall; z < endwall; ++z) {
                    WallFrustum2d wallFrustum;
                    Wall wal = boardService.getWall(z);
                    short nextsectnum = wal.getNextsector();
                    if (!this.WallFacingCheck(cameraX, cameraY, wal) || !cam.polyInCamera(mesh.getPoints(WorldMesh.Heinum.Max, sectnum, z)) || !pFrustum.wallInFrustum(wal) || this.info.hasOccluders(sectnum) && !this.ray.check(z)) continue;
                    if (nextsectnum != -1 && (wallFrustum = this.pWallFrustumPool.obtain().set(cam, wal)) != null && wallFrustum.fieldOfViewClipping(pFrustum)) {
                        if (this.gotviewport[nextsectnum] == null) {
                            this.portqueue[this.pqtail++ & this.queuemask] = wallFrustum;
                            this.gotviewport[nextsectnum] = wallFrustum;
                        } else {
                            WallFrustum2d nextp = this.gotviewport[nextsectnum];
                            if ((nextp = nextp.fieldOfViewExpand(wallFrustum)) != null && (this.handled[nextsectnum >> 3] & Engine.pow2char[nextsectnum & 7]) != 0) {
                                this.portqueue[this.pqtail++ & this.queuemask] = nextp;
                            }
                        }
                    }
                    int n = z >> 3;
                    this.gotwall[n] = (byte)(this.gotwall[n] | Engine.pow2char[z & 7]);
                }
            }
            pFrustum = pFrustum.next != null ? pFrustum.next : this.portqueue[++this.pqhead & this.queuemask];
            if ((this.handled[sectnum >> 3] & Engine.pow2char[sectnum & 7]) == 0) {
                this.sectorqueue[this.secindex++] = sectnum;
            }
            int n = sectnum >> 3;
            this.handled[n] = (byte)(this.handled[n] | Engine.pow2char[sectnum & 7]);
        }
        this.ray.init(cam, true);
        for (sectnum = 0; sectnum < Engine.MAXSECTORS; ++sectnum) {
            pFrustum = this.gotviewport[sectnum];
            if (pFrustum == null || this.info.isCorruptSector(sectnum)) continue;
            startwall = boardService.getSector(sectnum).getWallptr();
            endwall = boardService.getSector(sectnum).getWallnum() + startwall;
            for (z = startwall; z < endwall; ++z) {
                float j;
                if ((this.gotwall[z >> 3] & Engine.pow2char[z & 7]) == 0) continue;
                Wall w = boardService.getWall(z);
                Wall p2 = boardService.getWall(w.getPoint2());
                int dx = p2.getX() - w.getX();
                int dy = p2.getY() - w.getY();
                float i = (float)dx * (cameraX - (float)w.getX()) + (float)dy * (cameraY - (float)w.getY());
                if (i >= 0.0f && i < (j = (float)(dx * dx + dy * dy))) {
                    int px = (int)((float)dx * (i /= j) + (float)w.getX());
                    int py = (int)((float)dy * i + (float)w.getY());
                    dx = (int)Math.abs((float)px - cameraX);
                    if (dx + (dy = (int)Math.abs((float)py - cameraY)) < 128) continue;
                }
                this.ray.add(cursectnum, z, pFrustum);
            }
        }
        this.ray.update();
    }

    public boolean checkWall(int z) {
        if ((this.gotwall[z >> 3] & Engine.pow2char[z & 7]) != 0) {
            return this.ray.check(z);
        }
        return false;
    }

    public boolean checkSector(int z) {
        return this.gotviewport[z] != null;
    }

    private boolean WallFacingCheck(float cameraX, float cameraY, Wall wal) {
        float x1 = (float)wal.getX() - cameraX;
        float y1 = (float)wal.getY() - cameraY;
        float x2 = (float)wal.getWall2().getX() - cameraX;
        float y2 = (float)wal.getWall2().getY() - cameraY;
        return x1 * y2 - y1 * x2 >= 0.0f;
    }
}

