/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Matrix4;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.TextureHandle.IndexedShader;

public abstract class IndexedSkyShaderProgram
extends IndexedShader {
    protected int cameraloc;
    protected int projTransloc;
    protected int transformloc;
    protected int mirrorloc;

    public IndexedSkyShaderProgram(int numshades) throws Exception {
        super(Gdx.files.classpath("ru/m210projects/Build/Render/GdxRender/Shaders/sky_vertex.glsl").readString(), Gdx.files.classpath("ru/m210projects/Build/Render/GdxRender/Shaders/sky_fragment.glsl").readString(), numshades);
    }

    @Override
    protected void init(int numshades) throws Exception {
        super.init(numshades);
        this.cameraloc = this.getUniformLocation("u_camera");
        this.projTransloc = this.getUniformLocation("u_projTrans");
        this.transformloc = this.getUniformLocation("u_transform");
        this.mirrorloc = this.getUniformLocation("u_mirror");
    }

    public void prepare(BuildCamera cam) {
        this.setUniformf(this.cameraloc, cam.position.x, cam.position.y, cam.position.z);
        this.setUniformMatrix(this.projTransloc, cam.combined);
    }

    public void transform(Matrix4 transform) {
        this.setUniformMatrix(this.transformloc, transform);
    }

    public void mirror(boolean mirror) {
        this.setUniformi(this.mirrorloc, mirror ? 1 : 0);
    }
}

