/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.IntArray;
import java.util.Comparator;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.GDXRenderer;
import ru.m210projects.Build.Render.GdxRender.Shaders.ShaderManager;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.IndexedShader;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Types.AnimType;
import ru.m210projects.Build.Types.QuickSort;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class SpriteRenderer {
    private final Matrix4 transform;
    private final SpriteComparator comp;
    private final GDXRenderer parent;
    private final Engine engine;
    private final IntArray spritesz = new IntArray(4096);
    private BuildCamera cam;

    public SpriteRenderer(Engine engine, GDXRenderer parent) {
        this.transform = new Matrix4();
        this.comp = new SpriteComparator();
        this.parent = parent;
        this.engine = engine;
    }

    public void sort(Sprite[] array, int len) {
        for (int i = 0; i < len; ++i) {
            Sprite spr = array[i];
            short s = spr.getOwner();
            if (s == -1) continue;
            int[] items = this.spritesz.items;
            if (s >= items.length) {
                items = this.spritesz.ensureCapacity((int)((float)s * 1.75f));
            }
            items[s] = spr.getZ();
            if (!Gameutils.isValidTile(spr.getPicnum()) || (spr.getCstat() & 0x30) == 32) continue;
            ArtEntry pic = this.parent.getTile(spr.getPicnum());
            byte yoff = (byte)(pic.getOffsetY() + spr.getYoffset());
            short s2 = s;
            items[s2] = items[s2] - (yoff * spr.getYrepeat() << 2);
            int yspan = pic.getHeight() * spr.getYrepeat() << 2;
            if ((spr.getCstat() & 0x80) == 0) {
                short s3 = s;
                items[s3] = items[s3] - (yspan >> 1);
            }
            if (Pragmas.klabs(items[s] - this.parent.globalposz) >= yspan >> 1) continue;
            items[s] = this.parent.globalposz;
        }
        QuickSort.sort(array, len, this.comp);
    }

    public void begin(BuildCamera cam) {
        this.cam = cam;
    }

    public Matrix4 getMatrix(Sprite tspr, int texx, int texy) {
        int picnum = tspr.getPicnum();
        short orientation = tspr.getCstat();
        short spritenum = tspr.getOwner();
        ArtEntry pic = this.parent.getTile(picnum);
        int xoff = 0;
        int yoff = 0;
        if ((orientation & 0x30) != 48) {
            if (pic.getType() != AnimType.NONE) {
                picnum += this.parent.animateoffs(picnum, spritenum + 32768);
                pic = this.parent.getTile(picnum);
            }
            xoff = tspr.getXoffset();
            yoff = tspr.getYoffset();
            xoff += pic.getOffsetX();
            yoff += pic.getOffsetY();
        }
        int tsizx = pic.getWidth();
        int tsizy = pic.getHeight();
        if (tsizx <= 0 || tsizy <= 0) {
            return null;
        }
        boolean xflip = (orientation & 4) != 0;
        boolean yflip = (orientation & 8) != 0;
        float posx = tspr.getX();
        float posy = tspr.getY();
        float posz = tspr.getZ();
        this.transform.setToTranslation(posx, posy, posz);
        switch (orientation >> 4 & 3) {
            case 0: {
                float xspans = 5.0f;
                int ang = (int)this.parent.globalang - 512 & 0x7FF;
                if (xflip ^ yflip) {
                    ang += 1024;
                    if (!xflip) {
                        xoff = -xoff;
                    }
                    if (yflip) {
                        xspans = -xspans;
                    }
                } else if (xflip) {
                    xoff = -xoff;
                    xspans = -xspans;
                }
                this.transform.translate(0.0f, 0.0f, (float)(tspr.getYrepeat() * texy) * (yflip ? 2.0f : -2.0f));
                this.transform.rotate(0.0f, 0.0f, 1.0f, (int)Gameutils.AngleToDegrees(ang));
                this.transform.translate((float)(tspr.getXrepeat() * xoff) / 5.0f, 0.0f, -(yoff * tspr.getYrepeat() << 2));
                if ((tsizx & 1) == 0) {
                    this.transform.translate((float)(tspr.getXrepeat() >> 1) / xspans, 0.0f, 0.0f);
                }
                if ((orientation & 0x80) != 0) {
                    float zoffs = tsizy * tspr.getYrepeat() << 1;
                    if ((tsizy & 1) != 0) {
                        zoffs += (float)(tspr.getYrepeat() << 1);
                    }
                    this.transform.translate(0.0f, 0.0f, zoffs);
                }
                if (yflip) {
                    this.transform.rotate(0.0f, 1.0f, 0.0f, 180.0f);
                    this.transform.translate(0.0f, 0.0f, (float)(tspr.getYrepeat() * texy) * 4.0f);
                } else {
                    this.transform.translate(0.0f, 0.0f, (float)(tspr.getYrepeat() * (texy - tsizy)) * 4.0f);
                }
                this.transform.scale((float)(tspr.getXrepeat() * texx) / 5.0f, 0.0f, 4 * tspr.getYrepeat() * texy);
                break;
            }
            case 1: {
                int dang;
                if (yflip) {
                    yoff = -yoff;
                }
                int wang = (int)Gameutils.AngleToDegrees(tspr.getAng() + (xflip ^ yflip ? 1536 : 512) & 0x7FF);
                if ((orientation & 0x40) == 0 && ((dang = (tspr.getAng() - EngineUtils.getAngle(tspr.getX() - this.parent.globalposx, tspr.getY() - this.parent.globalposy) & 0x7FF) - 1024) > 512 || dang < -512)) {
                    xflip = !xflip;
                }
                float xspans = 4.0f;
                if (xflip ^ yflip) {
                    if (!xflip) {
                        xoff = -xoff;
                    }
                    if (yflip) {
                        xspans = -xspans;
                    }
                } else if (xflip) {
                    xoff = -xoff;
                    xspans = -xspans;
                }
                this.transform.translate(0.0f, 0.0f, (float)(tspr.getYrepeat() * texy) * (yflip ? 2.0f : -2.0f));
                this.transform.rotate(0.0f, 0.0f, 1.0f, wang);
                this.transform.translate((float)(tspr.getXrepeat() * xoff) / 4.0f, 0.0f, (float)(-(tspr.getYrepeat() * yoff)) * 4.0f);
                if ((orientation & 0x80) != 0) {
                    this.transform.translate(0.0f, 0.0f, (float)(tspr.getYrepeat() * tsizy) * 2.0f);
                }
                if ((tsizx & 1) == 0) {
                    this.transform.translate((float)(tspr.getXrepeat() >> 1) / xspans, 0.0f, 0.0f);
                }
                if (yflip) {
                    this.transform.rotate(0.0f, 1.0f, 0.0f, 180.0f);
                    this.transform.translate(0.0f, 0.0f, (float)(tspr.getYrepeat() * texy) * 4.0f);
                } else {
                    this.transform.translate(0.0f, 0.0f, (float)(tspr.getYrepeat() * (texy - tsizy)) * 4.0f);
                }
                this.transform.scale((float)(tspr.getXrepeat() * texx) / 4.0f, 0.0f, (float)(tspr.getYrepeat() * texy) * 4.0f);
                break;
            }
            case 2: {
                if (yflip) {
                    yoff = -yoff;
                }
                if ((orientation & 0x40) == 0) {
                    if (tspr.getZ() < this.parent.globalposz) {
                        yflip = true;
                    } else if (yflip) {
                        yflip = !yflip;
                    }
                }
                float xspans = 4.0f;
                if (xflip ^ yflip) {
                    if (yflip) {
                        xspans = -xspans;
                    }
                } else if (xflip) {
                    xspans = -xspans;
                }
                this.transform.rotate(0.0f, 0.0f, 1.0f, (int)Gameutils.AngleToDegrees(tspr.getAng() + (xflip ? 512 : 1536) & 0x7FF));
                this.transform.rotate(1.0f, 0.0f, 0.0f, xflip ? -90.0f : 90.0f);
                if ((tsizx & 1) == 0) {
                    this.transform.translate((float)(tspr.getXrepeat() >> 1) / xspans, 0.0f, 0.0f);
                }
                this.transform.translate((float)(tspr.getXrepeat() * xoff) / 4.0f, 0.0f, (float)(-(tspr.getYrepeat() * yoff)) / 4.0f);
                this.transform.scale((float)(tspr.getXrepeat() * texx) / 4.0f, 0.0f, (float)(tspr.getYrepeat() * texy) / 4.0f);
            }
        }
        return this.transform.rotate(1.0f, 0.0f, 0.0f, 90.0f);
    }

    public boolean draw(Sprite tspr) {
        GLTile tex;
        BoardService boardService = this.engine.getBoardService();
        if (tspr.getOwner() < 0 || !Gameutils.isValidTile(tspr.getPicnum()) || !boardService.isValidSector(tspr.getSectnum())) {
            return false;
        }
        ShaderManager manager = this.parent.manager;
        int picnum = tspr.getPicnum();
        byte shade = tspr.getShade();
        int pal = tspr.getPal() & 0xFF;
        short orientation = tspr.getCstat();
        short spritenum = tspr.getOwner();
        ArtEntry pic = this.parent.getTile(picnum);
        if ((orientation & 0x30) != 48 && pic.getType() != AnimType.NONE) {
            picnum += this.parent.animateoffs(picnum, spritenum + 32768);
            pic = this.parent.getTile(picnum);
        }
        int tsizx = pic.getWidth();
        int tsizy = pic.getHeight();
        if (tsizx <= 0 || tsizy <= 0) {
            return false;
        }
        int method = 5;
        if ((orientation & 2) != 0) {
            method = (orientation & 0x200) == 0 ? 6 : 7;
        }
        if ((tex = this.parent.bind(pic, pal, shade, 0, method)) == null) {
            return false;
        }
        if (tex.isHighTile()) {
            for (tsizy = 1; tsizy < tex.getHeight(); tsizy += tsizy) {
            }
            tsizy = (int)((float)tsizy / tex.getYScale());
        } else {
            tsizx = tex.getWidth();
            tsizy = tex.getHeight();
        }
        int vis = this.parent.globalvisibility;
        if (boardService.getSector(tspr.getSectnum()).getVisibility() != 0) {
            vis = Pragmas.mulscale(this.parent.globalvisibility, boardService.getSector(tspr.getSectnum()).getVisibility() + 16 & 0xFF, 4);
        }
        if (tex.getPixelFormat() == TileData.PixelFormat.Pal8) {
            ((IndexedShader)manager.getProgram()).setVisibility((int)((float)(-vis) / 64.0f));
        } else {
            this.parent.calcFog(pal, shade, vis);
        }
        boolean xflip = (orientation & 4) != 0;
        boolean yflip = (orientation & 8) != 0;
        switch (orientation >> 4 & 3) {
            case 1: {
                int dang;
                if ((orientation & 0x40) != 0 || (dang = (tspr.getAng() - EngineUtils.getAngle(tspr.getX() - this.parent.globalposx, tspr.getY() - this.parent.globalposy) & 0x7FF) - 1024) <= 512 && dang >= -512) break;
                xflip = !xflip;
                break;
            }
            case 2: {
                if ((orientation & 0x40) != 0) break;
                if (tspr.getZ() < this.parent.globalposz) {
                    yflip = true;
                    break;
                }
                if (!yflip) break;
                yflip = false;
            }
        }
        Gdx.gl.glEnable(3042);
        if (xflip ^ yflip) {
            Gdx.gl.glFrontFace(2305);
        } else {
            Gdx.gl.glFrontFace(2304);
        }
        Gdx.gl.glDepthFunc(515);
        Gdx.gl.glDepthRangef(0.0f, 0.99999f);
        Matrix4 mat = this.getMatrix(tspr, tsizx, tsizy);
        float invscalex = 1.0f / this.cam.xscale;
        float invscaley = 1.0f / this.cam.yscale;
        mat.val[0] = mat.val[0] * invscalex;
        mat.val[4] = mat.val[4] * invscalex;
        mat.val[8] = mat.val[8] * invscalex;
        mat.val[12] = mat.val[12] * invscalex;
        mat.val[1] = mat.val[1] * invscalex;
        mat.val[5] = mat.val[5] * invscalex;
        mat.val[9] = mat.val[9] * invscalex;
        mat.val[13] = mat.val[13] * invscalex;
        mat.val[2] = mat.val[2] * invscaley;
        mat.val[6] = mat.val[6] * invscaley;
        mat.val[10] = mat.val[10] * invscaley;
        mat.val[14] = mat.val[14] * invscaley;
        manager.transform(mat);
        manager.frustum(null);
        this.parent.world.getQuad().render(manager.getProgram());
        Gdx.gl.glFrontFace(2304);
        return true;
    }

    public void end() {
        Gdx.gl.glDepthFunc(513);
        Gdx.gl.glDepthRangef(this.parent.defznear, this.parent.defzfar);
    }

    public class SpriteComparator
    implements Comparator<Sprite> {
        @Override
        public int compare(Sprite o1, Sprite o2) {
            int len2;
            if (o1 == null || o2 == null) {
                return 0;
            }
            if (o1.getOwner() == o2.getOwner() || o1.getOwner() == -1 || o2.getOwner() == -1) {
                return 0;
            }
            int len1 = this.getDist(o1);
            if (len1 != (len2 = this.getDist(o2))) {
                return len1 < len2 ? -1 : 1;
            }
            if ((o1.getCstat() & 2) != 0) {
                return -1;
            }
            if ((o2.getCstat() & 2) != 0) {
                return 1;
            }
            if (o1.getStatnum() != o2.getStatnum()) {
                return o1.getStatnum() < o2.getStatnum() ? -1 : 1;
            }
            return o1.getOwner() <= o2.getOwner() ? -1 : 1;
        }

        public int getDist(Sprite spr) {
            int dx1 = spr.getX() - ((SpriteRenderer)SpriteRenderer.this).parent.globalposx;
            int dy1 = spr.getY() - ((SpriteRenderer)SpriteRenderer.this).parent.globalposy;
            int dz1 = ((SpriteRenderer)SpriteRenderer.this).spritesz.items[spr.getOwner()] - ((SpriteRenderer)SpriteRenderer.this).parent.globalposz >> 4;
            return dx1 * dx1 + dy1 * dy1 + dz1 * dz1;
        }
    }
}

