/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.NumberUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.GdxRender.WorldMesh;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.Pool;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class Tesselator {
    public final List<Zoid_t> zoids = new ArrayList<Zoid_t>();
    protected final VertexAttribute[] attributes;
    private final Pool<Zoid_t> pZoidsPool = new Pool<Zoid_t>(Zoid_t::new);
    private final Engine engine;
    private final SurfaceInfo surf;
    private final int vertexSize;
    private final Vertex[] pol = new Vertex[]{new Vertex(0, 0), new Vertex(1, 0), new Vertex(1, 1), new Vertex(0, 1)};
    private final Vector3 norm = new Vector3();
    private final Vertex[] vertex = new Vertex[3];
    private final IntArray secy = new IntArray();
    private final ArrayList<Float> trapx0 = new ArrayList();
    private final ArrayList<Float> trapx1 = new ArrayList();
    private final WorldMesh mesh;
    private int sectnum = -1;

    public Tesselator(WorldMesh mesh, VertexAttribute ... attributes) {
        this.mesh = mesh;
        this.engine = mesh.engine;
        this.attributes = attributes;
        int size = 0;
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].equals(VertexAttribute.ColorPacked())) {
                size += attributes[i].numComponents;
                continue;
            }
            ++size;
        }
        this.vertexSize = size;
        this.surf = new SurfaceInfo();
    }

    public int getVertexSize() {
        return this.vertexSize;
    }

    public void setSector(int sectnum, boolean initZoids) {
        if (initZoids && this.sectnum != sectnum) {
            this.initZoids(sectnum);
        }
        this.sectnum = sectnum;
    }

    public int getSector() {
        return this.sectnum;
    }

    private void initZoids(int sectnum) {
        int w;
        Sector sec = this.mesh.getSector(sectnum);
        int n = sec.getWallnum();
        this.zoids.clear();
        this.secy.clear();
        this.pZoidsPool.reset();
        if (n < 3) {
            return;
        }
        int startwall = sec.getWallptr();
        int endwall = startwall + sec.getWallnum() - 1;
        int i = 0;
        for (w = startwall; w <= endwall; ++w) {
            this.secy.add(this.mesh.getWall(w).getY());
        }
        this.secy.sort();
        int secn = 0;
        int cury = Integer.MIN_VALUE;
        for (i = 0; i < n; ++i) {
            int val = this.secy.get(i);
            if (val <= cury) continue;
            int n2 = secn++;
            cury = val;
            this.secy.set(n2, cury);
        }
        for (int s = 0; s < secn - 1; ++s) {
            int j;
            float f;
            float sy0 = this.secy.get(s);
            float sy1 = this.secy.get(s + 1);
            this.trapx0.clear();
            this.trapx1.clear();
            int ntrap = 0;
            startwall = sec.getWallptr();
            endwall = startwall + sec.getWallnum() - 1;
            for (w = startwall; w <= endwall; ++w) {
                Wall wal = this.mesh.getWall(w);
                Wall wal2 = this.mesh.getWall(wal.getPoint2());
                float x0 = wal.getX();
                float y0 = wal.getY();
                float x1 = wal2.getX();
                float y1 = wal2.getY();
                if (y0 > y1) {
                    f = x0;
                    x0 = x1;
                    x1 = f;
                    f = y0;
                    y0 = y1;
                    y1 = f;
                }
                if (y0 >= sy1 || y1 <= sy0) continue;
                if (y0 < sy0) {
                    x0 = (sy0 - (float)wal.getY()) * (float)(wal2.getX() - wal.getX()) / (float)(wal2.getY() - wal.getY()) + (float)wal.getX();
                }
                if (y1 > sy1) {
                    x1 = (sy1 - (float)wal.getY()) * (float)(wal2.getX() - wal.getX()) / (float)(wal2.getY() - wal.getY()) + (float)wal.getX();
                }
                this.trapx0.add(Float.valueOf(x0));
                this.trapx1.add(Float.valueOf(x1));
                ++ntrap;
            }
            for (int g = ntrap >> 1; g != 0; g >>= 1) {
                for (i = 0; i < ntrap - g; ++i) {
                    for (j = i; j >= 0 && !(this.trapx0.get(j).floatValue() + this.trapx1.get(j).floatValue() <= this.trapx0.get(j + g).floatValue() + this.trapx1.get(j + g).floatValue()); j -= g) {
                        f = this.trapx0.get(j).floatValue();
                        this.trapx0.set(j, this.trapx0.get(j + g));
                        this.trapx0.set(j + g, Float.valueOf(f));
                        f = this.trapx1.get(j).floatValue();
                        this.trapx1.set(j, this.trapx1.get(j + g));
                        this.trapx1.set(j + g, Float.valueOf(f));
                    }
                }
            }
            if (ntrap < 2) continue;
            i = 0;
            while (i < ntrap) {
                j = i + 1;
                if (i >= this.trapx0.size() || j >= this.trapx0.size()) {
                    Console.out.println(String.format("Sector %d is corrupt", sectnum), OsdColor.RED);
                    sec.setAsBroken();
                    this.zoids.clear();
                    return;
                }
                if (!(this.trapx0.get(j).floatValue() <= this.trapx0.get(i).floatValue()) || !(this.trapx1.get(j).floatValue() <= this.trapx1.get(i).floatValue())) {
                    while (j + 2 < ntrap && this.trapx0.get(j + 1).floatValue() <= this.trapx0.get(j).floatValue() && this.trapx1.get(j + 1).floatValue() <= this.trapx1.get(j).floatValue()) {
                        j += 2;
                    }
                    Zoid_t zoid = this.pZoidsPool.obtain();
                    ((Zoid_t)zoid).x[0] = this.trapx0.get(i).floatValue();
                    ((Zoid_t)zoid).x[1] = this.trapx0.get(j).floatValue();
                    ((Zoid_t)zoid).y[0] = sy0;
                    ((Zoid_t)zoid).x[3] = this.trapx1.get(i).floatValue();
                    ((Zoid_t)zoid).x[2] = this.trapx1.get(j).floatValue();
                    ((Zoid_t)zoid).y[1] = sy1;
                    this.zoids.add(zoid);
                }
                i = j + 1;
            }
        }
    }

    public int getMaxVertices() {
        int vertices = 2 * this.zoids.size() * 6;
        return 2 * (vertices += 30 * this.mesh.getSector(this.sectnum).getWallnum());
    }

    public SurfaceInfo getSurface(Type type, int num, FloatArray vertices) {
        this.surf.clear();
        int count = 0;
        switch (type.ordinal()) {
            case 4: {
                float SIZEX = 0.5f;
                float SIZEY = 0.5f;
                ArrayList<Vertex> pol = new ArrayList<Vertex>();
                pol.add((Vertex)new Vertex(1, 1).set(-SIZEX, SIZEY, 0.0f));
                pol.add((Vertex)new Vertex(0, 1).set(SIZEX, SIZEY, 0.0f));
                pol.add((Vertex)new Vertex(0, 0).set(SIZEX, -SIZEY, 0.0f));
                pol.add((Vertex)new Vertex(1, 0).set(-SIZEX, -SIZEY, 0.0f));
                for (int v = 0; v < 4; ++v) {
                    Vertex vx = (Vertex)pol.get(v);
                    block27: for (int a = 0; a < this.attributes.length; ++a) {
                        switch (this.attributes[a].usage) {
                            case 1: {
                                vertices.addAll(vx.x, vx.y, vx.z);
                                continue block27;
                            }
                            case 16: {
                                vertices.addAll(vx.u, vx.v);
                                continue block27;
                            }
                            case 2: {
                                vertices.addAll(1.0f, 1.0f, 1.0f, 1.0f);
                                continue block27;
                            }
                            case 4: {
                                vertices.add(NumberUtils.intToFloatColor(-1));
                                continue block27;
                            }
                            case 8: {
                                vertices.addAll(this.norm.x, this.norm.y, this.norm.z);
                            }
                        }
                    }
                    ++count;
                }
                break;
            }
            case 0: 
            case 1: {
                Sector sec = this.mesh.getSector(num);
                this.surf.picnum = type == Type.Floor ? sec.getFloorpicnum() : sec.getCeilingpicnum();
                this.surf.obj = sec;
                ArtEntry pic = this.engine.getTile(this.surf.picnum);
                int n = 0;
                int j = 0;
                for (int i = 0; i < this.zoids.size(); ++i) {
                    n = 0;
                    for (j = 0; j < 4; ++j) {
                        this.pol[n].x = this.zoids.get(i).x[j];
                        this.pol[n].y = this.zoids.get(i).y[j >> 1];
                        if (n != 0 && this.pol[n].x == this.pol[n - 1].x && this.pol[n].y == this.pol[n - 1].y) continue;
                        this.pol[n].z = type == Type.Floor ? (float)this.engine.getflorzofslope((short)num, (int)this.pol[n].x, (int)this.pol[n].y) : (float)this.engine.getceilzofslope((short)num, (int)this.pol[n].x, (int)this.pol[n].y);
                        ++n;
                    }
                    if (n < 3) continue;
                    this.vertex[0] = this.pol[0];
                    for (j = 2; j < n; ++j) {
                        if (type == Type.Floor) {
                            this.vertex[1] = this.pol[j - 1];
                            this.vertex[2] = this.pol[j];
                        } else {
                            this.vertex[1] = this.pol[j];
                            this.vertex[2] = this.pol[j - 1];
                        }
                        this.norm.set(this.vertex[2]).sub(this.vertex[0]);
                        float dx = this.vertex[1].x - this.vertex[0].x;
                        float dy = this.vertex[1].y - this.vertex[0].y;
                        float dz = this.vertex[1].z - this.vertex[0].z;
                        this.norm.crs(dx, dy, dz).nor();
                        for (int v = 0; v < 3; ++v) {
                            Vertex vx = this.vertex[v];
                            block32: for (int a = 0; a < this.attributes.length; ++a) {
                                switch (this.attributes[a].usage) {
                                    case 1: {
                                        float[] fArray = new float[3];
                                        float f = vx.x;
                                        Objects.requireNonNull(this.mesh);
                                        fArray[0] = f / 512.0f;
                                        float f2 = vx.y;
                                        Objects.requireNonNull(this.mesh);
                                        fArray[1] = f2 / 512.0f;
                                        float f3 = vx.z;
                                        Objects.requireNonNull(this.mesh);
                                        fArray[2] = f3 / 8192.0f;
                                        vertices.addAll(fArray);
                                        continue block32;
                                    }
                                    case 16: {
                                        float uptr = vx.x;
                                        float vptr = vx.y;
                                        if (!pic.hasSize()) {
                                            vertices.addAll(0.0f, 0.0f);
                                            continue block32;
                                        }
                                        if (type == Type.Floor ? sec.isRelativeTexFloor() : sec.isRelativeTexCeiling()) {
                                            Wall wal = this.mesh.getWall(sec.getWallptr());
                                            Wall wal2 = this.mesh.getWall(wal.getPoint2());
                                            float vecx = wal.getX() - wal2.getX();
                                            float vecy = wal.getY() - wal2.getY();
                                            float len = (float)Math.sqrt(vecx * vecx + vecy * vecy);
                                            float nuptr = uptr - (float)wal.getX();
                                            float nvptr = vptr - (float)wal.getY();
                                            uptr = -nuptr * (vecx /= len) - (vecy /= len) * nvptr;
                                            vptr = nvptr * vecx - vecy * nuptr;
                                            if (type == Type.Floor ? sec.isFloorSlope() : sec.isCeilingSlope()) {
                                                double r = (double)(type == Type.Floor ? sec.getFloorheinum() : sec.getCeilingheinum()) / 4096.0;
                                                r = Math.sqrt(r * r + 1.0);
                                                if (type == Type.Floor ? !sec.isTexSwapedFloor() : !sec.isTexSwapedCeiling()) {
                                                    vptr = (float)((double)vptr * r);
                                                } else {
                                                    uptr = (float)((double)uptr * r);
                                                }
                                            }
                                        }
                                        float uCoff = 16.0f * (float)pic.getWidth();
                                        float vCoff = -16.0f * (float)pic.getHeight();
                                        if (type == Type.Floor ? sec.isTexSwapedFloor() : sec.isTexSwapedCeiling()) {
                                            float tmp = uptr;
                                            uptr = -vptr;
                                            vptr = -tmp;
                                        }
                                        if (type == Type.Floor ? sec.isTexSmooshedFloor() : sec.isTexSmooshedCeiling()) {
                                            uCoff /= 2.0f;
                                            vCoff /= 2.0f;
                                        }
                                        if (type == Type.Floor ? sec.isTexXFlippedFloor() : sec.isTexXFlippedCeiling()) {
                                            uCoff *= -1.0f;
                                        }
                                        if (type == Type.Floor ? sec.isTexYFlippedFloor() : sec.isTexYFlippedCeiling()) {
                                            vCoff *= -1.0f;
                                        }
                                        float uPanning = (float)(type == Type.Floor ? sec.getFloorxpanning() : sec.getCeilingxpanning()) / 255.0f;
                                        float vPanning = (float)(type == Type.Floor ? sec.getFloorypanning() : sec.getCeilingypanning()) / 255.0f;
                                        vertices.addAll(uptr / uCoff + uPanning, vptr / vCoff + vPanning);
                                        continue block32;
                                    }
                                    case 2: {
                                        vertices.addAll(1.0f, 1.0f, 1.0f, 1.0f);
                                        continue block32;
                                    }
                                    case 4: {
                                        vertices.add(NumberUtils.intToFloatColor(-1));
                                        continue block32;
                                    }
                                    case 8: {
                                        vertices.addAll(this.norm.x, this.norm.y, this.norm.z);
                                    }
                                }
                            }
                            ++count;
                        }
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                Wall wal = this.mesh.getWall(num);
                WorldMesh.Heinum heinum = type.getHeinum();
                ArrayList<Vertex> pol = this.mesh.getPoints(type.getHeinum(), this.sectnum, num);
                if (pol == null || pol.size() < 3) {
                    return null;
                }
                float uCoff = 1.0f;
                float vCoff = 1.0f;
                float uPanning = 0.0f;
                float vPanning = 0.0f;
                float vOffs = 0.0f;
                if (type != Type.Sky) {
                    int k = 0;
                    if (heinum == WorldMesh.Heinum.Portal) {
                        k = -1;
                    } else if (heinum == WorldMesh.Heinum.Lower) {
                        k = 1;
                    }
                    Wall ptr = wal;
                    if (k == 1 && wal.getNextsector() != -1 && wal.isSwapped()) {
                        ptr = this.mesh.getWall(wal.getNextwall());
                    }
                    vOffs = this.getVCoord(wal, this.sectnum, k);
                    short picnum = k == -1 ? ptr.getOverpicnum() : ptr.getPicnum();
                    this.surf.picnum = picnum;
                    this.surf.obj = ptr;
                    ArtEntry pic = this.engine.getTile(picnum);
                    if (pic.hasSize()) {
                        uCoff = (float)wal.getXrepeat() * 8.0f / (float)pic.getWidth();
                        vCoff = (float)(-wal.getYrepeat()) * 4.0f / (float)GLInfo.calcSize(pic.getHeight());
                        uPanning = (float)ptr.getXpanning() / (float)pic.getWidth();
                        vPanning = (float)ptr.getYpanning() / 256.0f;
                        if (wal.isXFlip()) {
                            uCoff *= -1.0f;
                            uPanning = ((float)wal.getXrepeat() * 8.0f + (float)ptr.getXpanning()) / (float)pic.getWidth();
                        }
                        if (ptr.isYFlip()) {
                            vCoff *= -1.0f;
                            vPanning *= -1.0f;
                        }
                    }
                } else {
                    this.surf.picnum = heinum == WorldMesh.Heinum.SkyLower ? this.mesh.getSector(this.sectnum).getFloorpicnum() : this.mesh.getSector(this.sectnum).getCeilingpicnum();
                    this.surf.obj = this.mesh.getSector(this.sectnum);
                }
                this.vertex[0] = pol.get(0);
                for (int j = 2; j < pol.size(); ++j) {
                    this.vertex[1] = pol.get(j - 1);
                    this.vertex[2] = pol.get(j);
                    this.norm.set(this.vertex[2]).sub(this.vertex[0]);
                    float dx = this.vertex[1].x - this.vertex[0].x;
                    float dy = this.vertex[1].y - this.vertex[0].y;
                    float dz = this.vertex[1].z - this.vertex[0].z;
                    this.norm.crs(dx, dy, dz).nor();
                    for (int i = 0; i < 3; ++i) {
                        Vertex ver = this.vertex[i];
                        block35: for (int a = 0; a < this.attributes.length; ++a) {
                            switch (this.attributes[a].usage) {
                                case 1: {
                                    float[] fArray = new float[3];
                                    float f = ver.x;
                                    Objects.requireNonNull(this.mesh);
                                    fArray[0] = f / 512.0f;
                                    float f4 = ver.y;
                                    Objects.requireNonNull(this.mesh);
                                    fArray[1] = f4 / 512.0f;
                                    float f5 = ver.z;
                                    Objects.requireNonNull(this.mesh);
                                    fArray[2] = f5 / 8192.0f;
                                    vertices.addAll(fArray);
                                    continue block35;
                                }
                                case 16: {
                                    if (type != Type.Sky) {
                                        float[] fArray = new float[2];
                                        fArray[0] = uCoff * ver.u + uPanning;
                                        float f = vCoff * (vOffs - ver.z);
                                        Objects.requireNonNull(this.mesh);
                                        fArray[1] = f / 8192.0f + vPanning;
                                        vertices.addAll(fArray);
                                        continue block35;
                                    }
                                    vertices.addAll(ver.u, ver.v);
                                    continue block35;
                                }
                                case 2: {
                                    vertices.addAll(1.0f, 1.0f, 1.0f, 1.0f);
                                    continue block35;
                                }
                                case 4: {
                                    vertices.add(NumberUtils.intToFloatColor(-1));
                                    continue block35;
                                }
                                case 8: {
                                    vertices.addAll(this.norm.x, this.norm.y, this.norm.z);
                                }
                            }
                        }
                        ++count;
                    }
                }
                break;
            }
        }
        if (count == 0) {
            return null;
        }
        this.surf.size = count;
        if (type == Type.Wall || type == Type.Sky) {
            this.surf.limit = 6;
            if (this.mesh.getMesh() == null) {
                int pads = 6 - count;
                for (int i = 0; i < pads; ++i) {
                    for (int j = 0; j < this.getVertexSize(); ++j) {
                        vertices.add(-1.0f);
                    }
                }
            }
        } else {
            this.surf.limit = count;
        }
        return this.surf;
    }

    private int getVCoord(Wall wal, int sectnum, int k) {
        int nextsectnum = wal.getNextsector();
        int s3 = sectnum;
        boolean align = false;
        if (nextsectnum != -1) {
            if (k == -1) {
                if (wal.isOneWay()) {
                    if (!wal.isBottomAligned()) {
                        s3 = nextsectnum;
                    }
                } else {
                    boolean bl = align = wal.isBottomAligned();
                    s3 = wal.isBottomAligned() ? (this.mesh.getSector(sectnum).getFloorz() < this.mesh.getSector(nextsectnum).getFloorz() ? sectnum : (int)nextsectnum) : (this.mesh.getSector(sectnum).getCeilingz() < this.mesh.getSector(nextsectnum).getCeilingz() ? nextsectnum : sectnum);
                }
            } else {
                if (k == 1) {
                    if (wal.isSwapped()) {
                        wal = this.mesh.getWall(wal.getNextwall());
                    }
                    boolean bl = align = !wal.isBottomAligned();
                }
                if (!wal.isBottomAligned()) {
                    s3 = nextsectnum;
                }
            }
        } else {
            align = wal.isBottomAligned();
        }
        Wall ptr = this.mesh.getWall(this.mesh.getSector(s3).getWallptr());
        if (!align) {
            return this.engine.getceilzofslope((short)s3, ptr.getX(), ptr.getY());
        }
        return this.engine.getflorzofslope((short)s3, ptr.getX(), ptr.getY());
    }

    public static class Vertex
    extends Vector3 {
        private static final long serialVersionUID = 2322711328782046279L;
        protected float u;
        protected float v;

        public Vertex(int u, int v) {
            this.u = u;
            this.v = v;
        }

        protected void set(Wall i, float z, float u, float v) {
            this.set(i.getX(), i.getY(), z);
            this.u = u;
            this.v = v;
        }
    }

    protected static class SurfaceInfo {
        public int picnum;
        public Object obj;
        public int size;
        public int limit;

        protected SurfaceInfo() {
        }

        protected void clear() {
            this.picnum = -1;
            this.obj = null;
            this.size = 0;
            this.limit = 0;
        }

        protected int getSize() {
            return this.size;
        }

        protected int getLimit() {
            return this.limit;
        }
    }

    private static class Zoid_t {
        private final float[] x = new float[4];
        private final float[] y = new float[2];
    }

    public static enum Type {
        Floor,
        Ceiling,
        Wall,
        Sky,
        Quad;

        private WorldMesh.Heinum heinum;

        public WorldMesh.Heinum getHeinum() {
            return this.heinum;
        }

        public Type setHeinum(WorldMesh.Heinum heinum) {
            this.heinum = heinum;
            return this;
        }
    }
}

