/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.IndexBufferObject;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.VertexBufferObject;
import com.badlogic.gdx.graphics.glutils.VertexBufferObjectWithVAO;
import com.badlogic.gdx.graphics.glutils.VertexData;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.GdxRender.Tesselator;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Timer;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class WorldMesh {
    private static final int CEILING1 = 0;
    private static final int CEILING2 = 1;
    private static final int FLOOR2 = 2;
    private static final int FLOOR1 = 3;
    protected final float scalexy = 512.0f;
    protected final float scalez = 8192.0f;
    private final Tesselator tess;
    private final Mesh mesh;
    private final BoardService boardService;
    private final FloatArray vertices = new FloatArray();
    private final int[] floorhash = new int[Engine.MAXSECTORS];
    private final int[] ceilinghash = new int[Engine.MAXSECTORS];
    private final int[] wallhash = new int[Engine.MAXWALLS];
    private final GLSurface[] walls = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] upper_walls = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] lower_walls = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] maskwalls = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] upper_skies = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] lower_skies = new GLSurface[Engine.MAXWALLS];
    private final GLSurface[] floors = new GLSurface[Engine.MAXSECTORS];
    private final GLSurface[] ceilings = new GLSurface[Engine.MAXSECTORS];
    private final GLSurface quad;
    private final Tesselator.Vertex[] pol = new Tesselator.Vertex[]{new Tesselator.Vertex(0, 0), new Tesselator.Vertex(1, 0), new Tesselator.Vertex(1, 1), new Tesselator.Vertex(0, 1)};
    private final ArrayList<Tesselator.Vertex> pointList = new ArrayList();
    protected Engine engine;
    protected GLSurface lastSurf;
    private ByteBuffer meshByteBuffer;
    private int meshOffset;
    private boolean validateMesh = false;
    private final AtomicInteger floorz = new AtomicInteger();
    private final AtomicInteger ceilz = new AtomicInteger();

    public WorldMesh(Engine engine) {
        this.engine = engine;
        this.boardService = engine.getBoardService();
        this.tess = new Tesselator(this, VertexAttribute.Position(), VertexAttribute.ColorPacked(), VertexAttribute.TexCoords(0));
        Timer.start();
        FloatArray vertices = new FloatArray();
        this.lastSurf = null;
        int maxVertices = 0;
        this.meshOffset = 0;
        this.quad = this.addQuad(vertices);
        for (int s = 0; s < this.boardService.getSectorCount(); s = (int)((short)(s + 1))) {
            int w;
            Sector sec = this.boardService.getSector(s);
            if (sec.getFloorz() == sec.getCeilingz()) continue;
            this.tess.setSector(s, true);
            if (this.tess.zoids.isEmpty()) continue;
            this.addFloor(vertices, s);
            this.floorhash[s] = this.getFloorHash(s);
            this.addCeiling(vertices, s);
            this.ceilinghash[s] = this.getCeilingHash(s);
            for (w = sec.getWallptr(); w < sec.getWallptr() + sec.getWallnum(); ++w) {
                this.wallhash[w] = this.getWallHash(s, w);
                this.addMiddle(vertices, s, w);
                this.addUpper(vertices, s, w);
                this.addLower(vertices, s, w);
                this.addMaskedWall(vertices, s, w);
            }
            if (sec.isParallaxCeiling() || sec.isParallaxFloor()) {
                for (w = sec.getWallptr(); w < sec.getWallptr() + sec.getWallnum(); ++w) {
                    this.addParallaxCeiling(vertices, s, w);
                    this.addParallaxFloor(vertices, s, w);
                }
            }
            maxVertices += this.tess.getMaxVertices();
        }
        Timer.result("WorldMesh built in: ");
        this.mesh = new MyMesh(this.makeVertexBuffer(maxVertices, new VertexAttributes(this.tess.attributes)));
        int size = Math.min(maxVertices * this.tess.getVertexSize(), vertices.items.length);
        this.mesh.setVertices(vertices.items, 0, size);
        this.validateMesh = false;
    }

    private VertexData makeVertexBuffer(int maxVertices, VertexAttributes vertexAttributes) {
        this.meshByteBuffer = BufferUtils.newUnsafeByteBuffer(vertexAttributes.vertexSize * maxVertices);
        if (Gdx.gl30 != null) {
            return new VertexBufferObjectWithVAO(false, this.meshByteBuffer, vertexAttributes);
        }
        return new MyVertexBufferObject(this.meshByteBuffer, vertexAttributes);
    }

    public ArrayList<Tesselator.Vertex> getPoints(Heinum heinum, int sectnum, int z) {
        Sector sec = this.boardService.getSector(sectnum);
        Wall wal = this.boardService.getWall(z);
        Wall wal2 = this.boardService.getWall(wal.getPoint2());
        short nextsector = wal.getNextsector();
        switch (heinum.ordinal()) {
            case 0: 
            case 1: {
                this.engine.getzsofslope((short)sectnum, wal.getX(), wal.getY(), this.floorz, this.ceilz);
                this.pol[0].set(wal, this.ceilz.get(), 0.0f, 0.0f);
                this.pol[3].set(wal, this.floorz.get(), 0.0f, 1.0f);
                this.engine.getzsofslope((short)sectnum, wal2.getX(), wal2.getY(), this.floorz, this.ceilz);
                this.pol[2].set(wal2, this.floorz.get(), 1.0f, 1.0f);
                this.pol[1].set(wal2, this.ceilz.get(), 1.0f, 0.0f);
                if (heinum != Heinum.Max) break;
                if (sec.isParallaxCeiling()) {
                    this.pol[1].z = -2.1474836E9f;
                    this.pol[0].z = -2.1474836E9f;
                }
                if (!sec.isParallaxFloor()) break;
                this.pol[2].z = 2.1474836E9f;
                this.pol[3].z = 2.1474836E9f;
                break;
            }
            case 2: {
                int fz1 = this.engine.getflorzofslope((short)sectnum, wal.getX(), wal.getY());
                int cz1 = this.engine.getflorzofslope(nextsector, wal.getX(), wal.getY());
                int fz2 = this.engine.getflorzofslope((short)sectnum, wal2.getX(), wal2.getY());
                int cz2 = this.engine.getflorzofslope(nextsector, wal2.getX(), wal2.getY());
                if (fz1 < cz1 && fz2 < cz2) {
                    return null;
                }
                this.pol[0].set(wal, cz1, 0.0f, 0.0f);
                this.pol[3].set(wal, fz1, 0.0f, 1.0f);
                this.pol[2].set(wal2, fz2, 1.0f, 1.0f);
                this.pol[1].set(wal2, cz2, 1.0f, 0.0f);
                break;
            }
            case 5: {
                int fz1 = this.engine.getflorzofslope((short)sectnum, wal.getX(), wal.getY());
                this.pol[0].set(wal, fz1, 0.0f, 1.0f);
                this.pol[3].set(wal, fz1 + 0x8000000, 0.0f, 0.0f);
                fz1 = this.engine.getflorzofslope((short)sectnum, wal2.getX(), wal2.getY());
                this.pol[2].set(wal2, fz1 + 0x8000000, 1.0f, 1.0f);
                this.pol[1].set(wal2, fz1, 1.0f, 0.0f);
                break;
            }
            case 6: {
                int cz1 = this.engine.getceilzofslope((short)sectnum, wal.getX(), wal.getY());
                this.pol[3].set(wal, cz1, 0.0f, 0.0f);
                this.pol[0].set(wal, cz1 - 0x8000000, 0.0f, 1.0f);
                cz1 = this.engine.getceilzofslope((short)sectnum, wal2.getX(), wal2.getY());
                this.pol[2].set(wal2, cz1, 1.0f, 1.0f);
                this.pol[1].set(wal2, cz1 - 0x8000000, 1.0f, 0.0f);
                break;
            }
            case 3: {
                int fz1 = this.engine.getceilzofslope((short)sectnum, wal.getX(), wal.getY());
                int cz1 = this.engine.getceilzofslope(nextsector, wal.getX(), wal.getY());
                int fz2 = this.engine.getceilzofslope((short)sectnum, wal2.getX(), wal2.getY());
                int cz2 = this.engine.getceilzofslope(nextsector, wal2.getX(), wal2.getY());
                if (fz1 >= cz1 && fz2 >= cz2) {
                    return null;
                }
                this.pol[0].set(wal, fz1, 0.0f, 0.0f);
                this.pol[3].set(wal, cz1, 0.0f, 1.0f);
                this.pol[2].set(wal2, cz2, 1.0f, 1.0f);
                this.pol[1].set(wal2, fz2, 1.0f, 0.0f);
                break;
            }
            case 4: {
                this.engine.getzsofslope(nextsector, wal.getX(), wal.getY(), this.floorz, this.ceilz);
                int fz1 = this.floorz.get();
                int cz1 = this.ceilz.get();
                this.engine.getzsofslope(nextsector, wal2.getX(), wal2.getY(), this.floorz, this.ceilz);
                int fz2 = this.floorz.get();
                int cz2 = this.ceilz.get();
                this.engine.getzsofslope((short)sectnum, wal.getX(), wal.getY(), this.floorz, this.ceilz);
                int fz3 = this.floorz.get();
                int cz3 = this.ceilz.get();
                this.engine.getzsofslope((short)sectnum, wal2.getX(), wal2.getY(), this.floorz, this.ceilz);
                int fz4 = this.floorz.get();
                int cz4 = this.ceilz.get();
                if (fz3 <= fz1 && fz4 <= fz2) {
                    fz1 = fz3;
                    fz2 = fz4;
                }
                if (cz3 >= cz1 && cz4 >= cz2) {
                    cz1 = cz3;
                    cz2 = cz4;
                }
                this.pol[0].set(wal, cz1, 0.0f, 0.0f);
                this.pol[3].set(wal, fz1, 0.0f, 1.0f);
                this.pol[2].set(wal2, fz2, 1.0f, 1.0f);
                this.pol[1].set(wal2, cz2, 1.0f, 0.0f);
            }
        }
        this.pointList.clear();
        if (this.pol[3].z == this.pol[0].z && this.pol[2].z == this.pol[1].z) {
            if (sec.isParallaxFloor() || sec.isParallaxCeiling()) {
                this.pointList.add(this.pol[0]);
                this.pointList.add(this.pol[1]);
                return this.pointList;
            }
            return null;
        }
        float dz0 = this.pol[3].z - this.pol[0].z;
        float dz1 = this.pol[2].z - this.pol[1].z;
        if (dz0 > 0.0f) {
            this.pointList.add(this.pol[0]);
            if (dz1 > 0.0f) {
                this.pointList.add(this.pol[1]);
                this.pointList.add(this.pol[2]);
                this.pointList.add(this.pol[3]);
                return this.pointList;
            }
            float f = dz0 / (dz0 - dz1);
            this.pol[1].x = (this.pol[1].x - this.pol[0].x) * f + this.pol[0].x;
            this.pol[1].y = (this.pol[1].y - this.pol[0].y) * f + this.pol[0].y;
            this.pol[1].z = (this.pol[1].z - this.pol[0].z) * f + this.pol[0].z;
            this.pol[1].u = (this.pol[1].u - this.pol[0].u) * f + this.pol[0].u;
            this.pol[1].v = (this.pol[1].v - this.pol[0].v) * f + this.pol[0].v;
            this.pointList.add(this.pol[1]);
            this.pointList.add(this.pol[3]);
            return this.pointList;
        }
        if (dz1 <= 0.0f) {
            return null;
        }
        float f = dz0 / (dz0 - dz1);
        this.pol[0].x = (this.pol[1].x - this.pol[0].x) * f + this.pol[0].x;
        this.pol[0].y = (this.pol[1].y - this.pol[0].y) * f + this.pol[0].y;
        this.pol[0].z = (this.pol[1].z - this.pol[0].z) * f + this.pol[0].z;
        this.pol[0].u = (this.pol[1].u - this.pol[0].u) * f + this.pol[0].u;
        this.pol[0].v = (this.pol[1].v - this.pol[0].v) * f + this.pol[0].v;
        this.pointList.add(this.pol[0]);
        this.pointList.add(this.pol[1]);
        this.pointList.add(this.pol[2]);
        return this.pointList;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    private GLSurface addParallaxFloor(FloatArray vertices, int sectnum, int wallnum) {
        Wall wal = this.boardService.getWall(wallnum);
        Sector sec = this.boardService.getSector(sectnum);
        boolean isParallaxFloor = sec.isParallaxFloor();
        if (!isParallaxFloor) {
            return this.setNull(this.lower_skies, wallnum);
        }
        short nextsector = wal.getNextsector();
        boolean isParallaxNext = nextsector != -1 && this.boardService.getSector(nextsector).isParallaxFloor();
        GLSurface surf = null;
        if (nextsector == -1 || !isParallaxNext) {
            Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Sky.setHeinum(Heinum.SkyLower), wallnum, vertices);
            if (info == null) {
                return this.setNull(this.lower_skies, wallnum);
            }
            surf = this.getSurface(this.lower_skies, wallnum, info.getSize(), info.getLimit());
            if (surf != null) {
                surf.picnum = info.picnum;
                surf.ptr = info.obj;
                surf.type = Tesselator.Type.Floor;
                surf.vis_ptr = sectnum;
                surf.visflag = 0;
            }
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addParallaxCeiling(FloatArray vertices, int sectnum, int wallnum) {
        Wall wal = this.boardService.getWall(wallnum);
        Sector sec = this.boardService.getSector(sectnum);
        boolean isParallaxCeiling = sec.isParallaxCeiling();
        if (!isParallaxCeiling) {
            return this.setNull(this.upper_skies, wallnum);
        }
        short nextsector = wal.getNextsector();
        boolean isParallaxNext = nextsector != -1 && this.boardService.getSector(nextsector).isParallaxCeiling();
        GLSurface surf = null;
        if (nextsector == -1 || !isParallaxNext) {
            Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Sky.setHeinum(Heinum.SkyUpper), wallnum, vertices);
            if (info == null) {
                return this.setNull(this.upper_skies, wallnum);
            }
            surf = this.getSurface(this.upper_skies, wallnum, info.getSize(), info.getLimit());
            if (surf != null) {
                surf.picnum = info.picnum;
                surf.ptr = info.obj;
                surf.type = Tesselator.Type.Ceiling;
                surf.vis_ptr = sectnum;
                surf.visflag = 0;
            }
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addMiddle(FloatArray vertices, int sectnum, int wallnum) {
        short nextsector = this.boardService.getWall(wallnum).getNextsector();
        if (nextsector != -1) {
            return this.setNull(this.walls, wallnum);
        }
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Wall.setHeinum(Heinum.MaxWall), wallnum, vertices);
        if (info == null) {
            return this.setNull(this.walls, wallnum);
        }
        GLSurface surf = this.getSurface(this.walls, wallnum, info.getSize(), info.getLimit());
        if (surf != null) {
            surf.picnum = info.picnum;
            surf.ptr = info.obj;
            surf.type = Tesselator.Type.Wall;
            surf.vis_ptr = sectnum;
            surf.visflag = 0;
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addUpper(FloatArray vertices, int sectnum, int wallnum) {
        short nextsector = this.boardService.getWall(wallnum).getNextsector();
        if (nextsector == -1 || this.boardService.getSector(nextsector).isParallaxCeiling() && this.boardService.getSector(sectnum).isParallaxCeiling()) {
            return this.setNull(this.upper_walls, wallnum);
        }
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Wall.setHeinum(Heinum.Upper), wallnum, vertices);
        if (info == null) {
            return this.setNull(this.upper_walls, wallnum);
        }
        GLSurface surf = this.getSurface(this.upper_walls, wallnum, info.getSize(), info.getLimit());
        if (surf != null) {
            surf.picnum = info.picnum;
            surf.ptr = info.obj;
            surf.type = Tesselator.Type.Wall;
            surf.vis_ptr = sectnum;
            surf.visflag = 2;
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addLower(FloatArray vertices, int sectnum, int wallnum) {
        short nextsector = this.boardService.getWall(wallnum).getNextsector();
        if (nextsector == -1 || this.boardService.getSector(nextsector).isParallaxFloor() && this.boardService.getSector(sectnum).isParallaxFloor()) {
            return this.setNull(this.lower_walls, wallnum);
        }
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Wall.setHeinum(Heinum.Lower), wallnum, vertices);
        if (info == null) {
            return this.setNull(this.lower_walls, wallnum);
        }
        GLSurface surf = this.getSurface(this.lower_walls, wallnum, info.getSize(), info.getLimit());
        if (surf != null) {
            surf.picnum = info.picnum;
            surf.ptr = info.obj;
            surf.type = Tesselator.Type.Wall;
            surf.vis_ptr = sectnum;
            surf.visflag = 1;
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addMaskedWall(FloatArray vertices, int sectnum, int wallnum) {
        Wall wal = this.boardService.getWall(wallnum);
        GLSurface surf = null;
        if ((wal.isMasked() || wal.isOneWay()) && wal.getNextsector() != -1) {
            Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Wall.setHeinum(Heinum.Portal), wallnum, vertices);
            if (info == null) {
                return this.setNull(this.maskwalls, wallnum);
            }
            surf = this.getSurface(this.maskwalls, wallnum, info.getSize(), info.getLimit());
            if (surf != null) {
                surf.picnum = info.picnum;
                surf.ptr = info.obj;
                surf.type = Tesselator.Type.Wall;
                surf.vis_ptr = sectnum;
                surf.visflag = 4;
            }
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addFloor(FloatArray vertices, int sectnum) {
        if (this.boardService.getSector(sectnum).isParallaxFloor()) {
            return this.setNull(this.floors, sectnum);
        }
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Floor, sectnum, vertices);
        if (info == null) {
            return this.setNull(this.floors, sectnum);
        }
        GLSurface surf = this.getSurface(this.floors, sectnum, info.getSize(), info.getLimit());
        if (surf != null) {
            surf.picnum = info.picnum;
            surf.ptr = info.obj;
            surf.type = Tesselator.Type.Floor;
            surf.vis_ptr = sectnum;
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private GLSurface addQuad(FloatArray vertices) {
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Quad, 0, vertices);
        GLSurface surf = new GLSurface(this.meshOffset);
        surf.count = info.getSize();
        surf.limit = info.getLimit();
        surf.type = Tesselator.Type.Quad;
        surf.primitiveType = 6;
        this.meshOffset += surf.limit;
        return surf;
    }

    private GLSurface addCeiling(FloatArray vertices, int sectnum) {
        if (this.boardService.getSector(sectnum).isParallaxCeiling()) {
            return this.setNull(this.ceilings, sectnum);
        }
        Tesselator.SurfaceInfo info = this.tess.getSurface(Tesselator.Type.Ceiling, sectnum, vertices);
        if (info == null) {
            return this.setNull(this.ceilings, sectnum);
        }
        GLSurface surf = this.getSurface(this.ceilings, sectnum, info.getSize(), info.getLimit());
        if (surf != null) {
            surf.picnum = info.picnum;
            surf.ptr = info.obj;
            surf.type = Tesselator.Type.Ceiling;
            surf.vis_ptr = sectnum;
        }
        if (surf != null && surf.count == 0) {
            return null;
        }
        return surf;
    }

    private void updateVertices(int targetOffset, float[] source, int sourceOffset, int count) {
        if (this.meshByteBuffer.limit() < targetOffset * 4) {
            this.checkValidate();
            this.meshByteBuffer.limit(targetOffset * 4);
        }
        this.mesh.updateVertices(targetOffset, source, sourceOffset, count);
    }

    public GLSurface getWall(int wallnum, int sectnum) {
        int hash = this.getWallHash(sectnum, wallnum);
        if (this.wallhash[wallnum] != hash) {
            this.wallhash[wallnum] = hash;
            this.tess.setSector(sectnum, false);
            this.vertices.clear();
            GLSurface surf = this.addMiddle(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.vertices.clear();
            surf = this.addUpper(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.vertices.clear();
            surf = this.addLower(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.vertices.clear();
            surf = this.addMaskedWall(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.vertices.clear();
            surf = this.addParallaxCeiling(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.vertices.clear();
            surf = this.addParallaxFloor(this.vertices, sectnum, wallnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.checkValidate();
        }
        return this.walls[wallnum];
    }

    protected void checkValidate() {
        if (this.validateMesh) {
            FloatBuffer buffer = this.mesh.getVerticesBuffer(true);
            int newLimit = (this.meshOffset + this.tess.getMaxVertices()) * this.tess.getVertexSize();
            if (newLimit > buffer.capacity()) {
                newLimit = buffer.capacity();
            }
            buffer.limit(newLimit);
            this.validateMesh = false;
        }
    }

    public GLSurface getUpper(int wallnum) {
        return this.upper_walls[wallnum];
    }

    public GLSurface getLower(int wallnum) {
        return this.lower_walls[wallnum];
    }

    public GLSurface getMaskedWall(int wallnum) {
        return this.maskwalls[wallnum];
    }

    public GLSurface getParallaxFloor(int wallnum) {
        return this.lower_skies[wallnum];
    }

    public GLSurface getParallaxCeiling(int wallnum) {
        return this.upper_skies[wallnum];
    }

    public GLSurface getQuad() {
        return this.quad;
    }

    public GLSurface getFloor(int sectnum) {
        int hash = this.getFloorHash(sectnum);
        GLSurface surf = this.floors[sectnum];
        if (this.floorhash[sectnum] != hash) {
            this.floorhash[sectnum] = hash;
            this.tess.setSector(sectnum, true);
            this.vertices.clear();
            surf = this.addFloor(this.vertices, sectnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.checkValidate();
        }
        return surf;
    }

    public GLSurface getCeiling(int sectnum) {
        int hash = this.getCeilingHash(sectnum);
        GLSurface surf = this.ceilings[sectnum];
        if (this.ceilinghash[sectnum] != hash) {
            this.ceilinghash[sectnum] = hash;
            this.tess.setSector(sectnum, true);
            this.vertices.clear();
            surf = this.addCeiling(this.vertices, sectnum);
            if (surf != null) {
                this.updateVertices(surf.offset * this.tess.getVertexSize(), this.vertices.items, 0, this.vertices.size);
            }
            this.checkValidate();
        }
        return surf;
    }

    private int getCeilingHash(int sectnum) {
        int hash = 1;
        int prime = 31;
        Sector sec = this.boardService.getSector(sectnum);
        int startwall = sec.getWallptr();
        int endwall = sec.getWallnum() + startwall;
        for (int z = startwall; z < endwall; ++z) {
            Wall wal = this.boardService.getWall(z);
            hash = 31 * hash + NumberUtils.floatToIntBits(wal.getX());
            hash = 31 * hash + NumberUtils.floatToIntBits(wal.getY());
        }
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.getCeilingz());
        hash = 31 * hash + sec.getCeilingstat();
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.getCeilingheinum());
        hash = 31 * hash + sec.getCeilingpicnum();
        hash = 31 * hash + sec.getCeilingxpanning();
        hash = 31 * hash + sec.getCeilingypanning();
        return hash;
    }

    private int getFloorHash(int sectnum) {
        int hash = 1;
        int prime = 31;
        Sector sec = this.boardService.getSector(sectnum);
        int startwall = sec.getWallptr();
        int endwall = sec.getWallnum() + startwall;
        for (int z = startwall; z < endwall; ++z) {
            Wall wal = this.boardService.getWall(z);
            hash = 31 * hash + NumberUtils.floatToIntBits(wal.getX());
            hash = 31 * hash + NumberUtils.floatToIntBits(wal.getY());
        }
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.getFloorz());
        hash = 31 * hash + sec.getFloorstat();
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.getFloorheinum());
        hash = 31 * hash + sec.getFloorpicnum();
        hash = 31 * hash + sec.getFloorxpanning();
        hash = 31 * hash + sec.getFloorypanning();
        return hash;
    }

    private int getWallHash(int sectnum, int z) {
        Wall wal2;
        Wall swal;
        Sector sec = this.boardService.getSector(sectnum);
        Wall wal = this.boardService.getWall(z);
        if (sec == null || wal == null) {
            return 0;
        }
        int hash = 1;
        int prime = 31;
        hash = 31 * hash + NumberUtils.floatToIntBits(wal.getX());
        hash = 31 * hash + NumberUtils.floatToIntBits(wal.getY());
        hash = 31 * hash + NumberUtils.floatToIntBits(wal.getWall2().getX());
        hash = 31 * hash + NumberUtils.floatToIntBits(wal.getWall2().getY());
        hash = 31 * hash + wal.getCstat();
        hash = 31 * hash + wal.getXpanning();
        hash = 31 * hash + wal.getYpanning();
        hash = 31 * hash + wal.getXrepeat();
        hash = 31 * hash + wal.getYrepeat();
        hash = 31 * hash + wal.getPicnum();
        hash = 31 * hash + wal.getOverpicnum();
        if (wal.isSwapped() && wal.getNextwall() != -1 && (swal = this.boardService.getWall(wal.getNextwall())) != null) {
            hash = 31 * hash + swal.getCstat();
            hash = 31 * hash + swal.getXpanning();
            hash = 31 * hash + swal.getYpanning();
            hash = 31 * hash + swal.getXrepeat();
            hash = 31 * hash + swal.getYrepeat();
            hash = 31 * hash + swal.getPicnum();
        }
        if (((sec.getCeilingstat() | sec.getFloorstat()) & 2) != 0 && (wal2 = this.boardService.getWall(sec.getWallptr())) != null) {
            hash = 31 * hash + NumberUtils.floatToIntBits(wal2.getX());
            hash = 31 * hash + NumberUtils.floatToIntBits(wal2.getY());
        }
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.getFloorz());
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.getFloorheinum());
        hash = 31 * hash + (sec.isFloorSlope() ? 1 : 0);
        hash = 31 * hash + (sec.isParallaxFloor() ? 1 : 0);
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.getCeilingz());
        hash = 31 * hash + NumberUtils.floatToIntBits(sec.getCeilingheinum());
        hash = 31 * hash + (sec.isCeilingSlope() ? 1 : 0);
        hash = 31 * hash + (sec.isParallaxCeiling() ? 1 : 0);
        Sector nsec = this.boardService.getSector(wal.getNextsector());
        if (nsec != null) {
            Wall wal22;
            hash = 31 * hash + NumberUtils.floatToIntBits(nsec.getFloorz());
            hash = 31 * hash + NumberUtils.floatToIntBits(nsec.getFloorheinum());
            hash = 31 * hash + (nsec.isFloorSlope() ? 1 : 0);
            hash = 31 * hash + (nsec.isParallaxFloor() ? 1 : 0);
            hash = 31 * hash + NumberUtils.floatToIntBits(nsec.getCeilingz());
            hash = 31 * hash + NumberUtils.floatToIntBits(nsec.getCeilingheinum());
            hash = 31 * hash + (nsec.isCeilingSlope() ? 1 : 0);
            hash = 31 * hash + (nsec.isParallaxCeiling() ? 1 : 0);
            if (((nsec.getCeilingstat() | nsec.getFloorstat()) & 2) != 0 && (wal22 = this.boardService.getWall(nsec.getWallptr())) != null) {
                hash = 31 * hash + NumberUtils.floatToIntBits(wal22.getX());
                hash = 31 * hash + NumberUtils.floatToIntBits(wal22.getY());
            }
        }
        return hash;
    }

    public Wall getWall(int index) {
        return this.boardService.getWall(index);
    }

    public Sector getSector(int index) {
        return this.boardService.getSector(index);
    }

    private GLSurface setNull(GLSurface[] array, int num) {
        GLSurface src = array[num];
        if (src != null) {
            src.count = 0;
        }
        return null;
    }

    private GLSurface getSurface(GLSurface[] array, int num, int count, int limit) {
        if (array[num] == null) {
            if (count == 0) {
                return null;
            }
            GLSurface surf = new GLSurface(this.meshOffset);
            surf.count = count;
            surf.limit = limit;
            this.meshOffset += surf.limit;
            array[num] = surf;
            if (this.lastSurf != null) {
                this.lastSurf.next = surf;
            }
            this.lastSurf = surf;
            this.validateMesh = true;
            return surf;
        }
        if (this.mesh == null) {
            Console.out.println("Error: Unexpected behavior in mesh initialization, perhaps the map is corrupt", OsdColor.RED);
            this.meshOffset += limit;
            return null;
        }
        if (array[num].limit < count) {
            int shift = count - array[num].limit;
            this.shiftFrom(array[num].next, shift);
            this.meshOffset += shift;
            array[num].limit = count;
        }
        array[num].count = count;
        return array[num];
    }

    public void nextpage() {
        this.tess.setSector(-1, false);
    }

    private void shiftFrom(GLSurface surf, int shift) {
        if (surf == null) {
            return;
        }
        int size = this.meshOffset;
        int newSize = size - surf.offset;
        float[] newItems = new float[newSize * this.tess.getVertexSize()];
        this.mesh.getVertices(surf.offset * this.tess.getVertexSize(), newItems);
        surf.offset += shift;
        this.validateMesh = true;
        this.updateVertices(surf.offset * this.tess.getVertexSize(), newItems, 0, newItems.length);
        surf = surf.next;
        while (surf != null) {
            surf.offset += shift;
            surf = surf.next;
        }
    }

    public Vector3[] getPositions(int offset, int count) {
        Vector3[] out = new Vector3[count];
        FloatBuffer buffer = this.mesh.getVerticesBuffer(false);
        for (int i = 0; i < count; ++i) {
            int offs = (offset + i) * this.tess.getVertexSize();
            out[i] = new Vector3(buffer.get(offs++), buffer.get(offs++), buffer.get(offs++));
        }
        return out;
    }

    public boolean isInvalid() {
        return this.validateMesh;
    }

    public void dispose() {
        this.mesh.dispose();
        this.meshByteBuffer = null;
        this.validateMesh = true;
    }

    public class GLSurface {
        public int offset;
        public int count;
        public int limit;
        public int visflag = 0;
        public int primitiveType = 4;
        public int picnum;
        protected GLSurface next;
        private Object ptr;
        private Tesselator.Type type;
        private int vis_ptr;

        public GLSurface(int offset) {
            this.offset = offset;
        }

        public int getVisibility() {
            return WorldMesh.this.boardService.getSector(this.vis_ptr).getVisibility();
        }

        public void render(ShaderProgram shader) {
            WorldMesh.this.mesh.render(shader, this.primitiveType, this.offset, this.count);
        }

        public int getMethod() {
            switch (this.type) {
                case Floor: {
                    return ((Sector)this.ptr).getFloorstat() >> 7 & 3;
                }
                case Ceiling: {
                    return ((Sector)this.ptr).getCeilingstat() >> 7 & 3;
                }
                case Wall: {
                    int method = 0;
                    Wall wal = (Wall)this.ptr;
                    if (wal.isMasked() && this.visflag == 4) {
                        method = 1;
                        if (!wal.isOneWay() && wal.isTransparent()) {
                            method = !wal.isTransparent2() ? 2 : 3;
                        }
                    }
                    return method;
                }
            }
            return 0;
        }

        public short getPal() {
            switch (this.type) {
                case Floor: {
                    return ((Sector)this.ptr).getFloorpal();
                }
                case Ceiling: {
                    return ((Sector)this.ptr).getCeilingpal();
                }
                case Wall: {
                    return ((Wall)this.ptr).getPal();
                }
            }
            return 0;
        }

        public byte getShade() {
            switch (this.type) {
                case Floor: {
                    return ((Sector)this.ptr).getFloorshade();
                }
                case Ceiling: {
                    return ((Sector)this.ptr).getCeilingshade();
                }
                case Wall: {
                    return ((Wall)this.ptr).getShade();
                }
            }
            return 0;
        }
    }

    private static class MyMesh
    extends Mesh {
        public MyMesh(VertexData vertices) {
            super(vertices, new IndexBufferObject(false, 0), false);
        }
    }

    private static class MyVertexBufferObject
    extends VertexBufferObject {
        protected MyVertexBufferObject(ByteBuffer data, VertexAttributes attributes) {
            super(35048, data, false, attributes);
        }
    }

    public static enum Heinum {
        MaxWall,
        Max,
        Lower,
        Upper,
        Portal,
        SkyLower,
        SkyUpper;

    }
}

